/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.compress;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.luck.picture.lib.compress.Checker;
import com.luck.picture.lib.compress.CompressionPredicate;
import com.luck.picture.lib.compress.Engine;
import com.luck.picture.lib.compress.InputStreamAdapter;
import com.luck.picture.lib.compress.InputStreamProvider;
import com.luck.picture.lib.compress.OnCompressListener;
import com.luck.picture.lib.compress.OnRenameListener;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.AndroidQTransformUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Luban
implements Handler.Callback {
    private static final String TAG = "Luban";
    private static final int MSG_COMPRESS_SUCCESS = 0;
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;
    private String mTargetDir;
    private boolean focusAlpha;
    private int mLeastCompressSize;
    private OnRenameListener mRenameListener;
    private OnCompressListener mCompressListener;
    private CompressionPredicate mCompressionPredicate;
    private List<InputStreamProvider> mStreamProviders;
    private List<String> mPaths;
    private List<LocalMedia> mediaList;
    private int index = -1;
    private boolean isAndroidQ;
    private int compressQuality;
    private Handler mHandler;

    private Luban(Builder builder) {
        this.mPaths = builder.mPaths;
        this.mediaList = builder.mediaList;
        this.mTargetDir = builder.mTargetDir;
        this.mRenameListener = builder.mRenameListener;
        this.mStreamProviders = builder.mStreamProviders;
        this.mCompressListener = builder.mCompressListener;
        this.mLeastCompressSize = builder.mLeastCompressSize;
        this.mCompressionPredicate = builder.mCompressionPredicate;
        this.compressQuality = builder.compressQuality;
        this.focusAlpha = builder.focusAlpha;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.isAndroidQ = builder.isAndroidQ;
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private File getImageCacheFile(Context context, String suffix) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir) && Luban.getImageCacheDir(context) != null) {
            this.mTargetDir = Luban.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + DateUtils.getCreateFileName("IMG_") + (TextUtils.isEmpty((CharSequence)suffix) ? ".jpg" : suffix);
        return new File(cacheBuilder);
    }

    private File getImageCustomFile(Context context, String filename) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            this.mTargetDir = Luban.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + filename;
        return new File(cacheBuilder);
    }

    private static File getImageCacheDir(Context context) {
        File cacheDir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (cacheDir != null) {
            if (!(cacheDir.mkdirs() || cacheDir.exists() && cacheDir.isDirectory())) {
                return null;
            }
            return cacheDir;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    private void launch(Context context) {
        if (this.mStreamProviders == null || this.mPaths == null || this.mStreamProviders.size() == 0 && this.mCompressListener != null) {
            this.mCompressListener.onError(new NullPointerException("image file cannot be null"));
        }
        Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        this.index = -1;
        while (iterator.hasNext()) {
            InputStreamProvider path = iterator.next();
            AsyncTask.SERIAL_EXECUTOR.execute(() -> {
                try {
                    boolean exists;
                    ++this.index;
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
                    File result = path.getMedia().isCompressed() && !TextUtils.isEmpty((CharSequence)path.getMedia().getCompressPath()) ? ((exists = new File(path.getMedia().getCompressPath()).exists()) ? new File(path.getMedia().getCompressPath()) : this.compress(context, path)) : this.compress(context, path);
                    if (this.mediaList != null && this.mediaList.size() > 0) {
                        boolean isLast;
                        LocalMedia media = this.mediaList.get(this.index);
                        String newPath = result.getAbsolutePath();
                        boolean eqHttp = PictureMimeType.isHttp(newPath);
                        media.setCompressed(!eqHttp);
                        media.setCompressPath(eqHttp ? "" : result.getAbsolutePath());
                        boolean bl = isLast = this.index == this.mediaList.size() - 1;
                        if (isLast) {
                            this.mHandler.sendMessage(this.mHandler.obtainMessage(0, this.mediaList));
                        }
                    } else {
                        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)new IOException()));
                    }
                }
                catch (IOException e) {
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)e));
                }
            });
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File get(InputStreamProvider input, Context context) throws IOException {
        try {
            File file = new Engine(input, this.getImageCacheFile(context, Checker.SINGLE.extSuffix(input)), this.focusAlpha, this.compressQuality).compress();
            return file;
        }
        finally {
            input.close();
        }
    }

    private List<File> get(Context context) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        while (iterator.hasNext()) {
            InputStreamProvider provider = iterator.next();
            if (provider.getMedia().isCompressed() && !TextUtils.isEmpty((CharSequence)provider.getMedia().getCompressPath())) {
                boolean exists = new File(provider.getMedia().getCompressPath()).exists();
                File oldFile = exists ? new File(provider.getMedia().getCompressPath()) : this.compress(context, provider);
                results.add(oldFile);
            } else {
                results.add(this.compress(context, provider));
            }
            iterator.remove();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File compress(Context context, InputStreamProvider path) throws IOException {
        try {
            File file = this.compressRealLocalMedia(context, path);
            return file;
        }
        finally {
            path.close();
        }
    }

    private File compressReal(Context context, InputStreamProvider path) throws IOException {
        String suffix = Checker.SINGLE.extSuffix(path.getMedia() != null ? path.getMedia().getMimeType() : "");
        File outFile = this.getImageCacheFile(context, TextUtils.isEmpty((CharSequence)suffix) ? Checker.SINGLE.extSuffix(path) : suffix);
        if (this.mRenameListener != null) {
            String filename = this.mRenameListener.rename(path.getPath());
            outFile = this.getImageCustomFile(context, filename);
        }
        File result = this.mCompressionPredicate != null ? (this.mCompressionPredicate.apply(path.getPath()) && Checker.SINGLE.needCompress(this.mLeastCompressSize, path.getPath()) ? new Engine(path, outFile, this.focusAlpha, this.compressQuality).compress() : new File(path.getPath())) : (Checker.SINGLE.extSuffix(path).startsWith(".gif") ? new File(path.getPath()) : (Checker.SINGLE.needCompress(this.mLeastCompressSize, path.getPath()) ? new Engine(path, outFile, this.focusAlpha, this.compressQuality).compress() : new File(path.getPath())));
        return result;
    }

    private File compressRealLocalMedia(Context context, InputStreamProvider path) throws IOException {
        File result;
        LocalMedia media = path.getMedia();
        String newPath = this.isAndroidQ ? PictureFileUtils.getPath(context, Uri.parse((String)path.getPath())) : path.getPath();
        String suffix = Checker.SINGLE.extSuffix(media != null ? path.getMedia().getMimeType() : "");
        File outFile = this.getImageCacheFile(context, TextUtils.isEmpty((CharSequence)suffix) ? Checker.SINGLE.extSuffix(path) : suffix);
        String filename = "";
        if (this.mRenameListener != null && !TextUtils.isEmpty((CharSequence)(filename = this.mRenameListener.rename(newPath)))) {
            outFile = this.getImageCustomFile(context, filename);
        }
        if (this.mCompressionPredicate != null) {
            if (Checker.SINGLE.extSuffix(path).startsWith(".gif")) {
                if (this.isAndroidQ) {
                    String newFilePath = media.isCut() ? media.getCutPath() : AndroidQTransformUtils.copyImagePathToDirectoryPictures(context, path.getPath(), filename, media.getMimeType());
                    result = new File(newFilePath);
                } else {
                    result = new File(newPath);
                }
            } else if (this.mCompressionPredicate.apply(newPath) && Checker.SINGLE.needCompressToLocalMedia(this.mLeastCompressSize, newPath)) {
                result = new Engine(path, outFile, this.focusAlpha, this.compressQuality).compress();
            } else if (this.isAndroidQ) {
                String newFilePath = media.isCut() ? media.getCutPath() : AndroidQTransformUtils.copyImagePathToDirectoryPictures(context, path.getPath(), filename, media.getMimeType());
                result = new File(newFilePath);
            } else {
                result = new File(newPath);
            }
        } else if (Checker.SINGLE.extSuffix(path).startsWith(".gif")) {
            if (this.isAndroidQ) {
                String newFilePath = media.isCut() ? media.getCutPath() : AndroidQTransformUtils.copyImagePathToDirectoryPictures(context, path.getPath(), filename, media.getMimeType());
                result = new File(newFilePath);
            } else {
                result = new File(newPath);
            }
        } else {
            boolean isCompress = Checker.SINGLE.needCompressToLocalMedia(this.mLeastCompressSize, newPath);
            result = isCompress ? new Engine(path, outFile, this.focusAlpha, this.compressQuality).compress() : (this.isAndroidQ ? new File(media.isCut() ? media.getCutPath() : AndroidQTransformUtils.copyImagePathToDirectoryPictures(context, path.getPath(), filename, media.getMimeType())) : new File(newPath));
        }
        return result;
    }

    public boolean handleMessage(Message msg) {
        if (this.mCompressListener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.mCompressListener.onStart();
                break;
            }
            case 0: {
                this.mCompressListener.onSuccess((List)msg.obj);
                break;
            }
            case 2: {
                this.mCompressListener.onError((Throwable)msg.obj);
            }
        }
        return false;
    }

    public static class Builder {
        private Context context;
        private String mTargetDir;
        private boolean focusAlpha;
        private int compressQuality;
        private int mLeastCompressSize = 100;
        private OnRenameListener mRenameListener;
        private OnCompressListener mCompressListener;
        private CompressionPredicate mCompressionPredicate;
        private List<InputStreamProvider> mStreamProviders;
        private List<String> mPaths;
        private List<LocalMedia> mediaList;
        private boolean isAndroidQ;

        Builder(Context context) {
            this.context = context;
            this.mPaths = new ArrayList<String>();
            this.mediaList = new ArrayList<LocalMedia>();
            this.mStreamProviders = new ArrayList<InputStreamProvider>();
            this.isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        }

        private Luban build() {
            return new Luban(this);
        }

        public Builder load(InputStreamProvider inputStreamProvider) {
            this.mStreamProviders.add(inputStreamProvider);
            return this;
        }

        public <T> Builder loadMediaData(List<LocalMedia> list) {
            this.mediaList = list;
            for (LocalMedia src : list) {
                this.load(src);
            }
            return this;
        }

        private Builder load(final LocalMedia media) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    if (isAndroidQ && !media.isCut()) {
                        return context.getContentResolver().openInputStream(Uri.parse((String)media.getPath()));
                    }
                    return new FileInputStream(media.isCut() ? media.getCutPath() : media.getPath());
                }

                @Override
                public String getPath() {
                    return media.isCut() ? media.getCutPath() : media.getPath();
                }

                @Override
                public LocalMedia getMedia() {
                    return media;
                }
            });
            return this;
        }

        public Builder load(final Uri uri) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    return context.getContentResolver().openInputStream(uri);
                }

                @Override
                public String getPath() {
                    return uri.getPath();
                }

                @Override
                public LocalMedia getMedia() {
                    return null;
                }
            });
            return this;
        }

        public Builder load(final File file) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    return file.getAbsolutePath();
                }

                @Override
                public LocalMedia getMedia() {
                    return null;
                }
            });
            return this;
        }

        public Builder load(final String string2) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    return new FileInputStream(string2);
                }

                @Override
                public String getPath() {
                    return string2;
                }

                @Override
                public LocalMedia getMedia() {
                    return null;
                }
            });
            return this;
        }

        public <T> Builder load(List<T> list) {
            for (T src : list) {
                if (src instanceof String) {
                    this.load((String)src);
                    continue;
                }
                if (src instanceof File) {
                    this.load((File)src);
                    continue;
                }
                if (src instanceof Uri) {
                    this.load((Uri)src);
                    continue;
                }
                throw new IllegalArgumentException("Incoming data type exception, it must be String, File, Uri or Bitmap");
            }
            return this;
        }

        public Builder putGear(int gear) {
            return this;
        }

        public Builder setRenameListener(OnRenameListener listener) {
            this.mRenameListener = listener;
            return this;
        }

        public Builder setCompressListener(OnCompressListener listener) {
            this.mCompressListener = listener;
            return this;
        }

        public Builder setTargetDir(String targetDir) {
            this.mTargetDir = targetDir;
            return this;
        }

        public Builder setFocusAlpha(boolean focusAlpha) {
            this.focusAlpha = focusAlpha;
            return this;
        }

        public Builder setCompressQuality(int compressQuality) {
            this.compressQuality = compressQuality;
            return this;
        }

        public Builder ignoreBy(int size) {
            this.mLeastCompressSize = size;
            return this;
        }

        public Builder filter(CompressionPredicate compressionPredicate) {
            this.mCompressionPredicate = compressionPredicate;
            return this;
        }

        public void launch() {
            this.build().launch(this.context);
        }

        public File get(final String path) throws IOException {
            return this.build().get(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    return new FileInputStream(path);
                }

                @Override
                public String getPath() {
                    return path;
                }

                @Override
                public LocalMedia getMedia() {
                    return null;
                }
            }, this.context);
        }

        public List<File> get() throws IOException {
            return this.build().get(this.context);
        }
    }
}

