/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PointF;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.R;
import com.luck.picture.lib.broadcast.BroadcastManager;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.luck.picture.lib.widget.longimage.ImageSource;
import com.luck.picture.lib.widget.longimage.ImageViewState;
import com.luck.picture.lib.widget.longimage.SubsamplingScaleImageView;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PictureExternalPreviewActivity
extends PictureBaseActivity
implements View.OnClickListener {
    private ImageButton ibLeftBack;
    private TextView tvTitle;
    private PreviewViewPager viewPager;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private int position = 0;
    private SimpleFragmentAdapter adapter;
    private LayoutInflater inflater;
    private loadDataThread loadDataThread;
    private String downloadPath;
    private String mimeType;
    private ImageButton ibDelete;
    private boolean isAndroidQ;
    private View titleViewBg;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 200: {
                    try {
                        String path = (String)msg.obj;
                        if (!TextUtils.isEmpty((CharSequence)path)) {
                            File file = new File(path);
                            MediaStore.Images.Media.insertImage((ContentResolver)PictureExternalPreviewActivity.this.getContentResolver(), (String)file.getAbsolutePath(), (String)file.getName(), null);
                            new PictureMediaScannerConnection(PictureExternalPreviewActivity.this.getContext().getApplicationContext(), file.getAbsolutePath(), () -> {});
                            ToastUtils.s(PictureExternalPreviewActivity.this.getContext(), PictureExternalPreviewActivity.this.getString(R.string.picture_save_success) + "\n" + file.getAbsolutePath());
                        }
                        PictureExternalPreviewActivity.this.dismissDialog();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 400: {
                    ToastUtils.s(PictureExternalPreviewActivity.this.getContext(), PictureExternalPreviewActivity.this.getString(R.string.picture_save_error));
                    break;
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.inflater = LayoutInflater.from((Context)this);
        this.isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
    }

    @Override
    public int getResourceId() {
        return R.layout.picture_activity_external_preview;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.titleViewBg = this.findViewById(R.id.titleViewBg);
        this.tvTitle = (TextView)this.findViewById(R.id.picture_title);
        this.ibLeftBack = (ImageButton)this.findViewById(R.id.left_back);
        this.ibDelete = (ImageButton)this.findViewById(R.id.ib_delete);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.position = this.getIntent().getIntExtra("position", 0);
        this.images = (List)((Object)this.getIntent().getSerializableExtra("previewSelectList"));
        this.ibLeftBack.setOnClickListener((View.OnClickListener)this);
        this.ibDelete.setOnClickListener((View.OnClickListener)this);
        this.ibDelete.setVisibility(this.config.style != null ? (this.config.style.pictureExternalPreviewGonePreviewDelete ? 0 : 8) : 8);
        this.initViewPageAdapterData();
    }

    @Override
    public void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (this.config.style.pictureTitleTextColor != 0) {
                this.tvTitle.setTextColor(this.config.style.pictureTitleTextColor);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.ibLeftBack.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.pictureExternalPreviewDeleteStyle != 0) {
                this.ibDelete.setImageResource(this.config.style.pictureExternalPreviewDeleteStyle);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.ibLeftBack.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.pictureTitleBarBackgroundColor != 0) {
                this.titleViewBg.setBackgroundColor(this.colorPrimary);
            }
        } else {
            int previewBgColor = AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_ac_preview_title_bg);
            if (previewBgColor != 0) {
                this.titleViewBg.setBackgroundColor(previewBgColor);
            } else {
                this.titleViewBg.setBackgroundColor(this.colorPrimary);
            }
        }
    }

    private void initViewPageAdapterData() {
        this.tvTitle.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.images.size()}));
        this.adapter = new SimpleFragmentAdapter();
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int index) {
                PictureExternalPreviewActivity.this.tvTitle.setText((CharSequence)PictureExternalPreviewActivity.this.getString(R.string.picture_preview_image_num, new Object[]{index + 1, PictureExternalPreviewActivity.this.images.size()}));
                PictureExternalPreviewActivity.this.position = index;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.left_back) {
            this.finish();
            this.exitAnimation();
        } else if (id2 == R.id.ib_delete && this.images != null && this.images.size() > 0) {
            int currentItem = this.viewPager.getCurrentItem();
            this.images.remove(currentItem);
            Bundle bundle = new Bundle();
            bundle.putInt("position", currentItem);
            BroadcastManager.getInstance((Context)this).action("com.luck.picture.lib.action.delete_preview_position").extras(bundle).broadcast();
            if (this.images.size() == 0) {
                this.onBackPressed();
                return;
            }
            this.tvTitle.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.images.size()}));
            this.position = currentItem;
            this.adapter.notifyDataSetChanged();
        }
    }

    private void displayLongPic(Uri uri, SubsamplingScaleImageView longImg) {
        longImg.setQuickScaleEnabled(true);
        longImg.setZoomEnabled(true);
        longImg.setPanEnabled(true);
        longImg.setDoubleTapZoomDuration(100);
        longImg.setMinimumScaleType(2);
        longImg.setDoubleTapZoomDpi(2);
        longImg.setImage(ImageSource.uri(uri), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
    }

    private void showDownLoadDialog() {
        if (TextUtils.isEmpty((CharSequence)this.downloadPath)) {
            return;
        }
        PictureCustomDialog dialog = new PictureCustomDialog((Context)this, ScreenUtils.getScreenWidth((Context)this) * 3 / 4, ScreenUtils.getScreenHeight((Context)this) / 4, R.layout.picture_wind_base_dialog_xml, R.style.Picture_Theme_Dialog);
        Button btn_cancel = (Button)dialog.findViewById(R.id.btn_cancel);
        Button btn_commit = (Button)dialog.findViewById(R.id.btn_commit);
        TextView tv_title = (TextView)dialog.findViewById(R.id.tv_title);
        TextView tv_content = (TextView)dialog.findViewById(R.id.tv_content);
        tv_title.setText((CharSequence)this.getString(R.string.picture_prompt));
        tv_content.setText((CharSequence)this.getString(R.string.picture_prompt_content));
        btn_cancel.setOnClickListener(view -> dialog.dismiss());
        btn_commit.setOnClickListener(view -> {
            boolean isHttp = PictureMimeType.isHttp(this.downloadPath);
            if (isHttp) {
                this.showPleaseDialog();
                this.loadDataThread = new loadDataThread(this.downloadPath);
                this.loadDataThread.start();
            } else {
                try {
                    if (this.isAndroidQ) {
                        this.savePictureAlbumAndroidQ(Uri.parse((String)this.downloadPath));
                    } else {
                        this.savePictureAlbum();
                    }
                    this.dismissDialog();
                }
                catch (Exception e) {
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_save_error) + "\n" + e.getMessage());
                    this.dismissDialog();
                    e.printStackTrace();
                }
            }
            dialog.dismiss();
        });
        dialog.show();
    }

    private void savePictureAlbum() throws Exception {
        File folderDir;
        File rootDir;
        String suffix = PictureMimeType.getLastImgSuffix(this.mimeType);
        String state = Environment.getExternalStorageState();
        File file = this.isAndroidQ ? this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES) : (rootDir = state.equals("mounted") ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) : this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES));
        if (rootDir == null || rootDir.exists() || rootDir.mkdirs()) {
            // empty if block
        }
        if ((folderDir = new File(this.isAndroidQ || !state.equals("mounted") ? rootDir.getAbsolutePath() : rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator)) == null || folderDir.exists() || folderDir.mkdirs()) {
            // empty if block
        }
        String fileName = DateUtils.getCreateFileName("IMG_") + suffix;
        File file2 = new File(folderDir, fileName);
        PictureFileUtils.copyFile(this.downloadPath, file2.getAbsolutePath());
        Message message = this.mHandler.obtainMessage();
        message.what = 200;
        message.obj = file2.getAbsolutePath();
        this.mHandler.sendMessage(message);
    }

    private void savePictureAlbumAndroidQ(Uri inputUri) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        contentValues.put("datetaken", ValueOf.toString(System.currentTimeMillis()));
        contentValues.put("mime_type", "image/jpeg");
        contentValues.put("relative_path", "DCIM/Camera");
        Uri uri = this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
        if (uri == null) {
            this.mHandler.sendEmptyMessage(400);
            return;
        }
        AsyncTask.SERIAL_EXECUTOR.execute(() -> {
            OutputStream outputStream = null;
            try {
                outputStream = this.getContentResolver().openOutputStream(uri);
                ParcelFileDescriptor inputDescriptor = this.getContentResolver().openFileDescriptor(inputUri, "r");
                Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)inputDescriptor.getFileDescriptor());
                if (bitmap != null) {
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, outputStream);
                    outputStream.close();
                    String path = PictureFileUtils.getPath((Context)this, uri);
                    Message message = this.mHandler.obtainMessage();
                    message.what = 200;
                    message.obj = path;
                    this.mHandler.sendMessage(message);
                } else {
                    this.mHandler.sendEmptyMessage(400);
                }
            }
            catch (Exception e) {
                this.mHandler.sendEmptyMessage(400);
                e.printStackTrace();
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showLoadingImage(String urlPath) {
        try {
            int read;
            File folderDir;
            File rootDir;
            URL u = new URL(urlPath);
            String suffix = PictureMimeType.getLastImgSuffix(this.mimeType);
            String state = Environment.getExternalStorageState();
            File file = this.isAndroidQ ? this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES) : (rootDir = state.equals("mounted") ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) : this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES));
            if (rootDir == null || rootDir.exists() || rootDir.mkdirs()) {
                // empty if block
            }
            if ((folderDir = new File(this.isAndroidQ || !state.equals("mounted") ? rootDir.getAbsolutePath() : rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator)) == null || folderDir.exists() || folderDir.mkdirs()) {
                // empty if block
            }
            String fileName = DateUtils.getCreateFileName("IMG_") + suffix;
            File file2 = new File(folderDir, fileName);
            String path = file2.getAbsolutePath();
            byte[] buffer = new byte[8192];
            int ava = 0;
            long start = System.currentTimeMillis();
            BufferedInputStream bin = new BufferedInputStream(u.openStream());
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(path));
            while ((read = bin.read(buffer)) > -1) {
                bout.write(buffer, 0, read);
                long l = (long)(ava += read) / (System.currentTimeMillis() - start);
            }
            bout.flush();
            bout.close();
            Message message = this.mHandler.obtainMessage();
            message.what = 200;
            message.obj = path;
            this.mHandler.sendMessage(message);
        }
        catch (IOException e) {
            Message message = this.mHandler.obtainMessage();
            message.what = 400;
            this.mHandler.sendMessage(message);
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
        this.exitAnimation();
    }

    private void exitAnimation() {
        this.overridePendingTransition(R.anim.picture_anim_fade_in, this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewExitAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewExitAnimation : R.anim.picture_anim_exit);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.loadDataThread != null) {
            this.mHandler.removeCallbacks((Runnable)this.loadDataThread);
            this.loadDataThread = null;
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] == 0) {
                        this.showDownLoadDialog();
                        continue;
                    }
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_jurisdiction));
                }
                break;
            }
        }
    }

    public class loadDataThread
    extends Thread {
        private String path;

        public loadDataThread(String path) {
            this.path = path;
        }

        @Override
        public void run() {
            try {
                PictureExternalPreviewActivity.this.showLoadingImage(this.path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class SimpleFragmentAdapter
    extends PagerAdapter {
        public int getCount() {
            return PictureExternalPreviewActivity.this.images != null ? PictureExternalPreviewActivity.this.images.size() : 0;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public int getItemPosition(@NonNull Object object) {
            return -2;
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View contentView = PictureExternalPreviewActivity.this.inflater.inflate(R.layout.picture_image_preview, container, false);
            PhotoView imageView = (PhotoView)contentView.findViewById(R.id.preview_image);
            SubsamplingScaleImageView longImg = (SubsamplingScaleImageView)contentView.findViewById(R.id.longImg);
            LocalMedia media = (LocalMedia)PictureExternalPreviewActivity.this.images.get(position);
            if (media != null) {
                PictureExternalPreviewActivity.this.mimeType = media.getMimeType();
                String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : media.getPath());
                boolean isGif = PictureMimeType.isGif(PictureExternalPreviewActivity.this.mimeType);
                boolean eqLongImg = MediaUtils.isLongImg(media);
                imageView.setVisibility(eqLongImg && !isGif ? 8 : 0);
                longImg.setVisibility(eqLongImg && !isGif ? 0 : 8);
                if (isGif && !media.isCompressed()) {
                    if (PictureExternalPreviewActivity.this.config != null && PictureExternalPreviewActivity.this.config.imageEngine != null) {
                        PictureExternalPreviewActivity.this.config.imageEngine.loadAsGifImage((Context)PictureExternalPreviewActivity.this, path, imageView);
                    }
                } else if (PictureExternalPreviewActivity.this.config != null && PictureExternalPreviewActivity.this.config.imageEngine != null) {
                    if (eqLongImg) {
                        PictureExternalPreviewActivity.this.displayLongPic(PictureExternalPreviewActivity.this.isAndroidQ ? Uri.parse((String)path) : Uri.fromFile((File)new File(path)), longImg);
                    } else {
                        PictureExternalPreviewActivity.this.config.imageEngine.loadImage(contentView.getContext(), path, imageView);
                    }
                }
                imageView.setOnViewTapListener((view, x, y) -> {
                    PictureExternalPreviewActivity.this.finish();
                    PictureExternalPreviewActivity.this.exitAnimation();
                });
                longImg.setOnClickListener(v -> {
                    PictureExternalPreviewActivity.this.finish();
                    PictureExternalPreviewActivity.this.exitAnimation();
                });
                imageView.setOnLongClickListener(v -> {
                    if (PictureExternalPreviewActivity.this.config.isNotPreviewDownload) {
                        if (PermissionChecker.checkSelfPermission(PictureExternalPreviewActivity.this.getContext(), "android.permission.WRITE_EXTERNAL_STORAGE")) {
                            PictureExternalPreviewActivity.this.downloadPath = path;
                            PictureExternalPreviewActivity.this.showDownLoadDialog();
                        } else {
                            PermissionChecker.requestPermissions((Activity)PictureExternalPreviewActivity.this, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
                        }
                    }
                    return true;
                });
            }
            container.addView(contentView, 0);
            return contentView;
        }
    }
}

