/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ValueOf;

public class MediaUtils {
    public static Uri createImageUri(Context context) {
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        values.put("datetaken", time);
        values.put("mime_type", "image/jpeg");
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Images.Media.getContentUri((String)"external"), values) : context.getContentResolver().insert(MediaStore.Images.Media.getContentUri((String)"internal"), values);
        return imageFilePath[0];
    }

    public static Uri createVideoUri(Context context) {
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        values.put("datetaken", time);
        values.put("mime_type", "video/mp4");
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Video.Media.getContentUri((String)"external"), values) : context.getContentResolver().insert(MediaStore.Video.Media.getContentUri((String)"internal"), values);
        return imageFilePath[0];
    }

    public static long extractDuration(Context context, boolean isAndroidQ, String path) {
        return isAndroidQ ? MediaUtils.getLocalDuration(context, Uri.parse((String)path)) : MediaUtils.getLocalDuration(path);
    }

    public static boolean isLongImg(LocalMedia media) {
        if (null != media) {
            int h;
            int width = media.getWidth();
            int height = media.getHeight();
            return height > (h = width * 3);
        }
        return false;
    }

    private static long getLocalDuration(Context context, Uri uri) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(context, uri);
            return Long.parseLong(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static long getLocalDuration(String path) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(path);
            return Long.parseLong(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static int[] getLocalSizeToAndroidQ(Context context, String videoPath) {
        int[] size = new int[2];
        try {
            Cursor query;
            if (Build.VERSION.SDK_INT >= 26 && (query = context.getApplicationContext().getContentResolver().query(Uri.parse((String)videoPath), null, null, null)) != null) {
                query.moveToFirst();
                size[0] = query.getInt(query.getColumnIndexOrThrow("width"));
                size[1] = query.getInt(query.getColumnIndexOrThrow("height"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static int[] getLocalImageSizeToAndroidQ(Context context, String videoPath) {
        int[] size = new int[2];
        try {
            Cursor query;
            if (Build.VERSION.SDK_INT >= 26 && (query = context.getApplicationContext().getContentResolver().query(Uri.parse((String)videoPath), null, null, null)) != null) {
                query.moveToFirst();
                size[0] = query.getInt(query.getColumnIndexOrThrow("width"));
                size[1] = query.getInt(query.getColumnIndexOrThrow("height"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static int[] getLocalVideoSize(String videoPath) {
        int[] size = new int[2];
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(videoPath);
            size[0] = ValueOf.toInt(mmr.extractMetadata(18));
            size[1] = ValueOf.toInt(mmr.extractMetadata(19));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static int[] getLocalVideoSize(Context context, Uri uri) {
        int[] size = new int[2];
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(context, uri);
            size[0] = ValueOf.toInt(mmr.extractMetadata(18));
            size[1] = ValueOf.toInt(mmr.extractMetadata(19));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static int[] getLocalImageWidthOrHeight(String imagePath) {
        int[] size = new int[2];
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
            size[0] = options.outWidth;
            size[1] = options.outHeight;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    @Deprecated
    public static int getLastImageId(Context context, String mimeType) {
        try {
            boolean isMimeType = PictureMimeType.eqImage(mimeType);
            String absolutePath = PictureFileUtils.getDCIMCameraPath(context, mimeType);
            String ORDER_BY = "_id DESC";
            String selection = isMimeType ? "_data like ?" : "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            Cursor imageCursor = context.getContentResolver().query(isMimeType ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, selection, selectionArgs, ORDER_BY);
            if (imageCursor.moveToFirst()) {
                int id2 = imageCursor.getInt(isMimeType ? imageCursor.getColumnIndex("_id") : imageCursor.getColumnIndex("_id"));
                long date = imageCursor.getLong(isMimeType ? imageCursor.getColumnIndex("duration") : imageCursor.getColumnIndex("date_added"));
                int duration = DateUtils.dateDiffer(date);
                imageCursor.close();
                return duration <= 30 ? id2 : -1;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

