/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import java.util.ArrayList;
import java.util.List;

public class PictureAlbumDirectoryAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<LocalMediaFolder> folders = new ArrayList<LocalMediaFolder>();
    private int chooseMode;
    private PictureSelectionConfig config;
    private OnItemClickListener onItemClickListener;

    public PictureAlbumDirectoryAdapter(PictureSelectionConfig config) {
        this.config = config;
        this.chooseMode = config.chooseMode;
    }

    public void bindFolderData(List<LocalMediaFolder> folders) {
        this.folders = folders;
        this.notifyDataSetChanged();
    }

    public void setChooseMode(int chooseMode) {
        this.chooseMode = chooseMode;
    }

    public List<LocalMediaFolder> getFolderData() {
        if (this.folders == null) {
            this.folders = new ArrayList<LocalMediaFolder>();
        }
        return this.folders;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.picture_album_folder_item, parent, false);
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        LocalMediaFolder folder = this.folders.get(position);
        String name = folder.getName();
        int imageNum = folder.getImageNum();
        String imagePath = folder.getFirstImagePath();
        boolean isChecked = folder.isChecked();
        int checkedNum = folder.getCheckedNum();
        holder.tvSign.setVisibility(checkedNum > 0 ? 0 : 4);
        holder.itemView.setSelected(isChecked);
        if (this.chooseMode == PictureMimeType.ofAudio()) {
            holder.ivFirstImage.setImageResource(R.drawable.picture_audio_placeholder);
        } else if (this.config != null && this.config.imageEngine != null) {
            this.config.imageEngine.loadFolderAsBitmapImage(holder.itemView.getContext(), imagePath, holder.ivFirstImage, R.drawable.picture_icon_placeholder);
        }
        Context context = holder.itemView.getContext();
        String firstTitle = folder.getOfAllType() != -1 ? (folder.getOfAllType() == PictureMimeType.ofAudio() ? context.getString(R.string.picture_all_audio) : context.getString(R.string.picture_camera_roll)) : name;
        holder.tvFolderName.setText((CharSequence)context.getString(R.string.picture_camera_roll_num, new Object[]{firstTitle, imageNum}));
        holder.itemView.setOnClickListener(view -> {
            if (this.onItemClickListener != null) {
                for (LocalMediaFolder mediaFolder : this.folders) {
                    mediaFolder.setChecked(false);
                }
                folder.setChecked(true);
                this.notifyDataSetChanged();
                this.onItemClickListener.onItemClick(folder.isCameraFolder(), folder.getName(), folder.getImages());
            }
        });
    }

    public int getItemCount() {
        return this.folders.size();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(boolean var1, String var2, List<LocalMedia> var3);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivFirstImage;
        TextView tvFolderName;
        TextView tvSign;

        public ViewHolder(View itemView) {
            super(itemView);
            this.ivFirstImage = (ImageView)itemView.findViewById(R.id.first_image);
            this.tvFolderName = (TextView)itemView.findViewById(R.id.tv_folder_name);
            this.tvSign = (TextView)itemView.findViewById(R.id.tv_sign);
            if (((PictureAlbumDirectoryAdapter)PictureAlbumDirectoryAdapter.this).config.style != null && ((PictureAlbumDirectoryAdapter)PictureAlbumDirectoryAdapter.this).config.style.pictureFolderCheckedDotStyle != 0) {
                this.tvSign.setBackgroundResource(((PictureAlbumDirectoryAdapter)PictureAlbumDirectoryAdapter.this).config.style.pictureFolderCheckedDotStyle);
            }
        }
    }
}

