/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.ViewPager;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureSimpleFragmentAdapter;
import com.luck.picture.lib.anim.OptAnimationLoader;
import com.luck.picture.lib.broadcast.BroadcastManager;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.VoiceUtils;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.yalantis.ucrop.UCropMulti;
import com.yalantis.ucrop.model.CutInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PicturePreviewActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureSimpleFragmentAdapter.OnCallBackActivity {
    protected ImageView picture_left_back;
    protected TextView tv_img_num;
    protected TextView tv_title;
    protected TextView mTvPictureOk;
    protected PreviewViewPager viewPager;
    protected int position;
    protected boolean is_bottom_preview;
    protected List<LocalMedia> images = new ArrayList<LocalMedia>();
    protected List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    protected TextView check;
    protected PictureSimpleFragmentAdapter adapter;
    protected Animation animation;
    protected View btnCheck;
    protected boolean refresh;
    protected int index;
    protected int screenWidth;
    protected Handler mHandler;
    protected RelativeLayout selectBarLayout;
    protected CheckBox mCbOriginal;
    protected View titleViewBg;
    private BroadcastReceiver commonBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "com.luck.picture.lib.action.close.preview": {
                    PicturePreviewActivity.this.dismissDialog();
                    PicturePreviewActivity.this.mHandler.postDelayed(() -> PicturePreviewActivity.this.onBackPressed(), 150L);
                    break;
                }
            }
        }
    };

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        BroadcastManager.getInstance((Context)this).registerReceiver(this.commonBroadcastReceiver, "com.luck.picture.lib.action.close.preview");
    }

    @Override
    public int getResourceId() {
        return R.layout.picture_preview;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.mHandler = new Handler();
        this.titleViewBg = this.findViewById(R.id.titleViewBg);
        this.screenWidth = ScreenUtils.getScreenWidth((Context)this);
        this.animation = OptAnimationLoader.loadAnimation((Context)this, R.anim.picture_anim_modal_in);
        this.picture_left_back = (ImageView)this.findViewById(R.id.picture_left_back);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.btnCheck = this.findViewById(R.id.btnCheck);
        this.check = (TextView)this.findViewById(R.id.check);
        this.picture_left_back.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureOk = (TextView)this.findViewById(R.id.tv_ok);
        this.mCbOriginal = (CheckBox)this.findViewById(R.id.cb_original);
        this.tv_img_num = (TextView)this.findViewById(R.id.tv_img_num);
        this.selectBarLayout = (RelativeLayout)this.findViewById(R.id.select_bar_layout);
        this.mTvPictureOk.setOnClickListener((View.OnClickListener)this);
        this.tv_img_num.setOnClickListener((View.OnClickListener)this);
        this.tv_title = (TextView)this.findViewById(R.id.picture_title);
        this.position = this.getIntent().getIntExtra("position", 0);
        this.mTvPictureOk.setText((CharSequence)(this.numComplete ? this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}) : this.getString(R.string.picture_please_select)));
        this.tv_img_num.setSelected(this.config.checkNumMode);
        this.btnCheck.setOnClickListener((View.OnClickListener)this);
        this.selectImages = this.getIntent().getParcelableArrayListExtra("selectList");
        this.is_bottom_preview = this.getIntent().getBooleanExtra("bottom_preview", false);
        this.images = this.is_bottom_preview ? this.getIntent().getParcelableArrayListExtra("previewSelectList") : ImagesObservable.getInstance().readPreviewMediaData();
        this.initViewPageAdapterData();
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                PicturePreviewActivity.this.isPreviewEggs(PicturePreviewActivity.this.config.previewEggs, position, positionOffsetPixels);
            }

            public void onPageSelected(int i) {
                PicturePreviewActivity.this.position = i;
                PicturePreviewActivity.this.tv_title.setText((CharSequence)(PicturePreviewActivity.this.position + 1 + "/" + PicturePreviewActivity.this.images.size()));
                LocalMedia media = PicturePreviewActivity.this.images.get(PicturePreviewActivity.this.position);
                PicturePreviewActivity.this.index = media.getPosition();
                if (!PicturePreviewActivity.this.config.previewEggs) {
                    if (PicturePreviewActivity.this.config.checkNumMode) {
                        PicturePreviewActivity.this.check.setText((CharSequence)(media.getNum() + ""));
                        PicturePreviewActivity.this.notifyCheckChanged(media);
                    }
                    PicturePreviewActivity.this.onImageChecked(PicturePreviewActivity.this.position);
                }
                if (PicturePreviewActivity.this.config.isOriginalControl) {
                    boolean eqVideo = PictureMimeType.eqVideo(media.getMimeType());
                    PicturePreviewActivity.this.config.isCheckOriginalImage = eqVideo ? false : PicturePreviewActivity.this.config.isCheckOriginalImage;
                    PicturePreviewActivity.this.mCbOriginal.setVisibility(eqVideo ? 8 : 0);
                    PicturePreviewActivity.this.mCbOriginal.setChecked(PicturePreviewActivity.this.config.isCheckOriginalImage);
                }
                PicturePreviewActivity.this.onPageSelectedChange(media);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
        this.mCbOriginal.setVisibility(this.config.isOriginalControl ? 0 : 8);
        this.mCbOriginal.setOnCheckedChangeListener((buttonView, isChecked) -> {
            this.config.isCheckOriginalImage = isChecked;
        });
    }

    protected void onPageSelectedChange(LocalMedia media) {
    }

    @Override
    public void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (this.config.style.pictureTitleTextColor != 0) {
                this.tv_title.setTextColor(this.config.style.pictureTitleTextColor);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.picture_left_back.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.picturePreviewBottomBgColor != 0) {
                this.selectBarLayout.setBackgroundColor(this.config.style.picturePreviewBottomBgColor);
            }
            if (this.config.style.pictureCheckNumBgStyle != 0) {
                this.tv_img_num.setBackgroundResource(this.config.style.pictureCheckNumBgStyle);
            }
            if (this.config.style.pictureCheckedStyle != 0) {
                this.check.setBackgroundResource(this.config.style.pictureCheckedStyle);
            }
            if (this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
        }
        this.titleViewBg.setBackgroundColor(this.colorPrimary);
        if (this.config.isOriginalControl) {
            if (this.config.style != null && this.config.style.pictureOriginalControlStyle != 0) {
                this.mCbOriginal.setButtonDrawable(this.config.style.pictureOriginalControlStyle);
            } else {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
            }
            if (this.config.style != null && this.config.style.pictureOriginalFontColor != 0) {
                this.mCbOriginal.setTextColor(this.config.style.pictureOriginalFontColor);
            } else {
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
            }
        }
    }

    private void isPreviewEggs(boolean previewEggs, int position, int positionOffsetPixels) {
        if (previewEggs && this.images.size() > 0 && this.images != null) {
            if (positionOffsetPixels < this.screenWidth / 2) {
                LocalMedia media = this.images.get(position);
                this.check.setSelected(this.isSelected(media));
                if (this.config.checkNumMode) {
                    int num = media.getNum();
                    this.check.setText((CharSequence)(num + ""));
                    this.notifyCheckChanged(media);
                    this.onImageChecked(position);
                }
            } else {
                LocalMedia media = this.images.get(position + 1);
                this.check.setSelected(this.isSelected(media));
                if (this.config.checkNumMode) {
                    int num = media.getNum();
                    this.check.setText((CharSequence)(num + ""));
                    this.notifyCheckChanged(media);
                    this.onImageChecked(position + 1);
                }
            }
        }
    }

    private void singleRadioMediaImage() {
        LocalMedia media;
        LocalMedia localMedia = media = this.selectImages != null && this.selectImages.size() > 0 ? this.selectImages.get(0) : null;
        if (media != null) {
            Bundle bundle = new Bundle();
            bundle.putInt("position", media.getPosition());
            bundle.putParcelableArrayList("selectImages", (ArrayList)this.selectImages);
            BroadcastManager.getInstance((Context)this).action("com.luck.picture.lib.action.selected.data").extras(bundle).broadcast();
            this.selectImages.clear();
        }
    }

    private void initViewPageAdapterData() {
        this.tv_title.setText((CharSequence)(this.position + 1 + "/" + this.images.size()));
        this.adapter = new PictureSimpleFragmentAdapter(this.config, this.images, (Context)this, this);
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.onSelectNumChange(false);
        this.onImageChecked(this.position);
        if (this.images.size() > 0) {
            LocalMedia media = this.images.get(this.position);
            this.index = media.getPosition();
            if (this.config.checkNumMode) {
                this.tv_img_num.setSelected(true);
                this.check.setText((CharSequence)(media.getNum() + ""));
                this.notifyCheckChanged(media);
            }
        }
    }

    private void notifyCheckChanged(LocalMedia imageBean) {
        if (this.config.checkNumMode) {
            this.check.setText((CharSequence)"");
            for (LocalMedia media : this.selectImages) {
                if (!media.getPath().equals(imageBean.getPath())) continue;
                imageBean.setNum(media.getNum());
                this.check.setText((CharSequence)String.valueOf(imageBean.getNum()));
            }
        }
    }

    private void subSelectPosition() {
        int len = this.selectImages.size();
        for (int index = 0; index < len; ++index) {
            LocalMedia media = this.selectImages.get(index);
            media.setNum(index + 1);
        }
    }

    public void onImageChecked(int position) {
        if (this.images != null && this.images.size() > 0) {
            LocalMedia media = this.images.get(position);
            this.check.setSelected(this.isSelected(media));
        } else {
            this.check.setSelected(false);
        }
    }

    public boolean isSelected(LocalMedia image) {
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    protected void onSelectNumChange(boolean isRefresh) {
        boolean enable;
        this.refresh = isRefresh;
        boolean bl = enable = this.selectImages.size() != 0;
        if (enable) {
            this.mTvPictureOk.setEnabled(true);
            this.mTvPictureOk.setSelected(true);
            if (this.config.style != null && this.config.style.pictureCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureCompleteTextColor);
            }
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{this.selectImages.size(), this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                if (this.refresh) {
                    this.tv_img_num.startAnimation(this.animation);
                }
                this.tv_img_num.setVisibility(0);
                this.tv_img_num.setText((CharSequence)String.valueOf(this.selectImages.size()));
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_completed));
            }
        } else {
            this.mTvPictureOk.setEnabled(false);
            this.mTvPictureOk.setSelected(false);
            if (this.config.style != null && this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                this.tv_img_num.setVisibility(4);
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_please_select));
            }
        }
        this.updateSelector(this.refresh);
    }

    protected void updateSelector(boolean isRefresh) {
        if (isRefresh) {
            Bundle bundle = new Bundle();
            bundle.putInt("position", this.index);
            bundle.putParcelableArrayList("selectImages", (ArrayList)this.selectImages);
            BroadcastManager.getInstance((Context)this).action("com.luck.picture.lib.action.selected.data").extras(bundle).broadcast();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.picture_left_back) {
            this.onBackPressed();
        } else if (id2 == R.id.tv_ok || id2 == R.id.tv_img_num) {
            this.onComplete();
        } else if (id2 == R.id.btnCheck) {
            this.onCheckedComplete();
        }
    }

    protected void onCheckedComplete() {
        block6: {
            block8: {
                LocalMedia image;
                block7: {
                    boolean isChecked;
                    boolean mimeTypeSame;
                    String mimeType;
                    if (this.images == null || this.images.size() <= 0) break block6;
                    image = this.images.get(this.viewPager.getCurrentItem());
                    String string2 = mimeType = this.selectImages.size() > 0 ? this.selectImages.get(0).getMimeType() : "";
                    if (!TextUtils.isEmpty((CharSequence)mimeType) && !(mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, image.getMimeType()))) {
                        ToastUtils.s(this.getContext(), this.getString(R.string.picture_rule));
                        return;
                    }
                    if (!this.check.isSelected()) {
                        isChecked = true;
                        this.check.setSelected(true);
                        this.check.startAnimation(this.animation);
                    } else {
                        isChecked = false;
                        this.check.setSelected(false);
                    }
                    if (this.selectImages.size() >= this.config.maxSelectNum && isChecked) {
                        ToastUtils.s(this.getContext(), this.getString(R.string.picture_message_max_num, new Object[]{this.config.maxSelectNum}));
                        this.check.setSelected(false);
                        return;
                    }
                    if (!isChecked) break block7;
                    VoiceUtils.playVoice(this.getContext(), this.config.openClickSound);
                    if (this.config.selectionMode == 1) {
                        this.singleRadioMediaImage();
                    }
                    this.selectImages.add(image);
                    this.onSelectedChange(true, image);
                    image.setNum(this.selectImages.size());
                    if (!this.config.checkNumMode) break block8;
                    this.check.setText((CharSequence)String.valueOf(image.getNum()));
                    break block8;
                }
                for (LocalMedia media : this.selectImages) {
                    if (!media.getPath().equals(image.getPath())) continue;
                    this.selectImages.remove(media);
                    this.onSelectedChange(false, image);
                    this.subSelectPosition();
                    this.notifyCheckChanged(media);
                    break;
                }
            }
            this.onSelectNumChange(true);
        }
    }

    protected void onSelectedChange(boolean isAddRemove, LocalMedia media) {
    }

    protected void onComplete() {
        String mimeType;
        int size = this.selectImages.size();
        LocalMedia image = this.selectImages.size() > 0 ? this.selectImages.get(0) : null;
        String string2 = mimeType = image != null ? image.getMimeType() : "";
        if (this.config.minSelectNum > 0 && size < this.config.minSelectNum && this.config.selectionMode == 2) {
            boolean eqImg = PictureMimeType.eqImage(mimeType);
            String str = eqImg ? this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}) : this.getString(R.string.picture_min_video_num, new Object[]{this.config.minSelectNum});
            ToastUtils.s(this.getContext(), str);
            return;
        }
        if (this.config.isCheckOriginalImage) {
            this.onResult(this.selectImages);
            return;
        }
        if (this.config.enableCrop && PictureMimeType.eqImage(mimeType)) {
            if (this.config.selectionMode == 1) {
                this.originalPath = image.getPath();
                this.startCrop(this.originalPath);
            } else {
                ArrayList<CutInfo> cuts = new ArrayList<CutInfo>();
                int count = this.selectImages.size();
                for (int i = 0; i < count; ++i) {
                    LocalMedia media = this.selectImages.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                    CutInfo cutInfo = new CutInfo();
                    cutInfo.setPath(media.getPath());
                    cutInfo.setImageWidth(media.getWidth());
                    cutInfo.setImageHeight(media.getHeight());
                    cutInfo.setMimeType(media.getMimeType());
                    cutInfo.setAndroidQToPath(media.getAndroidQToPath());
                    cuts.add(cutInfo);
                }
                this.startCrop(cuts);
            }
        } else {
            this.onResult(this.selectImages);
        }
    }

    @Override
    public void onResult(List<LocalMedia> images) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("selectImages", (ArrayList)images);
        BroadcastManager.getInstance((Context)this).action("com.luck.picture.lib.action.preview.compression").extras(bundle).broadcast();
        if (!this.config.isCompress || this.config.isCheckOriginalImage) {
            this.onBackPressed();
        } else {
            this.showPleaseDialog();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 609: {
                    List list = UCropMulti.getOutput((Intent)data);
                    this.setResult(-1, new Intent().putExtra("com.yalantis.ucrop.OutputUriList", (Serializable)((Object)list)));
                    this.finish();
                    break;
                }
                case 69: {
                    if (data != null) {
                        this.setResult(-1, data);
                    }
                    this.finish();
                }
            }
        } else if (resultCode == 96) {
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastUtils.s(this.getContext(), throwable.getMessage());
        }
    }

    public void onBackPressed() {
        if (this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewExitAnimation != 0) {
            this.finish();
            this.overridePendingTransition(0, this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewExitAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewExitAnimation : R.anim.picture_anim_exit);
        } else {
            this.closeActivity();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ImagesObservable.getInstance().clearPreviewMediaData();
        if (this.commonBroadcastReceiver != null) {
            BroadcastManager.getInstance((Context)this).unregisterReceiver(this.commonBroadcastReceiver, "com.luck.picture.lib.action.close.preview");
            this.commonBroadcastReceiver = null;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
    }

    @Override
    public void onActivityBackPressed() {
        this.onBackPressed();
    }
}

