/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.yalantis.ucrop.util.FileUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;

public class AndroidQTransformUtils {
    public static String parseVideoPathToAndroidQ(Context ctx, String path, String fileName, String mineType) {
        try {
            String suffix = PictureMimeType.getLastImgSuffix(mineType);
            File filesDir = ctx.getApplicationContext().getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            if (filesDir != null) {
                String newPath = new StringBuffer().append(filesDir).append(File.separator).append(TextUtils.isEmpty((CharSequence)fileName) ? System.currentTimeMillis() + suffix : fileName).toString();
                ParcelFileDescriptor parcelFileDescriptor = ctx.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                FileInputStream inputStream = new FileInputStream(fileDescriptor);
                boolean copyFileSuccess = FileUtils.copyFile((FileInputStream)inputStream, (String)newPath);
                if (copyFileSuccess) {
                    return newPath;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String parseImagePathToAndroidQ(Context ctx, String path, String fileName, String mineType) {
        try {
            String suffix = PictureMimeType.getLastImgSuffix(mineType);
            String filesDir = PictureFileUtils.getDiskCacheDir(ctx.getApplicationContext());
            if (filesDir != null) {
                String newPath = new StringBuffer().append(filesDir).append(File.separator).append(TextUtils.isEmpty((CharSequence)fileName) ? System.currentTimeMillis() + suffix : fileName).toString();
                ParcelFileDescriptor parcelFileDescriptor = ctx.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                FileInputStream inputStream = new FileInputStream(fileDescriptor);
                boolean copyFileSuccess = FileUtils.copyFile((FileInputStream)inputStream, (String)newPath);
                if (copyFileSuccess) {
                    return newPath;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String copyImagePathToDirectoryPictures(Context ctx, String uri, String fileName, String mimeType) {
        try {
            String filesDir;
            String suffix = PictureMimeType.getLastImgSuffix(mimeType);
            if (!TextUtils.isEmpty((CharSequence)fileName)) {
                int lastIndexOf = fileName.lastIndexOf(".");
                String oldSuffix = fileName.substring(lastIndexOf);
                fileName = fileName.replace(oldSuffix, suffix);
            }
            if ((filesDir = PictureFileUtils.getDiskCacheDir(ctx.getApplicationContext())) != null) {
                String newPath = new StringBuffer().append(filesDir).append(File.separator).append(TextUtils.isEmpty((CharSequence)fileName) ? System.currentTimeMillis() + suffix : fileName).toString();
                ParcelFileDescriptor parcelFileDescriptor = ctx.getContentResolver().openFileDescriptor(Uri.parse((String)uri), "r");
                FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                FileInputStream inputStream = new FileInputStream(fileDescriptor);
                boolean copyFileSuccess = FileUtils.copyFile((FileInputStream)inputStream, (String)newPath);
                if (copyFileSuccess) {
                    return newPath;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String parseAudioPathToAndroidQ(Context ctx, String path, String fileName, String mineType) {
        try {
            String suffix = PictureMimeType.getLastImgSuffix(mineType);
            File filesDir = ctx.getApplicationContext().getExternalFilesDir(Environment.DIRECTORY_MUSIC);
            if (filesDir != null) {
                String newPath = new StringBuffer().append(filesDir).append(File.separator).append(TextUtils.isEmpty((CharSequence)fileName) ? System.currentTimeMillis() + suffix : fileName).toString();
                ParcelFileDescriptor parcelFileDescriptor = ctx.getApplicationContext().getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                FileInputStream inputStream = new FileInputStream(fileDescriptor);
                boolean copyFileSuccess = FileUtils.copyFile((FileInputStream)inputStream, (String)newPath);
                if (copyFileSuccess) {
                    return newPath;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

