/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.decoration;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;

public class GridSpacingItemNotBothDecoration
extends RecyclerView.ItemDecoration {
    private int spanCount;
    private int spacing;
    private boolean includeEdge;
    private boolean isRemoveBoth;

    public GridSpacingItemNotBothDecoration(int spanCount, int spacing, boolean includeEdge, boolean isRemoveBoth) {
        this.spanCount = spanCount;
        this.spacing = spacing;
        this.includeEdge = includeEdge;
        this.isRemoveBoth = isRemoveBoth;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int column = position % this.spanCount;
        if (this.includeEdge) {
            if (this.isRemoveBoth) {
                outRect.left = column == 0 ? 0 : this.spacing - column * this.spacing / this.spanCount;
                outRect.right = column == this.spanCount - 1 ? 0 : (column + 1) * this.spacing / this.spanCount;
            } else {
                outRect.left = this.spacing - column * this.spacing / this.spanCount;
                outRect.right = (column + 1) * this.spacing / this.spanCount;
            }
            if (position < this.spanCount) {
                outRect.top = this.spacing;
            }
            outRect.bottom = this.spacing;
        } else {
            outRect.left = column * this.spacing / this.spanCount;
            outRect.right = this.spacing - (column + 1) * this.spacing / this.spanCount;
            if (position >= this.spanCount) {
                outRect.top = this.spacing;
            }
        }
    }
}

