/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.util.ArrayList;

public class PictureSelectorCameraEmptyActivity
extends PictureBaseActivity {
    @Override
    public boolean isImmersive() {
        return false;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") || !PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            ToastUtils.s(this.getContext(), this.getString(R.string.picture_camera));
            this.closeActivity();
            return;
        }
        this.onTakePhoto();
        this.setTheme(R.style.Picture_Theme_Translucent);
    }

    @Override
    public int getResourceId() {
        return R.layout.picture_empty;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
    }

    private void onTakePhoto() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
            this.startCamera();
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
        }
    }

    private void startCamera() {
        switch (this.config.chooseMode) {
            case 0: 
            case 1: {
                this.startOpenCamera();
                break;
            }
            case 2: {
                this.startOpenCameraVideo();
                break;
            }
            case 3: {
                this.startOpenCameraAudio();
                break;
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            switch (requestCode) {
                case 69: {
                    this.singleCropHandleResult(data);
                    break;
                }
                case 609: {
                    this.multiCropHandleResult(data);
                    break;
                }
                case 909: {
                    this.requestCamera(data);
                    break;
                }
            }
        } else if (resultCode == 0) {
            this.closeActivity();
        } else if (resultCode == 96) {
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastUtils.s(this.getContext(), throwable.getMessage());
        }
    }

    private void singleCropHandleResult(Intent data) {
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        Uri resultUri = UCrop.getOutput((Intent)data);
        String cutPath = resultUri.getPath();
        LocalMedia media = new LocalMedia(this.cameraPath, 0L, false, this.config.isCamera ? 1 : 0, 0, this.config.chooseMode);
        media.setCut(true);
        media.setCutPath(cutPath);
        String mimeType = PictureMimeType.getImageMimeType(cutPath);
        media.setMimeType(mimeType);
        medias.add(media);
        this.handlerResult(medias);
    }

    private void requestCamera(Intent data) {
        String mimeType = null;
        long duration = 0L;
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.cameraPath = this.getAudioPath(data);
            if (TextUtils.isEmpty((CharSequence)this.cameraPath)) {
                return;
            }
            mimeType = "audio/mpeg";
            duration = isAndroidQ ? MediaUtils.extractDuration(this.getContext(), true, this.cameraPath) : MediaUtils.extractDuration(this.getContext(), false, this.cameraPath);
        }
        if (TextUtils.isEmpty((CharSequence)this.cameraPath) || new File(this.cameraPath) == null) {
            return;
        }
        long size = 0L;
        int[] newSize = new int[2];
        File file = new File(this.cameraPath);
        if (!isAndroidQ) {
            this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
        }
        LocalMedia media = new LocalMedia();
        if (this.config.chooseMode != PictureMimeType.ofAudio()) {
            if (isAndroidQ) {
                String path = PictureFileUtils.getPath(this.getApplicationContext(), Uri.parse((String)this.cameraPath));
                File f = new File(path);
                size = f.length();
                mimeType = PictureMimeType.fileToType(f);
                if (PictureMimeType.eqImage(mimeType)) {
                    int degree = PictureFileUtils.readPictureDegree((Context)this, this.cameraPath);
                    String rotateImagePath = PictureFileUtils.rotateImageToAndroidQ((Context)this, degree, this.cameraPath, this.config.cameraFileName);
                    media.setAndroidQToPath(rotateImagePath);
                    newSize = MediaUtils.getLocalImageSizeToAndroidQ((Context)this, this.cameraPath);
                } else {
                    newSize = MediaUtils.getLocalVideoSize((Context)this, Uri.parse((String)this.cameraPath));
                    duration = MediaUtils.extractDuration(this.getContext(), true, this.cameraPath);
                }
            } else {
                mimeType = PictureMimeType.fileToType(file);
                size = new File(this.cameraPath).length();
                if (PictureMimeType.eqImage(mimeType)) {
                    int degree = PictureFileUtils.readPictureDegree((Context)this, this.cameraPath);
                    PictureFileUtils.rotateImage(degree, this.cameraPath);
                    newSize = MediaUtils.getLocalImageWidthOrHeight(this.cameraPath);
                } else {
                    newSize = MediaUtils.getLocalVideoSize(this.cameraPath);
                    duration = MediaUtils.extractDuration(this.getContext(), false, this.cameraPath);
                }
            }
            boolean isMimeType = PictureMimeType.eqImage(mimeType);
            int lastImageId = MediaUtils.getLastImageId((Context)this, isMimeType);
            if (lastImageId != -1) {
                this.removeImage(lastImageId, isMimeType);
            }
        }
        media.setDuration(duration);
        media.setWidth(newSize[0]);
        media.setHeight(newSize[1]);
        media.setPath(this.cameraPath);
        media.setMimeType(mimeType);
        media.setSize(size);
        media.setChooseModel(this.config.chooseMode);
        this.cameraHandleResult(media, mimeType);
    }

    private void cameraHandleResult(LocalMedia media, String mimeType) {
        boolean eqImg = PictureMimeType.eqImage(mimeType);
        if (this.config.enableCrop && eqImg) {
            this.originalPath = this.cameraPath;
            this.startCrop(this.cameraPath);
        } else if (this.config.isCompress && eqImg && !this.config.isCheckOriginalImage) {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            result.add(media);
            this.compressImage(result);
        } else {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            result.add(media);
            this.onResult(result);
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeActivity();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] == 0) {
                        this.onTakePhoto();
                        continue;
                    }
                    this.closeActivity();
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_camera));
                }
                break;
            }
            case 2: {
                if (grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                this.closeActivity();
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_camera));
            }
        }
    }
}

