/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.config;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.luck.picture.lib.R;
import java.io.File;

public final class PictureMimeType {
    private static final String MIME_TYPE_PNG = "image/png";
    private static final String MIME_TYPE_JPEG = "image/jpeg";
    private static final String MIME_TYPE_BMP = "image/bmp";
    private static final String MIME_TYPE_GIF = "image/gif";
    private static final String MIME_TYPE_WEBP = "image/webp";
    private static final String MIME_TYPE_3GP = "video/3gp";
    private static final String MIME_TYPE_MP4 = "video/mp4";
    private static final String MIME_TYPE_MPEG = "video/mpeg";
    private static final String MIME_TYPE_AVI = "video/avi";
    public static final String JPEG = ".jpeg";
    public static final String PNG = ".png";
    public static final String MIME_TYPE_IMAGE = "image/jpeg";
    public static final String MIME_TYPE_VIDEO = "video/mp4";
    public static final String MIME_TYPE_AUDIO = "audio/mpeg";
    public static final String MIME_TYPE_PREFIX_IMAGE = "image";
    public static final String MIME_TYPE_PREFIX_VIDEO = "video";
    public static final String MIME_TYPE_PREFIX_AUDIO = "audio";

    public static final int ofAll() {
        return 0;
    }

    public static final int ofImage() {
        return 1;
    }

    public static final int ofVideo() {
        return 2;
    }

    @Deprecated
    public static final int ofAudio() {
        return 3;
    }

    public static final String ofPNG() {
        return MIME_TYPE_PNG;
    }

    public static final String ofJPEG() {
        return "image/jpeg";
    }

    public static final String ofBMP() {
        return MIME_TYPE_BMP;
    }

    public static final String ofGIF() {
        return MIME_TYPE_GIF;
    }

    public static final String ofWEBP() {
        return MIME_TYPE_WEBP;
    }

    public static final String of3GP() {
        return MIME_TYPE_3GP;
    }

    public static final String ofMP4() {
        return "video/mp4";
    }

    public static final String ofMPEG() {
        return MIME_TYPE_MPEG;
    }

    public static final String ofAVI() {
        return MIME_TYPE_AVI;
    }

    @Deprecated
    public static int isPictureType(String pictureType) {
        switch (pictureType) {
            case "video/3gp": 
            case "video/3gpp": 
            case "video/3gpp2": 
            case "video/avi": 
            case "video/mp4": 
            case "video/quicktime": 
            case "video/x-msvideo": 
            case "video/x-matroska": 
            case "video/mpeg": 
            case "video/webm": 
            case "video/mp2ts": {
                return 2;
            }
            case "audio/mpeg": 
            case "audio/amr-wb": 
            case "audio/x-ms-wma": 
            case "audio/x-wav": 
            case "audio/amr": 
            case "audio/wav": 
            case "audio/aac": 
            case "audio/mp4": 
            case "audio/quicktime": 
            case "audio/lamr": 
            case "audio/3gpp": {
                return 3;
            }
        }
        return 1;
    }

    public static boolean isGif(String mimeType) {
        return mimeType != null && (mimeType.equals(MIME_TYPE_GIF) || mimeType.equals("image/GIF"));
    }

    @Deprecated
    public static boolean isVideo(String pictureType) {
        switch (pictureType) {
            case "video/3gp": 
            case "video/3gpp": 
            case "video/3gpp2": 
            case "video/avi": 
            case "video/mp4": 
            case "video/quicktime": 
            case "video/x-msvideo": 
            case "video/x-matroska": 
            case "video/mpeg": 
            case "video/webm": 
            case "video/mp2ts": {
                return true;
            }
        }
        return false;
    }

    public static boolean eqVideo(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO);
    }

    public static boolean eqAudio(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_AUDIO);
    }

    public static boolean eqImage(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_IMAGE);
    }

    public static boolean isHttp(String path) {
        return !TextUtils.isEmpty((CharSequence)path) && (path.startsWith("http") || path.startsWith("https"));
    }

    public static String fileToType(File file) {
        if (file != null) {
            String name = file.getName();
            if (name.endsWith(".mp4") || name.endsWith(".avi") || name.endsWith(".3gpp") || name.endsWith(".3gp") || name.endsWith(".mov")) {
                return "video/mp4";
            }
            if (name.endsWith(".PNG") || name.endsWith(PNG) || name.endsWith(JPEG) || name.endsWith(".gif") || name.endsWith(".GIF") || name.endsWith(".jpg") || name.endsWith(".webp") || name.endsWith(".WEBP") || name.endsWith(".JPEG") || name.endsWith(".bmp")) {
                return "image/jpeg";
            }
            if (name.endsWith(".mp3") || name.endsWith(".amr") || name.endsWith(".aac") || name.endsWith(".war") || name.endsWith(".flac") || name.endsWith(".lamr")) {
                return MIME_TYPE_AUDIO;
            }
        }
        return "image/jpeg";
    }

    @Deprecated
    public static boolean mimeToEqual(String p1, String p2) {
        return PictureMimeType.isPictureType(p1) == PictureMimeType.isPictureType(p2);
    }

    public static boolean isMimeTypeSame(String oldMimeType, String newMimeType) {
        return PictureMimeType.getMimeType(oldMimeType) == PictureMimeType.getMimeType(newMimeType);
    }

    public static String getImageMimeType(String path) {
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file = new File(path);
                String fileName = file.getName();
                int last = fileName.lastIndexOf(".") + 1;
                String temp = fileName.substring(last);
                return "image/" + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "image/jpeg";
        }
        return "image/jpeg";
    }

    public static String getVideoMimeType(String path) {
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file = new File(path);
                String fileName = file.getName();
                int last = fileName.lastIndexOf(".") + 1;
                String temp = fileName.substring(last);
                return "video/" + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "video/mp4";
        }
        return "video/mp4";
    }

    public static String getMimeType(Context context, Uri uri) {
        Cursor cursor;
        if ("content".equals(uri.getScheme()) && (cursor = context.getApplicationContext().getContentResolver().query(uri, new String[]{"mime_type"}, null, null, null)) != null) {
            int columnIndex;
            if (cursor.moveToFirst() && (columnIndex = cursor.getColumnIndexOrThrow("mime_type")) > -1) {
                return cursor.getString(columnIndex);
            }
            cursor.close();
        }
        return "image/jpeg";
    }

    public static int getMimeType(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return 1;
        }
        if (mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO)) {
            return 2;
        }
        if (mimeType.startsWith(MIME_TYPE_PREFIX_AUDIO)) {
            return 3;
        }
        return 1;
    }

    public static String getLastImgType(String path) {
        try {
            int index = path.lastIndexOf(".");
            if (index > 0) {
                String imageType;
                switch (imageType = path.substring(index)) {
                    case ".png": 
                    case ".PNG": 
                    case ".jpg": 
                    case ".jpeg": 
                    case ".JPEG": 
                    case ".WEBP": 
                    case ".bmp": 
                    case ".BMP": 
                    case ".webp": {
                        return imageType;
                    }
                }
                return PNG;
            }
            return PNG;
        }
        catch (Exception e) {
            e.printStackTrace();
            return PNG;
        }
    }

    public static String getLastImgSuffix(String mineType) {
        String defaultSuffix = PNG;
        try {
            int index = mineType.lastIndexOf("/") + 1;
            if (index > 0) {
                return "." + mineType.substring(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultSuffix;
        }
        return defaultSuffix;
    }

    public static String s(Context context, String mimeType) {
        Context ctx = context.getApplicationContext();
        if (PictureMimeType.eqVideo(mimeType)) {
            return ctx.getString(R.string.picture_video_error);
        }
        if (PictureMimeType.eqAudio(mimeType)) {
            return ctx.getString(R.string.picture_audio_error);
        }
        return ctx.getString(R.string.picture_error);
    }
}

