/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureSimpleFragmentAdapter;
import com.luck.picture.lib.anim.OptAnimationLoader;
import com.luck.picture.lib.broadcast.BroadcastManager;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.VoiceUtils;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.yalantis.ucrop.UCropMulti;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PicturePreviewActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureSimpleFragmentAdapter.OnCallBackActivity {
    private ImageView picture_left_back;
    private TextView tv_img_num;
    private TextView tv_title;
    private TextView mTvPictureOk;
    private PreviewViewPager viewPager;
    private int position;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    private TextView check;
    private PictureSimpleFragmentAdapter adapter;
    private Animation animation;
    private View btnCheck;
    private boolean refresh;
    private int index;
    private int screenWidth;
    private Handler mHandler;
    private RelativeLayout selectBarLayout;
    private BroadcastReceiver commonBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "com.luck.picture.lib.action.close.preview": {
                    PicturePreviewActivity.this.dismissDialog();
                    PicturePreviewActivity.this.mHandler.postDelayed(() -> PicturePreviewActivity.this.onBackPressed(), 150L);
                    break;
                }
            }
        }
    };

    private void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (this.config.style.pictureTitleTextColor != 0) {
                this.tv_title.setTextColor(this.config.style.pictureTitleTextColor);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.picture_left_back.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.picturePreviewBottomBgColor != 0) {
                this.selectBarLayout.setBackgroundColor(this.config.style.picturePreviewBottomBgColor);
            }
            if (this.config.style.pictureCheckNumBgStyle != 0) {
                this.tv_img_num.setBackgroundResource(this.config.style.pictureCheckNumBgStyle);
            }
            if (this.config.style.pictureCheckedStyle != 0) {
                this.check.setBackgroundResource(this.config.style.pictureCheckedStyle);
            }
            if (this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
        }
        this.tv_title.setBackgroundColor(this.colorPrimary);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.picture_preview);
        BroadcastManager.getInstance((Context)this).registerReceiver(this.commonBroadcastReceiver, "com.luck.picture.lib.action.close.preview");
        this.mHandler = new Handler();
        this.screenWidth = ScreenUtils.getScreenWidth((Context)this);
        this.animation = OptAnimationLoader.loadAnimation((Context)this, R.anim.picture_anim_modal_in);
        this.picture_left_back = (ImageView)this.findViewById(R.id.picture_left_back);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.btnCheck = this.findViewById(R.id.btnCheck);
        this.check = (TextView)this.findViewById(R.id.check);
        this.picture_left_back.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureOk = (TextView)this.findViewById(R.id.tv_ok);
        this.tv_img_num = (TextView)this.findViewById(R.id.tv_img_num);
        this.selectBarLayout = (RelativeLayout)this.findViewById(R.id.select_bar_layout);
        this.mTvPictureOk.setOnClickListener((View.OnClickListener)this);
        this.tv_img_num.setOnClickListener((View.OnClickListener)this);
        this.tv_title = (TextView)this.findViewById(R.id.picture_title);
        this.position = this.getIntent().getIntExtra("position", 0);
        this.mTvPictureOk.setText((CharSequence)(this.numComplete ? this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}) : this.getString(R.string.picture_please_select)));
        this.tv_img_num.setSelected(this.config.checkNumMode);
        this.initPictureSelectorStyle();
        this.selectImages = this.getIntent().getParcelableArrayListExtra("selectList");
        boolean is_bottom_preview = this.getIntent().getBooleanExtra("bottom_preview", false);
        this.images = is_bottom_preview ? this.getIntent().getParcelableArrayListExtra("previewSelectList") : ImagesObservable.getInstance().readPreviewMediaData();
        this.initViewPageAdapterData();
        this.btnCheck.setOnClickListener(view -> {
            block6: {
                block8: {
                    LocalMedia image;
                    block7: {
                        boolean isChecked;
                        boolean mimeTypeSame;
                        String mimeType;
                        if (this.images == null || this.images.size() <= 0) break block6;
                        image = this.images.get(this.viewPager.getCurrentItem());
                        String string2 = mimeType = this.selectImages.size() > 0 ? this.selectImages.get(0).getMimeType() : "";
                        if (!TextUtils.isEmpty((CharSequence)mimeType) && !(mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, image.getMimeType()))) {
                            ToastUtils.s(this.mContext, this.getString(R.string.picture_rule));
                            return;
                        }
                        if (!this.check.isSelected()) {
                            isChecked = true;
                            this.check.setSelected(true);
                            this.check.startAnimation(this.animation);
                        } else {
                            isChecked = false;
                            this.check.setSelected(false);
                        }
                        if (this.selectImages.size() >= this.config.maxSelectNum && isChecked) {
                            ToastUtils.s(this.mContext, this.getString(R.string.picture_message_max_num, new Object[]{this.config.maxSelectNum}));
                            this.check.setSelected(false);
                            return;
                        }
                        if (!isChecked) break block7;
                        VoiceUtils.playVoice(this.mContext, this.config.openClickSound);
                        if (this.config.selectionMode == 1) {
                            this.singleRadioMediaImage();
                        }
                        this.selectImages.add(image);
                        image.setNum(this.selectImages.size());
                        if (!this.config.checkNumMode) break block8;
                        this.check.setText((CharSequence)String.valueOf(image.getNum()));
                        break block8;
                    }
                    for (LocalMedia media : this.selectImages) {
                        if (!media.getPath().equals(image.getPath())) continue;
                        this.selectImages.remove(media);
                        this.subSelectPosition();
                        this.notifyCheckChanged(media);
                        break;
                    }
                }
                this.onSelectNumChange(true);
            }
        });
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                PicturePreviewActivity.this.isPreviewEggs(PicturePreviewActivity.this.config.previewEggs, position, positionOffsetPixels);
            }

            public void onPageSelected(int i) {
                PicturePreviewActivity.this.position = i;
                PicturePreviewActivity.this.tv_title.setText((CharSequence)(PicturePreviewActivity.this.position + 1 + "/" + PicturePreviewActivity.this.images.size()));
                LocalMedia media = (LocalMedia)PicturePreviewActivity.this.images.get(PicturePreviewActivity.this.position);
                PicturePreviewActivity.this.index = media.getPosition();
                if (!PicturePreviewActivity.this.config.previewEggs) {
                    if (PicturePreviewActivity.this.config.checkNumMode) {
                        PicturePreviewActivity.this.check.setText((CharSequence)(media.getNum() + ""));
                        PicturePreviewActivity.this.notifyCheckChanged(media);
                    }
                    PicturePreviewActivity.this.onImageChecked(PicturePreviewActivity.this.position);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void isPreviewEggs(boolean previewEggs, int position, int positionOffsetPixels) {
        if (previewEggs && this.images.size() > 0 && this.images != null) {
            if (positionOffsetPixels < this.screenWidth / 2) {
                LocalMedia media = this.images.get(position);
                this.check.setSelected(this.isSelected(media));
                if (this.config.checkNumMode) {
                    int num = media.getNum();
                    this.check.setText((CharSequence)(num + ""));
                    this.notifyCheckChanged(media);
                    this.onImageChecked(position);
                }
            } else {
                LocalMedia media = this.images.get(position + 1);
                this.check.setSelected(this.isSelected(media));
                if (this.config.checkNumMode) {
                    int num = media.getNum();
                    this.check.setText((CharSequence)(num + ""));
                    this.notifyCheckChanged(media);
                    this.onImageChecked(position + 1);
                }
            }
        }
    }

    private void singleRadioMediaImage() {
        LocalMedia media;
        LocalMedia localMedia = media = this.selectImages != null && this.selectImages.size() > 0 ? this.selectImages.get(0) : null;
        if (media != null) {
            Bundle bundle = new Bundle();
            bundle.putInt("position", media.getPosition());
            bundle.putParcelableArrayList("selectImages", (ArrayList)this.selectImages);
            BroadcastManager.getInstance((Context)this).action("com.luck.picture.lib.action.selected.data").extras(bundle).broadcast();
            this.selectImages.clear();
        }
    }

    private void initViewPageAdapterData() {
        this.tv_title.setText((CharSequence)(this.position + 1 + "/" + this.images.size()));
        this.adapter = new PictureSimpleFragmentAdapter(this.config, this.images, (Context)this, this);
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.onSelectNumChange(false);
        this.onImageChecked(this.position);
        if (this.images.size() > 0) {
            LocalMedia media = this.images.get(this.position);
            this.index = media.getPosition();
            if (this.config.checkNumMode) {
                this.tv_img_num.setSelected(true);
                this.check.setText((CharSequence)(media.getNum() + ""));
                this.notifyCheckChanged(media);
            }
        }
    }

    private void notifyCheckChanged(LocalMedia imageBean) {
        if (this.config.checkNumMode) {
            this.check.setText((CharSequence)"");
            for (LocalMedia media : this.selectImages) {
                if (!media.getPath().equals(imageBean.getPath())) continue;
                imageBean.setNum(media.getNum());
                this.check.setText((CharSequence)String.valueOf(imageBean.getNum()));
            }
        }
    }

    private void subSelectPosition() {
        int len = this.selectImages.size();
        for (int index = 0; index < len; ++index) {
            LocalMedia media = this.selectImages.get(index);
            media.setNum(index + 1);
        }
    }

    public void onImageChecked(int position) {
        if (this.images != null && this.images.size() > 0) {
            LocalMedia media = this.images.get(position);
            this.check.setSelected(this.isSelected(media));
        } else {
            this.check.setSelected(false);
        }
    }

    public boolean isSelected(LocalMedia image) {
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    public void onSelectNumChange(boolean isRefresh) {
        boolean enable;
        this.refresh = isRefresh;
        boolean bl = enable = this.selectImages.size() != 0;
        if (enable) {
            this.mTvPictureOk.setEnabled(true);
            this.mTvPictureOk.setSelected(true);
            if (this.config.style != null && this.config.style.pictureCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureCompleteTextColor);
            }
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{this.selectImages.size(), this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                if (this.refresh) {
                    this.tv_img_num.startAnimation(this.animation);
                }
                this.tv_img_num.setVisibility(0);
                this.tv_img_num.setText((CharSequence)String.valueOf(this.selectImages.size()));
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_completed));
            }
        } else {
            this.mTvPictureOk.setEnabled(false);
            this.mTvPictureOk.setSelected(false);
            if (this.config.style != null && this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
            if (this.numComplete) {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                this.tv_img_num.setVisibility(4);
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_please_select));
            }
        }
        this.updateSelector(this.refresh);
    }

    private void updateSelector(boolean isRefresh) {
        if (isRefresh) {
            Bundle bundle = new Bundle();
            bundle.putInt("position", this.index);
            bundle.putParcelableArrayList("selectImages", (ArrayList)this.selectImages);
            BroadcastManager.getInstance((Context)this).action("com.luck.picture.lib.action.selected.data").extras(bundle).broadcast();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.picture_left_back) {
            this.onBackPressed();
        }
        if (id2 == R.id.tv_ok || id2 == R.id.tv_img_num) {
            String mimeType;
            int size = this.selectImages.size();
            LocalMedia image = this.selectImages.size() > 0 ? this.selectImages.get(0) : null;
            String string2 = mimeType = image != null ? image.getMimeType() : "";
            if (this.config.minSelectNum > 0 && size < this.config.minSelectNum && this.config.selectionMode == 2) {
                boolean eqImg = PictureMimeType.eqImage(mimeType);
                String str = eqImg ? this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}) : this.getString(R.string.picture_min_video_num, new Object[]{this.config.minSelectNum});
                ToastUtils.s(this.mContext, str);
                return;
            }
            if (this.config.enableCrop && PictureMimeType.eqImage(mimeType)) {
                if (this.config.selectionMode == 1) {
                    this.originalPath = image.getPath();
                    this.startCrop(this.originalPath);
                } else {
                    ArrayList<String> cuts = new ArrayList<String>();
                    for (LocalMedia media : this.selectImages) {
                        cuts.add(media.getPath());
                    }
                    this.startCrop(cuts);
                }
            } else {
                this.onResult(this.selectImages);
            }
        }
    }

    @Override
    public void onResult(List<LocalMedia> images) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("selectImages", (ArrayList)images);
        BroadcastManager.getInstance((Context)this).action("com.luck.picture.lib.action.preview.compression").extras(bundle).broadcast();
        if (!this.config.isCompress) {
            this.onBackPressed();
        } else {
            this.showPleaseDialog();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 609: {
                    List list = UCropMulti.getOutput((Intent)data);
                    this.setResult(-1, new Intent().putExtra("com.yalantis.ucrop.OutputUriList", (Serializable)((Object)list)));
                    this.finish();
                    break;
                }
                case 69: {
                    if (data != null) {
                        this.setResult(-1, data);
                    }
                    this.finish();
                }
            }
        } else if (resultCode == 96) {
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastUtils.s(this.mContext, throwable.getMessage());
        }
    }

    public void onBackPressed() {
        this.closeActivity();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ImagesObservable.getInstance().clearPreviewMediaData();
        if (this.commonBroadcastReceiver != null) {
            BroadcastManager.getInstance((Context)this).unregisterReceiver(this.commonBroadcastReceiver, "com.luck.picture.lib.action.close.preview");
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
    }

    @Override
    public void onActivityBackPressed() {
        this.onBackPressed();
    }
}

