/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.content.Intent;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.viewpager.widget.PagerAdapter;
import com.luck.picture.lib.PictureVideoPlayActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.widget.longimage.ImageSource;
import com.luck.picture.lib.widget.longimage.ImageViewState;
import com.luck.picture.lib.widget.longimage.SubsamplingScaleImageView;
import java.io.File;
import java.util.List;

public class SimpleFragmentAdapter
extends PagerAdapter {
    private List<LocalMedia> images;
    private Context mContext;
    private OnCallBackActivity onBackPressed;
    private PictureSelectionConfig config;

    public SimpleFragmentAdapter(PictureSelectionConfig config, List<LocalMedia> images, Context context, OnCallBackActivity onBackPressed) {
        this.config = config;
        this.images = images;
        this.mContext = context;
        this.onBackPressed = onBackPressed;
    }

    public int getCount() {
        return this.images != null ? this.images.size() : 0;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View contentView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.picture_image_preview, container, false);
        PhotoView imageView = (PhotoView)contentView.findViewById(R.id.preview_image);
        SubsamplingScaleImageView longImg = (SubsamplingScaleImageView)contentView.findViewById(R.id.longImg);
        ImageView iv_play = (ImageView)contentView.findViewById(R.id.iv_play);
        LocalMedia media = this.images.get(position);
        if (media != null) {
            String mimeType = media.getMimeType();
            boolean eqVideo = PictureMimeType.eqVideo(mimeType);
            iv_play.setVisibility(eqVideo ? 0 : 8);
            String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : media.getPath());
            boolean isGif = PictureMimeType.isGif(mimeType);
            boolean eqLongImg = MediaUtils.isLongImg(media);
            imageView.setVisibility(eqLongImg && !isGif ? 8 : 0);
            longImg.setVisibility(eqLongImg && !isGif ? 0 : 8);
            if (isGif && !media.isCompressed()) {
                if (this.config != null && this.config.imageEngine != null) {
                    this.config.imageEngine.loadAsGifImage(contentView.getContext(), path, imageView);
                }
            } else if (this.config != null && this.config.imageEngine != null) {
                if (eqLongImg) {
                    this.displayLongPic(SdkVersionUtils.checkedAndroid_Q() ? Uri.parse((String)path) : Uri.fromFile((File)new File(path)), longImg);
                } else {
                    this.config.imageEngine.loadImage(contentView.getContext(), path, imageView);
                }
            }
            imageView.setOnViewTapListener((view, x, y) -> {
                if (this.onBackPressed != null) {
                    this.onBackPressed.onActivityBackPressed();
                }
            });
            longImg.setOnClickListener(v -> {
                if (this.onBackPressed != null) {
                    this.onBackPressed.onActivityBackPressed();
                }
            });
            iv_play.setOnClickListener(v -> {
                Intent intent = new Intent();
                Bundle bundle = new Bundle();
                bundle.putString("video_path", path);
                intent.putExtras(bundle);
                intent.setClass(this.mContext, PictureVideoPlayActivity.class);
                this.mContext.startActivity(intent);
            });
        }
        container.addView(contentView, 0);
        return contentView;
    }

    private void displayLongPic(Uri uri, SubsamplingScaleImageView longImg) {
        longImg.setQuickScaleEnabled(true);
        longImg.setZoomEnabled(true);
        longImg.setPanEnabled(true);
        longImg.setDoubleTapZoomDuration(100);
        longImg.setMinimumScaleType(2);
        longImg.setDoubleTapZoomDpi(2);
        longImg.setImage(ImageSource.uri(uri), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
    }

    public static interface OnCallBackActivity {
        public void onActivityBackPressed();
    }
}

