/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.anim.OptAnimationLoader;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.VoiceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PictureImageGridAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int DURATION = 450;
    private Context context;
    private boolean showCamera;
    private OnPhotoSelectChangedListener imageSelectChangedListener;
    private int maxSelectNum;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    private boolean enablePreview;
    private int selectMode;
    private boolean enablePreviewVideo;
    private boolean enablePreviewAudio;
    private boolean is_checked_num;
    private boolean enableVoice;
    private Animation animation;
    private PictureSelectionConfig config;
    private int chooseMode;
    private boolean zoomAnim;
    private boolean isSingleDirectReturn;
    private boolean isGo;

    public PictureImageGridAdapter(Context context, PictureSelectionConfig config) {
        this.context = context;
        this.config = config;
        this.selectMode = config.selectionMode;
        this.showCamera = config.isCamera;
        this.maxSelectNum = config.maxSelectNum;
        this.enablePreview = config.enablePreview;
        this.enablePreviewVideo = config.enPreviewVideo;
        this.enablePreviewAudio = config.enablePreviewAudio;
        this.is_checked_num = config.checkNumMode;
        this.enableVoice = config.openClickSound;
        this.chooseMode = config.chooseMode;
        this.zoomAnim = config.zoomAnim;
        this.isSingleDirectReturn = config.isSingleDirectReturn;
        this.animation = OptAnimationLoader.loadAnimation(context, R.anim.modal_in);
    }

    public void setShowCamera(boolean showCamera) {
        this.showCamera = showCamera;
    }

    public void bindImagesData(List<LocalMedia> images) {
        this.images = images;
        this.notifyDataSetChanged();
    }

    public void bindSelectImages(List<LocalMedia> images) {
        ArrayList<LocalMedia> selection = new ArrayList<LocalMedia>();
        for (LocalMedia media : images) {
            selection.add(media);
        }
        this.selectImages = selection;
        this.subSelectPosition();
        if (this.imageSelectChangedListener != null) {
            this.imageSelectChangedListener.onChange(this.selectImages);
        }
    }

    public List<LocalMedia> getSelectedImages() {
        if (this.selectImages == null) {
            this.selectImages = new ArrayList<LocalMedia>();
        }
        return this.selectImages;
    }

    public List<LocalMedia> getImages() {
        if (this.images == null) {
            this.images = new ArrayList<LocalMedia>();
        }
        return this.images;
    }

    public int getItemViewType(int position) {
        if (this.showCamera && position == 0) {
            return 1;
        }
        return 2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.picture_item_camera, parent, false);
            return new HeaderViewHolder(view);
        }
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.picture_image_grid_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.getItemViewType(position) == 1) {
            HeaderViewHolder headerHolder = (HeaderViewHolder)holder;
            headerHolder.headerView.setOnClickListener(v -> {
                if (this.imageSelectChangedListener != null) {
                    this.imageSelectChangedListener.onTakePhoto();
                }
            });
        } else {
            ViewHolder contentHolder = (ViewHolder)holder;
            LocalMedia image = this.images.get(this.showCamera ? position - 1 : position);
            image.position = contentHolder.getAdapterPosition();
            String path = image.getPath();
            String mimeType = image.getMimeType();
            if (this.is_checked_num) {
                this.notifyCheckChanged(contentHolder, image);
            }
            this.selectImage(contentHolder, this.isSelected(image), false);
            boolean gif = PictureMimeType.isGif(mimeType);
            contentHolder.llCheck.setVisibility(this.isSingleDirectReturn ? 8 : 0);
            contentHolder.tvIsGif.setVisibility(gif ? 0 : 8);
            if (this.chooseMode == PictureMimeType.ofAudio()) {
                contentHolder.tvDuration.setVisibility(0);
                if (Build.VERSION.SDK_INT >= 17) {
                    contentHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.picture_audio, 0, 0, 0);
                }
            } else {
                if (Build.VERSION.SDK_INT >= 17) {
                    contentHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.video_icon, 0, 0, 0);
                }
                contentHolder.tvDuration.setVisibility(PictureMimeType.eqVideo(mimeType) ? 0 : 8);
            }
            boolean eqLongImg = MediaUtils.isLongImg(image);
            contentHolder.tvLongChart.setVisibility(eqLongImg ? 0 : 8);
            long duration = image.getDuration();
            contentHolder.tvDuration.setText((CharSequence)DateUtils.formatDurationTime(duration));
            if (this.chooseMode == PictureMimeType.ofAudio()) {
                contentHolder.iv_picture.setImageResource(R.drawable.audio_placeholder);
            } else if (this.config != null && this.config.imageEngine != null) {
                this.config.imageEngine.loadAsBitmapGridImage(this.context, path, contentHolder.iv_picture, R.drawable.image_placeholder);
            }
            if (this.enablePreview || this.enablePreviewVideo || this.enablePreviewAudio) {
                contentHolder.llCheck.setOnClickListener(v -> {
                    String newPath;
                    String string2 = newPath = SdkVersionUtils.checkedAndroid_Q() ? PictureFileUtils.getPath(this.context, Uri.parse((String)path)) : path;
                    if (!new File(newPath).exists()) {
                        ToastUtils.s(this.context, PictureMimeType.s(this.context, mimeType));
                        return;
                    }
                    this.changeCheckboxState(contentHolder, image);
                });
            }
            contentHolder.contentView.setOnClickListener(v -> {
                boolean eqResult;
                int index;
                String newPath;
                String string2 = newPath = SdkVersionUtils.checkedAndroid_Q() ? PictureFileUtils.getPath(this.context, Uri.parse((String)path)) : path;
                if (!new File(newPath).exists()) {
                    ToastUtils.s(this.context, PictureMimeType.s(this.context, mimeType));
                    return;
                }
                int n = index = this.showCamera ? position - 1 : position;
                if (index == -1) {
                    return;
                }
                boolean bl = eqResult = PictureMimeType.eqImage(mimeType) && this.enablePreview || PictureMimeType.eqVideo(mimeType) && (this.enablePreviewVideo || this.selectMode == 1) || PictureMimeType.eqAudio(mimeType) && (this.enablePreviewAudio || this.selectMode == 1);
                if (eqResult) {
                    this.imageSelectChangedListener.onPictureClick(image, index);
                } else {
                    this.changeCheckboxState(contentHolder, image);
                }
            });
        }
    }

    public int getItemCount() {
        return this.showCamera ? this.images.size() + 1 : this.images.size();
    }

    public boolean isSelected(LocalMedia image) {
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    private void notifyCheckChanged(ViewHolder viewHolder, LocalMedia imageBean) {
        viewHolder.check.setText((CharSequence)"");
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(imageBean.getPath())) continue;
            imageBean.setNum(media.getNum());
            media.setPosition(imageBean.getPosition());
            viewHolder.check.setText((CharSequence)String.valueOf(imageBean.getNum()));
        }
    }

    @SuppressLint(value={"StringFormatMatches"})
    private void changeCheckboxState(ViewHolder contentHolder, LocalMedia image) {
        boolean mimeTypeSame;
        String mimeType;
        boolean isChecked = contentHolder.check.isSelected();
        String string2 = mimeType = this.selectImages.size() > 0 ? this.selectImages.get(0).getMimeType() : "";
        if (!TextUtils.isEmpty((CharSequence)mimeType) && !(mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, image.getMimeType()))) {
            ToastUtils.s(this.context, this.context.getString(R.string.picture_rule));
            return;
        }
        if (this.selectImages.size() >= this.maxSelectNum && !isChecked) {
            String str = PictureMimeType.eqVideo(mimeType) ? this.context.getString(R.string.picture_message_video_max_num, new Object[]{this.maxSelectNum}) : (PictureMimeType.eqAudio(mimeType) ? this.context.getString(R.string.picture_message_audio_max_num, new Object[]{this.maxSelectNum}) : this.context.getString(R.string.picture_message_max_num, new Object[]{this.maxSelectNum}));
            ToastUtils.s(this.context, str);
            return;
        }
        if (isChecked) {
            for (LocalMedia media : this.selectImages) {
                if (!media.getPath().equals(image.getPath())) continue;
                this.selectImages.remove(media);
                this.subSelectPosition();
                this.disZoom(contentHolder.iv_picture);
                break;
            }
        } else {
            if (this.selectMode == 1) {
                this.singleRadioMediaImage();
            }
            this.selectImages.add(image);
            image.setNum(this.selectImages.size());
            VoiceUtils.playVoice(this.context, this.enableVoice);
            this.zoom(contentHolder.iv_picture);
        }
        this.notifyItemChanged(contentHolder.getAdapterPosition());
        this.selectImage(contentHolder, !isChecked, true);
        if (this.imageSelectChangedListener != null) {
            this.imageSelectChangedListener.onChange(this.selectImages);
        }
    }

    private void singleRadioMediaImage() {
        if (this.selectImages != null && this.selectImages.size() > 0) {
            this.isGo = true;
            LocalMedia media = this.selectImages.get(0);
            this.notifyItemChanged(this.config.isCamera ? media.position : (this.isGo ? media.position : (media.position > 0 ? media.position - 1 : 0)));
            this.selectImages.clear();
        }
    }

    private void subSelectPosition() {
        if (this.is_checked_num) {
            int size = this.selectImages.size();
            int length = size;
            for (int index = 0; index < length; ++index) {
                LocalMedia media = this.selectImages.get(index);
                media.setNum(index + 1);
                this.notifyItemChanged(media.position);
            }
        }
    }

    public void selectImage(ViewHolder holder, boolean isChecked, boolean isAnim) {
        holder.check.setSelected(isChecked);
        if (isChecked) {
            if (isAnim && this.animation != null) {
                holder.check.startAnimation(this.animation);
            }
            holder.iv_picture.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.image_overlay_true), PorterDuff.Mode.SRC_ATOP);
        } else {
            holder.iv_picture.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.image_overlay_false), PorterDuff.Mode.SRC_ATOP);
        }
    }

    public void setOnPhotoSelectChangedListener(OnPhotoSelectChangedListener imageSelectChangedListener) {
        this.imageSelectChangedListener = imageSelectChangedListener;
    }

    private void zoom(ImageView iv_img) {
        if (this.zoomAnim) {
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)iv_img, (String)"scaleX", (float[])new float[]{1.0f, 1.12f}), ObjectAnimator.ofFloat((Object)iv_img, (String)"scaleY", (float[])new float[]{1.0f, 1.12f})});
            set.setDuration(450L);
            set.start();
        }
    }

    private void disZoom(ImageView iv_img) {
        if (this.zoomAnim) {
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)iv_img, (String)"scaleX", (float[])new float[]{1.12f, 1.0f}), ObjectAnimator.ofFloat((Object)iv_img, (String)"scaleY", (float[])new float[]{1.12f, 1.0f})});
            set.setDuration(450L);
            set.start();
        }
    }

    public static interface OnPhotoSelectChangedListener {
        public void onTakePhoto();

        public void onChange(List<LocalMedia> var1);

        public void onPictureClick(LocalMedia var1, int var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView iv_picture;
        TextView check;
        TextView tvDuration;
        TextView tvIsGif;
        TextView tvLongChart;
        View contentView;
        LinearLayout llCheck;

        public ViewHolder(View itemView) {
            super(itemView);
            this.contentView = itemView;
            this.iv_picture = (ImageView)itemView.findViewById(R.id.iv_picture);
            this.check = (TextView)itemView.findViewById(R.id.check);
            this.llCheck = (LinearLayout)itemView.findViewById(R.id.ll_check);
            this.tvDuration = (TextView)itemView.findViewById(R.id.tv_duration);
            this.tvIsGif = (TextView)itemView.findViewById(R.id.tv_isGif);
            this.tvLongChart = (TextView)itemView.findViewById(R.id.tv_long_chart);
        }
    }

    public class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        View headerView;
        TextView tv_title_camera;

        public HeaderViewHolder(View itemView) {
            super(itemView);
            this.headerView = itemView;
            this.tv_title_camera = (TextView)itemView.findViewById(R.id.tv_title_camera);
            String title = PictureImageGridAdapter.this.chooseMode == PictureMimeType.ofAudio() ? PictureImageGridAdapter.this.context.getString(R.string.picture_tape) : PictureImageGridAdapter.this.context.getString(R.string.picture_take_picture);
            this.tv_title_camera.setText((CharSequence)title);
        }
    }
}

