/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectorCameraEmptyActivity
extends PictureBaseActivity {
    @Override
    public boolean isImmersive() {
        return false;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") || !PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            ToastUtils.s(this.mContext, this.getString(R.string.picture_camera));
            this.closeActivity();
            return;
        }
        this.onTakePhoto();
        this.setTheme(R.style.MyTheme_Translucent);
        this.setContentView(R.layout.picture_empty);
    }

    private void onTakePhoto() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
            this.startCamera();
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
        }
    }

    private void startCamera() {
        switch (this.config.chooseMode) {
            case 0: 
            case 1: {
                this.startOpenCamera();
                break;
            }
            case 2: {
                this.startOpenCameraVideo();
                break;
            }
            case 3: {
                this.startOpenCameraAudio();
                break;
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            switch (requestCode) {
                case 69: {
                    this.singleCropHandleResult(data);
                    break;
                }
                case 609: {
                    this.multiCropHandleResult(data);
                    break;
                }
                case 909: {
                    this.requestCamera(data);
                    break;
                }
            }
        } else if (resultCode == 0) {
            this.closeActivity();
        } else if (resultCode == 96) {
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastUtils.s(this.mContext, throwable.getMessage());
        }
    }

    private void singleCropHandleResult(Intent data) {
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        Uri resultUri = UCrop.getOutput((Intent)data);
        String cutPath = resultUri.getPath();
        LocalMedia media = new LocalMedia(this.cameraPath, 0L, false, this.config.isCamera ? 1 : 0, 0, this.config.chooseMode);
        media.setCut(true);
        media.setCutPath(cutPath);
        String mimeType = PictureMimeType.getImageMimeType(cutPath);
        media.setMimeType(mimeType);
        medias.add(media);
        this.handlerResult(medias);
    }

    private void requestCamera(Intent data) {
        int lastImageId;
        String mimeType;
        long size;
        File file;
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.cameraPath = this.getAudioPath(data);
        }
        if ((file = new File(this.cameraPath)) == null) {
            return;
        }
        this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        if (isAndroidQ) {
            String path = PictureFileUtils.getPath(this.getApplicationContext(), Uri.parse((String)this.cameraPath));
            File f = new File(path);
            size = f.length();
            mimeType = PictureMimeType.fileToType(f);
        } else {
            mimeType = PictureMimeType.fileToType(file);
            size = new File(this.cameraPath).length();
        }
        if (this.config.chooseMode != PictureMimeType.ofAudio()) {
            int degree = PictureFileUtils.readPictureDegree(file.getAbsolutePath());
            this.rotateImage(degree, file);
        }
        LocalMedia media = new LocalMedia();
        media.setPath(this.cameraPath);
        boolean eqVideo = PictureMimeType.eqVideo(mimeType);
        mimeType = this.config.chooseMode == PictureMimeType.ofAudio() ? "audio/mpeg" : (eqVideo ? (isAndroidQ ? PictureMimeType.getMimeType(this.mContext, Uri.parse((String)this.cameraPath)) : PictureMimeType.getVideoMimeType(this.cameraPath)) : (isAndroidQ ? PictureMimeType.getMimeType(this.mContext, Uri.parse((String)this.cameraPath)) : PictureMimeType.getImageMimeType(this.cameraPath)));
        long duration = MediaUtils.extractDuration(this.mContext, isAndroidQ, this.cameraPath);
        media.setMimeType(mimeType);
        media.setDuration(duration);
        media.setSize(size);
        media.setChooseModel(this.config.chooseMode);
        this.cameraHandleResult(medias, media, mimeType);
        if (this.config.chooseMode != PictureMimeType.ofAudio() && (lastImageId = this.getLastImageId(eqVideo)) != -1) {
            this.removeImage(lastImageId, eqVideo);
        }
    }

    private void cameraHandleResult(List<LocalMedia> medias, LocalMedia media, String mimeType) {
        boolean eqImg = PictureMimeType.eqImage(mimeType);
        if (this.config.enableCrop && eqImg) {
            this.originalPath = this.cameraPath;
            this.startCrop(this.cameraPath);
        } else if (this.config.isCompress && eqImg) {
            medias.add(media);
            this.compressImage(medias);
        } else {
            medias.add(media);
            this.onResult(medias);
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeActivity();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] == 0) {
                        this.onTakePhoto();
                        continue;
                    }
                    this.closeActivity();
                    ToastUtils.s(this.mContext, this.getString(R.string.picture_camera));
                }
                break;
            }
            case 2: {
                if (grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                this.closeActivity();
                ToastUtils.s(this.mContext, this.getString(R.string.picture_camera));
            }
        }
    }
}

