/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.tools.SdkVersionUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Locale;

public class PictureFileUtils {
    public static final String POSTFIX = ".JPEG";
    public static final String POST_VIDEO = ".mp4";
    public static final String POST_AUDIO = ".mp3";
    public static final String APP_NAME = "PictureSelector";
    public static final String CAMERA_PATH_IMAGE = "/PictureSelector/CameraImage/";
    public static final String CAMERA_PATH_VIDEO = "/PictureSelector/CameraVideo/";
    public static final String CAMERA_PATH_AUDIO = "/PictureSelector/CameraAudio/";
    static final String TAG = "PictureFileUtils";

    public static File createCameraFile(Context context, int type, String fileName, String format) {
        return PictureFileUtils.createMediaFile(context, type, fileName, format);
    }

    private static File createMediaFile(Context context, int type, String fileName, String format) {
        File tmpFile;
        File rootDir;
        if (SdkVersionUtils.checkedAndroid_Q()) {
            rootDir = PictureFileUtils.getRootDirFile(context, type);
        } else {
            String state = Environment.getExternalStorageState();
            File file = rootDir = state.equals("mounted") ? Environment.getExternalStorageDirectory() : context.getCacheDir();
        }
        if (rootDir == null || rootDir.exists() || rootDir.mkdirs()) {
            // empty if block
        }
        String parentPath = PictureFileUtils.getParentPath(type);
        File folderDir = new File(SdkVersionUtils.checkedAndroid_Q() ? rootDir.getAbsolutePath() : rootDir.getAbsolutePath() + parentPath);
        if (folderDir == null || folderDir.exists() || folderDir.mkdirs()) {
            // empty if block
        }
        fileName = TextUtils.isEmpty((CharSequence)fileName) ? String.valueOf(System.currentTimeMillis()) : fileName;
        switch (type) {
            case 2: {
                tmpFile = new File(folderDir, fileName + POST_VIDEO);
                break;
            }
            case 3: {
                tmpFile = new File(folderDir, fileName + POST_AUDIO);
                break;
            }
            default: {
                String suffixType = TextUtils.isEmpty((CharSequence)format) ? POSTFIX : format;
                tmpFile = new File(folderDir, fileName + suffixType);
            }
        }
        Log.i((String)"Mike", (String)("createMediaFile: " + tmpFile.getAbsolutePath()));
        return tmpFile;
    }

    private static File getRootDirFile(Context context, int type) {
        switch (type) {
            case 2: {
                return context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            }
            case 3: {
                return context.getExternalFilesDir(Environment.DIRECTORY_MUSIC);
            }
        }
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
    }

    private static String getParentPath(int type) {
        switch (type) {
            case 2: {
                return CAMERA_PATH_VIDEO;
            }
            case 3: {
                return CAMERA_PATH_AUDIO;
            }
        }
        return CAMERA_PATH_IMAGE;
    }

    private PictureFileUtils() {
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        catch (IllegalArgumentException ex) {
            Log.i((String)TAG, (String)String.format(Locale.getDefault(), "getDataColumn: _data - [%s]", ex.getMessage()));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (PictureFileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    if (SdkVersionUtils.checkedAndroid_Q()) {
                        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) + "/" + split[1];
                    }
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (PictureFileUtils.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return PictureFileUtils.getDataColumn(context, contentUri, null, null);
                }
                if (PictureFileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return PictureFileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (PictureFileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return PictureFileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(@NonNull String pathFrom, @NonNull String pathTo) throws IOException {
        if (pathFrom.equalsIgnoreCase(pathTo)) {
            return;
        }
        AbstractInterruptibleChannel outputChannel = null;
        AbstractInterruptibleChannel inputChannel = null;
        try {
            inputChannel = new FileInputStream(new File(pathFrom)).getChannel();
            outputChannel = new FileOutputStream(new File(pathTo)).getChannel();
            ((FileChannel)inputChannel).transferTo(0L, ((FileChannel)inputChannel).size(), (WritableByteChannel)((Object)outputChannel));
            inputChannel.close();
        }
        finally {
            if (inputChannel != null) {
                inputChannel.close();
            }
            if (outputChannel != null) {
                outputChannel.close();
            }
        }
    }

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap rotaingImageView(int angle, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        System.out.println("angle2=" + angle);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static void saveBitmapFile(Bitmap bitmap, File file) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String createDir(Context context, String filename) {
        File rootDir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        return rootDir + "/" + filename;
    }

    public static String getDCIMCameraPath(Context ctx) {
        String absolutePath;
        try {
            absolutePath = SdkVersionUtils.checkedAndroid_Q() ? "%" + ctx.getExternalFilesDir(Environment.DIRECTORY_PICTURES) + "/Camera" : "%" + Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + "/Camera";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return absolutePath;
    }

    public static void deleteCacheDirFile(Context mContext, int type) {
        File cutDir = mContext.getExternalFilesDir(type == PictureMimeType.ofImage() ? Environment.DIRECTORY_PICTURES : Environment.DIRECTORY_MOVIES);
        if (cutDir != null) {
            File[] files;
            for (File file : files = cutDir.listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    public static String getDiskCacheDir(Context ctx) {
        return ctx.getExternalFilesDir(Environment.DIRECTORY_PICTURES).getPath();
    }

    public static Uri parUri(Context context, File cameraFile) {
        String authority = context.getPackageName() + ".provider";
        Uri imageUri = Build.VERSION.SDK_INT > 23 ? FileProvider.getUriForFile((Context)context, (String)authority, (File)cameraFile) : Uri.fromFile((File)cameraFile);
        return imageUri;
    }
}

