/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.rxbus2;

import androidx.annotation.NonNull;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public class RxUtils {
    public static <T> DisposableObserver computation(RxSimpleTask task, Object ... objects) {
        return RxUtils.computation(0L, task, objects);
    }

    public static <T> DisposableObserver computation(long delayMilliseconds, final RxSimpleTask task, Object ... objects) {
        Observable observable = Observable.create(e -> {
            Object obj = task.doSth(objects);
            if (obj == null) {
                obj = new Object();
            }
            e.onNext(obj);
            e.onComplete();
        }).delay(delayMilliseconds, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.computation()).observeOn(AndroidSchedulers.mainThread());
        DisposableObserver disposableObserver = new DisposableObserver<T>(){

            public void onNext(T o) {
                if (!this.isDisposed()) {
                    task.onNext(o);
                }
            }

            public void onError(Throwable e) {
                if (!this.isDisposed()) {
                    task.onError(e);
                }
            }

            public void onComplete() {
                if (!this.isDisposed()) {
                    task.onComplete();
                }
            }
        };
        observable.subscribe((Observer)disposableObserver);
        return disposableObserver;
    }

    public static <T> void newThread(RxSimpleTask task, Object ... objects) {
        RxUtils.newThread(0L, task, objects);
    }

    public static <T> void newThread(long delayMilliseconds, final RxSimpleTask task, Object ... objects) {
        Observable observable = Observable.create(e -> {
            Object obj = task.doSth(objects);
            if (obj == null) {
                obj = new Object();
            }
            e.onNext(obj);
            e.onComplete();
        }).delay(delayMilliseconds, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
        observable.subscribe((Observer)new DisposableObserver<T>(){

            public void onNext(T o) {
                if (!this.isDisposed()) {
                    task.onNext(o);
                }
            }

            public void onError(Throwable e) {
                if (!this.isDisposed()) {
                    task.onError(e);
                }
            }

            public void onComplete() {
                if (!this.isDisposed()) {
                    task.onComplete();
                }
            }
        });
    }

    public static <T> void io(RxSimpleTask task) {
        RxUtils.io(0L, task);
    }

    public static <T> void io(long delayMilliseconds, final RxSimpleTask task) {
        Observable observable = Observable.create(e -> {
            Object obj = task.doSth(new Object[0]);
            if (obj == null) {
                obj = new Object();
            }
            e.onNext(obj);
            e.onComplete();
        }).delay(delayMilliseconds, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        observable.subscribe((Observer)new DisposableObserver<T>(){

            public void onNext(T o) {
                if (!this.isDisposed()) {
                    task.onNext(o);
                }
            }

            public void onError(Throwable e) {
                if (!this.isDisposed()) {
                    task.onError(e);
                }
            }

            public void onComplete() {
                if (!this.isDisposed()) {
                    task.onComplete();
                }
            }
        });
    }

    private RxUtils() {
    }

    public static abstract class RxSimpleTask<T> {
        public T getDefault() {
            return null;
        }

        @NonNull
        public T doSth(Object ... objects) {
            return this.getDefault();
        }

        public void onNext(T returnData) {
        }

        public void onError(Throwable e) {
        }

        public void onComplete() {
        }
    }
}

