/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import androidx.annotation.NonNull;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.rxbus2.RxUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class LocalMediaLoader {
    private int type;
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String ORDER_BY = "_id DESC";
    private static final String NOT_GIF = "!='image/gif'";
    private static final int AUDIO_DURATION = 500;
    private Context mContext;
    private boolean isGif;
    private long videoMaxS;
    private long videoMinS;
    private boolean isAndroidQ;
    private static final String[] PROJECTION = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size"};
    private static final String SELECTION = "media_type=? AND _size>0";
    private static final String SELECTION_NOT_GIF = "media_type=? AND _size>0 AND mime_type!='image/gif'";
    private static final String[] SELECTION_ALL_ARGS = new String[]{String.valueOf(1), String.valueOf(3)};

    private static String getSelectionArgsForSingleMediaCondition(String time_condition) {
        return "media_type=? AND _size>0 AND " + time_condition;
    }

    private static String getSelectionArgsForSingleMediaCondition() {
        return SELECTION;
    }

    private static String getSelectionArgsForAllMediaCondition(String time_condition, boolean isGif) {
        String condition = "(media_type=?" + (isGif ? "" : " AND mime_type!='image/gif'") + " OR " + "media_type=? AND " + time_condition + ") AND " + "_size" + ">0";
        return condition;
    }

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    public LocalMediaLoader(Context context, int type, boolean isGif, long videoMaxS, long videoMinS) {
        this.mContext = context.getApplicationContext();
        this.type = type;
        this.isGif = isGif;
        this.videoMaxS = videoMaxS;
        this.videoMinS = videoMinS;
        this.isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
    }

    public void loadAllMedia(final LocalMediaLoadListener imageLoadListener) {
        RxUtils.io(new RxUtils.RxSimpleTask<List<LocalMediaFolder>>(){

            @Override
            @NonNull
            public List<LocalMediaFolder> doSth(Object ... objects) {
                Cursor data = LocalMediaLoader.this.mContext.getContentResolver().query(QUERY_URI, PROJECTION, LocalMediaLoader.this.getSelection(), LocalMediaLoader.this.getSelectionArgs(), LocalMediaLoader.ORDER_BY);
                try {
                    int count;
                    ArrayList<LocalMediaFolder> imageFolders = new ArrayList<LocalMediaFolder>();
                    LocalMediaFolder allImageFolder = new LocalMediaFolder();
                    ArrayList<LocalMedia> latelyImages = new ArrayList<LocalMedia>();
                    if (data != null && (count = data.getCount()) > 0) {
                        data.moveToFirst();
                        do {
                            long id2 = data.getLong(data.getColumnIndexOrThrow(PROJECTION[0]));
                            String path = LocalMediaLoader.this.isAndroidQ ? LocalMediaLoader.this.getRealPathAndroid_Q(id2) : data.getString(data.getColumnIndexOrThrow(PROJECTION[1]));
                            String mimeType = data.getString(data.getColumnIndexOrThrow(PROJECTION[2]));
                            int w = data.getInt(data.getColumnIndexOrThrow(PROJECTION[3]));
                            int h = data.getInt(data.getColumnIndexOrThrow(PROJECTION[4]));
                            long duration = data.getLong(data.getColumnIndexOrThrow(PROJECTION[5]));
                            long size = data.getLong(data.getColumnIndexOrThrow(PROJECTION[6]));
                            Log.i((String)"Mike", (String)("doSth: " + mimeType + "----" + path + "---" + size));
                            if (LocalMediaLoader.this.type == 2) {
                                if (duration == 0L) {
                                    duration = MediaUtils.extractDuration(LocalMediaLoader.this.mContext, LocalMediaLoader.this.isAndroidQ, path);
                                }
                                if (LocalMediaLoader.this.videoMinS > 0L && duration < LocalMediaLoader.this.videoMinS || LocalMediaLoader.this.videoMaxS > 0L && duration > LocalMediaLoader.this.videoMaxS || duration == 0L || size <= 0L) continue;
                            }
                            LocalMedia image = new LocalMedia(path, duration, LocalMediaLoader.this.type, mimeType, w, h, size);
                            LocalMediaFolder folder = LocalMediaLoader.this.getImageFolder(path, imageFolders);
                            List<LocalMedia> images = folder.getImages();
                            images.add(image);
                            folder.setImageNum(folder.getImageNum() + 1);
                            latelyImages.add(image);
                            int imageNum = allImageFolder.getImageNum();
                            allImageFolder.setImageNum(imageNum + 1);
                        } while (data.moveToNext());
                        if (latelyImages.size() > 0) {
                            LocalMediaLoader.this.sortFolder(imageFolders);
                            imageFolders.add(0, allImageFolder);
                            allImageFolder.setFirstImagePath(((LocalMedia)latelyImages.get(0)).getPath());
                            String title = LocalMediaLoader.this.type == PictureMimeType.ofAudio() ? LocalMediaLoader.this.mContext.getString(R.string.picture_all_audio) : LocalMediaLoader.this.mContext.getString(R.string.picture_camera_roll);
                            allImageFolder.setName(title);
                            allImageFolder.setImages(latelyImages);
                        }
                        return imageFolders;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return this.getDefault();
            }

            @Override
            public List<LocalMediaFolder> getDefault() {
                return new ArrayList<LocalMediaFolder>();
            }

            @Override
            public void onNext(List<LocalMediaFolder> imageFolders) {
                super.onNext(imageFolders);
                if (imageLoadListener != null) {
                    imageLoadListener.loadComplete(imageFolders);
                }
            }
        });
    }

    private String getSelection() {
        switch (this.type) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaCondition(this.getDurationCondition(0L, 0L), this.isGif);
            }
            case 1: {
                return this.isGif ? SELECTION : SELECTION_NOT_GIF;
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaCondition();
            }
            case 3: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaCondition(this.getDurationCondition(0L, 500L));
            }
        }
        return null;
    }

    private String[] getSelectionArgs() {
        switch (this.type) {
            case 0: {
                return SELECTION_ALL_ARGS;
            }
            case 1: {
                String[] MEDIA_TYPE_IMAGE = LocalMediaLoader.getSelectionArgsForSingleMediaType(1);
                return MEDIA_TYPE_IMAGE;
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(3);
            }
            case 3: {
                String[] MEDIA_TYPE_AUDIO = LocalMediaLoader.getSelectionArgsForSingleMediaType(2);
                return MEDIA_TYPE_AUDIO;
            }
        }
        return null;
    }

    private void sortFolder(List<LocalMediaFolder> imageFolders) {
        Collections.sort(imageFolders, (lhs, rhs) -> {
            int rsize;
            if (lhs.getImages() == null || rhs.getImages() == null) {
                return 0;
            }
            int lsize = lhs.getImageNum();
            return lsize == (rsize = rhs.getImageNum()) ? 0 : (lsize < rsize ? 1 : -1);
        });
    }

    private String getRealPathAndroid_Q(long id2) {
        return QUERY_URI.buildUpon().appendPath(String.valueOf(id2)).build().toString();
    }

    private LocalMediaFolder getImageFolder(String path, List<LocalMediaFolder> imageFolders) {
        File imageFile = new File(path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            if (!folder.getName().equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile.getName());
        newFolder.setPath(folderFile.getAbsolutePath());
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    private String getDurationCondition(long exMaxLimit, long exMinLimit) {
        long maxS;
        long l = maxS = this.videoMaxS == 0L ? Long.MAX_VALUE : this.videoMaxS;
        if (exMaxLimit != 0L) {
            maxS = Math.min(maxS, exMaxLimit);
        }
        return String.format(Locale.CHINA, "%d <%s duration and duration <= %d", Math.max(exMinLimit, this.videoMinS), Math.max(exMinLimit, this.videoMinS) == 0L ? "" : "=", maxS);
    }

    public static interface LocalMediaLoadListener {
        public void loadComplete(List<LocalMediaFolder> var1);
    }
}

