/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.immersive;

import android.app.Activity;
import android.os.Build;
import android.view.Window;
import androidx.appcompat.app.AppCompatActivity;
import com.luck.picture.lib.immersive.LightStatusBarUtils;

public class ImmersiveManage {
    public static void immersiveAboveAPI19(AppCompatActivity baseActivity, int statusBarColor, int navigationBarColor, boolean isDarkStatusBarIcon) {
        ImmersiveManage.immersiveAboveAPI23((Activity)baseActivity, false, false, statusBarColor, navigationBarColor, isDarkStatusBarIcon);
    }

    public static void immersiveAboveAPI23(Activity baseActivity, int statusBarColor, int navigationBarColor, boolean isDarkStatusBarIcon) {
        if (Build.VERSION.SDK_INT >= 23) {
            ImmersiveManage.immersiveAboveAPI23(baseActivity, false, false, statusBarColor, navigationBarColor, isDarkStatusBarIcon);
        }
    }

    public static void immersiveAboveAPI23(Activity baseActivity, boolean isMarginStatusBar, boolean isMarginNavigationBar, int statusBarColor, int navigationBarColor, boolean isDarkStatusBarIcon) {
        try {
            Window window = baseActivity.getWindow();
            if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
                window.setFlags(0x4000000, 0x4000000);
            } else if (Build.VERSION.SDK_INT >= 21) {
                if (isMarginStatusBar && isMarginNavigationBar) {
                    window.clearFlags(0xC000000);
                    LightStatusBarUtils.setLightStatusBar(baseActivity, isMarginStatusBar, isMarginNavigationBar, statusBarColor == 0, isDarkStatusBarIcon);
                    window.addFlags(Integer.MIN_VALUE);
                } else if (!isMarginStatusBar && !isMarginNavigationBar) {
                    window.requestFeature(1);
                    window.clearFlags(0xC000000);
                    LightStatusBarUtils.setLightStatusBar(baseActivity, isMarginStatusBar, isMarginNavigationBar, statusBarColor == 0, isDarkStatusBarIcon);
                    window.addFlags(Integer.MIN_VALUE);
                } else if (!isMarginStatusBar && isMarginNavigationBar) {
                    window.requestFeature(1);
                    window.clearFlags(0xC000000);
                    LightStatusBarUtils.setLightStatusBar(baseActivity, isMarginStatusBar, isMarginNavigationBar, statusBarColor == 0, isDarkStatusBarIcon);
                    window.addFlags(Integer.MIN_VALUE);
                } else {
                    return;
                }
                window.setStatusBarColor(statusBarColor);
                window.setNavigationBarColor(navigationBarColor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

