/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.config;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.luck.picture.lib.R;
import java.io.File;

public final class PictureMimeType {
    public static final String JPEG = ".JPEG";
    public static final String PNG = ".png";
    public static final String MIME_TYPE_IMAGE = "image/jpeg";
    public static final String MIME_TYPE_VIDEO = "video/mp4";
    public static final String MIME_TYPE_AUDIO = "audio/mpeg";

    public static int ofAll() {
        return 0;
    }

    public static int ofImage() {
        return 1;
    }

    @Deprecated
    public static int ofVideo() {
        return 2;
    }

    public static int ofAudio() {
        return 3;
    }

    public static int isPictureType(String pictureType) {
        switch (pictureType) {
            case "video/3gp": 
            case "video/3gpp": 
            case "video/3gpp2": 
            case "video/avi": 
            case "video/mp4": 
            case "video/quicktime": 
            case "video/x-msvideo": 
            case "video/x-matroska": 
            case "video/mpeg": 
            case "video/webm": 
            case "video/mp2ts": {
                return 2;
            }
            case "audio/mpeg": 
            case "audio/x-ms-wma": 
            case "audio/x-wav": 
            case "audio/amr": 
            case "audio/wav": 
            case "audio/aac": 
            case "audio/mp4": 
            case "audio/quicktime": 
            case "audio/lamr": 
            case "audio/3gpp": {
                return 3;
            }
        }
        return 1;
    }

    public static boolean isGif(String pictureType) {
        switch (pictureType) {
            case "image/gif": 
            case "image/GIF": {
                return true;
            }
        }
        return false;
    }

    public static boolean isVideo(String pictureType) {
        switch (pictureType) {
            case "video/3gp": 
            case "video/3gpp": 
            case "video/3gpp2": 
            case "video/avi": 
            case "video/mp4": 
            case "video/quicktime": 
            case "video/x-msvideo": 
            case "video/x-matroska": 
            case "video/mpeg": 
            case "video/webm": 
            case "video/mp2ts": {
                return true;
            }
        }
        return false;
    }

    public static boolean isHttp(String path) {
        return !TextUtils.isEmpty((CharSequence)path) && (path.startsWith("http") || path.startsWith("https"));
    }

    public static String fileToType(File file) {
        if (file != null) {
            String name = file.getName();
            if (name.endsWith(".mp4") || name.endsWith(".avi") || name.endsWith(".3gpp") || name.endsWith(".3gp") || name.startsWith(".mov")) {
                return MIME_TYPE_VIDEO;
            }
            if (name.endsWith(".PNG") || name.endsWith(PNG) || name.endsWith(".jpeg") || name.endsWith(".gif") || name.endsWith(".GIF") || name.endsWith(".jpg") || name.endsWith(".webp") || name.endsWith(".WEBP") || name.endsWith(JPEG) || name.endsWith(".bmp")) {
                return MIME_TYPE_IMAGE;
            }
            if (name.endsWith(".mp3") || name.endsWith(".amr") || name.endsWith(".aac") || name.endsWith(".war") || name.endsWith(".flac") || name.endsWith(".lamr")) {
                return MIME_TYPE_AUDIO;
            }
        }
        return MIME_TYPE_IMAGE;
    }

    public static boolean mimeToEqual(String p1, String p2) {
        return PictureMimeType.isPictureType(p1) == PictureMimeType.isPictureType(p2);
    }

    public static String getImageMimeType(String path) {
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file = new File(path);
                String fileName = file.getName();
                int last = fileName.lastIndexOf(".") + 1;
                String temp = fileName.substring(last);
                return "image/" + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return MIME_TYPE_IMAGE;
        }
        return MIME_TYPE_IMAGE;
    }

    public static String getVideoMimeType(String path) {
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file = new File(path);
                String fileName = file.getName();
                int last = fileName.lastIndexOf(".") + 1;
                String temp = fileName.substring(last);
                return "video/" + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return MIME_TYPE_VIDEO;
        }
        return MIME_TYPE_VIDEO;
    }

    public static String getMimeType(Context context, Uri uri) {
        Cursor cursor;
        if ("content".equals(uri.getScheme()) && (cursor = context.getApplicationContext().getContentResolver().query(uri, new String[]{"mime_type"}, null, null, null)) != null) {
            int columnIndex;
            if (cursor.moveToFirst() && (columnIndex = cursor.getColumnIndexOrThrow("mime_type")) > -1) {
                return cursor.getString(columnIndex);
            }
            cursor.close();
        }
        return MIME_TYPE_IMAGE;
    }

    public static int getMimeType(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return 1;
        }
        if (mimeType.startsWith("video")) {
            return 2;
        }
        if (mimeType.startsWith("audio")) {
            return 3;
        }
        return 1;
    }

    public static String getLastImgType(String path) {
        try {
            int index = path.lastIndexOf(".");
            if (index > 0) {
                String imageType;
                switch (imageType = path.substring(index)) {
                    case ".png": 
                    case ".PNG": 
                    case ".jpg": 
                    case ".jpeg": 
                    case ".JPEG": 
                    case ".WEBP": 
                    case ".bmp": 
                    case ".BMP": 
                    case ".webp": {
                        return imageType;
                    }
                }
                return PNG;
            }
            return PNG;
        }
        catch (Exception e) {
            e.printStackTrace();
            return PNG;
        }
    }

    public static String getLastImgSuffix(String mineType) {
        String defaultSuffix = PNG;
        try {
            int index = mineType.lastIndexOf("/") + 1;
            if (index > 0) {
                return "." + mineType.substring(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultSuffix;
        }
        return defaultSuffix;
    }

    public static String s(Context context, int mediaMimeType) {
        Context ctx = context.getApplicationContext();
        switch (mediaMimeType) {
            case 1: {
                return ctx.getString(R.string.picture_error);
            }
            case 2: {
                return ctx.getString(R.string.picture_video_error);
            }
            case 3: {
                return ctx.getString(R.string.picture_audio_error);
            }
        }
        return ctx.getString(R.string.picture_error);
    }
}

