/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.rxbus2;

import com.luck.picture.lib.rxbus2.BusData;
import com.luck.picture.lib.rxbus2.Subscribe;
import com.luck.picture.lib.rxbus2.SubscriberMethod;
import com.luck.picture.lib.rxbus2.ThreadMode;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RxBus {
    public static final String LOG_BUS = "RXBUS_LOG";
    private static volatile RxBus defaultInstance;
    private Map<Class, List<Disposable>> subscriptionsByEventType = new HashMap<Class, List<Disposable>>();
    private Map<Object, List<Class>> eventTypesBySubscriber = new HashMap<Object, List<Class>>();
    private Map<Class, List<SubscriberMethod>> subscriberMethodByEventType = new HashMap<Class, List<SubscriberMethod>>();
    private final Subject<Object> bus = PublishSubject.create().toSerialized();

    private RxBus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RxBus getDefault() {
        RxBus rxBus = defaultInstance;
        if (defaultInstance != null) return rxBus;
        Class<RxBus> clazz = RxBus.class;
        synchronized (RxBus.class) {
            rxBus = defaultInstance;
            if (defaultInstance != null) return rxBus;
            defaultInstance = rxBus = new RxBus();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return rxBus;
        }
    }

    public <T> Flowable<T> toObservable(Class<T> eventType) {
        return this.bus.toFlowable(BackpressureStrategy.BUFFER).ofType(eventType);
    }

    private <T> Flowable<T> toObservable(final int code, final Class<T> eventType) {
        return this.bus.toFlowable(BackpressureStrategy.BUFFER).ofType(Message.class).filter((Predicate)new Predicate<Message>(){

            public boolean test(Message o) throws Exception {
                return o.getCode() == code && eventType.isInstance(o.getObject());
            }
        }).map((Function)new Function<Message, Object>(){

            public Object apply(Message o) throws Exception {
                return o.getObject();
            }
        }).cast(eventType);
    }

    public void register(Object subscriber) {
        Method[] methods;
        Class<?> subClass = subscriber.getClass();
        for (Method method : methods = subClass.getDeclaredMethods()) {
            SubscriberMethod subscriberMethod;
            ThreadMode threadMode;
            int code;
            Subscribe sub;
            Class eventType;
            if (!method.isAnnotationPresent(Subscribe.class)) continue;
            Class<?>[] parameterType = method.getParameterTypes();
            if (parameterType != null && parameterType.length == 1) {
                eventType = parameterType[0];
                this.addEventTypeToMap(subscriber, eventType);
                sub = method.getAnnotation(Subscribe.class);
                code = sub.code();
                threadMode = sub.threadMode();
                subscriberMethod = new SubscriberMethod(subscriber, method, eventType, code, threadMode);
                this.addSubscriberToMap(eventType, subscriberMethod);
                this.addSubscriber(subscriberMethod);
                continue;
            }
            if (parameterType != null && parameterType.length != 0) continue;
            eventType = BusData.class;
            this.addEventTypeToMap(subscriber, eventType);
            sub = method.getAnnotation(Subscribe.class);
            code = sub.code();
            threadMode = sub.threadMode();
            subscriberMethod = new SubscriberMethod(subscriber, method, eventType, code, threadMode);
            this.addSubscriberToMap(eventType, subscriberMethod);
            this.addSubscriber(subscriberMethod);
        }
    }

    private void addEventTypeToMap(Object subscriber, Class eventType) {
        List<Class> eventTypes = this.eventTypesBySubscriber.get(subscriber);
        if (eventTypes == null) {
            eventTypes = new ArrayList<Class>();
            this.eventTypesBySubscriber.put(subscriber, eventTypes);
        }
        if (!eventTypes.contains(eventType)) {
            eventTypes.add(eventType);
        }
    }

    private void addSubscriberToMap(Class eventType, SubscriberMethod subscriberMethod) {
        List<SubscriberMethod> subscriberMethods = this.subscriberMethodByEventType.get(eventType);
        if (subscriberMethods == null) {
            subscriberMethods = new ArrayList<SubscriberMethod>();
            this.subscriberMethodByEventType.put(eventType, subscriberMethods);
        }
        if (!subscriberMethods.contains(subscriberMethod)) {
            subscriberMethods.add(subscriberMethod);
        }
    }

    private void addSubscriptionToMap(Class eventType, Disposable disposable) {
        List<Disposable> disposables = this.subscriptionsByEventType.get(eventType);
        if (disposables == null) {
            disposables = new ArrayList<Disposable>();
            this.subscriptionsByEventType.put(eventType, disposables);
        }
        if (!disposables.contains(disposable)) {
            disposables.add(disposable);
        }
    }

    private void addSubscriber(final SubscriberMethod subscriberMethod) {
        Flowable<?> flowable = subscriberMethod.code == -1 ? this.toObservable(subscriberMethod.eventType) : this.toObservable(subscriberMethod.code, subscriberMethod.eventType);
        Disposable subscription = this.postToObservable(flowable, subscriberMethod).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                RxBus.this.callEvent(subscriberMethod, o);
            }
        });
        this.addSubscriptionToMap(subscriberMethod.subscriber.getClass(), subscription);
    }

    private Flowable postToObservable(Flowable observable, SubscriberMethod subscriberMethod) {
        Scheduler scheduler;
        switch (subscriberMethod.threadMode) {
            case MAIN: {
                scheduler = AndroidSchedulers.mainThread();
                break;
            }
            case NEW_THREAD: {
                scheduler = Schedulers.newThread();
                break;
            }
            case CURRENT_THREAD: {
                scheduler = Schedulers.trampoline();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown thread mode: " + (Object)((Object)subscriberMethod.threadMode));
            }
        }
        return observable.observeOn(scheduler);
    }

    private void callEvent(SubscriberMethod method, Object object) {
        Class<?> eventClass = object.getClass();
        List<SubscriberMethod> methods = this.subscriberMethodByEventType.get(eventClass);
        if (methods != null && methods.size() > 0) {
            for (SubscriberMethod subscriberMethod : methods) {
                Subscribe sub = subscriberMethod.method.getAnnotation(Subscribe.class);
                int c = sub.code();
                if (c != method.code || !method.subscriber.equals(subscriberMethod.subscriber) || !method.method.equals(subscriberMethod.method)) continue;
                subscriberMethod.invoke(object);
            }
        }
    }

    public synchronized boolean isRegistered(Object subscriber) {
        return this.eventTypesBySubscriber.containsKey(subscriber);
    }

    public void unregister(Object subscriber) {
        List<Class> subscribedTypes = this.eventTypesBySubscriber.get(subscriber);
        if (subscribedTypes != null) {
            for (Class eventType : subscribedTypes) {
                this.unSubscribeByEventType(subscriber.getClass());
                this.unSubscribeMethodByEventType(subscriber, eventType);
            }
            this.eventTypesBySubscriber.remove(subscriber);
        }
    }

    private void unSubscribeByEventType(Class eventType) {
        List<Disposable> disposables = this.subscriptionsByEventType.get(eventType);
        if (disposables != null) {
            Iterator<Disposable> iterator = disposables.iterator();
            while (iterator.hasNext()) {
                Disposable disposable = iterator.next();
                if (disposable == null || disposable.isDisposed()) continue;
                disposable.dispose();
                iterator.remove();
            }
        }
    }

    private void unSubscribeMethodByEventType(Object subscriber, Class eventType) {
        List<SubscriberMethod> subscriberMethods = this.subscriberMethodByEventType.get(eventType);
        if (subscriberMethods != null) {
            Iterator<SubscriberMethod> iterator = subscriberMethods.iterator();
            while (iterator.hasNext()) {
                SubscriberMethod subscriberMethod = iterator.next();
                if (!subscriberMethod.subscriber.equals(subscriber)) continue;
                iterator.remove();
            }
        }
    }

    public void send(int code, Object o) {
        this.bus.onNext((Object)new Message(code, o));
    }

    public void post(Object o) {
        this.bus.onNext(o);
    }

    public void send(int code) {
        this.bus.onNext((Object)new Message(code, new BusData()));
    }

    private class Message {
        private int code;
        private Object object;

        public Message() {
        }

        private Message(int code, Object o) {
            this.code = code;
            this.object = o;
        }

        private int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        private Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }
}

