/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.permissions;

import android.annotation.TargetApi;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.permissions.Permission;
import io.reactivex.subjects.PublishSubject;
import java.util.HashMap;
import java.util.Map;

public class RxPermissionsFragment
extends Fragment {
    private static final int PERMISSIONS_REQUEST_CODE = 42;
    private Map<String, PublishSubject<Permission>> mSubjects = new HashMap<String, PublishSubject<Permission>>();
    private boolean mLogging;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    @TargetApi(value=23)
    void requestPermissions(@NonNull String[] permissions) {
        this.requestPermissions(permissions, 42);
    }

    @TargetApi(value=23)
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode != 42) {
            return;
        }
        boolean[] shouldShowRequestPermissionRationale = new boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            shouldShowRequestPermissionRationale[i] = this.shouldShowRequestPermissionRationale(permissions[i]);
        }
        this.onRequestPermissionsResult(permissions, grantResults, shouldShowRequestPermissionRationale);
    }

    void onRequestPermissionsResult(String[] permissions, int[] grantResults, boolean[] shouldShowRequestPermissionRationale) {
        int size = permissions.length;
        for (int i = 0; i < size; ++i) {
            this.log("onRequestPermissionsResult  " + permissions[i]);
            PublishSubject<Permission> subject = this.mSubjects.get(permissions[i]);
            if (subject == null) {
                Log.e((String)"RxPermissions", (String)"RxPermissions.onRequestPermissionsResult invoked but didn't find the corresponding permission request.");
                return;
            }
            this.mSubjects.remove(permissions[i]);
            boolean granted = grantResults[i] == 0;
            subject.onNext((Object)new Permission(permissions[i], granted, shouldShowRequestPermissionRationale[i]));
            subject.onComplete();
        }
    }

    @TargetApi(value=23)
    boolean isGranted(String permission2) {
        return this.getActivity().checkSelfPermission(permission2) == 0;
    }

    @TargetApi(value=23)
    boolean isRevoked(String permission2) {
        return this.getActivity().getPackageManager().isPermissionRevokedByPolicy(permission2, this.getActivity().getPackageName());
    }

    public void setLogging(boolean logging) {
        this.mLogging = logging;
    }

    public PublishSubject<Permission> getSubjectByPermission(@NonNull String permission2) {
        return this.mSubjects.get(permission2);
    }

    public boolean containsByPermission(@NonNull String permission2) {
        return this.mSubjects.containsKey(permission2);
    }

    public PublishSubject<Permission> setSubjectForPermission(@NonNull String permission2, @NonNull PublishSubject<Permission> subject) {
        return this.mSubjects.put(permission2, subject);
    }

    void log(String message) {
        if (this.mLogging) {
            Log.d((String)"RxPermissions", (String)message);
        }
    }
}

