/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.config;

import android.content.Context;
import android.database.Cursor;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.luck.picture.lib.R;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import java.io.File;

public final class PictureMimeType {
    public static final String JPEG = ".JPEG";
    public static final String PNG = ".png";

    public static int ofAll() {
        return 0;
    }

    public static int ofImage() {
        return 1;
    }

    public static int ofVideo() {
        return 2;
    }

    public static int ofAudio() {
        return 3;
    }

    public static int isPictureType(String pictureType) {
        switch (pictureType) {
            case "image/png": 
            case "image/PNG": 
            case "image/jpeg": 
            case "image/JPEG": 
            case "image/webp": 
            case "image/WEBP": 
            case "image/gif": 
            case "image/bmp": 
            case "image/GIF": 
            case "imagex-ms-bmp": {
                return 1;
            }
            case "video/3gp": 
            case "video/3gpp": 
            case "video/3gpp2": 
            case "video/avi": 
            case "video/mp4": 
            case "video/quicktime": 
            case "video/x-msvideo": 
            case "video/x-matroska": 
            case "video/mpeg": 
            case "video/webm": 
            case "video/mp2ts": {
                return 2;
            }
            case "audio/mpeg": 
            case "audio/x-ms-wma": 
            case "audio/x-wav": 
            case "audio/amr": 
            case "audio/wav": 
            case "audio/aac": 
            case "audio/mp4": 
            case "audio/quicktime": 
            case "audio/lamr": 
            case "audio/3gpp": {
                return 3;
            }
        }
        return 1;
    }

    public static boolean isGif(String pictureType) {
        switch (pictureType) {
            case "image/gif": 
            case "image/GIF": {
                return true;
            }
        }
        return false;
    }

    public static boolean isImageGif(String path) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            int lastIndex = path.lastIndexOf(".");
            String pictureType = path.substring(lastIndex, path.length());
            return pictureType.startsWith(".gif") || pictureType.startsWith(".GIF");
        }
        return false;
    }

    public static boolean isVideo(String pictureType) {
        switch (pictureType) {
            case "video/3gp": 
            case "video/3gpp": 
            case "video/3gpp2": 
            case "video/avi": 
            case "video/mp4": 
            case "video/quicktime": 
            case "video/x-msvideo": 
            case "video/x-matroska": 
            case "video/mpeg": 
            case "video/webm": 
            case "video/mp2ts": {
                return true;
            }
        }
        return false;
    }

    public static boolean isHttp(String path) {
        return !TextUtils.isEmpty((CharSequence)path) && (path.startsWith("http") || path.startsWith("https"));
    }

    public static String fileToType(File file) {
        if (file != null) {
            String name = file.getName();
            if (name.endsWith(".mp4") || name.endsWith(".avi") || name.endsWith(".3gpp") || name.endsWith(".3gp") || name.startsWith(".mov")) {
                return "video/mp4";
            }
            if (name.endsWith(".PNG") || name.endsWith(PNG) || name.endsWith(".jpeg") || name.endsWith(".gif") || name.endsWith(".GIF") || name.endsWith(".jpg") || name.endsWith(".webp") || name.endsWith(".WEBP") || name.endsWith(JPEG) || name.endsWith(".bmp")) {
                return "image/jpeg";
            }
            if (name.endsWith(".mp3") || name.endsWith(".amr") || name.endsWith(".aac") || name.endsWith(".war") || name.endsWith(".flac") || name.endsWith(".lamr")) {
                return "audio/mpeg";
            }
        }
        return "image/jpeg";
    }

    public static boolean mimeToEqual(String p1, String p2) {
        return PictureMimeType.isPictureType(p1) == PictureMimeType.isPictureType(p2);
    }

    public static String createImageType(String path) {
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file = new File(path);
                String fileName = file.getName();
                int last = fileName.lastIndexOf(".") + 1;
                String temp = fileName.substring(last);
                return "image/" + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "image/jpeg";
        }
        return "image/jpeg";
    }

    public static String createVideoType(Context context, String path) {
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file;
                boolean androidQ = SdkVersionUtils.checkedAndroid_Q();
                if (androidQ) {
                    String newPath = PictureFileUtils.getPath(context.getApplicationContext(), Uri.parse((String)path));
                    file = new File(newPath);
                } else {
                    file = new File(path);
                }
                String fileName = file.getName();
                int last = fileName.lastIndexOf(".") + 1;
                String temp = fileName.substring(last);
                return "video/" + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "video/mp4";
        }
        return "video/mp4";
    }

    public static int pictureToVideo(String pictureType) {
        if (!TextUtils.isEmpty((CharSequence)pictureType)) {
            if (pictureType.startsWith("video")) {
                return 2;
            }
            if (pictureType.startsWith("audio")) {
                return 3;
            }
        }
        return 1;
    }

    public static int getLocalVideoDuration(String videoPath) {
        int duration;
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(videoPath);
            duration = Integer.parseInt(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return duration;
    }

    @RequiresApi(api=26)
    public static int getLocalVideoDurationToAndroidQ(Context context, String videoPath) {
        try {
            Cursor query = context.getApplicationContext().getContentResolver().query(Uri.parse((String)videoPath), null, null, null);
            if (query != null) {
                query.moveToFirst();
                int duration = query.getInt(query.getColumnIndexOrThrow("duration"));
                return duration;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean isLongImg(LocalMedia media) {
        if (null != media) {
            int h;
            int width = media.getWidth();
            int height = media.getHeight();
            return height > (h = width * 3);
        }
        return false;
    }

    public static String getLastImgType(String path) {
        try {
            int index = path.lastIndexOf(".");
            if (index > 0) {
                String imageType;
                switch (imageType = path.substring(index)) {
                    case ".png": 
                    case ".PNG": 
                    case ".jpg": 
                    case ".jpeg": 
                    case ".JPEG": 
                    case ".WEBP": 
                    case ".bmp": 
                    case ".BMP": 
                    case ".webp": {
                        return imageType;
                    }
                }
                return PNG;
            }
            return PNG;
        }
        catch (Exception e) {
            e.printStackTrace();
            return PNG;
        }
    }

    public static String s(Context context, int mediaMimeType) {
        Context ctx = context.getApplicationContext();
        switch (mediaMimeType) {
            case 1: {
                return ctx.getString(R.string.picture_error);
            }
            case 2: {
                return ctx.getString(R.string.picture_video_error);
            }
            case 3: {
                return ctx.getString(R.string.picture_audio_error);
            }
        }
        return ctx.getString(R.string.picture_error);
    }
}

