/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.compress;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.luck.picture.lib.compress.Checker;
import com.luck.picture.lib.compress.Engine;
import com.luck.picture.lib.compress.OnCompressListener;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.PictureFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Luban
implements Handler.Callback {
    private static final String TAG = "Luban";
    private static final String DEFAULT_DISK_CACHE_DIR = "luban_disk_cache";
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;
    private static final int MSG_COMPRESS_MULTIPLE_SUCCESS = 3;
    private String mTargetDir;
    private List<String> mPaths;
    private List<LocalMedia> medias;
    private int mLeastCompressSize;
    private OnCompressListener mCompressListener;
    private int index = -1;
    private Handler mHandler;
    private Context context;

    private Luban(Builder builder) {
        this.mPaths = builder.mPaths;
        this.medias = builder.medias;
        this.context = builder.context;
        this.mTargetDir = builder.mTargetDir;
        this.mCompressListener = builder.mCompressListener;
        this.mLeastCompressSize = builder.mLeastCompressSize;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private File getImageCacheFile(Context context, String suffix) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            this.mTargetDir = this.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + System.currentTimeMillis() + (int)(Math.random() * 1000.0) + (TextUtils.isEmpty((CharSequence)suffix) ? ".jpg" : suffix);
        return new File(cacheBuilder);
    }

    @Nullable
    private File getImageCacheDir(Context context) {
        return this.getImageCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    @Nullable
    private File getImageCacheDir(Context context, String cacheName) {
        String dir = PictureFileUtils.getDiskCacheDir(context);
        File cacheDir = new File(dir);
        if (cacheDir != null) {
            File result = new File(cacheDir, cacheName);
            if (!(result.mkdirs() || result.exists() && result.isDirectory())) {
                return null;
            }
            return result;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    @UiThread
    private void launch(final Context context) {
        if (this.mPaths == null || this.mPaths.size() == 0 && this.mCompressListener != null) {
            this.mCompressListener.onError(new NullPointerException("image file cannot be null"));
        }
        Iterator<String> iterator = this.mPaths.iterator();
        this.index = -1;
        while (iterator.hasNext()) {
            final String path = iterator.next();
            if (Checker.isImage(path)) {
                AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            File result;
                            Luban.this.index++;
                            Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(1));
                            File file = result = Checker.isNeedCompress(Luban.this.mLeastCompressSize, path) ? new Engine(path, Luban.this.getImageCacheFile(context, Checker.checkSuffix(path))).compress() : new File(path);
                            if (Luban.this.medias != null && Luban.this.medias.size() > 0) {
                                boolean isLast;
                                LocalMedia media = (LocalMedia)Luban.this.medias.get(Luban.this.index);
                                String path2 = result.getAbsolutePath();
                                boolean eqHttp = PictureMimeType.isHttp(path2);
                                media.setCompressed(!eqHttp);
                                media.setCompressPath(eqHttp ? "" : result.getAbsolutePath());
                                boolean bl = isLast = Luban.this.index == Luban.this.medias.size() - 1;
                                if (isLast) {
                                    Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(3, (Object)Luban.this.medias));
                                }
                            } else {
                                Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(2, (Object)new IOException()));
                            }
                        }
                        catch (IOException e) {
                            Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(2, (Object)e));
                        }
                    }
                });
            } else {
                this.mCompressListener.onError(new IllegalArgumentException("can not read the path : " + path));
            }
            iterator.remove();
        }
    }

    @WorkerThread
    private File get(String path, Context context) throws IOException {
        return Checker.isNeedCompress(this.mLeastCompressSize, path) ? new Engine(path, this.getImageCacheFile(context, Checker.checkSuffix(path))).compress() : new File(path);
    }

    @WorkerThread
    private List<File> get(Context context) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        Iterator<String> iterator = this.mPaths.iterator();
        while (iterator.hasNext()) {
            String path = iterator.next();
            if (Checker.isImage(path)) {
                File result = Checker.isNeedCompress(this.mLeastCompressSize, path) ? new Engine(path, this.getImageCacheFile(context, Checker.checkSuffix(path))).compress() : new File(path);
                results.add(result);
            }
            iterator.remove();
        }
        return results;
    }

    public boolean handleMessage(Message msg) {
        if (this.mCompressListener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.mCompressListener.onStart();
                break;
            }
            case 3: {
                this.mCompressListener.onSuccess((List)msg.obj);
                break;
            }
            case 2: {
                this.mCompressListener.onError((Throwable)msg.obj);
            }
        }
        return false;
    }

    public static class Builder {
        private Context context;
        private String mTargetDir;
        private List<String> mPaths;
        private List<LocalMedia> medias;
        private int mLeastCompressSize = 100;
        private OnCompressListener mCompressListener;

        Builder(Context context) {
            this.context = context;
            this.mPaths = new ArrayList<String>();
        }

        private Luban build() {
            return new Luban(this);
        }

        public Builder load(File file) {
            this.mPaths.add(file.getAbsolutePath());
            return this;
        }

        public Builder load(String string2) {
            this.mPaths.add(string2);
            return this;
        }

        public Builder load(List<String> list) {
            this.mPaths.addAll(list);
            return this;
        }

        public Builder loadLocalMedia(List<LocalMedia> list) {
            if (list == null) {
                list = new ArrayList<LocalMedia>();
            }
            this.medias = list;
            for (LocalMedia media : list) {
                this.mPaths.add(media.isCut() ? media.getCutPath() : media.getPath());
            }
            return this;
        }

        public Builder setCompressListener(OnCompressListener listener) {
            this.mCompressListener = listener;
            return this;
        }

        public Builder setTargetDir(String targetDir) {
            this.mTargetDir = targetDir;
            return this;
        }

        public Builder ignoreBy(int size) {
            this.mLeastCompressSize = size;
            return this;
        }

        public void launch() {
            this.build().launch(this.context);
        }

        public File get(String path) throws IOException {
            return this.build().get(path, this.context);
        }

        public List<File> get() throws IOException {
            return this.build().get(this.context);
        }
    }
}

