/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.SimpleFragmentAdapter;
import com.luck.picture.lib.anim.OptAnimationLoader;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.EventEntity;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.rxbus2.RxBus;
import com.luck.picture.lib.rxbus2.Subscribe;
import com.luck.picture.lib.rxbus2.ThreadMode;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.ToastManage;
import com.luck.picture.lib.tools.VoiceUtils;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.yalantis.ucrop.UCropMulti;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PicturePreviewActivity
extends PictureBaseActivity
implements View.OnClickListener,
Animation.AnimationListener,
SimpleFragmentAdapter.OnCallBackActivity {
    private ImageView picture_left_back;
    private TextView tv_img_num;
    private TextView tv_title;
    private TextView tv_ok;
    private PreviewViewPager viewPager;
    private LinearLayout id_ll_ok;
    private int position;
    private LinearLayout ll_check;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    private TextView check;
    private SimpleFragmentAdapter adapter;
    private Animation animation;
    private boolean refresh;
    private int index;
    private int screenWidth;
    private Handler mHandler;

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void eventBus(EventEntity obj) {
        switch (obj.what) {
            case 2770: {
                this.dismissDialog();
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PicturePreviewActivity.this.onBackPressed();
                    }
                }, 150L);
            }
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.picture_preview);
        if (!RxBus.getDefault().isRegistered(this)) {
            RxBus.getDefault().register(this);
        }
        this.mHandler = new Handler();
        this.screenWidth = ScreenUtils.getScreenWidth((Context)this);
        this.animation = OptAnimationLoader.loadAnimation((Context)this, R.anim.modal_in);
        this.animation.setAnimationListener((Animation.AnimationListener)this);
        this.picture_left_back = (ImageView)this.findViewById(R.id.picture_left_back);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.ll_check = (LinearLayout)this.findViewById(R.id.ll_check);
        this.id_ll_ok = (LinearLayout)this.findViewById(R.id.id_ll_ok);
        this.check = (TextView)this.findViewById(R.id.check);
        this.picture_left_back.setOnClickListener((View.OnClickListener)this);
        this.tv_ok = (TextView)this.findViewById(R.id.tv_ok);
        this.id_ll_ok.setOnClickListener((View.OnClickListener)this);
        this.tv_img_num = (TextView)this.findViewById(R.id.tv_img_num);
        this.tv_title = (TextView)this.findViewById(R.id.picture_title);
        this.position = this.getIntent().getIntExtra("position", 0);
        this.tv_ok.setText((CharSequence)(this.numComplete ? this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}) : this.getString(R.string.picture_please_select)));
        this.tv_img_num.setSelected(this.config.checkNumMode);
        this.selectImages = (List)((Object)this.getIntent().getSerializableExtra("selectList"));
        boolean is_bottom_preview = this.getIntent().getBooleanExtra("bottom_preview", false);
        this.images = is_bottom_preview ? (List<Object>)((Object)this.getIntent().getSerializableExtra("previewSelectList")) : ImagesObservable.getInstance().readLocalMedias();
        this.initViewPageAdapterData();
        this.ll_check.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                block6: {
                    block8: {
                        LocalMedia image;
                        block7: {
                            boolean isChecked;
                            boolean toEqual;
                            String pictureType;
                            if (PicturePreviewActivity.this.images == null || PicturePreviewActivity.this.images.size() <= 0) break block6;
                            image = (LocalMedia)PicturePreviewActivity.this.images.get(PicturePreviewActivity.this.viewPager.getCurrentItem());
                            String string2 = pictureType = PicturePreviewActivity.this.selectImages.size() > 0 ? ((LocalMedia)PicturePreviewActivity.this.selectImages.get(0)).getPictureType() : "";
                            if (!TextUtils.isEmpty((CharSequence)pictureType) && !(toEqual = PictureMimeType.mimeToEqual(pictureType, image.getPictureType()))) {
                                ToastManage.s(PicturePreviewActivity.this.mContext, PicturePreviewActivity.this.getString(R.string.picture_rule));
                                return;
                            }
                            if (!PicturePreviewActivity.this.check.isSelected()) {
                                isChecked = true;
                                PicturePreviewActivity.this.check.setSelected(true);
                                PicturePreviewActivity.this.check.startAnimation(PicturePreviewActivity.this.animation);
                            } else {
                                isChecked = false;
                                PicturePreviewActivity.this.check.setSelected(false);
                            }
                            if (PicturePreviewActivity.this.selectImages.size() >= PicturePreviewActivity.this.config.maxSelectNum && isChecked) {
                                ToastManage.s(PicturePreviewActivity.this.mContext, PicturePreviewActivity.this.getString(R.string.picture_message_max_num, new Object[]{PicturePreviewActivity.this.config.maxSelectNum}));
                                PicturePreviewActivity.this.check.setSelected(false);
                                return;
                            }
                            if (!isChecked) break block7;
                            VoiceUtils.playVoice(PicturePreviewActivity.this.mContext, PicturePreviewActivity.this.config.openClickSound);
                            if (PicturePreviewActivity.this.config.selectionMode == 1) {
                                PicturePreviewActivity.this.singleRadioMediaImage();
                            }
                            PicturePreviewActivity.this.selectImages.add(image);
                            image.setNum(PicturePreviewActivity.this.selectImages.size());
                            if (!PicturePreviewActivity.this.config.checkNumMode) break block8;
                            PicturePreviewActivity.this.check.setText((CharSequence)String.valueOf(image.getNum()));
                            break block8;
                        }
                        for (LocalMedia media : PicturePreviewActivity.this.selectImages) {
                            if (!media.getPath().equals(image.getPath())) continue;
                            PicturePreviewActivity.this.selectImages.remove(media);
                            PicturePreviewActivity.this.subSelectPosition();
                            PicturePreviewActivity.this.notifyCheckChanged(media);
                            break;
                        }
                    }
                    PicturePreviewActivity.this.onSelectNumChange(true);
                }
            }
        });
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                PicturePreviewActivity.this.isPreviewEggs(PicturePreviewActivity.this.config.previewEggs, position, positionOffsetPixels);
            }

            public void onPageSelected(int i) {
                PicturePreviewActivity.this.position = i;
                PicturePreviewActivity.this.tv_title.setText((CharSequence)(PicturePreviewActivity.this.position + 1 + "/" + PicturePreviewActivity.this.images.size()));
                LocalMedia media = (LocalMedia)PicturePreviewActivity.this.images.get(PicturePreviewActivity.this.position);
                PicturePreviewActivity.this.index = media.getPosition();
                if (!PicturePreviewActivity.this.config.previewEggs) {
                    if (PicturePreviewActivity.this.config.checkNumMode) {
                        PicturePreviewActivity.this.check.setText((CharSequence)(media.getNum() + ""));
                        PicturePreviewActivity.this.notifyCheckChanged(media);
                    }
                    PicturePreviewActivity.this.onImageChecked(PicturePreviewActivity.this.position);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void isPreviewEggs(boolean previewEggs, int position, int positionOffsetPixels) {
        if (previewEggs && this.images.size() > 0 && this.images != null) {
            if (positionOffsetPixels < this.screenWidth / 2) {
                LocalMedia media = this.images.get(position);
                this.check.setSelected(this.isSelected(media));
                if (this.config.checkNumMode) {
                    int num = media.getNum();
                    this.check.setText((CharSequence)(num + ""));
                    this.notifyCheckChanged(media);
                    this.onImageChecked(position);
                }
            } else {
                LocalMedia media = this.images.get(position + 1);
                this.check.setSelected(this.isSelected(media));
                if (this.config.checkNumMode) {
                    int num = media.getNum();
                    this.check.setText((CharSequence)(num + ""));
                    this.notifyCheckChanged(media);
                    this.onImageChecked(position + 1);
                }
            }
        }
    }

    private void singleRadioMediaImage() {
        if (this.selectImages != null && this.selectImages.size() > 0) {
            LocalMedia media = this.selectImages.get(0);
            RxBus.getDefault().post(new EventEntity(2774, this.selectImages, media.getPosition()));
            this.selectImages.clear();
        }
    }

    private void initViewPageAdapterData() {
        this.tv_title.setText((CharSequence)(this.position + 1 + "/" + this.images.size()));
        this.adapter = new SimpleFragmentAdapter(this.images, (Context)this, this);
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.onSelectNumChange(false);
        this.onImageChecked(this.position);
        if (this.images.size() > 0) {
            LocalMedia media = this.images.get(this.position);
            this.index = media.getPosition();
            if (this.config.checkNumMode) {
                this.tv_img_num.setSelected(true);
                this.check.setText((CharSequence)(media.getNum() + ""));
                this.notifyCheckChanged(media);
            }
        }
    }

    private void notifyCheckChanged(LocalMedia imageBean) {
        if (this.config.checkNumMode) {
            this.check.setText((CharSequence)"");
            for (LocalMedia media : this.selectImages) {
                if (!media.getPath().equals(imageBean.getPath())) continue;
                imageBean.setNum(media.getNum());
                this.check.setText((CharSequence)String.valueOf(imageBean.getNum()));
            }
        }
    }

    private void subSelectPosition() {
        int len = this.selectImages.size();
        for (int index = 0; index < len; ++index) {
            LocalMedia media = this.selectImages.get(index);
            media.setNum(index + 1);
        }
    }

    public void onImageChecked(int position) {
        if (this.images != null && this.images.size() > 0) {
            LocalMedia media = this.images.get(position);
            this.check.setSelected(this.isSelected(media));
        } else {
            this.check.setSelected(false);
        }
    }

    public boolean isSelected(LocalMedia image) {
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    public void onSelectNumChange(boolean isRefresh) {
        boolean enable;
        this.refresh = isRefresh;
        boolean bl = enable = this.selectImages.size() != 0;
        if (enable) {
            this.tv_ok.setSelected(true);
            this.id_ll_ok.setEnabled(true);
            if (this.numComplete) {
                this.tv_ok.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{this.selectImages.size(), this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                if (this.refresh) {
                    this.tv_img_num.startAnimation(this.animation);
                }
                this.tv_img_num.setVisibility(0);
                this.tv_img_num.setText((CharSequence)String.valueOf(this.selectImages.size()));
                this.tv_ok.setText((CharSequence)this.getString(R.string.picture_completed));
            }
        } else {
            this.id_ll_ok.setEnabled(false);
            this.tv_ok.setSelected(false);
            if (this.numComplete) {
                this.tv_ok.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{0, this.config.selectionMode == 1 ? 1 : this.config.maxSelectNum}));
            } else {
                this.tv_img_num.setVisibility(4);
                this.tv_ok.setText((CharSequence)this.getString(R.string.picture_please_select));
            }
        }
        this.updateSelector(this.refresh);
    }

    private void updateSelector(boolean isRefresh) {
        if (isRefresh) {
            EventEntity obj = new EventEntity(2774, this.selectImages, this.index);
            RxBus.getDefault().post(obj);
        }
    }

    public void onAnimationStart(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        this.updateSelector(this.refresh);
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.picture_left_back) {
            this.onBackPressed();
        }
        if (id2 == R.id.id_ll_ok) {
            String pictureType;
            int size = this.selectImages.size();
            LocalMedia image = this.selectImages.size() > 0 ? this.selectImages.get(0) : null;
            String string2 = pictureType = image != null ? image.getPictureType() : "";
            if (this.config.minSelectNum > 0 && size < this.config.minSelectNum && this.config.selectionMode == 2) {
                boolean eqImg = pictureType.startsWith("image");
                String str = eqImg ? this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}) : this.getString(R.string.picture_min_video_num, new Object[]{this.config.minSelectNum});
                ToastManage.s(this.mContext, str);
                return;
            }
            if (this.config.enableCrop && pictureType.startsWith("image")) {
                if (this.config.selectionMode == 1) {
                    this.originalPath = image.getPath();
                    this.startCrop(this.originalPath);
                } else {
                    ArrayList<String> cuts = new ArrayList<String>();
                    for (LocalMedia media : this.selectImages) {
                        cuts.add(media.getPath());
                    }
                    this.startCrop(cuts);
                }
            } else {
                this.onResult(this.selectImages);
            }
        }
    }

    @Override
    public void onResult(List<LocalMedia> images) {
        RxBus.getDefault().post(new EventEntity(2771, images));
        if (!this.config.isCompress) {
            this.onBackPressed();
        } else {
            this.showPleaseDialog();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 609: {
                    List list = UCropMulti.getOutput((Intent)data);
                    this.setResult(-1, new Intent().putExtra("com.yalantis.ucrop.OutputUriList", (Serializable)((Object)list)));
                    this.finish();
                    break;
                }
                case 69: {
                    if (data != null) {
                        this.setResult(-1, data);
                    }
                    this.finish();
                }
            }
        } else if (resultCode == 96) {
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastManage.s(this.mContext, throwable.getMessage());
        }
    }

    public void onBackPressed() {
        this.closeActivity();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (RxBus.getDefault().isRegistered(this)) {
            RxBus.getDefault().unregister(this);
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
    }

    @Override
    public void onActivityBackPressed() {
        this.onBackPressed();
    }
}

