/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.luck.picture.lib.R;
import com.luck.picture.lib.ui.PicturePreviewActivity;
import com.luck.picture.lib.widget.CustomDialog;
import com.yalantis.ucrop.dialog.SweetAlertDialog;
import com.yalantis.ucrop.entity.LocalMedia;
import com.yalantis.ucrop.util.FileUtils;
import com.yalantis.ucrop.util.ScreenUtils;
import com.yalantis.ucrop.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import uk.co.senab.photoview.PhotoViewAttacher;

public class PictureImagePreviewFragment
extends Fragment {
    public static final String PATH = "path";
    private List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    private SweetAlertDialog dialog;
    private loadDataThread loadDataThread;
    private boolean isSave;
    private String directory_path;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 200: {
                    String path = (String)msg.obj;
                    Toast.makeText((Context)PictureImagePreviewFragment.this.getActivity(), (CharSequence)("\u56fe\u7247\u4fdd\u5b58\u6210\u529f\u81f3\n" + path), (int)0).show();
                    PictureImagePreviewFragment.this.dismiss();
                }
            }
        }
    };

    public static PictureImagePreviewFragment getInstance(String path, boolean isSave, String directory_path, List<LocalMedia> medias) {
        PictureImagePreviewFragment fragment = new PictureImagePreviewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(PATH, path);
        bundle.putBoolean("isSave", isSave);
        bundle.putString("directory_path", directory_path);
        bundle.putSerializable("previewSelectList", (Serializable)((Object)medias));
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View contentView = inflater.inflate(R.layout.picture_fragment_image_preview, container, false);
        final ImageView imageView = (ImageView)contentView.findViewById(R.id.preview_image);
        final PhotoViewAttacher mAttacher = new PhotoViewAttacher(imageView);
        this.selectImages = (List)((Object)this.getArguments().getSerializable("previewSelectList"));
        final String path = this.getArguments().getString(PATH);
        this.isSave = this.getArguments().getBoolean("isSave");
        this.directory_path = this.getArguments().getString("directory_path");
        if (!this.isSave && path.startsWith("http")) {
            this.showPleaseDialog("\u8bf7\u7a0d\u5019...");
        }
        Glide.with((Context)container.getContext()).load(path).asBitmap().diskCacheStrategy(DiskCacheStrategy.RESULT).into((Target)new SimpleTarget<Bitmap>(480, 800){

            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                imageView.setImageBitmap(resource);
                mAttacher.update();
                PictureImagePreviewFragment.this.dismiss();
            }
        });
        mAttacher.setOnViewTapListener(new PhotoViewAttacher.OnViewTapListener(){

            public void onViewTap(View view, float x, float y) {
                if (PictureImagePreviewFragment.this.getActivity() instanceof PicturePreviewActivity) {
                    PictureImagePreviewFragment.this.activityFinish();
                } else {
                    PictureImagePreviewFragment.this.getActivity().finish();
                    PictureImagePreviewFragment.this.getActivity().overridePendingTransition(0, R.anim.toast_out);
                }
            }
        });
        mAttacher.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (!PictureImagePreviewFragment.this.isSave) {
                    if (PictureImagePreviewFragment.this.hasPermission("android.permission.WRITE_EXTERNAL_STORAGE")) {
                        PictureImagePreviewFragment.this.showDownLoadDialog(path);
                    } else {
                        PictureImagePreviewFragment.this.requestPermission(1, "android.permission.WRITE_EXTERNAL_STORAGE");
                    }
                }
                return true;
            }
        });
        return contentView;
    }

    protected void activityFinish() {
        FragmentActivity fragmentActivity = this.getActivity();
        this.getActivity();
        fragmentActivity.setResult(-1, new Intent().putExtra("type", 1).putExtra("previewSelectList", (Serializable)((Object)this.selectImages)));
        this.getActivity().finish();
    }

    private void showDownLoadDialog(final String path) {
        final CustomDialog dialog = new CustomDialog(this.getContext(), ScreenUtils.getScreenWidth((Context)this.getContext()) * 3 / 4, ScreenUtils.getScreenHeight((Context)this.getContext()) / 4, R.layout.wind_base_dialog_xml, R.style.Theme_dialog);
        Button btn_cancel = (Button)dialog.findViewById(R.id.btn_cancel);
        Button btn_commit = (Button)dialog.findViewById(R.id.btn_commit);
        TextView tv_title = (TextView)dialog.findViewById(R.id.tv_title);
        TextView tv_content = (TextView)dialog.findViewById(R.id.tv_content);
        tv_title.setText((CharSequence)"\u63d0\u793a");
        tv_content.setText((CharSequence)"\u662f\u5426\u4fdd\u5b58\u56fe\u7247\u81f3\u624b\u673a\uff1f");
        btn_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
            }
        });
        btn_commit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PictureImagePreviewFragment.this.showPleaseDialog("\u8bf7\u7a0d\u5019...");
                if (!Utils.isNull((String)path)) {
                    if (path.startsWith("http") || path.startsWith("https")) {
                        PictureImagePreviewFragment.this.loadDataThread = new loadDataThread(path);
                        PictureImagePreviewFragment.this.loadDataThread.start();
                    } else {
                        String dirPath = PictureImagePreviewFragment.this.createDir(System.currentTimeMillis() + ".png");
                        try {
                            FileUtils.copyFile((String)path, (String)dirPath);
                            Toast.makeText((Context)PictureImagePreviewFragment.this.getActivity(), (CharSequence)("\u56fe\u7247\u4fdd\u5b58\u6210\u529f\u81f3\n" + dirPath), (int)0).show();
                            PictureImagePreviewFragment.this.dismiss();
                        }
                        catch (IOException e) {
                            Toast.makeText((Context)PictureImagePreviewFragment.this.getActivity(), (CharSequence)("\u56fe\u7247\u4fdd\u5b58\u5931\u8d25\n" + e.getMessage()), (int)0).show();
                            PictureImagePreviewFragment.this.dismiss();
                            e.printStackTrace();
                        }
                    }
                }
                dialog.dismiss();
            }
        });
        dialog.show();
    }

    public void showLoadingImage(String urlPath) {
        try {
            int read;
            URL u = new URL(urlPath);
            String path = this.createDir(System.currentTimeMillis() + ".png");
            byte[] buffer = new byte[8192];
            int ava = 0;
            long start = System.currentTimeMillis();
            HttpURLConnection urlConn = (HttpURLConnection)u.openConnection();
            double fileLength = urlConn.getContentLength();
            BufferedInputStream bin = new BufferedInputStream(u.openStream());
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(path));
            while ((read = bin.read(buffer)) > -1) {
                bout.write(buffer, 0, read);
                int a = (int)Math.floor((double)(ava += read) / fileLength * 100.0);
                long speed = (long)ava / (System.currentTimeMillis() - start);
                System.out.println("Download: " + ava + " byte(s)    avg speed: " + speed + "  (kb/s)");
            }
            bout.flush();
            bout.close();
            Message message = this.handler.obtainMessage();
            message.what = 200;
            message.obj = path;
            this.handler.sendMessage(message);
        }
        catch (IOException e) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)("\u56fe\u7247\u4fdd\u5b58\u5931\u8d25\n" + e.getMessage()), (int)0).show();
            e.printStackTrace();
        }
    }

    private String createDir(String filename) {
        String state = Environment.getExternalStorageState();
        File rootDir = state.equals("mounted") ? Environment.getExternalStorageDirectory() : this.getActivity().getCacheDir();
        File path = null;
        path = !Utils.isNull((String)this.directory_path) ? new File(rootDir.getAbsolutePath() + this.directory_path) : new File(rootDir.getAbsolutePath() + "/PictureSelector");
        if (!path.exists()) {
            path.mkdirs();
        }
        return path + "/" + filename;
    }

    private void showPleaseDialog(String msg) {
        if (!this.getActivity().isFinishing()) {
            this.dialog = new SweetAlertDialog((Context)this.getActivity());
            this.dialog.setTitleText(msg);
            this.dialog.show();
        }
    }

    private void dismiss() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.cancel();
        }
    }

    protected boolean hasPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    protected void requestPermission(int code, String ... permissions) {
        ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])permissions, (int)code);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1: {
                if (grantResults[0] == 0) break;
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u8bfb\u53d6\u5185\u5b58\u5361\u6743\u9650\u5df2\u88ab\u62d2\u7edd", (int)0).show();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.loadDataThread != null) {
            this.handler.removeCallbacks((Runnable)this.loadDataThread);
            this.loadDataThread = null;
        }
    }

    public class loadDataThread
    extends Thread {
        private String path;

        public loadDataThread(String path) {
            this.path = path;
        }

        @Override
        public void run() {
            try {
                PictureImagePreviewFragment.this.showLoadingImage(this.path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

