/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureAlbumDirectoryAdapter;
import com.luck.picture.lib.decoration.RecycleViewDivider;
import com.luck.picture.lib.model.PictureConfig;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.observable.ObserverListener;
import com.luck.picture.lib.ui.PictureBaseActivity;
import com.luck.picture.lib.ui.PictureImageGridActivity;
import com.yalantis.ucrop.entity.EventEntity;
import com.yalantis.ucrop.entity.LocalMedia;
import com.yalantis.ucrop.entity.LocalMediaFolder;
import com.yalantis.ucrop.rxbus2.RxBus;
import com.yalantis.ucrop.rxbus2.Subscribe;
import com.yalantis.ucrop.rxbus2.ThreadMode;
import com.yalantis.ucrop.util.ToolbarUtil;
import com.yalantis.ucrop.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PictureAlbumDirectoryActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureAlbumDirectoryAdapter.OnItemClickListener,
ObserverListener {
    private List<LocalMediaFolder> folders = new ArrayList<LocalMediaFolder>();
    private PictureAlbumDirectoryAdapter adapter;
    private RecyclerView recyclerView;
    private TextView tv_empty;
    private RelativeLayout rl_picture_title;
    private TextView picture_tv_title;
    private TextView picture_tv_right;
    private List<LocalMedia> selectMedias = new ArrayList<LocalMedia>();

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void eventBus(EventEntity obj) {
        switch (obj.what) {
            case 2773: {
                this.finish();
                this.overridePendingTransition(0, R.anim.slide_bottom_out);
            }
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.picture_activity_album);
        if (!RxBus.getDefault().isRegistered((Object)this)) {
            RxBus.getDefault().register((Object)this);
        }
        this.selectMedias = (List)((Object)this.getIntent().getSerializableExtra("previewSelectList"));
        if (this.selectMedias == null) {
            this.selectMedias = new ArrayList<LocalMedia>();
        }
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.tv_empty = (TextView)this.findViewById(R.id.tv_empty);
        this.rl_picture_title = (RelativeLayout)this.findViewById(R.id.rl_picture_title);
        this.picture_tv_title = (TextView)this.findViewById(R.id.picture_tv_title);
        this.picture_tv_right = (TextView)this.findViewById(R.id.picture_tv_right);
        this.picture_tv_right.setTextColor(this.right_color);
        this.picture_tv_title.setTextColor(this.title_color);
        this.tv_empty.setOnClickListener((View.OnClickListener)this);
        ImagesObservable.getInstance().add(this);
        switch (this.type) {
            case 1: {
                this.picture_tv_title.setText((CharSequence)this.getString(R.string.picture_select_photo));
                break;
            }
            case 2: {
                this.picture_tv_title.setText((CharSequence)this.getString(R.string.picture_select_video));
                break;
            }
        }
        ToolbarUtil.setColorNoTranslucent((Activity)this, (int)this.statusBar);
        this.rl_picture_title.setBackgroundColor(this.backgroundColor);
        this.picture_tv_right.setText((CharSequence)this.getString(R.string.picture_cancel));
        this.picture_tv_right.setOnClickListener((View.OnClickListener)this);
        this.adapter = new PictureAlbumDirectoryAdapter((Context)this);
        LinearLayoutManager manager = new LinearLayoutManager((Context)this);
        ((SimpleItemAnimator)this.recyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
        this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new RecycleViewDivider(this.mContext, 0, Utils.dip2px((Context)this, (float)0.5f), ContextCompat.getColor((Context)this, (int)R.color.line_color)));
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)manager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.adapter.setOnItemClickListener(this);
        this.initData();
    }

    protected void initData() {
        this.folders = ImagesObservable.getInstance().readLocalFolders();
        if (this.folders.size() > 0) {
            this.tv_empty.setVisibility(8);
            this.adapter.bindFolderData(this.folders);
            this.notifyDataCheckedStatus(this.selectMedias);
        } else {
            this.tv_empty.setVisibility(0);
            switch (this.type) {
                case 1: {
                    this.tv_empty.setText((CharSequence)this.getString(R.string.picture_no_photo));
                    break;
                }
                case 2: {
                    this.tv_empty.setText((CharSequence)this.getString(R.string.picture_no_video));
                    break;
                }
            }
        }
    }

    private void notifyDataCheckedStatus(List<LocalMedia> medias) {
        try {
            if (medias == null) {
                medias = new ArrayList<LocalMedia>();
            }
            List<LocalMediaFolder> folders = this.adapter.getFolderData();
            for (LocalMediaFolder folder : folders) {
                if (!folder.isChecked()) continue;
                folder.setCheckedNum(0);
                folder.setChecked(false);
            }
            if (medias.size() > 0) {
                for (LocalMediaFolder folder : folders) {
                    int num = 0;
                    List images = folder.getImages();
                    for (LocalMedia media : images) {
                        String path = media.getPath();
                        for (LocalMedia m : medias) {
                            if (!path.equals(m.getPath())) continue;
                            folder.setChecked(true);
                            folder.setCheckedNum(++num);
                        }
                    }
                }
            }
            this.adapter.bindFolderData(folders);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.tv_empty) {
            this.startEmptyImageActivity();
        } else if (id2 == R.id.picture_tv_right) {
            this.finish();
            this.overridePendingTransition(0, R.anim.slide_bottom_out);
        }
    }

    private void startEmptyImageActivity() {
        ArrayList<LocalMedia> images = new ArrayList<LocalMedia>();
        String title = "";
        switch (this.type) {
            case 1: {
                title = this.getString(R.string.picture_lately_image);
                break;
            }
            case 2: {
                title = this.getString(R.string.picture_lately_video);
            }
        }
        this.startImageGridActivity(title, images);
    }

    @Override
    public void onItemClick(String folderName, List<LocalMedia> images) {
        if (images != null && images.size() > 0) {
            this.startImageGridActivity(folderName, images);
        }
    }

    private void startImageGridActivity(String folderName, List<LocalMedia> images) {
        if (Utils.isFastDoubleClick()) {
            return;
        }
        Intent intent = new Intent();
        List<LocalMediaFolder> folders = this.adapter.getFolderData();
        ImagesObservable.getInstance().saveLocalMedia(images);
        ImagesObservable.getInstance().saveLocalFolders(folders);
        intent.putExtra("previewSelectList", (Serializable)((Object)this.selectMedias));
        intent.putExtra("function_options", (Serializable)this.options);
        intent.putExtra("folderName", folderName);
        intent.putExtra("isTopActivity", true);
        intent.setClass(this.mContext, PictureImageGridActivity.class);
        this.startActivityForResult(intent, 88);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
        this.overridePendingTransition(0, R.anim.slide_bottom_out);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (RxBus.getDefault().isRegistered((Object)this)) {
            RxBus.getDefault().unregister((Object)this);
        }
        this.clearData();
    }

    protected void clearData() {
        PictureConfig.resultCallback = null;
        ImagesObservable.getInstance().remove(this);
        ImagesObservable.getInstance().clearLocalFolders();
        ImagesObservable.getInstance().clearLocalMedia();
        ImagesObservable.getInstance().clearSelectedLocalMedia();
    }

    @Override
    public void observerUpFoldersData(List<LocalMediaFolder> folders) {
        this.folders = folders;
        this.initData();
    }

    @Override
    public void observerUpSelectsData(List<LocalMedia> selectMedias) {
        this.folders = ImagesObservable.getInstance().readLocalFolders();
        this.selectMedias = selectMedias;
        if (this.folders != null && this.folders.size() > 0) {
            this.adapter.bindFolderData(this.folders);
        }
        if (selectMedias == null) {
            selectMedias = new ArrayList<LocalMedia>();
        }
        this.notifyDataCheckedStatus(selectMedias);
        if (this.tv_empty.getVisibility() == 0 && this.adapter.getFolderData().size() > 0) {
            this.tv_empty.setVisibility(8);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 88 && resultCode == -1) {
            List result = (List)((Object)data.getSerializableExtra("select_result"));
            this.setResult(-1, new Intent().putExtra("select_result", (Serializable)((Object)result)));
            this.finish();
        }
    }
}

