/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.compress;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import com.luck.picture.lib.compress.CompressConfig;
import com.yalantis.ucrop.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class CompressImageUtil {
    private CompressConfig config;
    private Context context;
    Handler mhHandler = new Handler();

    public CompressImageUtil(Context context, CompressConfig config) {
        this.context = context;
        this.config = config == null ? CompressConfig.ofDefaultConfig() : config;
    }

    public void compress(String imagePath, CompressListener listener) {
        if (this.config.isEnablePixelCompress()) {
            try {
                this.compressImageByPixel(imagePath, listener);
            }
            catch (FileNotFoundException e) {
                listener.onCompressFailed(imagePath, String.format("\u56fe\u7247\u538b\u7f29\u5931\u8d25,%s", e.toString()));
                e.printStackTrace();
            }
        } else {
            this.compressImageByQuality(BitmapFactory.decodeFile((String)imagePath), imagePath, listener);
        }
    }

    private void compressImageByQuality(final Bitmap bitmap, final String imgPath, final CompressListener listener) {
        if (bitmap == null) {
            this.sendMsg(false, imgPath, "\u50cf\u7d20\u538b\u7f29\u5931\u8d25,bitmap is null", listener);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int options = 100;
                bitmap.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
                while (baos.toByteArray().length > CompressImageUtil.this.config.getMaxSize()) {
                    baos.reset();
                    if ((options -= 5) <= 5) {
                        options = 5;
                    }
                    bitmap.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
                    if (options != 5) continue;
                }
                try {
                    File thumbnailFile = CompressImageUtil.this.getThumbnailFile(new File(imgPath));
                    FileOutputStream fos = new FileOutputStream(thumbnailFile);
                    fos.write(baos.toByteArray());
                    fos.flush();
                    fos.close();
                    CompressImageUtil.this.sendMsg(true, thumbnailFile.getPath(), null, listener);
                }
                catch (Exception e) {
                    CompressImageUtil.this.sendMsg(false, imgPath, "\u8d28\u91cf\u538b\u7f29\u5931\u8d25", listener);
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void compressImageByPixel(String imgPath, CompressListener listener) throws FileNotFoundException {
        if (imgPath == null) {
            this.sendMsg(false, imgPath, "\u8981\u538b\u7f29\u7684\u6587\u4ef6\u4e0d\u5b58\u5728", listener);
            return;
        }
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int width = newOpts.outWidth;
        int height = newOpts.outHeight;
        float maxSize = this.config.getMaxPixel();
        int be = 1;
        if (width >= height && (float)width > maxSize) {
            be = (int)((float)newOpts.outWidth / maxSize);
            ++be;
        } else if (width < height && (float)height > maxSize) {
            be = (int)((float)newOpts.outHeight / maxSize);
            ++be;
        }
        newOpts.inSampleSize = be;
        newOpts.inPreferredConfig = Bitmap.Config.ARGB_8888;
        newOpts.inPurgeable = true;
        newOpts.inInputShareable = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)newOpts);
        if (this.config.isEnableQualityCompress()) {
            this.compressImageByQuality(bitmap, imgPath, listener);
        } else {
            File thumbnailFile = this.getThumbnailFile(new File(imgPath));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)new FileOutputStream(thumbnailFile));
            listener.onCompressSuccess(thumbnailFile.getPath());
        }
    }

    private void sendMsg(final boolean isSuccess, final String imagePath, final String message, final CompressListener listener) {
        this.mhHandler.post(new Runnable(){

            @Override
            public void run() {
                if (isSuccess) {
                    listener.onCompressSuccess(imagePath);
                } else {
                    listener.onCompressFailed(imagePath, message);
                }
            }
        });
    }

    private File getThumbnailFile(File file) {
        if (file == null || !file.exists()) {
            return file;
        }
        return FileUtils.getPhotoCacheDir((Context)this.context, (File)file);
    }

    public static interface CompressListener {
        public void onCompressSuccess(String var1);

        public void onCompressFailed(String var1, String var2);
    }
}

