/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.compress;

import android.content.Context;
import android.text.TextUtils;
import com.luck.picture.lib.compress.CompressConfig;
import com.luck.picture.lib.compress.CompressImageUtil;
import com.luck.picture.lib.compress.CompressInterface;
import com.luck.picture.lib.compress.LuBanCompress;
import com.yalantis.ucrop.entity.LocalMedia;
import java.io.File;
import java.util.List;

public class CompressImageOptions
implements CompressInterface {
    private CompressImageUtil compressImageUtil;
    private List<LocalMedia> images;
    private CompressInterface.CompressListener listener;

    public static CompressInterface compress(Context context, CompressConfig config, List<LocalMedia> images, CompressInterface.CompressListener listener) {
        if (config.getLubanOptions() != null) {
            return new LuBanCompress(context, config, images, listener);
        }
        return new CompressImageOptions(context, config, images, listener);
    }

    private CompressImageOptions(Context context, CompressConfig config, List<LocalMedia> images, CompressInterface.CompressListener listener) {
        this.compressImageUtil = new CompressImageUtil(context, config);
        this.images = images;
        this.listener = listener;
    }

    @Override
    public void compress() {
        if (this.images == null || this.images.isEmpty()) {
            this.listener.onCompressError(this.images, " images is null");
        }
        for (LocalMedia image : this.images) {
            if (image != null) continue;
            this.listener.onCompressError(this.images, " There are pictures of compress  is null.");
            return;
        }
        this.compress(this.images.get(0));
    }

    private void compress(final LocalMedia image) {
        String path = "";
        path = image.isCut() ? image.getCutPath() : image.getPath();
        if (TextUtils.isEmpty((CharSequence)path)) {
            this.continueCompress(image, false, new String[0]);
            return;
        }
        File file = new File(path);
        if (file == null || !file.exists() || !file.isFile()) {
            this.continueCompress(image, false, new String[0]);
            return;
        }
        this.compressImageUtil.compress(path, new CompressImageUtil.CompressListener(){

            @Override
            public void onCompressSuccess(String imgPath) {
                image.setCompressPath(imgPath);
                CompressImageOptions.this.continueCompress(image, true, new String[0]);
            }

            @Override
            public void onCompressFailed(String imgPath, String msg) {
                CompressImageOptions.this.continueCompress(image, false, new String[]{msg});
            }
        });
    }

    private void continueCompress(LocalMedia image, boolean preSuccess, String ... message) {
        boolean isLast;
        image.setCompressed(preSuccess);
        int index = this.images.indexOf(image);
        boolean bl = isLast = index == this.images.size() - 1;
        if (isLast) {
            this.handleCompressCallBack(message);
        } else {
            this.compress(this.images.get(index + 1));
        }
    }

    private void handleCompressCallBack(String ... message) {
        if (message.length > 0) {
            this.listener.onCompressError(this.images, message[0]);
            return;
        }
        for (LocalMedia image : this.images) {
            if (image.isCompressed()) continue;
            this.listener.onCompressError(this.images, image.getCompressPath() + " is compress failures");
            return;
        }
        this.listener.onCompressSuccess(this.images);
    }
}

