/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.graphics.PorterDuff;
import android.media.SoundPool;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.luck.picture.lib.R;
import com.yalantis.ucrop.dialog.OptAnimationLoader;
import com.yalantis.ucrop.entity.LocalMedia;
import com.yalantis.ucrop.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class PictureImageGridAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int TYPE_CAMERA = 1;
    public static final int TYPE_PICTURE = 2;
    private Context context;
    private boolean showCamera = true;
    private OnPhotoSelectChangedListener imageSelectChangedListener;
    private int maxSelectNum;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    private boolean enablePreview;
    private int selectMode = 1;
    private boolean enablePreviewVideo = false;
    private int cb_drawable;
    private boolean is_checked_num;
    private int type;
    private boolean isGif;
    private boolean clickVideo;
    private SoundPool soundPool;
    private int soundID;

    public PictureImageGridAdapter(Context context, boolean isGif, boolean showCamera, int maxSelectNum, int mode, boolean enablePreview, boolean enablePreviewVideo, int cb_drawable, boolean is_checked_num, int type, boolean clickVideo, SoundPool soundPool, int soundID) {
        this.context = context;
        this.selectMode = mode;
        this.showCamera = showCamera;
        this.maxSelectNum = maxSelectNum;
        this.enablePreview = enablePreview;
        this.enablePreviewVideo = enablePreviewVideo;
        this.cb_drawable = cb_drawable;
        this.is_checked_num = is_checked_num;
        this.type = type;
        this.isGif = isGif;
        this.clickVideo = clickVideo;
        this.soundPool = soundPool;
        this.soundID = soundID;
    }

    public void bindImagesData(List<LocalMedia> images) {
        this.images = images;
        this.notifyDataSetChanged();
    }

    private void playSound() {
        if (this.clickVideo) {
            this.soundPool.play(this.soundID, 0.1f, 0.5f, 0, 1, 1.0f);
        }
    }

    public void bindSelectImages(List<LocalMedia> images) {
        this.selectImages = images;
        this.notifyDataSetChanged();
        this.subSelectPosition();
        if (this.imageSelectChangedListener != null) {
            this.imageSelectChangedListener.onChange(this.selectImages);
        }
    }

    public List<LocalMedia> getSelectedImages() {
        return this.selectImages;
    }

    public List<LocalMedia> getImages() {
        return this.images;
    }

    public int getItemViewType(int position) {
        if (this.showCamera && position == 0) {
            return 1;
        }
        return 2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.picture_item_camera, parent, false);
            return new HeaderViewHolder(view);
        }
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.picture_image_grid_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        if (this.getItemViewType(position) == 1) {
            HeaderViewHolder headerHolder = (HeaderViewHolder)holder;
            headerHolder.headerView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PictureImageGridAdapter.this.imageSelectChangedListener != null) {
                        PictureImageGridAdapter.this.imageSelectChangedListener.onTakePhoto();
                    }
                }
            });
        } else {
            final ViewHolder contentHolder = (ViewHolder)holder;
            final LocalMedia image = this.images.get(this.showCamera ? position - 1 : position);
            image.position = contentHolder.getAdapterPosition();
            String path = image.getPath();
            final int type = image.getType();
            contentHolder.check.setBackgroundResource(this.cb_drawable);
            if (this.selectMode == 2) {
                contentHolder.ll_check.setVisibility(8);
            } else {
                contentHolder.ll_check.setVisibility(0);
            }
            if (this.is_checked_num) {
                this.notifyCheckChanged(contentHolder, image);
            }
            this.selectImage(contentHolder, this.isSelected(image), false);
            if (type == 2) {
                Glide.with((Context)this.context).load(path).diskCacheStrategy(DiskCacheStrategy.RESULT).crossFade().centerCrop().override(150, 150).into(contentHolder.picture);
                long duration = image.getDuration();
                if (contentHolder.rl_duration.getVisibility() == 8) {
                    contentHolder.rl_duration.setVisibility(0);
                }
                contentHolder.tv_duration.setText((CharSequence)("\u65f6\u957f\uff1a" + this.timeParse(duration)));
            } else {
                DiskCacheStrategy result = this.isGif ? DiskCacheStrategy.SOURCE : DiskCacheStrategy.RESULT;
                Glide.with((Context)holder.itemView.getContext()).load(path).placeholder(R.drawable.image_placeholder).diskCacheStrategy(result).crossFade().centerCrop().override(150, 150).into(contentHolder.picture);
                if (contentHolder.rl_duration.getVisibility() == 0) {
                    contentHolder.rl_duration.setVisibility(8);
                }
            }
            if (this.enablePreview || this.enablePreviewVideo) {
                contentHolder.ll_check.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (!Utils.isFastDoubleClick2()) {
                            PictureImageGridAdapter.this.changeCheckboxState(contentHolder, image);
                        }
                    }
                });
            }
            contentHolder.contentView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (type == 2 && (PictureImageGridAdapter.this.selectMode == 2 || PictureImageGridAdapter.this.enablePreviewVideo) && PictureImageGridAdapter.this.imageSelectChangedListener != null) {
                        int index = PictureImageGridAdapter.this.showCamera ? position - 1 : position;
                        PictureImageGridAdapter.this.imageSelectChangedListener.onPictureClick(image, index);
                    } else if (type == 1 && (PictureImageGridAdapter.this.selectMode == 2 || PictureImageGridAdapter.this.enablePreview) && PictureImageGridAdapter.this.imageSelectChangedListener != null) {
                        int index = PictureImageGridAdapter.this.showCamera ? position - 1 : position;
                        PictureImageGridAdapter.this.imageSelectChangedListener.onPictureClick(image, index);
                    } else if (!Utils.isFastDoubleClick2()) {
                        PictureImageGridAdapter.this.changeCheckboxState(contentHolder, image);
                    }
                }
            });
        }
    }

    public int getItemCount() {
        return this.showCamera ? this.images.size() + 1 : this.images.size();
    }

    public boolean isSelected(LocalMedia image) {
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    private void notifyCheckChanged(ViewHolder viewHolder, LocalMedia imageBean) {
        viewHolder.check.setText((CharSequence)"");
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(imageBean.getPath())) continue;
            imageBean.setNum(media.getNum());
            viewHolder.check.setText((CharSequence)String.valueOf(imageBean.getNum()));
        }
    }

    private void changeCheckboxState(ViewHolder contentHolder, LocalMedia image) {
        boolean isChecked = contentHolder.check.isSelected();
        if (this.selectImages.size() >= this.maxSelectNum && !isChecked) {
            switch (this.type) {
                case 1: {
                    Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.picture_message_max_num, new Object[]{this.maxSelectNum}), (int)1).show();
                    break;
                }
                case 2: {
                    Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.picture_message_video_max_num, new Object[]{this.maxSelectNum}), (int)1).show();
                    break;
                }
            }
            return;
        }
        if (isChecked) {
            for (LocalMedia media : this.selectImages) {
                if (!media.getPath().equals(image.getPath())) continue;
                this.selectImages.remove(media);
                this.subSelectPosition();
                break;
            }
        } else {
            this.selectImages.add(image);
            image.setNum(this.selectImages.size());
            this.playSound();
        }
        this.notifyItemChanged(contentHolder.getAdapterPosition());
        this.selectImage(contentHolder, !isChecked, true);
        if (this.imageSelectChangedListener != null) {
            this.imageSelectChangedListener.onChange(this.selectImages);
        }
    }

    private void subSelectPosition() {
        if (this.is_checked_num) {
            int len = this.selectImages.size();
            for (int index = 0; index < len; ++index) {
                LocalMedia media = this.selectImages.get(index);
                media.setNum(index + 1);
                this.notifyItemChanged(media.position);
            }
        }
    }

    public void selectImage(ViewHolder holder, boolean isChecked, boolean isAnim) {
        holder.check.setSelected(isChecked);
        if (isChecked) {
            if (isAnim) {
                Animation animation = OptAnimationLoader.loadAnimation((Context)this.context, (int)R.anim.modal_in);
                holder.check.startAnimation(animation);
            }
            holder.picture.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.image_overlay2), PorterDuff.Mode.SRC_ATOP);
        } else {
            holder.picture.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.image_overlay), PorterDuff.Mode.SRC_ATOP);
        }
    }

    public void setOnPhotoSelectChangedListener(OnPhotoSelectChangedListener imageSelectChangedListener) {
        this.imageSelectChangedListener = imageSelectChangedListener;
    }

    public String timeParse(long duration) {
        String time = "";
        long minute = duration / 60000L;
        long seconds = duration % 60000L;
        long second = Math.round((float)seconds / 1000.0f);
        if (minute < 10L) {
            time = time + "0";
        }
        time = time + minute + ":";
        if (second < 10L) {
            time = time + "0";
        }
        time = time + second;
        return time;
    }

    public static interface OnPhotoSelectChangedListener {
        public void onTakePhoto();

        public void onChange(List<LocalMedia> var1);

        public void onPictureClick(LocalMedia var1, int var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView picture;
        TextView check;
        TextView tv_duration;
        View contentView;
        LinearLayout ll_check;
        RelativeLayout rl_duration;

        public ViewHolder(View itemView) {
            super(itemView);
            this.contentView = itemView;
            this.picture = (ImageView)itemView.findViewById(R.id.picture);
            this.check = (TextView)itemView.findViewById(R.id.check);
            this.ll_check = (LinearLayout)itemView.findViewById(R.id.ll_check);
            this.tv_duration = (TextView)itemView.findViewById(R.id.tv_duration);
            this.rl_duration = (RelativeLayout)itemView.findViewById(R.id.rl_duration);
        }
    }

    public class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        View headerView;

        public HeaderViewHolder(View itemView) {
            super(itemView);
            this.headerView = itemView;
        }
    }
}

