/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.luck.picture.lib.R;
import com.yalantis.ucrop.entity.LocalMedia;
import com.yalantis.ucrop.entity.LocalMediaFolder;
import java.util.ArrayList;
import java.util.List;

public class PictureAlbumDirectoryAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context mContext;
    private List<LocalMediaFolder> folders = new ArrayList<LocalMediaFolder>();
    private OnItemClickListener onItemClickListener;

    public PictureAlbumDirectoryAdapter(Context mContext) {
        this.mContext = mContext;
    }

    public void bindFolderData(List<LocalMediaFolder> folders) {
        this.folders = folders;
        this.notifyDataSetChanged();
    }

    public List<LocalMediaFolder> getFolderData() {
        return this.folders;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.picture_album_folder_item, parent, false);
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        final LocalMediaFolder folder = this.folders.get(position);
        String name = folder.getName();
        int imageNum = folder.getImageNum();
        String imagePath = folder.getFirstImagePath();
        if (folder.isChecked()) {
            holder.tv_img_num.setVisibility(0);
            holder.tv_img_num.setText((CharSequence)(folder.getCheckedNum() + ""));
        } else {
            holder.tv_img_num.setVisibility(4);
        }
        int type = folder.getType();
        switch (type) {
            case 2: {
                Glide.with((Context)holder.itemView.getContext()).load(imagePath).thumbnail(0.5f).into(holder.first_image);
                break;
            }
            case 1: {
                Glide.with((Context)holder.itemView.getContext()).load(imagePath).error(R.drawable.ic_placeholder).centerCrop().crossFade().override(180, 180).diskCacheStrategy(DiskCacheStrategy.RESULT).into(holder.first_image);
                break;
            }
        }
        holder.image_num.setText((CharSequence)("(" + imageNum + ")"));
        holder.tv_folder_name.setText((CharSequence)name);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PictureAlbumDirectoryAdapter.this.onItemClickListener != null) {
                    PictureAlbumDirectoryAdapter.this.onItemClickListener.onItemClick(folder.getName(), folder.getImages());
                }
            }
        });
    }

    public int getItemCount() {
        return this.folders.size();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(String var1, List<LocalMedia> var2);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView first_image;
        TextView tv_folder_name;
        TextView image_num;
        TextView tv_img_num;

        public ViewHolder(View itemView) {
            super(itemView);
            this.first_image = (ImageView)itemView.findViewById(R.id.first_image);
            this.tv_folder_name = (TextView)itemView.findViewById(R.id.tv_folder_name);
            this.image_num = (TextView)itemView.findViewById(R.id.image_num);
            this.tv_img_num = (TextView)itemView.findViewById(R.id.tv_img_num);
        }
    }
}

