/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.ui;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.luck.picture.lib.R;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.ui.PictureBaseActivity;
import com.luck.picture.lib.ui.PictureImagePreviewFragment;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.yalantis.ucrop.MultiUCrop;
import com.yalantis.ucrop.dialog.OptAnimationLoader;
import com.yalantis.ucrop.dialog.SweetAlertDialog;
import com.yalantis.ucrop.entity.EventEntity;
import com.yalantis.ucrop.entity.LocalMedia;
import com.yalantis.ucrop.util.ToolbarUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class PicturePreviewActivity
extends PictureBaseActivity
implements View.OnClickListener,
Animation.AnimationListener {
    private ImageView picture_left_back;
    private TextView tv_img_num;
    private TextView tv_title;
    private TextView tv_ok;
    private RelativeLayout select_bar_layout;
    private PreviewViewPager viewPager;
    private int position;
    private RelativeLayout rl_title;
    private LinearLayout ll_check;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    private TextView check;
    private SimpleFragmentAdapter adapter;
    private Animation animation;
    private boolean refresh;
    private SweetAlertDialog dialog;

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void eventBus(EventEntity obj) {
        switch (obj.what) {
            case 2773: {
                this.dismiss();
                this.closeActivity();
                break;
            }
            case 2776: {
                this.closeActivity();
            }
        }
    }

    protected void closeActivity() {
        this.finish();
        this.overridePendingTransition(0, R.anim.slide_bottom_out);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.picture_activity_image_preview);
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.rl_title = (RelativeLayout)this.findViewById(R.id.rl_title);
        this.picture_left_back = (ImageView)this.findViewById(R.id.picture_left_back);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.ll_check = (LinearLayout)this.findViewById(R.id.ll_check);
        this.select_bar_layout = (RelativeLayout)this.findViewById(R.id.select_bar_layout);
        this.check = (TextView)this.findViewById(R.id.check);
        this.picture_left_back.setOnClickListener((View.OnClickListener)this);
        this.tv_ok = (TextView)this.findViewById(R.id.tv_ok);
        this.tv_img_num = (TextView)this.findViewById(R.id.tv_img_num);
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        this.tv_ok.setOnClickListener((View.OnClickListener)this);
        this.position = this.getIntent().getIntExtra("position", 0);
        this.rl_title.setBackgroundColor(this.backgroundColor);
        ToolbarUtil.setColorNoTranslucent((Activity)this, (int)this.backgroundColor);
        this.tv_ok.setTextColor(this.completeColor);
        this.select_bar_layout.setBackgroundColor(this.previewBottomBgColor);
        this.animation = OptAnimationLoader.loadAnimation((Context)this, (int)R.anim.modal_in);
        this.animation.setAnimationListener((Animation.AnimationListener)this);
        boolean is_bottom_preview = this.getIntent().getBooleanExtra("bottom_preview", false);
        this.images = is_bottom_preview ? (List<Object>)((Object)this.getIntent().getSerializableExtra("previewList")) : ImagesObservable.getInstance().readLocalMedias();
        if (this.is_checked_num) {
            this.tv_img_num.setBackgroundResource(R.drawable.message_oval_blue);
        }
        this.selectImages = (List)((Object)this.getIntent().getSerializableExtra("previewSelectList"));
        this.initViewPageAdapterData();
        this.ll_check.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                block5: {
                    LocalMedia image;
                    block4: {
                        boolean isChecked;
                        if (!PicturePreviewActivity.this.check.isSelected()) {
                            isChecked = true;
                            PicturePreviewActivity.this.check.setSelected(true);
                            PicturePreviewActivity.this.check.startAnimation(PicturePreviewActivity.this.animation);
                        } else {
                            isChecked = false;
                            PicturePreviewActivity.this.check.setSelected(false);
                        }
                        if (PicturePreviewActivity.this.selectImages.size() >= PicturePreviewActivity.this.maxSelectNum && isChecked) {
                            Toast.makeText((Context)PicturePreviewActivity.this, (CharSequence)PicturePreviewActivity.this.getString(R.string.picture_message_max_num, new Object[]{PicturePreviewActivity.this.maxSelectNum}), (int)1).show();
                            PicturePreviewActivity.this.check.setSelected(false);
                            return;
                        }
                        image = (LocalMedia)PicturePreviewActivity.this.images.get(PicturePreviewActivity.this.viewPager.getCurrentItem());
                        if (!isChecked) break block4;
                        PicturePreviewActivity.this.selectImages.add(image);
                        image.setNum(PicturePreviewActivity.this.selectImages.size());
                        if (!PicturePreviewActivity.this.is_checked_num) break block5;
                        PicturePreviewActivity.this.check.setText((CharSequence)(image.getNum() + ""));
                        break block5;
                    }
                    for (LocalMedia media : PicturePreviewActivity.this.selectImages) {
                        if (!media.getPath().equals(image.getPath())) continue;
                        PicturePreviewActivity.this.selectImages.remove(media);
                        PicturePreviewActivity.this.subSelectPosition();
                        PicturePreviewActivity.this.notifyCheckChanged(media);
                        break;
                    }
                }
                PicturePreviewActivity.this.onSelectNumChange(true);
            }
        });
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                PicturePreviewActivity.this.tv_title.setText((CharSequence)(position + 1 + "/" + PicturePreviewActivity.this.images.size()));
                if (PicturePreviewActivity.this.is_checked_num) {
                    LocalMedia media = (LocalMedia)PicturePreviewActivity.this.images.get(position);
                    PicturePreviewActivity.this.check.setText((CharSequence)(media.getNum() + ""));
                    PicturePreviewActivity.this.notifyCheckChanged(media);
                }
                PicturePreviewActivity.this.onImageChecked(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void initViewPageAdapterData() {
        this.tv_title.setText((CharSequence)(this.position + 1 + "/" + this.images.size()));
        this.adapter = new SimpleFragmentAdapter(this.getSupportFragmentManager());
        this.check.setBackgroundResource(this.cb_drawable);
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.onSelectNumChange(false);
        this.onImageChecked(this.position);
        if (this.is_checked_num) {
            this.tv_img_num.setBackgroundResource(R.drawable.message_oval_blue);
            LocalMedia media = this.images.get(this.position);
            this.check.setText((CharSequence)(media.getNum() + ""));
            this.notifyCheckChanged(media);
        }
    }

    private void notifyCheckChanged(LocalMedia imageBean) {
        if (this.is_checked_num) {
            this.check.setText((CharSequence)"");
            for (LocalMedia media : this.selectImages) {
                if (!media.getPath().equals(imageBean.getPath())) continue;
                imageBean.setNum(media.getNum());
                this.check.setText((CharSequence)String.valueOf(imageBean.getNum()));
            }
        }
    }

    private void subSelectPosition() {
        int len = this.selectImages.size();
        for (int index = 0; index < len; ++index) {
            LocalMedia media = this.selectImages.get(index);
            media.setNum(index + 1);
        }
    }

    public void onImageChecked(int position) {
        this.check.setSelected(this.isSelected(this.images.get(position)));
    }

    public boolean isSelected(LocalMedia image) {
        for (LocalMedia media : this.selectImages) {
            if (!media.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    public void onSelectNumChange(boolean isRefresh) {
        boolean enable;
        this.refresh = isRefresh;
        boolean bl = enable = this.selectImages.size() != 0;
        if (enable) {
            this.tv_ok.setEnabled(true);
            this.tv_img_num.setVisibility(0);
            this.tv_img_num.startAnimation(this.animation);
            this.tv_img_num.setText((CharSequence)(this.selectImages.size() + ""));
            this.tv_ok.setText((CharSequence)this.getString(R.string.picture_completed));
        } else {
            this.tv_ok.setEnabled(false);
            this.tv_img_num.setVisibility(4);
            this.tv_ok.setText((CharSequence)this.getString(R.string.picture_please_select));
            this.updateSelector(this.refresh);
        }
    }

    private void updateSelector(boolean isRefresh) {
        if (isRefresh) {
            EventEntity obj = new EventEntity(2774, this.selectImages);
            EventBus.getDefault().post((Object)obj);
        }
    }

    public void onAnimationStart(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        this.updateSelector(this.refresh);
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.picture_left_back) {
            this.finish();
        } else if (id2 == R.id.tv_ok) {
            int size = this.selectImages.size();
            if (this.minSelectNum > 0 && size < this.minSelectNum && this.selectMode == 1) {
                switch (this.type) {
                    case 1: {
                        this.showToast(this.getString(R.string.picture_min_img_num, new Object[]{this.options.getMinSelectNum()}));
                        return;
                    }
                    case 2: {
                        this.showToast(this.getString(R.string.picture_min_video_num, new Object[]{this.options.getMinSelectNum()}));
                        return;
                    }
                }
            }
            if (this.selectMode == 1 && this.enableCrop && this.type == 1) {
                this.startMultiCopy(this.selectImages);
            } else {
                this.onResult(this.selectImages);
            }
        }
    }

    public void onResult(List<LocalMedia> images) {
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        for (LocalMedia media : images) {
            result.add(media);
        }
        EventEntity obj = new EventEntity(2775, result);
        EventBus.getDefault().post((Object)obj);
        if (!this.isCompress) {
            this.finish();
            this.overridePendingTransition(0, R.anim.slide_bottom_out);
        } else {
            this.showPleaseDialog(this.getString(R.string.picture_please));
        }
    }

    protected void startMultiCopy(List<LocalMedia> medias) {
        if (medias != null && medias.size() > 0) {
            LocalMedia media = medias.get(0);
            String path = media.getPath();
            MultiUCrop uCrop = MultiUCrop.of((Uri)Uri.parse((String)path), (Uri)Uri.fromFile((File)new File(this.getCacheDir(), System.currentTimeMillis() + ".jpg")));
            MultiUCrop.Options options = new MultiUCrop.Options();
            switch (this.copyMode) {
                case 0: {
                    options.withAspectRatio(0.0f, 0.0f);
                    break;
                }
                case 11: {
                    options.withAspectRatio(1.0f, 1.0f);
                    break;
                }
                case 32: {
                    options.withAspectRatio(3.0f, 2.0f);
                    break;
                }
                case 34: {
                    options.withAspectRatio(3.0f, 4.0f);
                    break;
                }
                case 169: {
                    options.withAspectRatio(16.0f, 9.0f);
                }
            }
            if (this.circularCut) {
                options.setCircleDimmedLayer(true);
                options.setShowCropFrame(false);
                options.setShowCropGrid(false);
                options.withAspectRatio(1.0f, 1.0f);
            }
            options.setLocalMedia(medias);
            options.setCompressionQuality(this.compressQuality);
            options.withMaxResultSize(this.cropW, this.cropH);
            options.background_color(this.backgroundColor);
            options.setIsCompress(this.isCompress);
            options.copyMode(this.copyMode);
            options.setCircularCut(this.circularCut);
            uCrop.withOptions(options);
            uCrop.start((Activity)this);
        }
    }

    private void showPleaseDialog(String msg) {
        if (!this.isFinishing()) {
            this.dialog = new SweetAlertDialog((Context)this);
            this.dialog.setTitleText(msg);
            this.dialog.show();
        }
    }

    private void dismiss() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.cancel();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
    }

    public class SimpleFragmentAdapter
    extends FragmentPagerAdapter {
        public SimpleFragmentAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int position) {
            PictureImagePreviewFragment fragment = PictureImagePreviewFragment.getInstance(((LocalMedia)PicturePreviewActivity.this.images.get(position)).getPath(), PicturePreviewActivity.this.selectImages);
            return fragment;
        }

        public int getCount() {
            return PicturePreviewActivity.this.images.size();
        }
    }
}

