/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.ui;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.luck.picture.lib.R;
import com.luck.picture.lib.ui.PicturePreviewActivity;
import com.yalantis.ucrop.entity.LocalMedia;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.co.senab.photoview.PhotoViewAttacher;

public class PictureImagePreviewFragment
extends Fragment {
    public static final String PATH = "path";
    private List<LocalMedia> selectImages = new ArrayList<LocalMedia>();

    public static PictureImagePreviewFragment getInstance(String path, List<LocalMedia> medias) {
        PictureImagePreviewFragment fragment = new PictureImagePreviewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(PATH, path);
        bundle.putSerializable("previewSelectList", (Serializable)((Object)medias));
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View contentView = inflater.inflate(R.layout.picture_fragment_image_preview, container, false);
        final ImageView imageView = (ImageView)contentView.findViewById(R.id.preview_image);
        final PhotoViewAttacher mAttacher = new PhotoViewAttacher(imageView);
        this.selectImages = (List)((Object)this.getArguments().getSerializable("previewSelectList"));
        String path = this.getArguments().getString(PATH);
        Glide.with((Context)container.getContext()).load(path).asBitmap().diskCacheStrategy(DiskCacheStrategy.RESULT).into((Target)new SimpleTarget<Bitmap>(480, 800){

            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                imageView.setImageBitmap(resource);
                mAttacher.update();
            }
        });
        mAttacher.setOnViewTapListener(new PhotoViewAttacher.OnViewTapListener(){

            public void onViewTap(View view, float x, float y) {
                if (PictureImagePreviewFragment.this.getActivity() instanceof PicturePreviewActivity) {
                    PictureImagePreviewFragment.this.activityFinish();
                } else {
                    PictureImagePreviewFragment.this.getActivity().finish();
                    PictureImagePreviewFragment.this.getActivity().overridePendingTransition(0, R.anim.toast_out);
                }
            }
        });
        return contentView;
    }

    protected void activityFinish() {
        FragmentActivity fragmentActivity = this.getActivity();
        this.getActivity();
        fragmentActivity.setResult(-1, new Intent().putExtra("type", 1).putExtra("previewSelectList", (Serializable)((Object)this.selectImages)));
        this.getActivity().finish();
    }
}

