/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.FileProvider;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.KeyEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.compress.CompressConfig;
import com.luck.picture.lib.compress.CompressImageOptions;
import com.luck.picture.lib.compress.CompressInterface;
import com.luck.picture.lib.compress.LubanOptions;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.model.LocalMediaLoader;
import com.luck.picture.lib.model.PictureConfig;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.ui.PictureAlbumDirectoryActivity;
import com.luck.picture.lib.ui.PictureBaseActivity;
import com.luck.picture.lib.ui.PicturePreviewActivity;
import com.luck.picture.lib.ui.PictureVideoPlayActivity;
import com.luck.picture.lib.widget.MyItemAnimator;
import com.yalantis.ucrop.MultiUCrop;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.dialog.SweetAlertDialog;
import com.yalantis.ucrop.entity.EventEntity;
import com.yalantis.ucrop.entity.LocalMedia;
import com.yalantis.ucrop.entity.LocalMediaFolder;
import com.yalantis.ucrop.util.FileUtils;
import com.yalantis.ucrop.util.ScreenUtils;
import com.yalantis.ucrop.util.ToolbarUtil;
import com.yalantis.ucrop.util.Utils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class PictureImageGridActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureImageGridAdapter.OnPhotoSelectChangedListener {
    public final String TAG = PictureImageGridActivity.class.getSimpleName();
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private RecyclerView recyclerView;
    private TextView tv_img_num;
    private TextView tv_ok;
    private TextView tv_mask;
    private RelativeLayout rl_bottom;
    private ImageView picture_left_back;
    private RelativeLayout rl_picture_title;
    private TextView picture_tv_title;
    private TextView picture_tv_right;
    private Animation animation = null;
    private TextView id_preview;
    private PictureImageGridAdapter adapter;
    private String cameraPath;
    private SweetAlertDialog dialog;
    private List<LocalMediaFolder> folders = new ArrayList<LocalMediaFolder>();
    private boolean is_top_activity;
    private boolean takePhoto = false;
    private boolean takePhotoSuccess = false;

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void eventBus(EventEntity obj) {
        switch (obj.what) {
            case 2773: {
                this.finish();
                this.overridePendingTransition(0, R.anim.slide_bottom_out);
                break;
            }
            case 2774: {
                List selectImages = obj.medias;
                this.adapter.bindSelectImages(selectImages);
                break;
            }
            case 2775: {
                ArrayList result = obj.medias;
                if (result == null) {
                    result = new ArrayList();
                }
                this.handleCropResult(result);
            }
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.picture_activity_image_grid);
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.rl_bottom = (RelativeLayout)this.findViewById(R.id.rl_bottom);
        this.picture_left_back = (ImageView)this.findViewById(R.id.picture_left_back);
        this.rl_picture_title = (RelativeLayout)this.findViewById(R.id.rl_picture_title);
        this.picture_tv_title = (TextView)this.findViewById(R.id.picture_tv_title);
        this.picture_tv_right = (TextView)this.findViewById(R.id.picture_tv_right);
        this.rl_picture_title.setBackgroundColor(this.backgroundColor);
        ToolbarUtil.setColorNoTranslucent((Activity)this, (int)this.backgroundColor);
        this.tv_ok = (TextView)this.findViewById(R.id.tv_ok);
        this.id_preview = (TextView)this.findViewById(R.id.id_preview);
        this.tv_img_num = (TextView)this.findViewById(R.id.tv_img_num);
        this.tv_mask = (TextView)this.findViewById(R.id.tv_mask);
        this.id_preview.setText((CharSequence)this.getString(R.string.picture_preview));
        this.tv_ok.setText((CharSequence)this.getString(R.string.picture_please_select));
        this.animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.modal_in);
        this.id_preview.setOnClickListener((View.OnClickListener)this);
        this.tv_ok.setOnClickListener((View.OnClickListener)this);
        this.picture_left_back.setOnClickListener((View.OnClickListener)this);
        this.picture_tv_right.setOnClickListener((View.OnClickListener)this);
        this.is_top_activity = this.getIntent().getBooleanExtra("isTopActivity", false);
        this.takePhoto = this.getIntent().getBooleanExtra("function_take", false);
        if (savedInstanceState != null) {
            this.cameraPath = savedInstanceState.getString("CameraPath");
        }
        if (this.takePhoto) {
            this.onTakePhoto();
            if (!this.enableCrop && this.isCompress) {
                ToolbarUtil.setColorNoTranslucent((Activity)this, (int)R.color.black);
                this.tv_mask.setVisibility(0);
            }
        } else {
            if (!this.is_top_activity) {
                if (this.hasPermission("android.permission.READ_EXTERNAL_STORAGE")) {
                    this.readLocalMedia();
                } else {
                    this.requestPermission(1, "android.permission.READ_EXTERNAL_STORAGE");
                }
            } else {
                this.selectMedias = (List)((Object)this.getIntent().getSerializableExtra("previewSelectList"));
            }
            String folderName = this.getIntent().getStringExtra("folderName");
            this.folders = ImagesObservable.getInstance().readLocalFolders();
            if (this.folders == null) {
                this.folders = new ArrayList<LocalMediaFolder>();
            }
            this.images = ImagesObservable.getInstance().readLocalMedias();
            if (this.images == null) {
                this.images = new ArrayList<LocalMedia>();
            }
            if (this.selectMedias == null) {
                this.selectMedias = new ArrayList();
            }
            if (this.enablePreview && this.selectMode == 1) {
                if (this.type == 2) {
                    this.id_preview.setVisibility(8);
                } else {
                    this.id_preview.setVisibility(0);
                }
            } else if (this.selectMode == 2) {
                this.rl_bottom.setVisibility(8);
            } else {
                this.id_preview.setVisibility(8);
            }
            if (folderName != null && !folderName.equals("")) {
                this.picture_tv_title.setText((CharSequence)folderName);
            } else {
                switch (this.type) {
                    case 1: {
                        this.picture_tv_title.setText((CharSequence)this.getString(R.string.picture_lately_image));
                        break;
                    }
                    case 2: {
                        this.picture_tv_title.setText((CharSequence)this.getString(R.string.picture_lately_video));
                    }
                }
            }
            this.rl_bottom.setBackgroundColor(this.bottomBgColor);
            this.id_preview.setTextColor(this.previewColor);
            this.tv_ok.setTextColor(this.completeColor);
            this.picture_tv_right.setText((CharSequence)this.getString(R.string.picture_cancel));
            this.recyclerView.setHasFixedSize(true);
            this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(this.spanCount, ScreenUtils.dip2px((Context)this, (float)2.0f), false));
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, this.spanCount));
            ((SimpleItemAnimator)this.recyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
            if (!this.is_checked_num) {
                this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new MyItemAnimator());
            } else {
                this.tv_img_num.setBackgroundResource(R.drawable.message_oval_blue);
            }
            String titleText = this.picture_tv_title.getText().toString().trim();
            if (this.showCamera) {
                this.showCamera = !Utils.isNull((String)titleText) && titleText.startsWith("\u6700\u8fd1") || titleText.startsWith("Recent");
            }
            this.adapter = new PictureImageGridAdapter((Context)this, this.options.isGif(), this.showCamera, this.maxSelectNum, this.selectMode, this.enablePreview, this.enablePreviewVideo, this.cb_drawable, this.is_checked_num, this.type);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
            this.adapter.notifyDataSetChanged();
            if (this.selectMedias.size() > 0) {
                this.ChangeImageNumber(this.selectMedias);
                this.adapter.bindSelectImages(this.selectMedias);
            }
            this.adapter.bindImagesData(this.images);
            this.adapter.setOnPhotoSelectChangedListener(this);
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.picture_tv_right.isEnabled()) {
            this.picture_tv_right.setEnabled(true);
        }
    }

    @Override
    protected void readLocalMedia() {
        this.showPleaseDialog(this.getString(R.string.picture_please));
        new LocalMediaLoader(this, this.type, this.options.isGif()).loadAllImage(new LocalMediaLoader.LocalMediaLoadListener(){

            @Override
            public void loadComplete(List<LocalMediaFolder> folders) {
                PictureImageGridActivity.this.dismiss();
                if (folders.size() > 0) {
                    LocalMediaFolder folder = folders.get(0);
                    PictureImageGridActivity.this.images = folder.getImages();
                    PictureImageGridActivity.this.adapter.bindImagesData(PictureImageGridActivity.this.images);
                    PictureImageGridActivity.this.folders = folders;
                    ImagesObservable.getInstance().saveLocalFolders(folders);
                    ImagesObservable.getInstance().notifyFolderObserver(folders);
                }
            }
        });
    }

    public void onClick(View view) {
        Intent intent = new Intent();
        int id2 = view.getId();
        if (id2 == R.id.picture_left_back) {
            this.activityFinish(1);
        } else if (id2 == R.id.picture_tv_right) {
            this.activityFinish(2);
        } else if (id2 == R.id.id_preview) {
            if (Utils.isFastDoubleClick()) {
                return;
            }
            List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
            ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
            for (LocalMedia media : selectedImages) {
                medias.add(media);
            }
            intent.putExtra("previewList", (Serializable)medias);
            intent.putExtra("previewSelectList", (Serializable)((Object)selectedImages));
            intent.putExtra("position", 0);
            intent.putExtra("bottom_preview", true);
            intent.putExtra("function_options", (Serializable)this.options);
            intent.setClass(this.mContext, PicturePreviewActivity.class);
            this.startActivityForResult(intent, 100);
        } else if (id2 == R.id.tv_ok) {
            List<LocalMedia> images = this.adapter.getSelectedImages();
            int size = images.size();
            if (this.minSelectNum > 0 && this.selectMode == 1 && size < this.minSelectNum) {
                switch (this.type) {
                    case 1: {
                        this.showToast(this.getString(R.string.picture_min_img_num, new Object[]{this.options.getMinSelectNum()}));
                        return;
                    }
                    case 2: {
                        this.showToast(this.getString(R.string.picture_min_video_num, new Object[]{this.options.getMinSelectNum()}));
                        return;
                    }
                }
            }
            if (this.enableCrop && this.type == 1 && this.selectMode == 1) {
                this.startMultiCopy(images);
            } else if (this.isCompress && this.type == 1) {
                this.compressImage(images);
            } else {
                this.resultBack(images);
            }
        }
    }

    private void resultBack(List<LocalMedia> images) {
        this.onResult(images);
    }

    @Override
    public void onTakePhoto() {
        if (this.hasPermission("android.permission.CAMERA")) {
            this.startCamera();
        } else {
            this.requestPermission(2, "android.permission.CAMERA");
        }
    }

    @Override
    public void onChange(List<LocalMedia> selectImages) {
        this.ChangeImageNumber(selectImages);
    }

    public void ChangeImageNumber(List<LocalMedia> selectImages) {
        boolean enable;
        boolean bl = enable = selectImages.size() != 0;
        if (enable) {
            this.tv_ok.setEnabled(true);
            this.id_preview.setEnabled(true);
            this.tv_img_num.startAnimation(this.animation);
            this.tv_img_num.setVisibility(0);
            this.tv_img_num.setText((CharSequence)(selectImages.size() + ""));
            this.tv_ok.setText((CharSequence)this.getString(R.string.picture_completed));
        } else {
            this.tv_ok.setEnabled(false);
            this.id_preview.setEnabled(false);
            this.tv_img_num.setVisibility(4);
            this.tv_ok.setText((CharSequence)this.getString(R.string.picture_please_select));
        }
    }

    @Override
    public void startCamera() {
        if (!Utils.isFastDoubleClick()) {
            switch (this.type) {
                case 1: {
                    this.startOpenCamera();
                    break;
                }
                case 2: {
                    this.startOpenCameraVideo();
                }
            }
        }
    }

    @Override
    public void onPictureClick(LocalMedia media, int position) {
        if (!Utils.isFastDoubleClick2()) {
            this.startPreview(this.adapter.getImages(), position);
        }
    }

    public void startPreview(List<LocalMedia> previewImages, int position) {
        LocalMedia media = previewImages.get(position);
        int type = media.getType();
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        switch (type) {
            case 1: {
                if (this.enableCrop && this.selectMode == 2) {
                    this.startCopy(media.getPath());
                    break;
                }
                if (!this.enableCrop && this.selectMode == 2) {
                    ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
                    LocalMedia m = new LocalMedia();
                    m.setPath(media.getPath());
                    m.setType(type);
                    result.add(m);
                    if (this.isCompress) {
                        this.compressImage(result);
                        break;
                    }
                    this.onSelectDone(result);
                    break;
                }
                if (Utils.isFastDoubleClick()) {
                    return;
                }
                ImagesObservable.getInstance().saveLocalMedia(previewImages);
                List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                intent.putExtra("previewSelectList", (Serializable)((Object)selectedImages));
                intent.putExtra("position", position);
                intent.putExtra("function_options", (Serializable)this.options);
                intent.setClass(this.mContext, PicturePreviewActivity.class);
                this.startActivityForResult(intent, 100);
                break;
            }
            case 2: {
                if (this.selectMode == 2) {
                    ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
                    LocalMedia m = new LocalMedia();
                    m.setPath(media.getPath());
                    m.setDuration(media.getDuration());
                    m.setType(type);
                    result.add(m);
                    this.onSelectDone(result);
                    break;
                }
                if (Utils.isFastDoubleClick()) {
                    return;
                }
                bundle.putString("video_path", media.getPath());
                bundle.putSerializable("function_options", (Serializable)this.options);
                this.startActivity(PictureVideoPlayActivity.class, bundle);
            }
        }
    }

    protected void startCopy(String path) {
        if (Utils.isFastDoubleClick()) {
            return;
        }
        UCrop uCrop = UCrop.of((Uri)Uri.parse((String)path), (Uri)Uri.fromFile((File)new File(this.getCacheDir(), System.currentTimeMillis() + ".jpg")));
        UCrop.Options options = new UCrop.Options();
        switch (this.copyMode) {
            case 0: {
                options.withAspectRatio(0.0f, 0.0f);
                break;
            }
            case 11: {
                options.withAspectRatio(1.0f, 1.0f);
                break;
            }
            case 32: {
                options.withAspectRatio(3.0f, 2.0f);
                break;
            }
            case 34: {
                options.withAspectRatio(3.0f, 4.0f);
                break;
            }
            case 169: {
                options.withAspectRatio(16.0f, 9.0f);
            }
        }
        if (this.circularCut) {
            options.setCircleDimmedLayer(true);
            options.setShowCropFrame(false);
            options.setShowCropGrid(false);
            options.withAspectRatio(1.0f, 1.0f);
        }
        options.setCompressionQuality(this.compressQuality);
        options.withMaxResultSize(this.cropW, this.cropH);
        options.background_color(this.backgroundColor);
        options.localType(this.type);
        options.setIsCompress(this.isCompress);
        options.setIsTakePhoto(this.takePhoto);
        options.setCircularCut(this.circularCut);
        uCrop.withOptions(options);
        uCrop.start((Activity)this);
    }

    protected void startMultiCopy(List<LocalMedia> medias) {
        if (Utils.isFastDoubleClick()) {
            return;
        }
        this.picture_tv_right.setEnabled(false);
        if (medias != null && medias.size() > 0) {
            LocalMedia media = medias.get(0);
            String path = media.getPath();
            MultiUCrop uCrop = MultiUCrop.of((Uri)Uri.parse((String)path), (Uri)Uri.fromFile((File)new File(this.getCacheDir(), System.currentTimeMillis() + ".jpg")));
            MultiUCrop.Options options = new MultiUCrop.Options();
            switch (this.copyMode) {
                case 0: {
                    options.withAspectRatio(0.0f, 0.0f);
                    break;
                }
                case 11: {
                    options.withAspectRatio(1.0f, 1.0f);
                    break;
                }
                case 32: {
                    options.withAspectRatio(3.0f, 2.0f);
                    break;
                }
                case 34: {
                    options.withAspectRatio(3.0f, 4.0f);
                    break;
                }
                case 169: {
                    options.withAspectRatio(16.0f, 9.0f);
                }
            }
            if (this.circularCut) {
                options.setCircleDimmedLayer(true);
                options.setShowCropFrame(false);
                options.setShowCropGrid(false);
                options.withAspectRatio(1.0f, 1.0f);
            }
            options.setLocalMedia(medias);
            options.setCompressionQuality(this.compressQuality);
            options.withMaxResultSize(this.cropW, this.cropH);
            options.background_color(this.backgroundColor);
            options.setIsCompress(this.isCompress);
            options.setCircularCut(this.circularCut);
            options.copyMode(this.copyMode);
            uCrop.withOptions(options);
            uCrop.start((Activity)this);
        }
    }

    public void startOpenCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            File cameraFile = FileUtils.createCameraFile((Context)this, (int)this.type);
            this.cameraPath = cameraFile.getAbsolutePath();
            String authority = this.getPackageName() + ".provider";
            Uri imageUri = Build.VERSION.SDK_INT >= 23 ? FileProvider.getUriForFile((Context)this.mContext, (String)authority, (File)cameraFile) : Uri.fromFile((File)cameraFile);
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            this.startActivityForResult(cameraIntent, 99);
        }
    }

    public void startOpenCameraVideo() {
        Intent cameraIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            File cameraFile = FileUtils.createCameraFile((Context)this, (int)this.type);
            this.cameraPath = cameraFile.getAbsolutePath();
            String authority = this.getPackageName() + ".provider";
            Uri imageUri = Build.VERSION.SDK_INT >= 23 ? FileProvider.getUriForFile((Context)this.mContext, (String)authority, (File)cameraFile) : Uri.fromFile((File)cameraFile);
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            cameraIntent.putExtra("android.intent.extra.durationLimit", this.recordVideoSecond);
            cameraIntent.putExtra("android.intent.extra.videoQuality", this.definition);
            this.startActivityForResult(cameraIntent, 99);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            if (requestCode == 99) {
                File file = new File(this.cameraPath);
                int degree = FileUtils.readPictureDegree((String)file.getAbsolutePath());
                this.rotateImage(degree, file);
                this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
                this.takePhotoSuccess = true;
                LocalMedia media = new LocalMedia();
                media.setPath(this.cameraPath);
                media.setType(this.type);
                if (this.selectMode == 2 || this.takePhoto) {
                    if (this.type == 1) {
                        if (this.enableCrop) {
                            this.startCopy(this.cameraPath);
                        } else if (this.isCompress) {
                            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
                            result.add(media);
                            this.compressImage(result);
                        } else {
                            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
                            result.add(media);
                            this.onSelectDone(result);
                        }
                    } else {
                        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
                        MediaMetadataRetriever mmr = new MediaMetadataRetriever();
                        mmr.setDataSource(this.cameraPath);
                        long duration = Integer.parseInt(mmr.extractMetadata(9));
                        media.setDuration(duration);
                        result.add(media);
                        this.onSelectDone(result);
                    }
                } else {
                    int duration = 0;
                    if (this.type == 2) {
                        MediaMetadataRetriever mmr = new MediaMetadataRetriever();
                        mmr.setDataSource(file.getPath());
                        duration = Integer.parseInt(mmr.extractMetadata(9));
                    }
                    this.createNewFolder(this.folders);
                    media = new LocalMedia(file.getPath(), (long)duration, (long)duration, this.type);
                    LocalMediaFolder folder = this.getImageFolder(media.getPath(), this.folders);
                    folder.getImages().add(0, media);
                    folder.setImageNum(folder.getImageNum() + 1);
                    folder.setFirstImagePath(media.getPath());
                    folder.setType(this.type);
                    LocalMediaFolder mediaFolder = this.folders.get(0);
                    mediaFolder.setFirstImagePath(media.getPath());
                    mediaFolder.setType(this.type);
                    List localMedias = mediaFolder.getImages();
                    if (localMedias.size() >= 100) {
                        localMedias.remove(localMedias.size() - 1);
                    }
                    List<LocalMedia> images = this.adapter.getImages();
                    images.add(0, media);
                    mediaFolder.setImages(images);
                    mediaFolder.setImageNum(mediaFolder.getImages().size());
                    if (this.adapter.getSelectedImages().size() < this.maxSelectNum) {
                        List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                        selectedImages.add(media);
                        this.adapter.bindSelectImages(selectedImages);
                        this.ChangeImageNumber(this.adapter.getSelectedImages());
                    }
                    this.adapter.bindImagesData(images);
                }
            }
        } else if (resultCode == 0 && this.takePhoto && !this.takePhotoSuccess) {
            this.recycleCallBack();
        }
    }

    private void rotateImage(int degree, File file) {
        if (degree > 0) {
            try {
                BitmapFactory.Options opts = new BitmapFactory.Options();
                opts.inSampleSize = 2;
                Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)opts);
                Bitmap bmp = FileUtils.rotaingImageView((int)degree, (Bitmap)bitmap);
                FileUtils.saveBitmapFile((Bitmap)bmp, (File)file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void recycleCallBack() {
        this.activityFinish(2);
        this.clearData();
    }

    private void createNewFolder(List<LocalMediaFolder> folders) {
        if (folders.size() == 0) {
            LocalMediaFolder newFolder = new LocalMediaFolder();
            String folderName = "";
            switch (this.type) {
                case 1: {
                    folderName = this.getString(R.string.picture_lately_image);
                    break;
                }
                case 2: {
                    folderName = this.getString(R.string.picture_lately_video);
                }
            }
            newFolder.setName(folderName);
            newFolder.setPath("");
            newFolder.setFirstImagePath("");
            newFolder.setType(this.type);
            folders.add(newFolder);
        }
    }

    private void handleCropResult(List<LocalMedia> result) {
        if (result != null) {
            if (this.isCompress && this.type == 1) {
                this.compressImage(result);
            } else {
                this.onSelectDone(result);
            }
        }
    }

    public void onSelectDone(List<LocalMedia> result) {
        this.onResult(result);
    }

    public void onResult(List<LocalMedia> images) {
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        for (LocalMedia media : images) {
            result.add(media);
        }
        PictureConfig.OnSelectResultCallback resultCallback = PictureConfig.getInstance().getResultCallback();
        if (resultCallback != null) {
            resultCallback.onSelectSuccess(result);
        }
        EventEntity obj = new EventEntity(2773);
        EventBus.getDefault().post((Object)obj);
        if (this.takePhoto && this.takePhotoSuccess || this.enableCrop && this.isCompress && this.selectMode == 2) {
            this.recycleCallBack();
            EventEntity obj1 = new EventEntity(2777);
            EventBus.getDefault().post((Object)obj1);
        } else {
            this.clearData();
        }
        this.finish();
        this.overridePendingTransition(0, R.anim.slide_bottom_out);
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putString("CameraPath", this.cameraPath);
    }

    private LocalMediaFolder getImageFolder(String path, List<LocalMediaFolder> imageFolders) {
        File imageFile = new File(path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            if (!folder.getName().equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile.getName());
        newFolder.setPath(folderFile.getAbsolutePath());
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.activityFinish(1);
                return false;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void activityFinish(int type) {
        switch (type) {
            case 1: {
                List<LocalMedia> selectedImages = this.adapter.getSelectedImages();
                if (selectedImages == null) {
                    selectedImages = new ArrayList<LocalMedia>();
                }
                this.startActivity(new Intent(this.mContext, PictureAlbumDirectoryActivity.class).putExtra("previewSelectList", (Serializable)((Object)selectedImages)).putExtra("function_options", (Serializable)this.options));
                this.overridePendingTransition(R.anim.slide_right_in, R.anim.slide_right_out);
                ImagesObservable.getInstance().notifySelectLocalMediaObserver(selectedImages);
                this.finish();
                break;
            }
            case 2: {
                this.clearData();
                EventEntity obj = new EventEntity(2773);
                EventBus.getDefault().post((Object)obj);
                this.finish();
                this.overridePendingTransition(0, R.anim.slide_bottom_out);
            }
        }
    }

    private void compressImage(List<LocalMedia> result) {
        this.showPleaseDialog(this.getString(R.string.picture_please));
        CompressConfig compress_config = CompressConfig.ofDefaultConfig();
        switch (this.compressFlag) {
            case 1: {
                compress_config.enablePixelCompress(this.options.isEnablePixelCompress());
                compress_config.enableQualityCompress(this.options.isEnableQualityCompress());
                compress_config.setMaxSize(this.maxB);
                break;
            }
            case 2: {
                LubanOptions option = new LubanOptions.Builder().setMaxHeight(this.compressH).setMaxWidth(this.compressW).setMaxSize(this.maxB).setGrade(this.grade).create();
                compress_config = CompressConfig.ofLuban(option);
            }
        }
        CompressImageOptions.compress((Context)this, compress_config, result, new CompressInterface.CompressListener(){

            @Override
            public void onCompressSuccess(List<LocalMedia> images) {
                PictureImageGridActivity.this.onResult(images);
                PictureImageGridActivity.this.dismiss();
            }

            @Override
            public void onCompressError(List<LocalMedia> images, String msg) {
                List<LocalMedia> selectedImages = PictureImageGridActivity.this.adapter.getSelectedImages();
                PictureImageGridActivity.this.onResult(selectedImages);
                PictureImageGridActivity.this.dismiss();
            }
        }).compress();
    }

    private void showPleaseDialog(String msg) {
        if (!this.isFinishing()) {
            this.dialog = new SweetAlertDialog((Context)this);
            this.dialog.setTitleText(msg);
            this.dialog.show();
        }
    }

    private void dismiss() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.cancel();
        }
    }

    protected void clearData() {
        PictureConfig.getInstance().resultCallback = null;
        ImagesObservable.getInstance().clearLocalFolders();
        ImagesObservable.getInstance().clearLocalMedia();
        ImagesObservable.getInstance().clearSelectedLocalMedia();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
    }
}

