/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.progress;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.data.DataFetcher;
import com.luck.picture.lib.progress.ProgressListener;
import com.luck.picture.lib.progress.ProgressResponseBody;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ProgressDataFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "ProgressDataFetcher";
    private final String url;
    private final Handler handler;
    private Call progressCall;
    private InputStream stream;
    private volatile boolean isCancelled;

    public ProgressDataFetcher(String url, Handler handler) {
        this.url = url;
        this.handler = handler;
    }

    public InputStream loadData(Priority priority) throws Exception {
        Request request = new Request.Builder().url(this.url).build();
        final ProgressListener progressListener = new ProgressListener(){

            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
                Log.e((String)ProgressDataFetcher.TAG, (String)(bytesRead + "," + contentLength + done));
                if (ProgressDataFetcher.this.handler != null) {
                    Message message = ProgressDataFetcher.this.handler.obtainMessage();
                    message.what = 1;
                    message.arg1 = (int)bytesRead;
                    message.arg2 = (int)contentLength;
                    ProgressDataFetcher.this.handler.sendMessage(message);
                }
            }
        };
        OkHttpClient client = new OkHttpClient.Builder().addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            }
        }).build();
        try {
            this.progressCall = client.newCall(request);
            Response response = this.progressCall.execute();
            if (this.isCancelled) {
                return null;
            }
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            this.stream = response.body().byteStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.stream;
    }

    public void cleanup() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.progressCall != null) {
            this.progressCall.cancel();
        }
    }

    public String getId() {
        return this.url;
    }

    public void cancel() {
        this.isCancelled = true;
    }
}

