/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.luck.picture.lib.R;
import com.luck.picture.lib.model.FunctionOptions;
import com.luck.picture.lib.ui.PictureExternalPreviewActivity;
import com.luck.picture.lib.ui.PictureImageGridActivity;
import com.luck.picture.lib.ui.PictureVideoPlayActivity;
import com.yalantis.ucrop.entity.LocalMedia;
import com.yalantis.ucrop.util.Utils;
import java.io.Serializable;
import java.util.List;

public class PictureConfig {
    public FunctionOptions options;
    public static PictureConfig sInstance;
    public OnSelectResultCallback resultCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PictureConfig getInstance() {
        if (sInstance != null) return sInstance;
        Class<PictureConfig> clazz = PictureConfig.class;
        synchronized (PictureConfig.class) {
            if (sInstance != null) return sInstance;
            sInstance = new PictureConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public OnSelectResultCallback getResultCallback() {
        return this.resultCallback;
    }

    public PictureConfig init(FunctionOptions options) {
        this.options = options;
        return this;
    }

    public void openPhoto(Activity activity, OnSelectResultCallback resultCall) {
        if (Utils.isFastDoubleClick()) {
            return;
        }
        if (this.options == null) {
            this.options = new FunctionOptions.Builder().create();
        }
        Intent intent = new Intent((Context)activity, PictureImageGridActivity.class);
        intent.putExtra("function_options", (Serializable)this.options);
        activity.startActivity(intent);
        activity.overridePendingTransition(R.anim.slide_bottom_in, 0);
        this.resultCallback = resultCall;
    }

    public void startOpenCamera(Activity activity, OnSelectResultCallback resultCall) {
        if (this.options == null) {
            this.options = new FunctionOptions.Builder().create();
        }
        Intent intent = new Intent((Context)activity, PictureImageGridActivity.class);
        intent.putExtra("function_options", (Serializable)this.options);
        intent.putExtra("function_take", true);
        activity.startActivity(intent);
        activity.overridePendingTransition(R.anim.fade, R.anim.hold);
        this.resultCallback = resultCall;
    }

    public void externalPicturePreview(Activity activity, int position, List<LocalMedia> medias) {
        if (medias != null && medias.size() > 0) {
            Intent intent = new Intent();
            intent.putExtra("previewSelectList", (Serializable)((Object)medias));
            intent.putExtra("position", position);
            intent.setClass((Context)activity, PictureExternalPreviewActivity.class);
            activity.startActivity(intent);
            activity.overridePendingTransition(R.anim.toast_enter, 0);
        }
    }

    public void externalPictureVideo(Activity activity, String path) {
        if (!Utils.isNull((String)path)) {
            Intent intent = new Intent();
            intent.putExtra("video_path", path);
            intent.setClass((Context)activity, PictureVideoPlayActivity.class);
            activity.startActivity(intent);
        }
    }

    public static interface OnSelectResultCallback {
        public void onSelectSuccess(List<LocalMedia> var1);
    }
}

