/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import com.luck.picture.lib.R;
import com.yalantis.ucrop.entity.LocalMedia;
import com.yalantis.ucrop.entity.LocalMediaFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LocalMediaLoader {
    public boolean isGif;
    public int index = 0;
    private static final String[] IMAGE_PROJECTION = new String[]{"_data", "_display_name", "date_added", "_id"};
    private static final String[] VIDEO_PROJECTION = new String[]{"_data", "_display_name", "date_added", "_id", "duration"};
    private int type = 1;
    private FragmentActivity activity;

    public LocalMediaLoader(FragmentActivity activity, int type, boolean isGif) {
        this.activity = activity;
        this.type = type;
        this.isGif = isGif;
    }

    public void loadAllImage(final LocalMediaLoadListener imageLoadListener) {
        this.activity.getSupportLoaderManager().initLoader(this.type, null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<Cursor>(){

            public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
                CursorLoader cursorLoader = null;
                String[] select = null;
                String condition = "";
                if (LocalMediaLoader.this.isGif) {
                    select = new String[]{"image/jpeg", "image/png", "image/gif"};
                    condition = "mime_type=? or mime_type=? or mime_type=?";
                } else {
                    select = new String[]{"image/jpeg", "image/png", "image/webp"};
                    condition = "mime_type=? or mime_type=? or mime_type=?";
                }
                if (id2 == 1) {
                    cursorLoader = new CursorLoader((Context)LocalMediaLoader.this.activity, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, IMAGE_PROJECTION, condition, select, IMAGE_PROJECTION[2] + " DESC");
                } else if (id2 == 2) {
                    cursorLoader = new CursorLoader((Context)LocalMediaLoader.this.activity, MediaStore.Video.Media.EXTERNAL_CONTENT_URI, VIDEO_PROJECTION, null, null, VIDEO_PROJECTION[2] + " DESC");
                }
                return cursorLoader;
            }

            public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
                try {
                    ArrayList<LocalMediaFolder> imageFolders = new ArrayList<LocalMediaFolder>();
                    LocalMediaFolder allImageFolder = new LocalMediaFolder();
                    ArrayList<LocalMedia> allImages = new ArrayList<LocalMedia>();
                    if (data != null) {
                        int count = data.getCount();
                        if (count > 0) {
                            data.moveToFirst();
                            do {
                                String path;
                                if (TextUtils.isEmpty((CharSequence)(path = data.getString(data.getColumnIndexOrThrow(IMAGE_PROJECTION[0])))) || !new File(path).exists()) continue;
                                long dateTime = data.getLong(data.getColumnIndexOrThrow(IMAGE_PROJECTION[2]));
                                int duration = LocalMediaLoader.this.type == 2 ? data.getInt(data.getColumnIndexOrThrow(VIDEO_PROJECTION[4])) : 0;
                                LocalMedia image = new LocalMedia(path, dateTime, (long)duration, LocalMediaLoader.this.type);
                                LocalMediaFolder folder = LocalMediaLoader.this.getImageFolder(path, imageFolders);
                                folder.getImages().add(image);
                                folder.setType(LocalMediaLoader.this.type);
                                ++LocalMediaLoader.this.index;
                                folder.setImageNum(folder.getImageNum() + 1);
                                if (LocalMediaLoader.this.index > 100) continue;
                                allImages.add(image);
                                allImageFolder.setType(LocalMediaLoader.this.type);
                                allImageFolder.setImageNum(allImageFolder.getImageNum() + 1);
                            } while (data.moveToNext());
                            if (allImages.size() > 0) {
                                LocalMediaLoader.this.sortFolder(imageFolders);
                                imageFolders.add(0, allImageFolder);
                                String title = "";
                                switch (LocalMediaLoader.this.type) {
                                    case 2: {
                                        title = LocalMediaLoader.this.activity.getString(R.string.picture_lately_video);
                                        break;
                                    }
                                    case 1: {
                                        title = LocalMediaLoader.this.activity.getString(R.string.picture_lately_image);
                                    }
                                }
                                allImageFolder.setFirstImagePath(((LocalMedia)allImages.get(0)).getPath());
                                allImageFolder.setName(title);
                                allImageFolder.setType(LocalMediaLoader.this.type);
                                allImageFolder.setImages(allImages);
                            }
                            imageLoadListener.loadComplete(imageFolders);
                            data.close();
                        } else {
                            imageLoadListener.loadComplete(imageFolders);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onLoaderReset(Loader<Cursor> loader) {
            }
        });
    }

    private void sortFolder(List<LocalMediaFolder> imageFolders) {
        Collections.sort(imageFolders, new Comparator<LocalMediaFolder>(){

            @Override
            public int compare(LocalMediaFolder lhs, LocalMediaFolder rhs) {
                int rsize;
                if (lhs.getImages() == null || rhs.getImages() == null) {
                    return 0;
                }
                int lsize = lhs.getImageNum();
                return lsize == (rsize = rhs.getImageNum()) ? 0 : (lsize < rsize ? 1 : -1);
            }
        });
    }

    private LocalMediaFolder getImageFolder(String path, List<LocalMediaFolder> imageFolders) {
        File imageFile = new File(path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            if (!folder.getName().equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile.getName());
        newFolder.setPath(folderFile.getAbsolutePath());
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    public static interface LocalMediaLoadListener {
        public void loadComplete(List<LocalMediaFolder> var1);
    }
}

