/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.compress;

import android.content.Context;
import android.util.Log;
import com.luck.picture.lib.compress.CompressConfig;
import com.luck.picture.lib.compress.CompressInterface;
import com.luck.picture.lib.compress.Luban;
import com.luck.picture.lib.compress.LubanOptions;
import com.luck.picture.lib.compress.OnCompressListener;
import com.luck.picture.lib.compress.OnMultiCompressListener;
import com.yalantis.ucrop.entity.LocalMedia;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LuBanCompress
implements CompressInterface {
    private List<LocalMedia> images;
    private CompressInterface.CompressListener listener;
    private Context context;
    private LubanOptions options;
    private ArrayList<File> files = new ArrayList();

    public LuBanCompress(Context context, CompressConfig config, List<LocalMedia> images, CompressInterface.CompressListener listener) {
        this.options = config.getLubanOptions();
        this.images = images;
        this.listener = listener;
        this.context = context;
    }

    @Override
    public void compress() {
        if (this.images == null || this.images.isEmpty()) {
            this.listener.onCompressError(this.images, " images is null");
            return;
        }
        for (LocalMedia image : this.images) {
            if (image == null) {
                this.listener.onCompressError(this.images, " There are pictures of compress  is null.");
                return;
            }
            if (image.isCut()) {
                this.files.add(new File(image.getCutPath()));
                continue;
            }
            this.files.add(new File(image.getPath()));
        }
        if (this.images.size() == 1) {
            this.compressOne();
        } else {
            this.compressMulti();
        }
    }

    private void compressOne() {
        Log.i((String)"\u538b\u7f29\u6863\u6b21::", (String)(this.options.getGrade() + ""));
        Luban.compress(this.context, this.files.get(0)).putGear(this.options.getGrade()).setMaxHeight(this.options.getMaxHeight()).setMaxWidth(this.options.getMaxWidth()).setMaxSize(this.options.getMaxSize() / 1000).launch(new OnCompressListener(){

            @Override
            public void onStart() {
            }

            @Override
            public void onSuccess(File file) {
                LocalMedia image = (LocalMedia)LuBanCompress.this.images.get(0);
                image.setCompressPath(file.getPath());
                image.setCompressed(true);
                LuBanCompress.this.listener.onCompressSuccess(LuBanCompress.this.images);
            }

            @Override
            public void onError(Throwable e) {
                LuBanCompress.this.listener.onCompressError(LuBanCompress.this.images, e.getMessage() + " is compress failures");
            }
        });
    }

    private void compressMulti() {
        Log.i((String)"\u538b\u7f29\u6863\u6b21::", (String)(this.options.getGrade() + ""));
        Luban.compress(this.context, this.files).putGear(this.options.getGrade()).setMaxSize(this.options.getMaxSize() / 1000).setMaxHeight(this.options.getMaxHeight()).setMaxWidth(this.options.getMaxWidth()).launch(new OnMultiCompressListener(){

            @Override
            public void onStart() {
            }

            @Override
            public void onSuccess(List<File> fileList) {
                LuBanCompress.this.handleCompressCallBack(fileList);
            }

            @Override
            public void onError(Throwable e) {
                LuBanCompress.this.listener.onCompressError(LuBanCompress.this.images, e.getMessage() + " is compress failures");
            }
        });
    }

    private void handleCompressCallBack(List<File> files) {
        int j = this.images.size();
        for (int i = 0; i < j; ++i) {
            LocalMedia image = this.images.get(i);
            image.setCompressed(true);
            image.setCompressPath(files.get(i).getPath());
        }
        this.listener.onCompressSuccess(this.images);
    }
}

