/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import com.luck.picture.lib.PictureContextWrapper;
import com.luck.picture.lib.PictureCustomCameraActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.PictureSelectorActivity;
import com.luck.picture.lib.PictureSelectorCameraEmptyActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.app.PictureAppMaster;
import com.luck.picture.lib.compress.Luban;
import com.luck.picture.lib.compress.OnCompressListener;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.dialog.PictureLoadingDialog;
import com.luck.picture.lib.engine.PictureSelectorEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.immersive.ImmersiveManage;
import com.luck.picture.lib.immersive.NavBarUtils;
import com.luck.picture.lib.language.PictureLanguageUtils;
import com.luck.picture.lib.model.LocalMediaPageLoader;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.AndroidQTransformUtils;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.VoiceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PictureBaseActivity
extends AppCompatActivity {
    protected PictureSelectionConfig config;
    protected boolean openWhiteStatusBar;
    protected boolean numComplete;
    protected int colorPrimary;
    protected int colorPrimaryDark;
    protected PictureLoadingDialog mLoadingDialog;
    protected List<LocalMedia> selectionMedias;
    protected Handler mHandler = new Handler(Looper.getMainLooper());
    protected View container;
    protected boolean isHasMore = true;
    protected int mPage = 1;
    protected boolean isOnSaveInstanceState;

    public boolean isImmersive() {
        return true;
    }

    public boolean isRequestedOrientation() {
        return true;
    }

    public void immersive() {
        ImmersiveManage.immersiveAboveAPI23(this, this.colorPrimaryDark, this.colorPrimary, this.openWhiteStatusBar);
    }

    public abstract int getResourceId();

    protected void initWidgets() {
    }

    protected void initPictureSelectorStyle() {
    }

    protected void initCompleteText(int startCount) {
    }

    protected void initCompleteText(List<LocalMedia> list) {
    }

    protected void onCreate(Bundle savedInstanceState) {
        int layoutResID;
        this.config = PictureSelectionConfig.getInstance();
        PictureLanguageUtils.setAppLanguage(this.getContext(), this.config.language);
        if (!this.config.camera) {
            this.setTheme(this.config.themeStyleId == 0 ? R.style.picture_default_style : this.config.themeStyleId);
        }
        super.onCreate(savedInstanceState);
        this.newCreateEngine();
        this.newCreateResultCallbackListener();
        if (this.isRequestedOrientation()) {
            this.setNewRequestedOrientation();
        }
        this.initConfig();
        if (this.isImmersive()) {
            this.immersive();
        }
        if (PictureSelectionConfig.uiStyle != null) {
            if (PictureSelectionConfig.uiStyle.picture_navBarColor != 0) {
                NavBarUtils.setNavBarColor((Activity)this, PictureSelectionConfig.uiStyle.picture_navBarColor);
            }
        } else if (PictureSelectionConfig.style != null && PictureSelectionConfig.style.pictureNavBarColor != 0) {
            NavBarUtils.setNavBarColor((Activity)this, PictureSelectionConfig.style.pictureNavBarColor);
        }
        if ((layoutResID = this.getResourceId()) != 0) {
            this.setContentView(layoutResID);
        }
        this.initWidgets();
        this.initPictureSelectorStyle();
        this.isOnSaveInstanceState = false;
    }

    private void newCreateEngine() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.imageEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.imageEngine = baseEngine.createEngine();
        }
    }

    private void newCreateResultCallbackListener() {
        PictureSelectorEngine baseEngine;
        if (this.config.isCallbackMode && PictureSelectionConfig.listener == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.listener = baseEngine.getResultCallbackListener();
        }
    }

    protected void attachBaseContext(Context newBase) {
        if (this.config == null) {
            super.attachBaseContext(newBase);
        } else {
            super.attachBaseContext((Context)PictureContextWrapper.wrap(newBase, this.config.language));
        }
    }

    protected void setNewRequestedOrientation() {
        if (this.config != null && !this.config.camera) {
            this.setRequestedOrientation(this.config.requestedOrientation);
        }
    }

    protected Context getContext() {
        return this;
    }

    private void initConfig() {
        List<Object> list = this.selectionMedias = this.config.selectionMedias == null ? new ArrayList() : this.config.selectionMedias;
        if (PictureSelectionConfig.uiStyle != null) {
            this.openWhiteStatusBar = PictureSelectionConfig.uiStyle.picture_statusBarChangeTextColor;
            if (PictureSelectionConfig.uiStyle.picture_top_titleBarBackgroundColor != 0) {
                this.colorPrimary = PictureSelectionConfig.uiStyle.picture_top_titleBarBackgroundColor;
            }
            if (PictureSelectionConfig.uiStyle.picture_statusBarBackgroundColor != 0) {
                this.colorPrimaryDark = PictureSelectionConfig.uiStyle.picture_statusBarBackgroundColor;
            }
            this.numComplete = PictureSelectionConfig.uiStyle.picture_switchSelectTotalStyle;
            this.config.checkNumMode = PictureSelectionConfig.uiStyle.picture_switchSelectNumberStyle;
        } else if (PictureSelectionConfig.style != null) {
            this.openWhiteStatusBar = PictureSelectionConfig.style.isChangeStatusBarFontColor;
            if (PictureSelectionConfig.style.pictureTitleBarBackgroundColor != 0) {
                this.colorPrimary = PictureSelectionConfig.style.pictureTitleBarBackgroundColor;
            }
            if (PictureSelectionConfig.style.pictureStatusBarColor != 0) {
                this.colorPrimaryDark = PictureSelectionConfig.style.pictureStatusBarColor;
            }
            this.numComplete = PictureSelectionConfig.style.isOpenCompletedNumStyle;
            this.config.checkNumMode = PictureSelectionConfig.style.isOpenCheckNumStyle;
        } else {
            this.openWhiteStatusBar = this.config.isChangeStatusBarFontColor;
            if (!this.openWhiteStatusBar) {
                this.openWhiteStatusBar = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_statusFontColor);
            }
            this.numComplete = this.config.isOpenStyleNumComplete;
            if (!this.numComplete) {
                this.numComplete = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_style_numComplete);
            }
            this.config.checkNumMode = this.config.isOpenStyleCheckNumMode;
            if (!this.config.checkNumMode) {
                this.config.checkNumMode = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_style_checkNumMode);
            }
            this.colorPrimary = this.config.titleBarBackgroundColor != 0 ? this.config.titleBarBackgroundColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.colorPrimary);
            this.colorPrimaryDark = this.config.pictureStatusBarColor != 0 ? this.config.pictureStatusBarColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.colorPrimaryDark);
        }
        if (this.config.openClickSound) {
            VoiceUtils.getInstance().init(this.getContext());
        }
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.isOnSaveInstanceState = true;
        outState.putParcelable("PictureSelectorConfig", (Parcelable)this.config);
    }

    protected void showPleaseDialog() {
        try {
            if (!this.isFinishing()) {
                if (this.mLoadingDialog == null) {
                    this.mLoadingDialog = new PictureLoadingDialog(this.getContext());
                }
                if (this.mLoadingDialog.isShowing()) {
                    this.mLoadingDialog.dismiss();
                }
                this.mLoadingDialog.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void dismissDialog() {
        if (!this.isFinishing()) {
            try {
                if (this.mLoadingDialog != null && this.mLoadingDialog.isShowing()) {
                    this.mLoadingDialog.dismiss();
                }
            }
            catch (Exception e) {
                this.mLoadingDialog = null;
                e.printStackTrace();
            }
        }
    }

    protected void compressImage(List<LocalMedia> result) {
        this.showPleaseDialog();
        this.compressToLuban(result);
    }

    private void compressToLuban(final List<LocalMedia> result) {
        if (this.config.synOrAsy) {
            PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<List<File>>(){

                @Override
                public List<File> doInBackground() throws Exception {
                    return Luban.with(PictureBaseActivity.this.getContext()).loadMediaData(result).isCamera(PictureBaseActivity.this.config.camera).setTargetDir(PictureBaseActivity.this.config.compressSavePath).setCompressQuality(PictureBaseActivity.this.config.compressQuality).setFocusAlpha(PictureBaseActivity.this.config.focusAlpha).setNewCompressFileName(PictureBaseActivity.this.config.renameCompressFileName).ignoreBy(PictureBaseActivity.this.config.minimumCompressSize).get();
                }

                @Override
                public void onSuccess(List<File> files) {
                    if (files != null && files.size() > 0 && files.size() == result.size()) {
                        PictureBaseActivity.this.handleCompressCallBack(result, files);
                    } else {
                        PictureBaseActivity.this.onResult(result);
                    }
                }
            });
        } else {
            Luban.with((Context)this).loadMediaData(result).ignoreBy(this.config.minimumCompressSize).isCamera(this.config.camera).setCompressQuality(this.config.compressQuality).setTargetDir(this.config.compressSavePath).setFocusAlpha(this.config.focusAlpha).setNewCompressFileName(this.config.renameCompressFileName).setCompressListener(new OnCompressListener(){

                @Override
                public void onStart() {
                }

                @Override
                public void onSuccess(List<LocalMedia> list) {
                    PictureBaseActivity.this.onResult(list);
                }

                @Override
                public void onError(Throwable e) {
                    PictureBaseActivity.this.onResult(result);
                }
            }).launch();
        }
    }

    private void handleCompressCallBack(List<LocalMedia> images, List<File> files) {
        if (images == null || files == null) {
            this.exit();
            return;
        }
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        int size = images.size();
        if (files.size() == size) {
            int j = size;
            for (int i = 0; i < j; ++i) {
                File file = files.get(i);
                if (file == null) continue;
                String path = file.getAbsolutePath();
                LocalMedia image = images.get(i);
                boolean http = PictureMimeType.isHasHttp(path);
                boolean flag = !TextUtils.isEmpty((CharSequence)path) && http;
                boolean isHasVideo = PictureMimeType.isHasVideo(image.getMimeType());
                image.setCompressed(!isHasVideo && !flag);
                image.setCompressPath(isHasVideo || flag ? null : path);
                if (!isAndroidQ) continue;
                image.setAndroidQToPath(image.getCompressPath());
            }
        }
        this.onResult(images);
    }

    protected void handlerResult(List<LocalMedia> result) {
        if (this.config.isCompress && !this.config.isCheckOriginalImage) {
            this.compressImage(result);
        } else {
            this.onResult(result);
        }
    }

    protected void createNewFolder(List<LocalMediaFolder> folders) {
        if (folders.size() == 0) {
            LocalMediaFolder newFolder = new LocalMediaFolder();
            String folderName = this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
            newFolder.setName(folderName);
            newFolder.setFirstImagePath("");
            newFolder.setCameraFolder(true);
            newFolder.setBucketId(-1L);
            newFolder.setChecked(true);
            folders.add(newFolder);
        }
    }

    protected LocalMediaFolder getImageFolder(String path, String realPath, List<LocalMediaFolder> imageFolders) {
        File imageFile = new File(PictureMimeType.isContent(path) ? realPath : path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            if (folderFile == null || !folder.getName().equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile != null ? folderFile.getName() : "");
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    protected void onResult(List<LocalMedia> images) {
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        if (isAndroidQ && this.config.isAndroidQTransform) {
            this.showPleaseDialog();
            this.onResultToAndroidAsy(images);
        } else {
            this.dismissDialog();
            if (this.config.camera && this.config.selectionMode == 2 && this.selectionMedias != null) {
                images.addAll(images.size() > 0 ? images.size() - 1 : 0, this.selectionMedias);
            }
            if (this.config.isCheckOriginalImage) {
                int size = images.size();
                for (int i = 0; i < size; ++i) {
                    LocalMedia media = images.get(i);
                    media.setOriginal(true);
                    media.setOriginalPath(media.getPath());
                }
            }
            if (PictureSelectionConfig.listener != null) {
                PictureSelectionConfig.listener.onResult(images);
            } else {
                Intent intent = PictureSelector.putIntentResult(images);
                this.setResult(-1, intent);
            }
            this.exit();
        }
    }

    private void onResultToAndroidAsy(final List<LocalMedia> images) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<List<LocalMedia>>(){

            @Override
            public List<LocalMedia> doInBackground() {
                int size = images.size();
                for (int i = 0; i < size; ++i) {
                    boolean isCopyAndroidQToPath;
                    LocalMedia media = (LocalMedia)images.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                    boolean bl = isCopyAndroidQToPath = !media.isCut() && !media.isCompressed() && TextUtils.isEmpty((CharSequence)media.getAndroidQToPath());
                    if (isCopyAndroidQToPath && PictureMimeType.isContent(media.getPath())) {
                        if (!PictureMimeType.isHasHttp(media.getPath())) {
                            String AndroidQToPath = AndroidQTransformUtils.copyPathToAndroidQ(PictureBaseActivity.this.getContext(), media.getPath(), media.getWidth(), media.getHeight(), media.getMimeType(), PictureBaseActivity.this.config.cameraFileName);
                            media.setAndroidQToPath(AndroidQToPath);
                        }
                    } else if (media.isCut() && media.isCompressed()) {
                        media.setAndroidQToPath(media.getCompressPath());
                    }
                    if (!PictureBaseActivity.this.config.isCheckOriginalImage) continue;
                    media.setOriginal(true);
                    media.setOriginalPath(media.getAndroidQToPath());
                }
                return images;
            }

            @Override
            public void onSuccess(List<LocalMedia> images2) {
                PictureBaseActivity.this.dismissDialog();
                if (images2 != null) {
                    if (PictureBaseActivity.this.config.camera && PictureBaseActivity.this.config.selectionMode == 2 && PictureBaseActivity.this.selectionMedias != null) {
                        images2.addAll(images2.size() > 0 ? images2.size() - 1 : 0, PictureBaseActivity.this.selectionMedias);
                    }
                    if (PictureSelectionConfig.listener != null) {
                        PictureSelectionConfig.listener.onResult(images2);
                    } else {
                        Intent intent = PictureSelector.putIntentResult(images2);
                        PictureBaseActivity.this.setResult(-1, intent);
                    }
                    PictureBaseActivity.this.exit();
                }
            }
        });
    }

    protected void exit() {
        this.finish();
        if (this.config.camera) {
            this.overridePendingTransition(0, R.anim.picture_anim_fade_out);
            if (this.getContext() instanceof PictureSelectorCameraEmptyActivity || this.getContext() instanceof PictureCustomCameraActivity) {
                this.releaseResultListener();
            }
        } else {
            this.overridePendingTransition(0, PictureSelectionConfig.windowAnimationStyle.activityExitAnimation);
            if (this.getContext() instanceof PictureSelectorActivity) {
                this.releaseResultListener();
                if (this.config.openClickSound) {
                    VoiceUtils.getInstance().releaseSoundPool();
                }
            }
        }
    }

    protected void onDestroy() {
        if (this.mLoadingDialog != null) {
            this.mLoadingDialog.dismiss();
            this.mLoadingDialog = null;
        }
        super.onDestroy();
    }

    protected String getAudioPath(Intent data) {
        if (data != null && this.config.chooseMode == PictureMimeType.ofAudio()) {
            try {
                Uri uri = data.getData();
                if (uri != null) {
                    return Build.VERSION.SDK_INT <= 19 ? uri.getPath() : MediaUtils.getAudioFilePathFromUri(this.getContext(), uri);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected void startOpenCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri imageUri;
            int chooseMode;
            String cameraFileName = null;
            int n = chooseMode = this.config.chooseMode == 0 ? 1 : this.config.chooseMode;
            if (!TextUtils.isEmpty((CharSequence)this.config.cameraFileName)) {
                boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(this.config.cameraFileName);
                this.config.cameraFileName = !isSuffixOfImage ? StringUtils.renameSuffix(this.config.cameraFileName, ".jpeg") : this.config.cameraFileName;
                String string2 = cameraFileName = this.config.camera ? this.config.cameraFileName : StringUtils.rename(this.config.cameraFileName);
            }
            if (SdkVersionUtils.checkedAndroid_Q()) {
                if (TextUtils.isEmpty((CharSequence)this.config.outPutCameraPath)) {
                    imageUri = MediaUtils.createImageUri((Context)this, this.config.cameraFileName, this.config.suffixType);
                } else {
                    File cameraFile = PictureFileUtils.createCameraFile((Context)this, chooseMode, cameraFileName, this.config.suffixType, this.config.outPutCameraPath);
                    this.config.cameraPath = cameraFile.getAbsolutePath();
                    imageUri = PictureFileUtils.parUri((Context)this, cameraFile);
                }
                if (imageUri != null) {
                    this.config.cameraPath = imageUri.toString();
                }
            } else {
                File cameraFile = PictureFileUtils.createCameraFile((Context)this, chooseMode, cameraFileName, this.config.suffixType, this.config.outPutCameraPath);
                this.config.cameraPath = cameraFile.getAbsolutePath();
                imageUri = PictureFileUtils.parUri((Context)this, cameraFile);
            }
            if (imageUri == null) {
                ToastUtils.s(this.getContext(), "open is camera error\uff0cthe uri is empty ");
                if (this.config.camera) {
                    this.exit();
                }
                return;
            }
            this.config.cameraMimeType = PictureMimeType.ofImage();
            if (this.config.isCameraAroundState) {
                cameraIntent.putExtra("android.intent.extras.CAMERA_FACING", 1);
            }
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    protected void startOpenCameraVideo() {
        Intent cameraIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri videoUri;
            int chooseMode;
            String cameraFileName = null;
            int n = chooseMode = this.config.chooseMode == 0 ? 2 : this.config.chooseMode;
            if (!TextUtils.isEmpty((CharSequence)this.config.cameraFileName)) {
                boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(this.config.cameraFileName);
                this.config.cameraFileName = isSuffixOfImage ? StringUtils.renameSuffix(this.config.cameraFileName, ".mp4") : this.config.cameraFileName;
                String string2 = cameraFileName = this.config.camera ? this.config.cameraFileName : StringUtils.rename(this.config.cameraFileName);
            }
            if (SdkVersionUtils.checkedAndroid_Q()) {
                if (TextUtils.isEmpty((CharSequence)this.config.outPutCameraPath)) {
                    videoUri = MediaUtils.createVideoUri((Context)this, this.config.cameraFileName, this.config.suffixType);
                } else {
                    File cameraFile = PictureFileUtils.createCameraFile((Context)this, chooseMode, cameraFileName, this.config.suffixType, this.config.outPutCameraPath);
                    this.config.cameraPath = cameraFile.getAbsolutePath();
                    videoUri = PictureFileUtils.parUri((Context)this, cameraFile);
                }
                if (videoUri != null) {
                    this.config.cameraPath = videoUri.toString();
                }
            } else {
                File cameraFile = PictureFileUtils.createCameraFile((Context)this, chooseMode, cameraFileName, this.config.suffixType, this.config.outPutCameraPath);
                this.config.cameraPath = cameraFile.getAbsolutePath();
                videoUri = PictureFileUtils.parUri((Context)this, cameraFile);
            }
            if (videoUri == null) {
                ToastUtils.s(this.getContext(), "open is camera error\uff0cthe uri is empty ");
                if (this.config.camera) {
                    this.exit();
                }
                return;
            }
            this.config.cameraMimeType = PictureMimeType.ofVideo();
            cameraIntent.putExtra("output", (Parcelable)videoUri);
            if (this.config.isCameraAroundState) {
                cameraIntent.putExtra("android.intent.extras.CAMERA_FACING", 1);
            }
            cameraIntent.putExtra("android.intent.extra.quickCapture", this.config.isQuickCapture);
            cameraIntent.putExtra("android.intent.extra.durationLimit", this.config.recordVideoSecond);
            cameraIntent.putExtra("android.intent.extra.videoQuality", this.config.videoQuality);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    public void startOpenCameraAudio() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO")) {
            Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
            if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
                this.config.cameraMimeType = PictureMimeType.ofAudio();
                this.startActivityForResult(cameraIntent, 909);
            }
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 3);
        }
    }

    private void releaseResultListener() {
        if (this.config != null) {
            PictureSelectionConfig.destroy();
            LocalMediaPageLoader.setInstanceNull();
            PictureThreadUtils.cancel(PictureThreadUtils.getIoPool());
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 3) {
            if (grantResults[0] == 0) {
                Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
                if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
                    this.startActivityForResult(cameraIntent, 909);
                }
            } else {
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_audio));
            }
        }
    }

    protected void showPermissionsDialog(boolean isCamera, String errorMsg) {
    }

    protected void showPromptDialog(String content) {
        if (!this.isFinishing()) {
            PictureCustomDialog dialog = new PictureCustomDialog(this.getContext(), R.layout.picture_prompt_dialog);
            TextView btnOk = (TextView)dialog.findViewById(R.id.btnOk);
            TextView tvContent = (TextView)dialog.findViewById(R.id.tv_content);
            tvContent.setText((CharSequence)content);
            btnOk.setOnClickListener(v -> {
                if (!this.isFinishing()) {
                    dialog.dismiss();
                }
            });
            dialog.show();
        }
    }

    protected void sortFolder(List<LocalMediaFolder> imageFolders) {
        Collections.sort(imageFolders, (lhs, rhs) -> {
            if (lhs.getData() == null || rhs.getData() == null) {
                return 0;
            }
            int lSize = lhs.getImageNum();
            int rSize = rhs.getImageNum();
            return Integer.compare(rSize, lSize);
        });
    }
}

