/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.core.content.ContextCompat;
import com.luck.picture.lib.PictureSelectorActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.AttrsUtils;
import java.util.List;

public class PictureSelectorWeChatStyleActivity
extends PictureSelectorActivity {
    private RelativeLayout rlAlbum;

    @Override
    public int getResourceId() {
        return R.layout.picture_wechat_style_selector;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.rlAlbum = (RelativeLayout)this.findViewById(R.id.rlAlbum);
        this.mTvPictureRight.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureRight.setText((CharSequence)this.getString(R.string.picture_send));
        this.mTvPicturePreview.setTextSize(16.0f);
        this.mCbOriginal.setTextSize(16.0f);
        boolean isChooseMode = this.config.selectionMode == 1 && this.config.isSingleDirectReturn;
        this.mTvPictureRight.setVisibility(isChooseMode ? 8 : 0);
        this.mTvPictureRight.setOnClickListener((View.OnClickListener)this);
        if (this.rlAlbum.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.rlAlbum.getLayoutParams();
            if (isChooseMode) {
                lp.addRule(14);
            } else {
                lp.addRule(1, R.id.pictureLeftBack);
            }
        }
    }

    @Override
    public void initPictureSelectorStyle() {
        if (PictureSelectionConfig.uiStyle != null) {
            if (PictureSelectionConfig.uiStyle.picture_top_titleRightTextDefaultBackground != 0) {
                this.mTvPictureRight.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_top_titleRightTextDefaultBackground);
            } else {
                this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_default_bg);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_barBackgroundColor != 0) {
                this.mBottomLayout.setBackgroundColor(PictureSelectionConfig.uiStyle.picture_bottom_barBackgroundColor);
            } else {
                this.mBottomLayout.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_grey));
            }
            if (PictureSelectionConfig.uiStyle.picture_top_titleRightTextColor.length > 0) {
                ColorStateList colorStateList = AttrsUtils.getColorStateList(PictureSelectionConfig.uiStyle.picture_top_titleRightTextColor);
                if (colorStateList != null) {
                    this.mTvPictureRight.setTextColor(colorStateList);
                }
            } else {
                this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_53575e));
            }
            if (PictureSelectionConfig.uiStyle.picture_top_titleRightTextSize != 0) {
                this.mTvPictureRight.setTextSize((float)PictureSelectionConfig.uiStyle.picture_top_titleRightTextSize);
            }
            if (this.config.isOriginalControl) {
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureCheckStyle != 0) {
                    this.mCbOriginal.setButtonDrawable(PictureSelectionConfig.uiStyle.picture_bottom_originalPictureCheckStyle);
                }
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextColor != 0) {
                    this.mCbOriginal.setTextColor(PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextColor);
                }
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextSize != 0) {
                    this.mCbOriginal.setTextSize((float)PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextSize);
                }
            }
            if (PictureSelectionConfig.uiStyle.picture_container_backgroundColor != 0) {
                this.container.setBackgroundColor(PictureSelectionConfig.uiStyle.picture_container_backgroundColor);
            }
            if (PictureSelectionConfig.uiStyle.picture_top_titleAlbumBackground != 0) {
                this.rlAlbum.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_top_titleAlbumBackground);
            } else {
                this.rlAlbum.setBackgroundResource(R.drawable.picture_album_bg);
            }
            if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.uiStyle.picture_top_titleRightDefaultText)) {
                this.mTvPictureRight.setText((CharSequence)PictureSelectionConfig.uiStyle.picture_top_titleRightDefaultText);
            }
        } else if (PictureSelectionConfig.style != null) {
            if (PictureSelectionConfig.style.pictureUnCompleteBackgroundStyle != 0) {
                this.mTvPictureRight.setBackgroundResource(PictureSelectionConfig.style.pictureUnCompleteBackgroundStyle);
            } else {
                this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_default_bg);
            }
            if (PictureSelectionConfig.style.pictureBottomBgColor != 0) {
                this.mBottomLayout.setBackgroundColor(PictureSelectionConfig.style.pictureBottomBgColor);
            } else {
                this.mBottomLayout.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_grey));
            }
            if (PictureSelectionConfig.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureRight.setTextColor(PictureSelectionConfig.style.pictureUnCompleteTextColor);
            } else if (PictureSelectionConfig.style.pictureCancelTextColor != 0) {
                this.mTvPictureRight.setTextColor(PictureSelectionConfig.style.pictureCancelTextColor);
            } else {
                this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_53575e));
            }
            if (PictureSelectionConfig.style.pictureRightTextSize != 0) {
                this.mTvPictureRight.setTextSize((float)PictureSelectionConfig.style.pictureRightTextSize);
            }
            if (PictureSelectionConfig.style.pictureOriginalFontColor == 0) {
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_white));
            }
            if (this.config.isOriginalControl && PictureSelectionConfig.style.pictureOriginalControlStyle == 0) {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_wechat_checkbox));
            }
            if (PictureSelectionConfig.style.pictureContainerBackgroundColor != 0) {
                this.container.setBackgroundColor(PictureSelectionConfig.style.pictureContainerBackgroundColor);
            }
            if (PictureSelectionConfig.style.pictureWeChatTitleBackgroundStyle != 0) {
                this.rlAlbum.setBackgroundResource(PictureSelectionConfig.style.pictureWeChatTitleBackgroundStyle);
            } else {
                this.rlAlbum.setBackgroundResource(R.drawable.picture_album_bg);
            }
            if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText)) {
                this.mTvPictureRight.setText((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText);
            }
        } else {
            this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_default_bg);
            this.rlAlbum.setBackgroundResource(R.drawable.picture_album_bg);
            this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_53575e));
            int pictureBottomBgColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_bottom_bg);
            this.mBottomLayout.setBackgroundColor(pictureBottomBgColor != 0 ? pictureBottomBgColor : ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_grey));
            this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_white));
            Drawable drawable2 = ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_icon_wechat_down);
            this.mIvArrow.setImageDrawable(drawable2);
            if (this.config.isOriginalControl) {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_wechat_checkbox));
            }
        }
        super.initPictureSelectorStyle();
        this.goneParentView();
    }

    private void goneParentView() {
        this.mTvPictureImgNum.setVisibility(8);
        this.mTvPictureOk.setVisibility(8);
    }

    @Override
    protected void changeImageNumber(List<LocalMedia> selectData) {
        boolean enable;
        int size = selectData.size();
        boolean bl = enable = size != 0;
        if (enable) {
            this.mTvPictureRight.setEnabled(true);
            this.mTvPictureRight.setSelected(true);
            this.mTvPicturePreview.setEnabled(true);
            this.mTvPicturePreview.setSelected(true);
            this.initCompleteText(selectData);
            if (PictureSelectionConfig.uiStyle != null) {
                if (PictureSelectionConfig.uiStyle.picture_top_titleRightTextNormalBackground != 0) {
                    this.mTvPictureRight.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_top_titleRightTextNormalBackground);
                } else {
                    this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_bg);
                }
                if (PictureSelectionConfig.uiStyle.picture_bottom_previewTextColor.length > 0) {
                    ColorStateList colorStateList = AttrsUtils.getColorStateList(PictureSelectionConfig.uiStyle.picture_bottom_previewTextColor);
                    if (colorStateList != null) {
                        this.mTvPicturePreview.setTextColor(colorStateList);
                    }
                } else {
                    this.mTvPicturePreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                }
                if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.uiStyle.picture_bottom_previewNormalText)) {
                    if (PictureSelectionConfig.uiStyle.isCompleteReplaceNum) {
                        this.mTvPicturePreview.setText((CharSequence)String.format(PictureSelectionConfig.uiStyle.picture_bottom_previewNormalText, size));
                    } else {
                        this.mTvPicturePreview.setText((CharSequence)PictureSelectionConfig.uiStyle.picture_bottom_previewNormalText);
                    }
                } else {
                    this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview_num, new Object[]{size}));
                }
            } else if (PictureSelectionConfig.style != null) {
                if (PictureSelectionConfig.style.pictureCompleteBackgroundStyle != 0) {
                    this.mTvPictureRight.setBackgroundResource(PictureSelectionConfig.style.pictureCompleteBackgroundStyle);
                } else {
                    this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_bg);
                }
                if (PictureSelectionConfig.style.pictureCompleteTextColor != 0) {
                    this.mTvPictureRight.setTextColor(PictureSelectionConfig.style.pictureCompleteTextColor);
                } else {
                    this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                }
                if (PictureSelectionConfig.style.picturePreviewTextColor != 0) {
                    this.mTvPicturePreview.setTextColor(PictureSelectionConfig.style.picturePreviewTextColor);
                } else {
                    this.mTvPicturePreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                }
                if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.picturePreviewText)) {
                    this.mTvPicturePreview.setText((CharSequence)PictureSelectionConfig.style.picturePreviewText);
                } else {
                    this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview_num, new Object[]{size}));
                }
            } else {
                this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_bg);
                this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                this.mTvPicturePreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview_num, new Object[]{size}));
            }
        } else {
            this.mTvPictureRight.setEnabled(false);
            this.mTvPictureRight.setSelected(false);
            this.mTvPicturePreview.setEnabled(false);
            this.mTvPicturePreview.setSelected(false);
            if (PictureSelectionConfig.uiStyle != null) {
                if (PictureSelectionConfig.uiStyle.picture_top_titleRightTextDefaultBackground != 0) {
                    this.mTvPictureRight.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_top_titleRightTextDefaultBackground);
                } else {
                    this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_default_bg);
                }
                if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.uiStyle.picture_top_titleRightDefaultText)) {
                    this.mTvPictureRight.setText((CharSequence)PictureSelectionConfig.uiStyle.picture_top_titleRightDefaultText);
                } else {
                    this.mTvPictureRight.setText((CharSequence)this.getString(R.string.picture_send));
                }
                if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.uiStyle.picture_bottom_previewDefaultText)) {
                    this.mTvPicturePreview.setText((CharSequence)PictureSelectionConfig.uiStyle.picture_bottom_previewDefaultText);
                } else {
                    this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview));
                }
            } else if (PictureSelectionConfig.style != null) {
                if (PictureSelectionConfig.style.pictureUnCompleteBackgroundStyle != 0) {
                    this.mTvPictureRight.setBackgroundResource(PictureSelectionConfig.style.pictureUnCompleteBackgroundStyle);
                } else {
                    this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_default_bg);
                }
                if (PictureSelectionConfig.style.pictureUnCompleteTextColor != 0) {
                    this.mTvPictureRight.setTextColor(PictureSelectionConfig.style.pictureUnCompleteTextColor);
                } else {
                    this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_53575e));
                }
                if (PictureSelectionConfig.style.pictureUnPreviewTextColor != 0) {
                    this.mTvPicturePreview.setTextColor(PictureSelectionConfig.style.pictureUnPreviewTextColor);
                } else {
                    this.mTvPicturePreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_9b));
                }
                if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText)) {
                    this.mTvPictureRight.setText((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText);
                } else {
                    this.mTvPictureRight.setText((CharSequence)this.getString(R.string.picture_send));
                }
                if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnPreviewText)) {
                    this.mTvPicturePreview.setText((CharSequence)PictureSelectionConfig.style.pictureUnPreviewText);
                } else {
                    this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview));
                }
            } else {
                this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_default_bg);
                this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_53575e));
                this.mTvPicturePreview.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_9b));
                this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview));
                this.mTvPictureRight.setText((CharSequence)this.getString(R.string.picture_send));
            }
        }
    }

    @Override
    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.picture_right) {
            if (this.folderWindow != null && this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else {
                this.mTvPictureOk.performClick();
            }
        } else {
            super.onClick(v);
        }
    }

    @Override
    protected void onChangeData(List<LocalMedia> list) {
        super.onChangeData(list);
        this.initCompleteText(list);
    }

    @Override
    protected void initCompleteText(List<LocalMedia> list) {
        boolean isNotEmptyStyle;
        int size = list.size();
        boolean bl = isNotEmptyStyle = PictureSelectionConfig.style != null;
        if (this.config.isWithVideoImage) {
            if (this.config.selectionMode == 1) {
                if (size <= 0) {
                    this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText) ? PictureSelectionConfig.style.pictureUnCompleteText : this.getString(R.string.picture_send)));
                } else {
                    boolean isCompleteReplaceNum;
                    boolean bl2 = isCompleteReplaceNum = isNotEmptyStyle && PictureSelectionConfig.style.isCompleteReplaceNum;
                    if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                        this.mTvPictureRight.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, size, 1));
                    } else {
                        this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText) ? PictureSelectionConfig.style.pictureCompleteText : this.getString(R.string.picture_send)));
                    }
                }
            } else {
                boolean isCompleteReplaceNum;
                boolean bl3 = isCompleteReplaceNum = isNotEmptyStyle && PictureSelectionConfig.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                    this.mTvPictureRight.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, size, this.config.maxSelectNum));
                } else {
                    this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText) ? PictureSelectionConfig.style.pictureUnCompleteText : this.getString(R.string.picture_send_num, new Object[]{size, this.config.maxSelectNum})));
                }
            }
        } else {
            int maxSize;
            String mimeType = list.get(0).getMimeType();
            int n = maxSize = PictureMimeType.isHasVideo(mimeType) && this.config.maxVideoSelectNum > 0 ? this.config.maxVideoSelectNum : this.config.maxSelectNum;
            if (this.config.selectionMode == 1) {
                boolean isCompleteReplaceNum;
                boolean bl4 = isCompleteReplaceNum = isNotEmptyStyle && PictureSelectionConfig.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                    this.mTvPictureRight.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, size, 1));
                } else {
                    this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText) ? PictureSelectionConfig.style.pictureCompleteText : this.getString(R.string.picture_send)));
                }
            } else {
                boolean isCompleteReplaceNum;
                boolean bl5 = isCompleteReplaceNum = isNotEmptyStyle && PictureSelectionConfig.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                    this.mTvPictureRight.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, size, maxSize));
                } else {
                    this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText) ? PictureSelectionConfig.style.pictureUnCompleteText : this.getString(R.string.picture_send_num, new Object[]{size, maxSize})));
                }
            }
        }
    }
}

