/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureCustomCameraActivity;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.animators.AlphaInAnimationAdapter;
import com.luck.picture.lib.animators.SlideInBottomAnimationAdapter;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.dialog.PhotoItemSelectedDialog;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.listener.OnAlbumItemClickListener;
import com.luck.picture.lib.listener.OnItemClickListener;
import com.luck.picture.lib.listener.OnPhotoSelectChangedListener;
import com.luck.picture.lib.listener.OnRecyclerViewPreloadMoreListener;
import com.luck.picture.lib.model.LocalMediaLoader;
import com.luck.picture.lib.model.LocalMediaPageLoader;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.BitmapUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.DoubleUtils;
import com.luck.picture.lib.tools.JumpUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.luck.picture.lib.widget.FolderPopWindow;
import com.luck.picture.lib.widget.RecyclerPreloadView;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.model.CutInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectorActivity
extends PictureBaseActivity
implements View.OnClickListener,
OnAlbumItemClickListener,
OnPhotoSelectChangedListener<LocalMedia>,
OnItemClickListener,
OnRecyclerViewPreloadMoreListener {
    private static final String TAG = PictureSelectorActivity.class.getSimpleName();
    protected ImageView mIvPictureLeftBack;
    protected ImageView mIvArrow;
    protected View titleViewBg;
    protected TextView mTvPictureTitle;
    protected TextView mTvPictureRight;
    protected TextView mTvPictureOk;
    protected TextView mTvEmpty;
    protected TextView mTvPictureImgNum;
    protected TextView mTvPicturePreview;
    protected TextView mTvPlayPause;
    protected TextView mTvStop;
    protected TextView mTvQuit;
    protected TextView mTvMusicStatus;
    protected TextView mTvMusicTotal;
    protected TextView mTvMusicTime;
    protected RecyclerPreloadView mRecyclerView;
    protected RelativeLayout mBottomLayout;
    protected PictureImageGridAdapter mAdapter;
    protected FolderPopWindow folderWindow;
    protected Animation animation = null;
    protected boolean isStartAnimation = false;
    protected MediaPlayer mediaPlayer;
    protected SeekBar musicSeekBar;
    protected boolean isPlayAudio = false;
    protected PictureCustomDialog audioDialog;
    protected CheckBox mCbOriginal;
    protected int oldCurrentListSize;
    protected boolean isEnterSetting;
    private long intervalClickTime = 0L;
    private int allFolderSize;
    private int mOpenCameraCount;
    public Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (PictureSelectorActivity.this.mediaPlayer != null) {
                    PictureSelectorActivity.this.mTvMusicTime.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition()));
                    PictureSelectorActivity.this.musicSeekBar.setProgress(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition());
                    PictureSelectorActivity.this.musicSeekBar.setMax(PictureSelectorActivity.this.mediaPlayer.getDuration());
                    PictureSelectorActivity.this.mTvMusicTotal.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getDuration()));
                    if (PictureSelectorActivity.this.mHandler != null) {
                        PictureSelectorActivity.this.mHandler.postDelayed(PictureSelectorActivity.this.mRunnable, 200L);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.allFolderSize = savedInstanceState.getInt("all_folder_size");
            this.oldCurrentListSize = savedInstanceState.getInt("oldCurrentListSize", 0);
            this.selectionMedias = PictureSelector.obtainSelectorList(savedInstanceState);
            if (this.mAdapter != null) {
                this.isStartAnimation = true;
                this.mAdapter.bindSelectData(this.selectionMedias);
            }
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isEnterSetting) {
            if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                if (this.mAdapter.isDataEmpty()) {
                    this.readLocalMedia();
                }
            } else {
                this.showPermissionsDialog(false, this.getString(R.string.picture_jurisdiction));
            }
            this.isEnterSetting = false;
        }
        if (this.config.isOriginalControl && this.mCbOriginal != null) {
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
        }
    }

    @Override
    public int getResourceId() {
        return R.layout.picture_selector;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.container = this.findViewById(R.id.container);
        this.titleViewBg = this.findViewById(R.id.titleViewBg);
        this.mIvPictureLeftBack = (ImageView)this.findViewById(R.id.pictureLeftBack);
        this.mTvPictureTitle = (TextView)this.findViewById(R.id.picture_title);
        this.mTvPictureRight = (TextView)this.findViewById(R.id.picture_right);
        this.mTvPictureOk = (TextView)this.findViewById(R.id.picture_tv_ok);
        this.mCbOriginal = (CheckBox)this.findViewById(R.id.cb_original);
        this.mIvArrow = (ImageView)this.findViewById(R.id.ivArrow);
        this.mTvPicturePreview = (TextView)this.findViewById(R.id.picture_id_preview);
        this.mTvPictureImgNum = (TextView)this.findViewById(R.id.picture_tvMediaNum);
        this.mRecyclerView = (RecyclerPreloadView)this.findViewById(R.id.picture_recycler);
        this.mBottomLayout = (RelativeLayout)this.findViewById(R.id.rl_bottom);
        this.mTvEmpty = (TextView)this.findViewById(R.id.tv_empty);
        this.isNumComplete(this.numComplete);
        if (!this.numComplete) {
            this.animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.picture_anim_modal_in);
        }
        this.mTvPicturePreview.setOnClickListener((View.OnClickListener)this);
        if (this.config.isAutomaticTitleRecyclerTop) {
            this.titleViewBg.setOnClickListener((View.OnClickListener)this);
        }
        this.mTvPicturePreview.setVisibility(this.config.chooseMode != PictureMimeType.ofAudio() && this.config.enablePreview ? 0 : 8);
        this.mBottomLayout.setVisibility(this.config.selectionMode == 1 && this.config.isSingleDirectReturn ? 8 : 0);
        this.mIvPictureLeftBack.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureRight.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureOk.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureImgNum.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureTitle.setOnClickListener((View.OnClickListener)this);
        this.mIvArrow.setOnClickListener((View.OnClickListener)this);
        String title = this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
        this.mTvPictureTitle.setText((CharSequence)title);
        this.mTvPictureTitle.setTag(R.id.view_tag, (Object)-1);
        this.folderWindow = new FolderPopWindow((Context)this, this.config);
        this.folderWindow.setArrowImageView(this.mIvArrow);
        this.folderWindow.setOnAlbumItemClickListener(this);
        this.mRecyclerView.addItemDecoration(new GridSpacingItemDecoration(this.config.imageSpanCount, ScreenUtils.dip2px((Context)this, 2.0f), false));
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), this.config.imageSpanCount));
        if (!this.config.isPageStrategy) {
            this.mRecyclerView.setHasFixedSize(true);
        } else {
            this.mRecyclerView.setReachBottomRow(2);
            this.mRecyclerView.setOnRecyclerViewPreloadListener(this);
        }
        RecyclerView.ItemAnimator itemAnimator = this.mRecyclerView.getItemAnimator();
        if (itemAnimator != null) {
            ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
            this.mRecyclerView.setItemAnimator(null);
        }
        this.loadAllMediaData();
        this.mTvEmpty.setText((CharSequence)(this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_audio_empty) : this.getString(R.string.picture_empty)));
        StringUtils.tempTextFont(this.mTvEmpty, this.config.chooseMode);
        this.mAdapter = new PictureImageGridAdapter(this.getContext(), this.config);
        this.mAdapter.setOnPhotoSelectChangedListener(this);
        switch (this.config.animationMode) {
            case 1: {
                this.mRecyclerView.setAdapter(new AlphaInAnimationAdapter(this.mAdapter));
                break;
            }
            case 2: {
                this.mRecyclerView.setAdapter(new SlideInBottomAnimationAdapter(this.mAdapter));
                break;
            }
            default: {
                this.mRecyclerView.setAdapter(this.mAdapter);
            }
        }
        if (this.config.isOriginalControl) {
            this.mCbOriginal.setVisibility(0);
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
            this.mCbOriginal.setOnCheckedChangeListener((buttonView, isChecked) -> {
                this.config.isCheckOriginalImage = isChecked;
            });
        }
    }

    @Override
    public void onRecyclerViewPreloadMore() {
        this.loadMoreData();
    }

    private int getPageLimit() {
        int bucketId = ValueOf.toInt(this.mTvPictureTitle.getTag(R.id.view_tag));
        if (bucketId == -1) {
            int limit = this.mOpenCameraCount > 0 ? this.config.pageSize - this.mOpenCameraCount : this.config.pageSize;
            this.mOpenCameraCount = 0;
            return limit;
        }
        return this.config.pageSize;
    }

    private void loadMoreData() {
        if (this.mAdapter != null && this.isHasMore) {
            ++this.mPage;
            long bucketId = ValueOf.toLong(this.mTvPictureTitle.getTag(R.id.view_tag));
            LocalMediaPageLoader.getInstance(this.getContext(), this.config).loadPageMediaData(bucketId, this.mPage, this.getPageLimit(), (result, currentPage, isHasMore) -> {
                if (!this.isFinishing()) {
                    this.isHasMore = isHasMore;
                    if (isHasMore) {
                        this.hideDataNull();
                        int size = result.size();
                        if (size > 0) {
                            int positionStart = this.mAdapter.getSize();
                            this.mAdapter.getData().addAll(result);
                            int itemCount = this.mAdapter.getItemCount();
                            this.mAdapter.notifyItemRangeChanged(positionStart, itemCount);
                        } else {
                            this.onRecyclerViewPreloadMore();
                        }
                        if (size < 10) {
                            this.mRecyclerView.onScrolled(this.mRecyclerView.getScrollX(), this.mRecyclerView.getScrollY());
                        }
                    } else {
                        boolean isEmpty = this.mAdapter.isDataEmpty();
                        if (isEmpty) {
                            this.showDataNull(bucketId == -1L ? this.getString(R.string.picture_empty) : this.getString(R.string.picture_data_null), R.drawable.picture_icon_no_data);
                        }
                    }
                }
            });
        }
    }

    private void loadAllMediaData() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            this.readLocalMedia();
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
    }

    @Override
    public void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (this.config.style.pictureTitleDownResId != 0) {
                Drawable drawable2 = ContextCompat.getDrawable((Context)this, (int)this.config.style.pictureTitleDownResId);
                this.mIvArrow.setImageDrawable(drawable2);
            }
            if (this.config.style.pictureTitleTextColor != 0) {
                this.mTvPictureTitle.setTextColor(this.config.style.pictureTitleTextColor);
            }
            if (this.config.style.pictureTitleTextSize != 0) {
                this.mTvPictureTitle.setTextSize((float)this.config.style.pictureTitleTextSize);
            }
            if (this.config.style.pictureRightDefaultTextColor != 0) {
                this.mTvPictureRight.setTextColor(this.config.style.pictureRightDefaultTextColor);
            } else if (this.config.style.pictureCancelTextColor != 0) {
                this.mTvPictureRight.setTextColor(this.config.style.pictureCancelTextColor);
            }
            if (this.config.style.pictureRightTextSize != 0) {
                this.mTvPictureRight.setTextSize((float)this.config.style.pictureRightTextSize);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.mIvPictureLeftBack.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.pictureUnPreviewTextColor != 0) {
                this.mTvPicturePreview.setTextColor(this.config.style.pictureUnPreviewTextColor);
            }
            if (this.config.style.picturePreviewTextSize != 0) {
                this.mTvPicturePreview.setTextSize((float)this.config.style.picturePreviewTextSize);
            }
            if (this.config.style.pictureCheckNumBgStyle != 0) {
                this.mTvPictureImgNum.setBackgroundResource(this.config.style.pictureCheckNumBgStyle);
            }
            if (this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
            if (this.config.style.pictureCompleteTextSize != 0) {
                this.mTvPictureOk.setTextSize((float)this.config.style.pictureCompleteTextSize);
            }
            if (this.config.style.pictureBottomBgColor != 0) {
                this.mBottomLayout.setBackgroundColor(this.config.style.pictureBottomBgColor);
            }
            if (this.config.style.pictureContainerBackgroundColor != 0) {
                this.container.setBackgroundColor(this.config.style.pictureContainerBackgroundColor);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureRightDefaultText)) {
                this.mTvPictureRight.setText((CharSequence)this.config.style.pictureRightDefaultText);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText)) {
                this.mTvPictureOk.setText((CharSequence)this.config.style.pictureUnCompleteText);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureUnPreviewText)) {
                this.mTvPicturePreview.setText((CharSequence)this.config.style.pictureUnPreviewText);
            }
        } else {
            int pictureBottomBgColor;
            if (this.config.downResId != 0) {
                Drawable drawable3 = ContextCompat.getDrawable((Context)this, (int)this.config.downResId);
                this.mIvArrow.setImageDrawable(drawable3);
            }
            if ((pictureBottomBgColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_bottom_bg)) != 0) {
                this.mBottomLayout.setBackgroundColor(pictureBottomBgColor);
            }
        }
        this.titleViewBg.setBackgroundColor(this.colorPrimary);
        if (this.config.isOriginalControl) {
            if (this.config.style != null) {
                if (this.config.style.pictureOriginalControlStyle != 0) {
                    this.mCbOriginal.setButtonDrawable(this.config.style.pictureOriginalControlStyle);
                } else {
                    this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                }
                if (this.config.style.pictureOriginalFontColor != 0) {
                    this.mCbOriginal.setTextColor(this.config.style.pictureOriginalFontColor);
                } else {
                    this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
                }
                if (this.config.style.pictureOriginalTextSize != 0) {
                    this.mCbOriginal.setTextSize((float)this.config.style.pictureOriginalTextSize);
                }
            } else {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
            }
        }
        this.mAdapter.bindSelectData(this.selectionMedias);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mAdapter != null) {
            outState.putInt("oldCurrentListSize", this.mAdapter.getSize());
            int size = this.folderWindow.getFolderData().size();
            if (size > 0) {
                outState.putInt("all_folder_size", this.folderWindow.getFolder(0).getImageNum());
            }
            if (this.mAdapter.getSelectedData() != null) {
                List<LocalMedia> selectedImages = this.mAdapter.getSelectedData();
                PictureSelector.saveSelectorList(outState, selectedImages);
            }
        }
    }

    private void isNumComplete(boolean numComplete) {
        if (numComplete) {
            this.initCompleteText(0);
        }
    }

    @Override
    protected void initCompleteText(int startCount) {
        boolean isNotEmptyStyle;
        boolean bl = isNotEmptyStyle = this.config.style != null;
        if (this.config.selectionMode == 1) {
            if (startCount <= 0) {
                this.mTvPictureOk.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_please_select)));
            } else {
                boolean isCompleteReplaceNum;
                boolean bl2 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)String.format(this.config.style.pictureCompleteText, startCount, 1));
                } else {
                    this.mTvPictureOk.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText) ? this.config.style.pictureCompleteText : this.getString(R.string.picture_done)));
                }
            }
        } else {
            boolean isCompleteReplaceNum;
            boolean bl3 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
            if (startCount <= 0) {
                this.mTvPictureOk.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxSelectNum})));
            } else if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                this.mTvPictureOk.setText((CharSequence)String.format(this.config.style.pictureCompleteText, startCount, this.config.maxSelectNum));
            } else {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxSelectNum}));
            }
        }
    }

    protected void readLocalMedia() {
        this.showPleaseDialog();
        if (this.config.isPageStrategy) {
            LocalMediaPageLoader.getInstance(this.getContext(), this.config).loadAllMedia((data, currentPage, isHasMore) -> {
                if (!this.isFinishing()) {
                    this.isHasMore = true;
                    this.initPageModel(data);
                    this.synchronousCover();
                }
            });
        } else {
            PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<List<LocalMediaFolder>>(){

                @Override
                public List<LocalMediaFolder> doInBackground() {
                    return new LocalMediaLoader(PictureSelectorActivity.this.getContext(), PictureSelectorActivity.this.config).loadAllMedia();
                }

                @Override
                public void onSuccess(List<LocalMediaFolder> folders) {
                    PictureSelectorActivity.this.initStandardModel(folders);
                }
            });
        }
    }

    private void initPageModel(List<LocalMediaFolder> folders) {
        if (folders != null) {
            this.folderWindow.bindFolder(folders);
            this.mPage = 1;
            LocalMediaFolder folder = this.folderWindow.getFolder(0);
            this.mTvPictureTitle.setTag(R.id.view_count_tag, (Object)(folder != null ? folder.getImageNum() : 0));
            this.mTvPictureTitle.setTag(R.id.view_index_tag, (Object)0);
            long bucketId = folder != null ? folder.getBucketId() : -1L;
            this.mRecyclerView.setEnabledLoadMore(true);
            LocalMediaPageLoader.getInstance(this.getContext(), this.config).loadPageMediaData(bucketId, this.mPage, (data, currentPage, isHasMore) -> {
                if (!this.isFinishing()) {
                    this.dismissDialog();
                    if (this.mAdapter != null) {
                        boolean isEmpty;
                        this.isHasMore = true;
                        if (isHasMore && data.size() == 0) {
                            this.onRecyclerViewPreloadMore();
                            return;
                        }
                        int currentSize = this.mAdapter.getSize();
                        int resultSize = data.size();
                        this.oldCurrentListSize += currentSize;
                        if (resultSize >= currentSize) {
                            if (currentSize > 0 && currentSize < resultSize && this.oldCurrentListSize != resultSize) {
                                if (this.isLocalMediaSame((LocalMedia)data.get(0))) {
                                    this.mAdapter.bindData(data);
                                } else {
                                    this.mAdapter.getData().addAll(data);
                                }
                            } else {
                                this.mAdapter.bindData(data);
                            }
                        }
                        if (isEmpty = this.mAdapter.isDataEmpty()) {
                            this.showDataNull(this.getString(R.string.picture_empty), R.drawable.picture_icon_no_data);
                        } else {
                            this.hideDataNull();
                        }
                    }
                }
            });
        } else {
            this.showDataNull(this.getString(R.string.picture_data_exception), R.drawable.picture_icon_data_error);
            this.dismissDialog();
        }
    }

    private void synchronousCover() {
        if (this.config.chooseMode == PictureMimeType.ofAll()) {
            PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<Boolean>(){

                @Override
                public Boolean doInBackground() {
                    int size = PictureSelectorActivity.this.folderWindow.getFolderData().size();
                    for (int i = 0; i < size; ++i) {
                        LocalMediaFolder mediaFolder = PictureSelectorActivity.this.folderWindow.getFolder(i);
                        if (mediaFolder == null) continue;
                        String firstCover = LocalMediaPageLoader.getInstance(PictureSelectorActivity.this.getContext(), PictureSelectorActivity.this.config).getFirstCover(mediaFolder.getBucketId());
                        mediaFolder.setFirstImagePath(firstCover);
                    }
                    return true;
                }

                @Override
                public void onSuccess(Boolean result) {
                }
            });
        }
    }

    private void initStandardModel(List<LocalMediaFolder> folders) {
        if (folders != null) {
            if (folders.size() > 0) {
                this.folderWindow.bindFolder(folders);
                LocalMediaFolder folder = folders.get(0);
                folder.setChecked(true);
                this.mTvPictureTitle.setTag(R.id.view_count_tag, (Object)folder.getImageNum());
                List<LocalMedia> result = folder.getData();
                if (this.mAdapter != null) {
                    boolean isEmpty;
                    int currentSize = this.mAdapter.getSize();
                    int resultSize = result.size();
                    this.oldCurrentListSize += currentSize;
                    if (resultSize >= currentSize) {
                        if (currentSize > 0 && currentSize < resultSize && this.oldCurrentListSize != resultSize) {
                            this.mAdapter.getData().addAll(result);
                            LocalMedia media = this.mAdapter.getData().get(0);
                            folder.setFirstImagePath(media.getPath());
                            folder.getData().add(0, media);
                            folder.setCheckedNum(1);
                            folder.setImageNum(folder.getImageNum() + 1);
                            this.updateMediaFolder(this.folderWindow.getFolderData(), media);
                        } else {
                            this.mAdapter.bindData(result);
                        }
                    }
                    if (isEmpty = this.mAdapter.isDataEmpty()) {
                        this.showDataNull(this.getString(R.string.picture_empty), R.drawable.picture_icon_no_data);
                    } else {
                        this.hideDataNull();
                    }
                }
            } else {
                this.showDataNull(this.getString(R.string.picture_empty), R.drawable.picture_icon_no_data);
            }
        } else {
            this.showDataNull(this.getString(R.string.picture_data_exception), R.drawable.picture_icon_data_error);
        }
        this.dismissDialog();
    }

    private boolean isLocalMediaSame(LocalMedia newMedia) {
        String oldId;
        String newId;
        LocalMedia oldMedia = this.mAdapter.getItem(0);
        if (oldMedia == null || newMedia == null) {
            return false;
        }
        if (oldMedia.getPath().equals(newMedia.getPath())) {
            return true;
        }
        return PictureMimeType.isContent(newMedia.getPath()) && PictureMimeType.isContent(oldMedia.getPath()) && !TextUtils.isEmpty((CharSequence)newMedia.getPath()) && !TextUtils.isEmpty((CharSequence)oldMedia.getPath()) && (newId = newMedia.getPath().substring(newMedia.getPath().lastIndexOf("/") + 1)).equals(oldId = oldMedia.getPath().substring(oldMedia.getPath().lastIndexOf("/") + 1));
    }

    public void startCamera() {
        if (!DoubleUtils.isFastDoubleClick()) {
            if (PictureSelectionConfig.onCustomCameraInterfaceListener != null) {
                if (this.config.chooseMode == 0) {
                    PhotoItemSelectedDialog selectedDialog = PhotoItemSelectedDialog.newInstance();
                    selectedDialog.setOnItemClickListener(this);
                    selectedDialog.show(this.getSupportFragmentManager(), "PhotoItemSelectedDialog");
                } else {
                    PictureSelectionConfig.onCustomCameraInterfaceListener.onCameraClick(this.getContext(), this.config, this.config.chooseMode);
                    this.config.cameraMimeType = this.config.chooseMode;
                }
                return;
            }
            if (this.config.isUseCustomCamera) {
                this.startCustomCamera();
                return;
            }
            switch (this.config.chooseMode) {
                case 0: {
                    PhotoItemSelectedDialog selectedDialog = PhotoItemSelectedDialog.newInstance();
                    selectedDialog.setOnItemClickListener(this);
                    selectedDialog.show(this.getSupportFragmentManager(), "PhotoItemSelectedDialog");
                    break;
                }
                case 1: {
                    this.startOpenCamera();
                    break;
                }
                case 2: {
                    this.startOpenCameraVideo();
                    break;
                }
                case 3: {
                    this.startOpenCameraAudio();
                    break;
                }
            }
        }
    }

    private void startCustomCamera() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO")) {
            Intent intent = new Intent((Context)this, PictureCustomCameraActivity.class);
            this.startActivityForResult(intent, 909);
            PictureWindowAnimationStyle windowAnimationStyle = this.config.windowAnimationStyle;
            this.overridePendingTransition(windowAnimationStyle != null && windowAnimationStyle.activityEnterAnimation != 0 ? windowAnimationStyle.activityEnterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 4);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.pictureLeftBack || id2 == R.id.picture_right) {
            if (this.folderWindow != null && this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else {
                this.onBackPressed();
            }
            return;
        }
        if (id2 == R.id.picture_title || id2 == R.id.ivArrow) {
            if (this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else if (!this.folderWindow.isEmpty()) {
                this.folderWindow.showAsDropDown(this.titleViewBg);
                if (!this.config.isSingleDirectReturn) {
                    List<LocalMedia> selectedImages = this.mAdapter.getSelectedData();
                    this.folderWindow.updateFolderCheckStatus(selectedImages);
                }
            }
            return;
        }
        if (id2 == R.id.picture_id_preview) {
            this.onPreview();
            return;
        }
        if (id2 == R.id.picture_tv_ok || id2 == R.id.picture_tvMediaNum) {
            this.onComplete();
            return;
        }
        if (id2 == R.id.titleViewBg && this.config.isAutomaticTitleRecyclerTop) {
            int intervalTime = 500;
            if (SystemClock.uptimeMillis() - this.intervalClickTime < (long)intervalTime) {
                if (this.mAdapter.getItemCount() > 0) {
                    this.mRecyclerView.scrollToPosition(0);
                }
            } else {
                this.intervalClickTime = SystemClock.uptimeMillis();
            }
        }
    }

    private void onPreview() {
        List<LocalMedia> selectedData = this.mAdapter.getSelectedData();
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        int size = selectedData.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = selectedData.get(i);
            medias.add(media);
        }
        if (PictureSelectionConfig.onCustomImagePreviewCallback != null) {
            PictureSelectionConfig.onCustomImagePreviewCallback.onCustomPreviewCallback(this.getContext(), selectedData, 0);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("previewSelectList", medias);
        bundle.putParcelableArrayList("selectList", (ArrayList)selectedData);
        bundle.putBoolean("bottom_preview", true);
        bundle.putBoolean("isOriginal", this.config.isCheckOriginalImage);
        bundle.putBoolean("isShowCamera", this.mAdapter.isShowCamera());
        bundle.putString("currentDirectory", this.mTvPictureTitle.getText().toString());
        JumpUtils.startPicturePreviewActivity(this.getContext(), this.config.isWeChatStyle, bundle, this.config.selectionMode == 1 ? 69 : 609);
        this.overridePendingTransition(this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewEnterAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewEnterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
    }

    private void onComplete() {
        List<LocalMedia> result = this.mAdapter.getSelectedData();
        int size = result.size();
        LocalMedia image = result.size() > 0 ? result.get(0) : null;
        String mimeType = image != null ? image.getMimeType() : "";
        boolean isHasImage = PictureMimeType.isHasImage(mimeType);
        if (this.config.isWithVideoImage) {
            int videoSize = 0;
            int imageSize = 0;
            for (int i = 0; i < size; ++i) {
                LocalMedia media = result.get(i);
                if (PictureMimeType.isHasVideo(media.getMimeType())) {
                    ++videoSize;
                    continue;
                }
                ++imageSize;
            }
            if (this.config.selectionMode == 2) {
                if (this.config.minSelectNum > 0 && imageSize < this.config.minSelectNum) {
                    this.showPromptDialog(this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}));
                    return;
                }
                if (this.config.minVideoSelectNum > 0 && videoSize < this.config.minVideoSelectNum) {
                    this.showPromptDialog(this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum}));
                    return;
                }
            }
        } else if (this.config.selectionMode == 2) {
            if (PictureMimeType.isHasImage(mimeType) && this.config.minSelectNum > 0 && size < this.config.minSelectNum) {
                String str = this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum});
                this.showPromptDialog(str);
                return;
            }
            if (PictureMimeType.isHasVideo(mimeType) && this.config.minVideoSelectNum > 0 && size < this.config.minVideoSelectNum) {
                String str = this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum});
                this.showPromptDialog(str);
                return;
            }
        }
        if (this.config.returnEmpty && size == 0) {
            if (this.config.selectionMode == 2) {
                if (this.config.minSelectNum > 0 && size < this.config.minSelectNum) {
                    String str = this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum});
                    this.showPromptDialog(str);
                    return;
                }
                if (this.config.minVideoSelectNum > 0 && size < this.config.minVideoSelectNum) {
                    String str = this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum});
                    this.showPromptDialog(str);
                    return;
                }
            }
            if (PictureSelectionConfig.listener != null) {
                PictureSelectionConfig.listener.onResult(result);
            } else {
                Intent intent = PictureSelector.putIntentResult(result);
                this.setResult(-1, intent);
            }
            this.closeActivity();
            return;
        }
        if (this.config.isCheckOriginalImage) {
            this.onResult(result);
            return;
        }
        if (this.config.chooseMode == PictureMimeType.ofAll() && this.config.isWithVideoImage) {
            this.bothMimeTypeWith(isHasImage, result);
        } else {
            this.separateMimeTypeWith(isHasImage, result);
        }
    }

    private void bothMimeTypeWith(boolean isHasImage, List<LocalMedia> images) {
        LocalMedia image;
        LocalMedia localMedia = image = images.size() > 0 ? images.get(0) : null;
        if (image == null) {
            return;
        }
        if (this.config.enableCrop) {
            if (this.config.selectionMode == 1 && isHasImage) {
                this.config.originalPath = image.getPath();
                this.startCrop(this.config.originalPath, image.getMimeType());
            } else {
                ArrayList<CutInfo> cuts = new ArrayList<CutInfo>();
                int count = images.size();
                int imageNum = 0;
                for (int i = 0; i < count; ++i) {
                    LocalMedia media = images.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                    if (PictureMimeType.isHasImage(media.getMimeType())) {
                        ++imageNum;
                    }
                    CutInfo cutInfo = new CutInfo();
                    cutInfo.setId(media.getId());
                    cutInfo.setPath(media.getPath());
                    cutInfo.setImageWidth(media.getWidth());
                    cutInfo.setImageHeight(media.getHeight());
                    cutInfo.setMimeType(media.getMimeType());
                    cutInfo.setDuration(media.getDuration());
                    cutInfo.setRealPath(media.getRealPath());
                    cuts.add(cutInfo);
                }
                if (imageNum <= 0) {
                    this.onResult(images);
                } else {
                    this.startCrop(cuts);
                }
            }
        } else if (this.config.isCompress) {
            int size = images.size();
            int imageNum = 0;
            for (int i = 0; i < size; ++i) {
                LocalMedia media = images.get(i);
                if (!PictureMimeType.isHasImage(media.getMimeType())) continue;
                ++imageNum;
                break;
            }
            if (imageNum <= 0) {
                this.onResult(images);
            } else {
                this.compressImage(images);
            }
        } else {
            this.onResult(images);
        }
    }

    private void separateMimeTypeWith(boolean isHasImage, List<LocalMedia> images) {
        LocalMedia image;
        LocalMedia localMedia = image = images.size() > 0 ? images.get(0) : null;
        if (image == null) {
            return;
        }
        if (this.config.enableCrop && isHasImage) {
            if (this.config.selectionMode == 1) {
                this.config.originalPath = image.getPath();
                this.startCrop(this.config.originalPath, image.getMimeType());
            } else {
                ArrayList<CutInfo> cuts = new ArrayList<CutInfo>();
                int count = images.size();
                for (int i = 0; i < count; ++i) {
                    LocalMedia media = images.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                    CutInfo cutInfo = new CutInfo();
                    cutInfo.setId(media.getId());
                    cutInfo.setPath(media.getPath());
                    cutInfo.setImageWidth(media.getWidth());
                    cutInfo.setImageHeight(media.getHeight());
                    cutInfo.setMimeType(media.getMimeType());
                    cutInfo.setDuration(media.getDuration());
                    cutInfo.setRealPath(media.getRealPath());
                    cuts.add(cutInfo);
                }
                this.startCrop(cuts);
            }
        } else if (this.config.isCompress && isHasImage) {
            this.compressImage(images);
        } else {
            this.onResult(images);
        }
    }

    private void AudioDialog(String path) {
        if (!this.isFinishing()) {
            this.audioDialog = new PictureCustomDialog(this.getContext(), R.layout.picture_audio_dialog);
            if (this.audioDialog.getWindow() != null) {
                this.audioDialog.getWindow().setWindowAnimations(R.style.Picture_Theme_Dialog_AudioStyle);
            }
            this.mTvMusicStatus = (TextView)this.audioDialog.findViewById(R.id.tv_musicStatus);
            this.mTvMusicTime = (TextView)this.audioDialog.findViewById(R.id.tv_musicTime);
            this.musicSeekBar = (SeekBar)this.audioDialog.findViewById(R.id.musicSeekBar);
            this.mTvMusicTotal = (TextView)this.audioDialog.findViewById(R.id.tv_musicTotal);
            this.mTvPlayPause = (TextView)this.audioDialog.findViewById(R.id.tv_PlayPause);
            this.mTvStop = (TextView)this.audioDialog.findViewById(R.id.tv_Stop);
            this.mTvQuit = (TextView)this.audioDialog.findViewById(R.id.tv_Quit);
            if (this.mHandler != null) {
                this.mHandler.postDelayed(() -> this.initPlayer(path), 30L);
            }
            this.mTvPlayPause.setOnClickListener((View.OnClickListener)new AudioOnClick(path));
            this.mTvStop.setOnClickListener((View.OnClickListener)new AudioOnClick(path));
            this.mTvQuit.setOnClickListener((View.OnClickListener)new AudioOnClick(path));
            this.musicSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

                public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    if (fromUser) {
                        PictureSelectorActivity.this.mediaPlayer.seekTo(progress);
                    }
                }

                public void onStartTrackingTouch(SeekBar seekBar) {
                }

                public void onStopTrackingTouch(SeekBar seekBar) {
                }
            });
            this.audioDialog.setOnDismissListener(dialog -> {
                if (this.mHandler != null) {
                    this.mHandler.removeCallbacks(this.mRunnable);
                }
                new Handler().postDelayed(() -> this.stop(path), 30L);
                try {
                    if (this.audioDialog != null && this.audioDialog.isShowing()) {
                        this.audioDialog.dismiss();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            if (this.mHandler != null) {
                this.mHandler.post(this.mRunnable);
            }
            this.audioDialog.show();
        }
    }

    private void initPlayer(String path) {
        this.mediaPlayer = new MediaPlayer();
        try {
            this.mediaPlayer.setDataSource(path);
            this.mediaPlayer.prepare();
            this.mediaPlayer.setLooping(true);
            this.playAudio();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playAudio() {
        String ppStr;
        if (this.mediaPlayer != null) {
            this.musicSeekBar.setProgress(this.mediaPlayer.getCurrentPosition());
            this.musicSeekBar.setMax(this.mediaPlayer.getDuration());
        }
        if ((ppStr = this.mTvPlayPause.getText().toString()).equals(this.getString(R.string.picture_play_audio))) {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.playOrPause();
        } else {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.playOrPause();
        }
        if (!this.isPlayAudio) {
            if (this.mHandler != null) {
                this.mHandler.post(this.mRunnable);
            }
            this.isPlayAudio = true;
        }
    }

    public void stop(String path) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.stop();
                this.mediaPlayer.reset();
                this.mediaPlayer.setDataSource(path);
                this.mediaPlayer.prepare();
                this.mediaPlayer.seekTo(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playOrPause() {
        try {
            if (this.mediaPlayer != null) {
                if (this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                } else {
                    this.mediaPlayer.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onItemClick(int position, boolean isCameraFolder, long bucketId, String folderName, List<LocalMedia> data) {
        boolean camera = this.config.isCamera && isCameraFolder;
        this.mAdapter.setShowCamera(camera);
        this.mTvPictureTitle.setText((CharSequence)folderName);
        long currentBucketId = ValueOf.toLong(this.mTvPictureTitle.getTag(R.id.view_tag));
        this.mTvPictureTitle.setTag(R.id.view_count_tag, (Object)(this.folderWindow.getFolder(position) != null ? this.folderWindow.getFolder(position).getImageNum() : 0));
        if (this.config.isPageStrategy) {
            if (currentBucketId != bucketId) {
                this.setLastCacheFolderData();
                boolean isCurrentCacheFolderData = this.isCurrentCacheFolderData(position);
                if (!isCurrentCacheFolderData) {
                    this.mPage = 1;
                    this.showPleaseDialog();
                    LocalMediaPageLoader.getInstance(this.getContext(), this.config).loadPageMediaData(bucketId, this.mPage, (result, currentPage, isHasMore) -> {
                        this.isHasMore = isHasMore;
                        if (!this.isFinishing()) {
                            if (result.size() == 0) {
                                this.mAdapter.clear();
                            }
                            this.mAdapter.bindData(result);
                            this.mRecyclerView.onScrolled(0, 0);
                            this.mRecyclerView.smoothScrollToPosition(0);
                            this.dismissDialog();
                        }
                    });
                }
            }
        } else {
            this.mAdapter.bindData(data);
            this.mRecyclerView.smoothScrollToPosition(0);
        }
        this.mTvPictureTitle.setTag(R.id.view_tag, (Object)bucketId);
        this.folderWindow.dismiss();
    }

    private void setLastCacheFolderData() {
        int oldPosition = ValueOf.toInt(this.mTvPictureTitle.getTag(R.id.view_index_tag));
        LocalMediaFolder lastFolder = this.folderWindow.getFolder(oldPosition);
        lastFolder.setData(this.mAdapter.getData());
        lastFolder.setCurrentDataPage(this.mPage);
        lastFolder.setHasMore(this.isHasMore);
    }

    private boolean isCurrentCacheFolderData(int position) {
        this.mTvPictureTitle.setTag(R.id.view_index_tag, (Object)position);
        LocalMediaFolder currentFolder = this.folderWindow.getFolder(position);
        if (currentFolder != null && currentFolder.getData() != null && currentFolder.getData().size() > 0) {
            this.mAdapter.bindData(currentFolder.getData());
            this.mPage = currentFolder.getCurrentDataPage();
            this.isHasMore = currentFolder.isHasMore();
            this.mRecyclerView.smoothScrollToPosition(0);
            return true;
        }
        return false;
    }

    @Override
    public void onTakePhoto() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
            if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                this.startCamera();
            } else {
                PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 5);
            }
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
        }
    }

    @Override
    public void onChange(List<LocalMedia> selectData) {
        this.changeImageNumber(selectData);
    }

    @Override
    public void onPictureClick(LocalMedia media, int position) {
        if (this.config.selectionMode == 1 && this.config.isSingleDirectReturn) {
            ArrayList<LocalMedia> list = new ArrayList<LocalMedia>();
            list.add(media);
            if (this.config.enableCrop && PictureMimeType.isHasImage(media.getMimeType()) && !this.config.isCheckOriginalImage) {
                this.mAdapter.bindSelectData(list);
                this.startCrop(media.getPath(), media.getMimeType());
            } else {
                this.handlerResult(list);
            }
        } else {
            List<LocalMedia> data = this.mAdapter.getData();
            this.startPreview(data, position);
        }
    }

    public void startPreview(List<LocalMedia> previewData, int position) {
        LocalMedia media = previewData.get(position);
        String mimeType = media.getMimeType();
        Bundle bundle = new Bundle();
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        if (PictureMimeType.isHasVideo(mimeType)) {
            if (this.config.selectionMode == 1 && !this.config.enPreviewVideo) {
                result.add(media);
                this.onResult(result);
            } else if (PictureSelectionConfig.customVideoPlayCallback != null) {
                PictureSelectionConfig.customVideoPlayCallback.startPlayVideo(media);
            } else {
                bundle.putParcelable("mediaKey", (Parcelable)media);
                JumpUtils.startPictureVideoPlayActivity(this.getContext(), bundle, 166);
            }
        } else if (PictureMimeType.isHasAudio(mimeType)) {
            if (this.config.selectionMode == 1) {
                result.add(media);
                this.onResult(result);
            } else {
                this.AudioDialog(media.getPath());
            }
        } else {
            if (PictureSelectionConfig.onCustomImagePreviewCallback != null) {
                PictureSelectionConfig.onCustomImagePreviewCallback.onCustomPreviewCallback(this.getContext(), previewData, position);
                return;
            }
            List<LocalMedia> selectedData = this.mAdapter.getSelectedData();
            ImagesObservable.getInstance().savePreviewMediaData(new ArrayList<LocalMedia>(previewData));
            bundle.putParcelableArrayList("selectList", (ArrayList)selectedData);
            bundle.putInt("position", position);
            bundle.putBoolean("isOriginal", this.config.isCheckOriginalImage);
            bundle.putBoolean("isShowCamera", this.mAdapter.isShowCamera());
            bundle.putLong("bucket_id", ValueOf.toLong(this.mTvPictureTitle.getTag(R.id.view_tag)));
            bundle.putInt("page", this.mPage);
            bundle.putParcelable("PictureSelectorConfig", (Parcelable)this.config);
            bundle.putInt("count", ValueOf.toInt(this.mTvPictureTitle.getTag(R.id.view_count_tag)));
            bundle.putString("currentDirectory", this.mTvPictureTitle.getText().toString());
            JumpUtils.startPicturePreviewActivity(this.getContext(), this.config.isWeChatStyle, bundle, this.config.selectionMode == 1 ? 69 : 609);
            this.overridePendingTransition(this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewEnterAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewEnterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
        }
    }

    protected void changeImageNumber(List<LocalMedia> selectData) {
        boolean enable;
        boolean bl = enable = selectData.size() != 0;
        if (enable) {
            this.mTvPictureOk.setEnabled(true);
            this.mTvPictureOk.setSelected(true);
            this.mTvPicturePreview.setEnabled(true);
            this.mTvPicturePreview.setSelected(true);
            if (this.config.style != null) {
                if (this.config.style.pictureCompleteTextColor != 0) {
                    this.mTvPictureOk.setTextColor(this.config.style.pictureCompleteTextColor);
                }
                if (this.config.style.picturePreviewTextColor != 0) {
                    this.mTvPicturePreview.setTextColor(this.config.style.picturePreviewTextColor);
                }
            }
            if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.picturePreviewText)) {
                this.mTvPicturePreview.setText((CharSequence)this.config.style.picturePreviewText);
            } else {
                this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview_num, new Object[]{selectData.size()}));
            }
            if (this.numComplete) {
                this.initCompleteText(selectData.size());
            } else {
                if (!this.isStartAnimation) {
                    this.mTvPictureImgNum.startAnimation(this.animation);
                }
                this.mTvPictureImgNum.setVisibility(0);
                this.mTvPictureImgNum.setText((CharSequence)String.valueOf(selectData.size()));
                if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)this.config.style.pictureCompleteText);
                } else {
                    this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_completed));
                }
                this.isStartAnimation = false;
            }
        } else {
            this.mTvPictureOk.setEnabled(this.config.returnEmpty);
            this.mTvPictureOk.setSelected(false);
            this.mTvPicturePreview.setEnabled(false);
            this.mTvPicturePreview.setSelected(false);
            if (this.config.style != null) {
                if (this.config.style.pictureUnCompleteTextColor != 0) {
                    this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
                }
                if (this.config.style.pictureUnPreviewTextColor != 0) {
                    this.mTvPicturePreview.setTextColor(this.config.style.pictureUnPreviewTextColor);
                }
            }
            if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnPreviewText)) {
                this.mTvPicturePreview.setText((CharSequence)this.config.style.pictureUnPreviewText);
            } else {
                this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview));
            }
            if (this.numComplete) {
                this.initCompleteText(selectData.size());
            } else {
                this.mTvPictureImgNum.setVisibility(4);
                if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)this.config.style.pictureUnCompleteText);
                } else {
                    this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_please_select));
                }
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        block11: {
            Throwable throwable;
            block10: {
                super.onActivityResult(requestCode, resultCode, data);
                if (resultCode != -1) break block10;
                switch (requestCode) {
                    case 166: {
                        ArrayList list;
                        if (data != null && (list = data.getParcelableArrayListExtra("selectList")) != null && list.size() > 0) {
                            this.onResult(list);
                            break;
                        }
                        break block11;
                    }
                    case 69: {
                        this.singleCropHandleResult(data);
                        break;
                    }
                    case 609: {
                        this.multiCropHandleResult(data);
                        break;
                    }
                    case 909: {
                        this.dispatchHandleCamera(data);
                        break;
                    }
                }
                break block11;
            }
            if (resultCode == 0) {
                this.previewCallback(data);
            } else if (resultCode == 96 && data != null && (throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error")) != null) {
                ToastUtils.s(this.getContext(), throwable.getMessage());
            }
        }
    }

    private void previewCallback(Intent data) {
        if (data == null) {
            return;
        }
        if (this.config.isOriginalControl) {
            this.config.isCheckOriginalImage = data.getBooleanExtra("isOriginal", this.config.isCheckOriginalImage);
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
        }
        ArrayList list = data.getParcelableArrayListExtra("selectList");
        if (this.mAdapter != null && list != null) {
            boolean isCompleteOrSelected = data.getBooleanExtra("isCompleteOrSelected", false);
            if (isCompleteOrSelected) {
                this.onChangeData(list);
                if (this.config.isWithVideoImage) {
                    int size = list.size();
                    int imageSize = 0;
                    for (int i = 0; i < size; ++i) {
                        LocalMedia media = (LocalMedia)list.get(i);
                        if (!PictureMimeType.isHasImage(media.getMimeType())) continue;
                        ++imageSize;
                        break;
                    }
                    if (imageSize <= 0 || !this.config.isCompress || this.config.isCheckOriginalImage) {
                        this.onResult(list);
                    } else {
                        this.compressImage(list);
                    }
                } else {
                    String mimeType;
                    String string2 = mimeType = list.size() > 0 ? ((LocalMedia)list.get(0)).getMimeType() : "";
                    if (this.config.isCompress && PictureMimeType.isHasImage(mimeType) && !this.config.isCheckOriginalImage) {
                        this.compressImage(list);
                    } else {
                        this.onResult(list);
                    }
                }
            } else {
                this.isStartAnimation = true;
            }
            this.mAdapter.bindSelectData(list);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    protected void onChangeData(List<LocalMedia> list) {
    }

    private void singleDirectReturnCameraHandleResult(String mimeType) {
        boolean isHasImage = PictureMimeType.isHasImage(mimeType);
        if (this.config.enableCrop && isHasImage) {
            this.config.originalPath = this.config.cameraPath;
            this.startCrop(this.config.cameraPath, mimeType);
        } else if (this.config.isCompress && isHasImage) {
            List<LocalMedia> selectedImages = this.mAdapter.getSelectedData();
            this.compressImage(selectedImages);
        } else {
            this.onResult(this.mAdapter.getSelectedData());
        }
    }

    private void dispatchHandleCamera(final Intent intent) {
        PictureSelectionConfig selectionConfig;
        PictureSelectionConfig pictureSelectionConfig = selectionConfig = intent != null ? (PictureSelectionConfig)intent.getParcelableExtra("PictureSelectorConfig") : null;
        if (selectionConfig != null) {
            this.config = selectionConfig;
        }
        final boolean isAudio = this.config.chooseMode == PictureMimeType.ofAudio();
        String string2 = this.config.cameraPath = isAudio ? this.getAudioPath(intent) : this.config.cameraPath;
        if (TextUtils.isEmpty((CharSequence)this.config.cameraPath)) {
            return;
        }
        this.showPleaseDialog();
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<LocalMedia>(){

            @Override
            public LocalMedia doInBackground() {
                LocalMedia media = new LocalMedia();
                String mimeType = isAudio ? "audio/mpeg" : "";
                int[] newSize = new int[2];
                long duration = 0L;
                if (!isAudio) {
                    if (PictureMimeType.isContent(PictureSelectorActivity.this.config.cameraPath)) {
                        String path = PictureFileUtils.getPath(PictureSelectorActivity.this.getContext(), Uri.parse((String)PictureSelectorActivity.this.config.cameraPath));
                        if (!TextUtils.isEmpty((CharSequence)path)) {
                            File cameraFile = new File(path);
                            mimeType = PictureMimeType.getMimeType(PictureSelectorActivity.this.config.cameraMimeType);
                            media.setSize(cameraFile.length());
                        }
                        if (PictureMimeType.isHasImage(mimeType)) {
                            newSize = MediaUtils.getImageSizeForUrlToAndroidQ(PictureSelectorActivity.this.getContext(), PictureSelectorActivity.this.config.cameraPath);
                        } else if (PictureMimeType.isHasVideo(mimeType)) {
                            newSize = MediaUtils.getVideoSizeForUri(PictureSelectorActivity.this.getContext(), Uri.parse((String)PictureSelectorActivity.this.config.cameraPath));
                            duration = MediaUtils.extractDuration(PictureSelectorActivity.this.getContext(), SdkVersionUtils.checkedAndroid_Q(), PictureSelectorActivity.this.config.cameraPath);
                        }
                        int lastIndexOf = PictureSelectorActivity.this.config.cameraPath.lastIndexOf("/") + 1;
                        media.setId(lastIndexOf > 0 ? ValueOf.toLong(PictureSelectorActivity.this.config.cameraPath.substring(lastIndexOf)) : -1L);
                        media.setRealPath(path);
                        String mediaPath = intent != null ? intent.getStringExtra("mediaPath") : null;
                        media.setAndroidQToPath(mediaPath);
                    } else {
                        File cameraFile = new File(PictureSelectorActivity.this.config.cameraPath);
                        mimeType = PictureMimeType.getMimeType(PictureSelectorActivity.this.config.cameraMimeType);
                        media.setSize(cameraFile.length());
                        if (PictureMimeType.isHasImage(mimeType)) {
                            int degree = PictureFileUtils.readPictureDegree(PictureSelectorActivity.this.getContext(), PictureSelectorActivity.this.config.cameraPath);
                            BitmapUtils.rotateImage(degree, PictureSelectorActivity.this.config.cameraPath);
                            newSize = MediaUtils.getImageSizeForUrl(PictureSelectorActivity.this.config.cameraPath);
                        } else if (PictureMimeType.isHasVideo(mimeType)) {
                            newSize = MediaUtils.getVideoSizeForUrl(PictureSelectorActivity.this.config.cameraPath);
                            duration = MediaUtils.extractDuration(PictureSelectorActivity.this.getContext(), SdkVersionUtils.checkedAndroid_Q(), PictureSelectorActivity.this.config.cameraPath);
                        }
                        media.setId(System.currentTimeMillis());
                    }
                    media.setPath(PictureSelectorActivity.this.config.cameraPath);
                    media.setDuration(duration);
                    media.setMimeType(mimeType);
                    media.setWidth(newSize[0]);
                    media.setHeight(newSize[1]);
                    if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isHasVideo(media.getMimeType())) {
                        media.setParentFolderName(Environment.DIRECTORY_MOVIES);
                    } else {
                        media.setParentFolderName("Camera");
                    }
                    media.setChooseModel(PictureSelectorActivity.this.config.chooseMode);
                    long bucketId = MediaUtils.getCameraFirstBucketId(PictureSelectorActivity.this.getContext());
                    media.setBucketId(bucketId);
                    MediaUtils.setOrientationSynchronous(PictureSelectorActivity.this.getContext(), media, PictureSelectorActivity.this.config.isAndroidQChangeWH, PictureSelectorActivity.this.config.isAndroidQChangeVideoWH);
                }
                return media;
            }

            @Override
            public void onSuccess(LocalMedia result) {
                int lastImageId;
                PictureSelectorActivity.this.dismissDialog();
                if (!SdkVersionUtils.checkedAndroid_Q()) {
                    if (PictureSelectorActivity.this.config.isFallbackVersion3) {
                        new PictureMediaScannerConnection(PictureSelectorActivity.this.getContext(), PictureSelectorActivity.this.config.cameraPath);
                    } else {
                        PictureSelectorActivity.this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)new File(PictureSelectorActivity.this.config.cameraPath))));
                    }
                }
                PictureSelectorActivity.this.notifyAdapterData(result);
                if (!SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isHasImage(result.getMimeType()) && (lastImageId = MediaUtils.getDCIMLastImageId(PictureSelectorActivity.this.getContext())) != -1) {
                    MediaUtils.removeMedia(PictureSelectorActivity.this.getContext(), lastImageId);
                }
            }
        });
    }

    private void notifyAdapterData(LocalMedia media) {
        if (this.mAdapter != null) {
            boolean isAddSameImp = this.isAddSameImp(this.folderWindow.getFolder(0) != null ? this.folderWindow.getFolder(0).getImageNum() : 0);
            if (!isAddSameImp) {
                this.mAdapter.getData().add(0, media);
                ++this.mOpenCameraCount;
            }
            if (this.checkVideoLegitimacy(media)) {
                if (this.config.selectionMode == 1) {
                    this.dispatchHandleSingle(media);
                } else {
                    this.dispatchHandleMultiple(media);
                }
            }
            this.mAdapter.notifyItemInserted(this.config.isCamera ? 1 : 0);
            this.mAdapter.notifyItemRangeChanged(this.config.isCamera ? 1 : 0, this.mAdapter.getSize());
            if (this.config.isPageStrategy) {
                this.manualSaveFolderForPageModel(media);
            } else {
                this.manualSaveFolder(media);
            }
            this.mTvEmpty.setVisibility(this.mAdapter.getSize() > 0 || this.config.isSingleDirectReturn ? 8 : 0);
            if (this.folderWindow.getFolder(0) != null) {
                this.mTvPictureTitle.setTag(R.id.view_count_tag, (Object)this.folderWindow.getFolder(0).getImageNum());
            }
            this.allFolderSize = 0;
        }
    }

    private void dispatchHandleMultiple(LocalMedia media) {
        List<LocalMedia> selectedData = this.mAdapter.getSelectedData();
        int count = selectedData.size();
        String oldMimeType = count > 0 ? selectedData.get(0).getMimeType() : "";
        boolean mimeTypeSame = PictureMimeType.isMimeTypeSame(oldMimeType, media.getMimeType());
        if (this.config.isWithVideoImage) {
            int videoSize = 0;
            for (int i = 0; i < count; ++i) {
                LocalMedia item = selectedData.get(i);
                if (!PictureMimeType.isHasVideo(item.getMimeType())) continue;
                ++videoSize;
            }
            if (PictureMimeType.isHasVideo(media.getMimeType())) {
                if (this.config.maxVideoSelectNum <= 0) {
                    this.showPromptDialog(this.getString(R.string.picture_rule));
                } else if (selectedData.size() >= this.config.maxSelectNum) {
                    this.showPromptDialog(this.getString(R.string.picture_message_max_num, new Object[]{this.config.maxSelectNum}));
                } else if (videoSize < this.config.maxVideoSelectNum) {
                    selectedData.add(0, media);
                    this.mAdapter.bindSelectData(selectedData);
                } else {
                    this.showPromptDialog(StringUtils.getMsg(this.getContext(), media.getMimeType(), this.config.maxVideoSelectNum));
                }
            } else if (selectedData.size() < this.config.maxSelectNum) {
                selectedData.add(0, media);
                this.mAdapter.bindSelectData(selectedData);
            } else {
                this.showPromptDialog(StringUtils.getMsg(this.getContext(), media.getMimeType(), this.config.maxSelectNum));
            }
        } else if (PictureMimeType.isHasVideo(oldMimeType) && this.config.maxVideoSelectNum > 0) {
            if (count < this.config.maxVideoSelectNum) {
                if ((mimeTypeSame || count == 0) && selectedData.size() < this.config.maxVideoSelectNum) {
                    selectedData.add(0, media);
                    this.mAdapter.bindSelectData(selectedData);
                }
            } else {
                this.showPromptDialog(StringUtils.getMsg(this.getContext(), oldMimeType, this.config.maxVideoSelectNum));
            }
        } else if (count < this.config.maxSelectNum) {
            if (mimeTypeSame || count == 0) {
                selectedData.add(0, media);
                this.mAdapter.bindSelectData(selectedData);
            }
        } else {
            this.showPromptDialog(StringUtils.getMsg(this.getContext(), oldMimeType, this.config.maxSelectNum));
        }
    }

    private void dispatchHandleSingle(LocalMedia media) {
        if (this.config.isSingleDirectReturn) {
            List<LocalMedia> selectedData = this.mAdapter.getSelectedData();
            selectedData.add(media);
            this.mAdapter.bindSelectData(selectedData);
            this.singleDirectReturnCameraHandleResult(media.getMimeType());
        } else {
            List<LocalMedia> selectedData = this.mAdapter.getSelectedData();
            String mimeType = selectedData.size() > 0 ? selectedData.get(0).getMimeType() : "";
            boolean mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, media.getMimeType());
            if (mimeTypeSame || selectedData.size() == 0) {
                this.singleRadioMediaImage();
                selectedData.add(media);
                this.mAdapter.bindSelectData(selectedData);
            }
        }
    }

    private boolean checkVideoLegitimacy(LocalMedia media) {
        boolean isEnterNext = true;
        if (PictureMimeType.isHasVideo(media.getMimeType())) {
            if (this.config.videoMinSecond > 0 && this.config.videoMaxSecond > 0) {
                if (media.getDuration() < (long)this.config.videoMinSecond || media.getDuration() > (long)this.config.videoMaxSecond) {
                    isEnterNext = false;
                    this.showPromptDialog(this.getString(R.string.picture_choose_limit_seconds, new Object[]{this.config.videoMinSecond / 1000, this.config.videoMaxSecond / 1000}));
                }
            } else if (this.config.videoMinSecond > 0) {
                if (media.getDuration() < (long)this.config.videoMinSecond) {
                    isEnterNext = false;
                    this.showPromptDialog(this.getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                }
            } else if (this.config.videoMaxSecond > 0 && media.getDuration() > (long)this.config.videoMaxSecond) {
                isEnterNext = false;
                this.showPromptDialog(this.getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
            }
        }
        return isEnterNext;
    }

    private void singleCropHandleResult(Intent data) {
        if (data == null) {
            return;
        }
        Uri resultUri = UCrop.getOutput((Intent)data);
        if (resultUri == null) {
            return;
        }
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        String cutPath = resultUri.getPath();
        if (this.mAdapter != null) {
            List<LocalMedia> mediaList;
            LocalMedia media;
            ArrayList list = data.getParcelableArrayListExtra("selectList");
            if (list != null) {
                this.mAdapter.bindSelectData(list);
                this.mAdapter.notifyDataSetChanged();
            }
            LocalMedia localMedia = media = (mediaList = this.mAdapter.getSelectedData()) != null && mediaList.size() > 0 ? mediaList.get(0) : null;
            if (media != null) {
                boolean isCutPathEmpty;
                this.config.originalPath = media.getPath();
                media.setCutPath(cutPath);
                media.setChooseModel(this.config.chooseMode);
                boolean bl = isCutPathEmpty = !TextUtils.isEmpty((CharSequence)cutPath);
                if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(media.getPath())) {
                    if (isCutPathEmpty) {
                        media.setSize(new File(cutPath).length());
                    } else {
                        media.setSize(!TextUtils.isEmpty((CharSequence)media.getRealPath()) ? new File(media.getRealPath()).length() : 0L);
                    }
                    media.setAndroidQToPath(cutPath);
                } else {
                    media.setSize(isCutPathEmpty ? new File(cutPath).length() : 0L);
                }
                media.setCut(isCutPathEmpty);
                result.add(media);
                this.handlerResult(result);
            } else {
                LocalMedia localMedia2 = media = list != null && list.size() > 0 ? (LocalMedia)list.get(0) : null;
                if (media != null) {
                    boolean isCutPathEmpty;
                    this.config.originalPath = media.getPath();
                    media.setCutPath(cutPath);
                    media.setChooseModel(this.config.chooseMode);
                    boolean bl = isCutPathEmpty = !TextUtils.isEmpty((CharSequence)cutPath);
                    if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(media.getPath())) {
                        if (isCutPathEmpty) {
                            media.setSize(new File(cutPath).length());
                        } else {
                            media.setSize(!TextUtils.isEmpty((CharSequence)media.getRealPath()) ? new File(media.getRealPath()).length() : 0L);
                        }
                        media.setAndroidQToPath(cutPath);
                    } else {
                        media.setSize(isCutPathEmpty ? new File(cutPath).length() : 0L);
                    }
                    media.setCut(isCutPathEmpty);
                    result.add(media);
                    this.handlerResult(result);
                }
            }
        }
    }

    protected void multiCropHandleResult(Intent data) {
        int oldSize;
        if (data == null) {
            return;
        }
        List mCuts = UCrop.getMultipleOutput((Intent)data);
        if (mCuts == null || mCuts.size() == 0) {
            return;
        }
        int size = mCuts.size();
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        ArrayList list = data.getParcelableArrayListExtra("selectList");
        if (list != null) {
            this.mAdapter.bindSelectData(list);
            this.mAdapter.notifyDataSetChanged();
        }
        int n = oldSize = this.mAdapter != null ? this.mAdapter.getSelectedData().size() : 0;
        if (oldSize == size) {
            List<LocalMedia> result = this.mAdapter.getSelectedData();
            for (int i = 0; i < size; ++i) {
                CutInfo c = (CutInfo)mCuts.get(i);
                LocalMedia media = result.get(i);
                media.setCut(!TextUtils.isEmpty((CharSequence)c.getCutPath()));
                media.setPath(c.getPath());
                media.setMimeType(c.getMimeType());
                media.setCutPath(c.getCutPath());
                media.setWidth(c.getImageWidth());
                media.setHeight(c.getImageHeight());
                media.setAndroidQToPath(isAndroidQ ? c.getCutPath() : media.getAndroidQToPath());
                media.setSize(!TextUtils.isEmpty((CharSequence)c.getCutPath()) ? new File(c.getCutPath()).length() : media.getSize());
            }
            this.handlerResult(result);
        } else {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            for (int i = 0; i < size; ++i) {
                CutInfo c = (CutInfo)mCuts.get(i);
                LocalMedia media = new LocalMedia();
                media.setId(c.getId());
                media.setCut(!TextUtils.isEmpty((CharSequence)c.getCutPath()));
                media.setPath(c.getPath());
                media.setCutPath(c.getCutPath());
                media.setMimeType(c.getMimeType());
                media.setWidth(c.getImageWidth());
                media.setHeight(c.getImageHeight());
                media.setDuration(c.getDuration());
                media.setChooseModel(this.config.chooseMode);
                media.setAndroidQToPath(isAndroidQ ? c.getCutPath() : c.getAndroidQToPath());
                if (!TextUtils.isEmpty((CharSequence)c.getCutPath())) {
                    media.setSize(new File(c.getCutPath()).length());
                } else if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(c.getPath())) {
                    media.setSize(!TextUtils.isEmpty((CharSequence)c.getRealPath()) ? new File(c.getRealPath()).length() : 0L);
                } else {
                    media.setSize(new File(c.getPath()).length());
                }
                result.add(media);
            }
            this.handlerResult(result);
        }
    }

    private void singleRadioMediaImage() {
        List<LocalMedia> selectData = this.mAdapter.getSelectedData();
        if (selectData != null && selectData.size() > 0) {
            LocalMedia media = selectData.get(0);
            int position = media.getPosition();
            selectData.clear();
            this.mAdapter.notifyItemChanged(position);
        }
    }

    private void manualSaveFolderForPageModel(LocalMedia media) {
        LocalMediaFolder allFolder;
        if (media == null) {
            return;
        }
        int count = this.folderWindow.getFolderData().size();
        LocalMediaFolder localMediaFolder = allFolder = count > 0 ? this.folderWindow.getFolderData().get(0) : new LocalMediaFolder();
        if (allFolder != null) {
            int totalNum = allFolder.getImageNum();
            allFolder.setFirstImagePath(media.getPath());
            allFolder.setImageNum(this.isAddSameImp(totalNum) ? allFolder.getImageNum() : allFolder.getImageNum() + 1);
            if (count == 0) {
                allFolder.setName(this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll));
                allFolder.setOfAllType(this.config.chooseMode);
                allFolder.setCameraFolder(true);
                allFolder.setChecked(true);
                allFolder.setBucketId(-1L);
                this.folderWindow.getFolderData().add(0, allFolder);
                LocalMediaFolder cameraFolder = new LocalMediaFolder();
                cameraFolder.setName(media.getParentFolderName());
                cameraFolder.setImageNum(this.isAddSameImp(totalNum) ? cameraFolder.getImageNum() : cameraFolder.getImageNum() + 1);
                cameraFolder.setFirstImagePath(media.getPath());
                cameraFolder.setBucketId(media.getBucketId());
                this.folderWindow.getFolderData().add(this.folderWindow.getFolderData().size(), cameraFolder);
            } else {
                boolean isCamera = false;
                String newFolder = SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isHasVideo(media.getMimeType()) ? Environment.DIRECTORY_MOVIES : "Camera";
                for (int i = 0; i < count; ++i) {
                    LocalMediaFolder cameraFolder = this.folderWindow.getFolderData().get(i);
                    if (TextUtils.isEmpty((CharSequence)cameraFolder.getName()) || !cameraFolder.getName().startsWith(newFolder)) continue;
                    media.setBucketId(cameraFolder.getBucketId());
                    cameraFolder.setFirstImagePath(this.config.cameraPath);
                    cameraFolder.setImageNum(this.isAddSameImp(totalNum) ? cameraFolder.getImageNum() : cameraFolder.getImageNum() + 1);
                    if (cameraFolder.getData() != null && cameraFolder.getData().size() > 0) {
                        cameraFolder.getData().add(0, media);
                    }
                    isCamera = true;
                    break;
                }
                if (!isCamera) {
                    LocalMediaFolder cameraFolder = new LocalMediaFolder();
                    cameraFolder.setName(media.getParentFolderName());
                    cameraFolder.setImageNum(this.isAddSameImp(totalNum) ? cameraFolder.getImageNum() : cameraFolder.getImageNum() + 1);
                    cameraFolder.setFirstImagePath(media.getPath());
                    cameraFolder.setBucketId(media.getBucketId());
                    this.folderWindow.getFolderData().add(cameraFolder);
                    this.sortFolder(this.folderWindow.getFolderData());
                }
            }
            this.folderWindow.bindFolder(this.folderWindow.getFolderData());
        }
    }

    private void manualSaveFolder(LocalMedia media) {
        try {
            LocalMediaFolder allFolder;
            int totalNum;
            boolean isEmpty = this.folderWindow.isEmpty();
            int n = totalNum = this.folderWindow.getFolder(0) != null ? this.folderWindow.getFolder(0).getImageNum() : 0;
            if (isEmpty) {
                this.createNewFolder(this.folderWindow.getFolderData());
                LocalMediaFolder localMediaFolder = allFolder = this.folderWindow.getFolderData().size() > 0 ? this.folderWindow.getFolderData().get(0) : null;
                if (allFolder == null) {
                    allFolder = new LocalMediaFolder();
                    this.folderWindow.getFolderData().add(0, allFolder);
                }
            } else {
                allFolder = this.folderWindow.getFolderData().get(0);
            }
            allFolder.setFirstImagePath(media.getPath());
            allFolder.setData(this.mAdapter.getData());
            allFolder.setBucketId(-1L);
            allFolder.setImageNum(this.isAddSameImp(totalNum) ? allFolder.getImageNum() : allFolder.getImageNum() + 1);
            LocalMediaFolder cameraFolder = this.getImageFolder(media.getPath(), media.getRealPath(), this.folderWindow.getFolderData());
            if (cameraFolder != null) {
                cameraFolder.setImageNum(this.isAddSameImp(totalNum) ? cameraFolder.getImageNum() : cameraFolder.getImageNum() + 1);
                if (!this.isAddSameImp(totalNum)) {
                    cameraFolder.getData().add(0, media);
                }
                cameraFolder.setBucketId(media.getBucketId());
                cameraFolder.setFirstImagePath(this.config.cameraPath);
            }
            this.folderWindow.bindFolder(this.folderWindow.getFolderData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isAddSameImp(int totalNum) {
        if (totalNum == 0) {
            return false;
        }
        return this.allFolderSize > 0 && this.allFolderSize < totalNum;
    }

    private void updateMediaFolder(List<LocalMediaFolder> imageFolders, LocalMedia media) {
        File imageFile = new File(media.getRealPath());
        File folderFile = imageFile.getParentFile();
        if (folderFile == null) {
            return;
        }
        int size = imageFolders.size();
        for (int i = 0; i < size; ++i) {
            LocalMediaFolder folder = imageFolders.get(i);
            String name = folder.getName();
            if (TextUtils.isEmpty((CharSequence)name) || !name.equals(folderFile.getName())) continue;
            folder.setFirstImagePath(this.config.cameraPath);
            folder.setImageNum(folder.getImageNum() + 1);
            folder.setCheckedNum(1);
            folder.getData().add(0, media);
            break;
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.config != null && PictureSelectionConfig.listener != null) {
            PictureSelectionConfig.listener.onCancel();
        }
        this.closeActivity();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        if (this.mediaPlayer != null && this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    @Override
    public void onItemClick(View view, int position) {
        switch (position) {
            case 0: {
                if (PictureSelectionConfig.onCustomCameraInterfaceListener != null) {
                    PictureSelectionConfig.onCustomCameraInterfaceListener.onCameraClick(this.getContext(), this.config, 1);
                    this.config.cameraMimeType = PictureMimeType.ofImage();
                    break;
                }
                this.startOpenCamera();
                break;
            }
            case 1: {
                if (PictureSelectionConfig.onCustomCameraInterfaceListener != null) {
                    PictureSelectionConfig.onCustomCameraInterfaceListener.onCameraClick(this.getContext(), this.config, 1);
                    this.config.cameraMimeType = PictureMimeType.ofVideo();
                    break;
                }
                this.startOpenCameraVideo();
                break;
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.readLocalMedia();
                    break;
                }
                this.showPermissionsDialog(false, this.getString(R.string.picture_jurisdiction));
                break;
            }
            case 2: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                this.showPermissionsDialog(true, this.getString(R.string.picture_camera));
                break;
            }
            case 5: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.startCamera();
                    break;
                }
                this.showPermissionsDialog(false, this.getString(R.string.picture_jurisdiction));
                break;
            }
            case 4: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.startCustomCamera();
                    break;
                }
                this.showPermissionsDialog(false, this.getString(R.string.picture_audio));
            }
        }
    }

    @Override
    protected void showPermissionsDialog(boolean isCamera, String errorMsg) {
        if (this.isFinishing()) {
            return;
        }
        PictureCustomDialog dialog = new PictureCustomDialog(this.getContext(), R.layout.picture_wind_base_dialog);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        Button btn_cancel = (Button)dialog.findViewById(R.id.btn_cancel);
        Button btn_commit = (Button)dialog.findViewById(R.id.btn_commit);
        btn_commit.setText((CharSequence)this.getString(R.string.picture_go_setting));
        TextView tvTitle = (TextView)dialog.findViewById(R.id.tvTitle);
        TextView tv_content = (TextView)dialog.findViewById(R.id.tv_content);
        tvTitle.setText((CharSequence)this.getString(R.string.picture_prompt));
        tv_content.setText((CharSequence)errorMsg);
        btn_cancel.setOnClickListener(v -> {
            if (!this.isFinishing()) {
                dialog.dismiss();
            }
            if (!isCamera) {
                this.closeActivity();
            }
        });
        btn_commit.setOnClickListener(v -> {
            if (!this.isFinishing()) {
                dialog.dismiss();
            }
            PermissionChecker.launchAppDetailsSettings(this.getContext());
            this.isEnterSetting = true;
        });
        dialog.show();
    }

    private void showDataNull(String msg, int topErrorResId) {
        if (this.mTvEmpty.getVisibility() == 8 || this.mTvEmpty.getVisibility() == 4) {
            this.mTvEmpty.setCompoundDrawablesRelativeWithIntrinsicBounds(0, topErrorResId, 0, 0);
            this.mTvEmpty.setText((CharSequence)msg);
            this.mTvEmpty.setVisibility(0);
        }
    }

    private void hideDataNull() {
        if (this.mTvEmpty.getVisibility() == 0) {
            this.mTvEmpty.setVisibility(8);
        }
    }

    public class AudioOnClick
    implements View.OnClickListener {
        private String path;

        public AudioOnClick(String path) {
            this.path = path;
        }

        public void onClick(View v) {
            int id2 = v.getId();
            if (id2 == R.id.tv_PlayPause) {
                PictureSelectorActivity.this.playAudio();
            }
            if (id2 == R.id.tv_Stop) {
                PictureSelectorActivity.this.mTvMusicStatus.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_stop_audio));
                PictureSelectorActivity.this.mTvPlayPause.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_play_audio));
                PictureSelectorActivity.this.stop(this.path);
            }
            if (id2 == R.id.tv_Quit && PictureSelectorActivity.this.mHandler != null) {
                PictureSelectorActivity.this.mHandler.postDelayed(() -> PictureSelectorActivity.this.stop(this.path), 30L);
                try {
                    if (PictureSelectorActivity.this.audioDialog != null && PictureSelectorActivity.this.audioDialog.isShowing()) {
                        PictureSelectorActivity.this.audioDialog.dismiss();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PictureSelectorActivity.this.mHandler.removeCallbacks(PictureSelectorActivity.this.mRunnable);
            }
        }
    }
}

