/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.crash;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import androidx.annotation.NonNull;
import com.luck.picture.lib.app.PictureAppMaster;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class PictureSelectorCrashUtils {
    private static boolean mInitialized;
    private static String defaultDir;
    private static String dir;
    private static String versionName;
    private static int versionCode;
    private static final String FILE_SEP;
    private static final Format FORMAT;
    private static final String CRASH_HEAD;
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER;
    private static CrashAppListener mFinishAppListener;

    private PictureSelectorCrashUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean init() {
        return PictureSelectorCrashUtils.init("", null);
    }

    public static boolean init(CrashAppListener listener) {
        return PictureSelectorCrashUtils.init("", listener);
    }

    public static boolean init(@NonNull File crashDir) {
        return PictureSelectorCrashUtils.init(crashDir.getAbsolutePath() + FILE_SEP, null);
    }

    public static boolean init(String crashDir, CrashAppListener listener) {
        mFinishAppListener = listener;
        if (PictureSelectorCrashUtils.isSpace(crashDir)) {
            dir = null;
        } else {
            String string2 = dir = crashDir.endsWith(FILE_SEP) ? dir : dir + FILE_SEP;
        }
        if (mInitialized) {
            return true;
        }
        defaultDir = "mounted".equals(Environment.getExternalStorageState()) && PictureAppMaster.getInstance().getAppContext().getExternalCacheDir() != null ? PictureAppMaster.getInstance().getAppContext().getExternalCacheDir() + FILE_SEP + "crash" + FILE_SEP : PictureAppMaster.getInstance().getAppContext().getCacheDir() + FILE_SEP + "crash" + FILE_SEP;
        Thread.setDefaultUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
        mInitialized = true;
        return true;
    }

    private static boolean createOrExistsFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!PictureSelectorCrashUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void setCrashListener(CrashAppListener crashListener) {
        mFinishAppListener = crashListener;
    }

    static {
        FILE_SEP = System.getProperty("file.separator");
        FORMAT = new SimpleDateFormat("MM-dd HH-mm-ss", Locale.getDefault());
        try {
            PackageInfo pi = PictureAppMaster.getInstance().getAppContext().getPackageManager().getPackageInfo(PictureAppMaster.getInstance().getAppContext().getPackageName(), 0);
            if (pi != null) {
                versionName = pi.versionName;
                versionCode = pi.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        CRASH_HEAD = "\n************* Crash Log Head ****************\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nApp VersionName    : " + versionName + "\nApp VersionCode    : " + versionCode + "\n************* Crash Log Head ****************\n\n";
        UNCAUGHT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (mFinishAppListener != null) {
                    mFinishAppListener.onFinishApp(t, e);
                }
                Date now = new Date(System.currentTimeMillis());
                String fileName = FORMAT.format(now) + ".txt";
                String fullPath = (dir == null ? defaultDir : dir) + fileName;
                if (PictureSelectorCrashUtils.createOrExistsFile(fullPath)) {
                    try (PrintWriter pw = null;){
                        pw = new PrintWriter(new FileWriter(fullPath, false));
                        pw.write(CRASH_HEAD);
                        e.printStackTrace(pw);
                        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                            cause.printStackTrace(pw);
                        }
                    }
                }
                Process.killProcess((int)Process.myPid());
                System.exit(0);
            }
        };
        mFinishAppListener = null;
    }

    public static interface CrashAppListener {
        public void onFinishApp(Thread var1, Throwable var2);
    }
}

