/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Locale;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class PictureFileUtils {
    public static final String POSTFIX = ".jpg";
    public static final String POST_VIDEO = ".mp4";
    public static final String POST_AUDIO = ".mp3";
    static final String TAG = "PictureFileUtils";

    @Nullable
    public static File createCameraFile(Context context, int type, String fileName, String format, String outCameraDirectory) {
        return PictureFileUtils.createMediaFile(context, type, fileName, format, outCameraDirectory);
    }

    @Nullable
    private static File createMediaFile(Context context, int chooseMode, String fileName, String format, String outCameraDirectory) {
        return PictureFileUtils.createOutFile(context, chooseMode, fileName, format, outCameraDirectory);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static File createOutFile(Context context, int chooseMode, String fileName, String format, String outCameraDirectory) {
        File folderDir = null;
        if (TextUtils.isEmpty((CharSequence)outCameraDirectory)) {
            File rootDir;
            String state = Environment.getExternalStorageState();
            File file = rootDir = state.equals("mounted") ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) : PictureFileUtils.getRootDirFile(context, chooseMode);
            if (rootDir != null) {
                if (!rootDir.exists()) {
                    rootDir.mkdirs();
                }
                if (!(folderDir = new File(rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator)).exists() && !folderDir.mkdirs()) {
                    // empty if block
                }
            }
        } else {
            folderDir = new File(outCameraDirectory);
            if (!folderDir.exists()) {
                folderDir.mkdirs();
            }
        }
        if (folderDir == null) {
            throw new NullPointerException("The media output path cannot be null");
        }
        boolean isOutFileNameEmpty = TextUtils.isEmpty((CharSequence)fileName);
        switch (chooseMode) {
            case 2: {
                String newFileVideoName = isOutFileNameEmpty ? DateUtils.getCreateFileName("VID_") + POST_VIDEO : fileName;
                return new File(folderDir, newFileVideoName);
            }
            case 3: {
                String newFileAudioName = isOutFileNameEmpty ? DateUtils.getCreateFileName("AUD_") + POST_AUDIO : fileName;
                return new File(folderDir, newFileAudioName);
            }
        }
        String suffix = TextUtils.isEmpty((CharSequence)format) ? POSTFIX : format;
        String newFileImageName = isOutFileNameEmpty ? DateUtils.getCreateFileName("IMG_") + suffix : fileName;
        return new File(folderDir, newFileImageName);
    }

    @Nullable
    private static File getRootDirFile(Context context, int type) {
        switch (type) {
            case 2: {
                return context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            }
            case 3: {
                return context.getExternalFilesDir(Environment.DIRECTORY_MUSIC);
            }
        }
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
    }

    private PictureFileUtils() {
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        catch (IllegalArgumentException ex) {
            Log.i((String)TAG, (String)String.format(Locale.getDefault(), "getDataColumn: _data - [%s]", ex.getMessage()));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context ctx, Uri uri) {
        boolean isKitKat;
        Context context = ctx.getApplicationContext();
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (PictureFileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    if (SdkVersionUtils.checkedAndroid_Q()) {
                        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) + "/" + split[1];
                    }
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (PictureFileUtils.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return PictureFileUtils.getDataColumn(context, contentUri, null, null);
                }
                if (PictureFileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return PictureFileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (PictureFileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return PictureFileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(@NonNull String pathFrom, @NonNull String pathTo) throws IOException {
        if (pathFrom.equalsIgnoreCase(pathTo)) {
            return;
        }
        AbstractInterruptibleChannel outputChannel = null;
        AbstractInterruptibleChannel inputChannel = null;
        try {
            inputChannel = new FileInputStream(new File(pathFrom)).getChannel();
            outputChannel = new FileOutputStream(new File(pathTo)).getChannel();
            ((FileChannel)inputChannel).transferTo(0L, ((FileChannel)inputChannel).size(), (WritableByteChannel)((Object)outputChannel));
            inputChannel.close();
        }
        finally {
            if (inputChannel != null) {
                inputChannel.close();
            }
            if (outputChannel != null) {
                outputChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean bufferCopy(BufferedSource inBuffer, File outFile) {
        BufferedSink outBuffer = null;
        try {
            outBuffer = Okio.buffer((Sink)Okio.sink((File)outFile));
            outBuffer.writeAll((Source)inBuffer);
            outBuffer.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            PictureFileUtils.close((Closeable)inBuffer);
            PictureFileUtils.close((Closeable)outBuffer);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean bufferCopy(BufferedSource inBuffer, OutputStream outputStream) {
        BufferedSink outBuffer = null;
        try {
            outBuffer = Okio.buffer((Sink)Okio.sink((OutputStream)outputStream));
            outBuffer.writeAll((Source)inBuffer);
            outBuffer.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            PictureFileUtils.close((Closeable)inBuffer);
            PictureFileUtils.close((Closeable)outBuffer);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean bufferCopy(File inFile, OutputStream outPutStream) {
        BufferedSource inBuffer = null;
        BufferedSink outBuffer = null;
        try {
            inBuffer = Okio.buffer((Source)Okio.source((File)inFile));
            outBuffer = Okio.buffer((Sink)Okio.sink((OutputStream)outPutStream));
            outBuffer.writeAll((Source)inBuffer);
            outBuffer.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            PictureFileUtils.close((Closeable)inBuffer);
            PictureFileUtils.close(outPutStream);
            PictureFileUtils.close((Closeable)outBuffer);
        }
        return false;
    }

    public static int readPictureDegree(Context context, String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface;
            if (SdkVersionUtils.checkedAndroid_Q()) {
                ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                exifInterface = new ExifInterface(parcelFileDescriptor.getFileDescriptor());
            } else {
                exifInterface = new ExifInterface(path);
            }
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static String getDCIMCameraPath() {
        String absolutePath;
        try {
            absolutePath = "%" + Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + "/Camera";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return absolutePath;
    }

    public static void deleteCacheDirFile(Context mContext, int type) {
        File[] files;
        File cutDir = mContext.getExternalFilesDir(type == PictureMimeType.ofImage() ? Environment.DIRECTORY_PICTURES : Environment.DIRECTORY_MOVIES);
        if (cutDir != null && (files = cutDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    public static void deleteAllCacheDirFile(Context context) {
        File[] files;
        File dirMusic;
        File[] files2;
        File dirMovies;
        File[] files3;
        File dirPictures = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (dirPictures != null && (files3 = dirPictures.listFiles()) != null) {
            for (File file : files3) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        if ((dirMovies = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES)) != null && (files2 = dirMovies.listFiles()) != null) {
            for (File file : files2) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        if ((dirMusic = context.getExternalFilesDir(Environment.DIRECTORY_MUSIC)) != null && (files = dirMusic.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    public static String getDiskCacheDir(Context ctx) {
        File filesDir = ctx.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (filesDir == null) {
            return "";
        }
        return filesDir.getPath();
    }

    public static String getVideoDiskCacheDir(Context ctx) {
        File filesDir = ctx.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
        if (filesDir == null) {
            return "";
        }
        return filesDir.getPath();
    }

    public static String getAudioDiskCacheDir(Context ctx) {
        File filesDir = ctx.getExternalFilesDir(Environment.DIRECTORY_MUSIC);
        if (filesDir == null) {
            return "";
        }
        return filesDir.getPath();
    }

    public static Uri parUri(Context context, File cameraFile) {
        String authority = context.getPackageName() + ".provider";
        Uri imageUri = Build.VERSION.SDK_INT > 23 ? FileProvider.getUriForFile((Context)context, (String)authority, (File)cameraFile) : Uri.fromFile((File)cameraFile);
        return imageUri;
    }

    public static String extSuffix(InputStream input) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
            return options.outMimeType.replace("image/", ".");
        }
        catch (Exception e) {
            return POSTFIX;
        }
    }

    public static String createFilePath(Context context, String md5, String mineType, String customFileName) {
        String suffix = PictureMimeType.getLastImgSuffix(mineType);
        if (PictureMimeType.isHasVideo(mineType)) {
            String filesDir = PictureFileUtils.getVideoDiskCacheDir(context) + File.separator;
            if (!TextUtils.isEmpty((CharSequence)md5)) {
                String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? "VID_" + md5.toUpperCase() + suffix : customFileName;
                return filesDir + fileName;
            }
            String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? DateUtils.getCreateFileName("VID_") + suffix : customFileName;
            return filesDir + fileName;
        }
        if (PictureMimeType.isHasAudio(mineType)) {
            String filesDir = PictureFileUtils.getAudioDiskCacheDir(context) + File.separator;
            if (!TextUtils.isEmpty((CharSequence)md5)) {
                String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? "AUD_" + md5.toUpperCase() + suffix : customFileName;
                return filesDir + fileName;
            }
            String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? DateUtils.getCreateFileName("AUD_") + suffix : customFileName;
            return filesDir + fileName;
        }
        String filesDir = PictureFileUtils.getDiskCacheDir(context) + File.separator;
        if (!TextUtils.isEmpty((CharSequence)md5)) {
            String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? "IMG_" + md5.toUpperCase() + suffix : customFileName;
            return filesDir + fileName;
        }
        String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? DateUtils.getCreateFileName("IMG_") + suffix : customFileName;
        return filesDir + fileName;
    }

    public static boolean isFileExists(String path) {
        return TextUtils.isEmpty((CharSequence)path) || new File(path).exists();
    }

    public static void close(@Nullable Closeable c) {
        if (c != null && c instanceof Closeable) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

