/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.R;
import com.luck.picture.lib.broadcast.BroadcastManager;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnImageCompleteCallback;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.JumpUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.luck.picture.lib.widget.longimage.ImageSource;
import com.luck.picture.lib.widget.longimage.ImageViewState;
import com.luck.picture.lib.widget.longimage.SubsamplingScaleImageView;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class PictureExternalPreviewActivity
extends PictureBaseActivity
implements View.OnClickListener {
    private ImageButton ibLeftBack;
    private TextView tvTitle;
    private PreviewViewPager viewPager;
    private List<LocalMedia> images = new ArrayList<LocalMedia>();
    private int position = 0;
    private SimpleFragmentAdapter adapter;
    private String downloadPath;
    private String mMimeType;
    private ImageButton ibDelete;
    private boolean isAndroidQ;
    private View titleViewBg;

    @Override
    public int getResourceId() {
        return R.layout.picture_activity_external_preview;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        this.titleViewBg = this.findViewById(R.id.titleViewBg);
        this.tvTitle = (TextView)this.findViewById(R.id.picture_title);
        this.ibLeftBack = (ImageButton)this.findViewById(R.id.left_back);
        this.ibDelete = (ImageButton)this.findViewById(R.id.ib_delete);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.position = this.getIntent().getIntExtra("position", 0);
        this.images = (List)((Object)this.getIntent().getSerializableExtra("previewSelectList"));
        this.ibLeftBack.setOnClickListener((View.OnClickListener)this);
        this.ibDelete.setOnClickListener((View.OnClickListener)this);
        this.ibDelete.setVisibility(this.config.style != null ? (this.config.style.pictureExternalPreviewGonePreviewDelete ? 0 : 8) : 8);
        this.initViewPageAdapterData();
    }

    @Override
    public void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (this.config.style.pictureTitleTextColor != 0) {
                this.tvTitle.setTextColor(this.config.style.pictureTitleTextColor);
            }
            if (this.config.style.pictureTitleTextSize != 0) {
                this.tvTitle.setTextSize((float)this.config.style.pictureTitleTextSize);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.ibLeftBack.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.pictureExternalPreviewDeleteStyle != 0) {
                this.ibDelete.setImageResource(this.config.style.pictureExternalPreviewDeleteStyle);
            }
            if (this.config.style.pictureTitleBarBackgroundColor != 0) {
                this.titleViewBg.setBackgroundColor(this.colorPrimary);
            }
        } else {
            int previewBgColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_ac_preview_title_bg);
            if (previewBgColor != 0) {
                this.titleViewBg.setBackgroundColor(previewBgColor);
            } else {
                this.titleViewBg.setBackgroundColor(this.colorPrimary);
            }
        }
    }

    private void initViewPageAdapterData() {
        this.tvTitle.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.images.size()}));
        this.adapter = new SimpleFragmentAdapter();
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int index) {
                PictureExternalPreviewActivity.this.tvTitle.setText((CharSequence)PictureExternalPreviewActivity.this.getString(R.string.picture_preview_image_num, new Object[]{index + 1, PictureExternalPreviewActivity.this.images.size()}));
                PictureExternalPreviewActivity.this.position = index;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.left_back) {
            this.finish();
            this.exitAnimation();
        } else if (id2 == R.id.ib_delete && this.images != null && this.images.size() > 0) {
            int currentItem = this.viewPager.getCurrentItem();
            this.images.remove(currentItem);
            this.adapter.removeCacheView(currentItem);
            Bundle bundle = new Bundle();
            bundle.putInt("position", currentItem);
            BroadcastManager.getInstance(this.getContext()).action("com.luck.picture.lib.action.delete_preview_position").extras(bundle).broadcast();
            if (this.images.size() == 0) {
                this.onBackPressed();
                return;
            }
            this.tvTitle.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.images.size()}));
            this.position = currentItem;
            this.adapter.notifyDataSetChanged();
        }
    }

    private void displayLongPic(Uri uri, SubsamplingScaleImageView longImg) {
        longImg.setQuickScaleEnabled(true);
        longImg.setZoomEnabled(true);
        longImg.setPanEnabled(true);
        longImg.setDoubleTapZoomDuration(100);
        longImg.setMinimumScaleType(2);
        longImg.setDoubleTapZoomDpi(2);
        longImg.setImage(ImageSource.uri(uri), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
    }

    private void showDownLoadDialog() {
        if (!this.isFinishing() && !TextUtils.isEmpty((CharSequence)this.downloadPath)) {
            PictureCustomDialog dialog = new PictureCustomDialog(this.getContext(), R.layout.picture_wind_base_dialog);
            Button btn_cancel = (Button)dialog.findViewById(R.id.btn_cancel);
            Button btn_commit = (Button)dialog.findViewById(R.id.btn_commit);
            TextView tvTitle = (TextView)dialog.findViewById(R.id.tvTitle);
            TextView tv_content = (TextView)dialog.findViewById(R.id.tv_content);
            tvTitle.setText((CharSequence)this.getString(R.string.picture_prompt));
            tv_content.setText((CharSequence)this.getString(R.string.picture_prompt_content));
            btn_cancel.setOnClickListener(v -> {
                if (!this.isFinishing()) {
                    dialog.dismiss();
                }
            });
            btn_commit.setOnClickListener(view -> {
                boolean isHttp = PictureMimeType.isHttp(this.downloadPath);
                this.showPleaseDialog();
                if (isHttp) {
                    PictureThreadUtils.executeByCached(new PictureThreadUtils.SimpleTask<String>(){

                        @Override
                        public String doInBackground() {
                            return PictureExternalPreviewActivity.this.showLoadingImage(PictureExternalPreviewActivity.this.downloadPath);
                        }

                        @Override
                        public void onSuccess(String result) {
                            PictureThreadUtils.cancel(PictureThreadUtils.getCachedPool());
                            PictureExternalPreviewActivity.this.onSuccessful(result);
                        }
                    });
                } else {
                    try {
                        if (this.isAndroidQ) {
                            this.savePictureAlbumAndroidQ(PictureMimeType.isContent(this.downloadPath) ? Uri.parse((String)this.downloadPath) : Uri.fromFile((File)new File(this.downloadPath)));
                        } else {
                            this.savePictureAlbum();
                        }
                    }
                    catch (Exception e) {
                        ToastUtils.s(this.getContext(), this.getString(R.string.picture_save_error) + "\n" + e.getMessage());
                        this.dismissDialog();
                        e.printStackTrace();
                    }
                }
                if (!this.isFinishing()) {
                    dialog.dismiss();
                }
            });
            dialog.show();
        }
    }

    private void savePictureAlbum() throws Exception {
        File folderDir;
        File rootDir;
        String suffix = PictureMimeType.getLastImgSuffix(this.mMimeType);
        String state = Environment.getExternalStorageState();
        File file = rootDir = state.equals("mounted") ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) : this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (rootDir == null || rootDir.exists() || rootDir.mkdirs()) {
            // empty if block
        }
        if ((folderDir = new File(this.isAndroidQ || !state.equals("mounted") ? rootDir.getAbsolutePath() : rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator)) == null || folderDir.exists() || folderDir.mkdirs()) {
            // empty if block
        }
        String fileName = DateUtils.getCreateFileName("IMG_") + suffix;
        File file2 = new File(folderDir, fileName);
        PictureFileUtils.copyFile(this.downloadPath, file2.getAbsolutePath());
        this.onSuccessful(file2.getAbsolutePath());
    }

    private void onSuccessful(String result) {
        this.dismissDialog();
        if (!TextUtils.isEmpty((CharSequence)result)) {
            try {
                if (!SdkVersionUtils.checkedAndroid_Q()) {
                    File file = new File(result);
                    MediaStore.Images.Media.insertImage((ContentResolver)this.getContentResolver(), (String)file.getAbsolutePath(), (String)file.getName(), null);
                    new PictureMediaScannerConnection(this.getContext(), file.getAbsolutePath(), () -> {});
                }
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_save_success) + "\n" + result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ToastUtils.s(this.getContext(), this.getString(R.string.picture_save_error));
        }
    }

    private void savePictureAlbumAndroidQ(final Uri inputUri) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        contentValues.put("datetaken", ValueOf.toString(System.currentTimeMillis()));
        contentValues.put("mime_type", this.mMimeType);
        contentValues.put("relative_path", "DCIM/Camera");
        final Uri uri = this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
        if (uri == null) {
            ToastUtils.s(this.getContext(), this.getString(R.string.picture_save_error));
            return;
        }
        PictureThreadUtils.executeByCached(new PictureThreadUtils.SimpleTask<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String doInBackground() {
                BufferedSource buffer;
                block8: {
                    String string2;
                    buffer = null;
                    try {
                        buffer = Okio.buffer((Source)Okio.source((InputStream)Objects.requireNonNull(PictureExternalPreviewActivity.this.getContentResolver().openInputStream(inputUri))));
                        OutputStream outputStream = PictureExternalPreviewActivity.this.getContentResolver().openOutputStream(uri);
                        boolean bufferCopy = PictureFileUtils.bufferCopy(buffer, outputStream);
                        if (!bufferCopy) break block8;
                        string2 = PictureFileUtils.getPath(PictureExternalPreviewActivity.this.getContext(), uri);
                    }
                    catch (Exception e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            if (buffer != null && buffer.isOpen()) {
                                PictureFileUtils.close(buffer);
                            }
                            throw throwable;
                        }
                        if (buffer != null && buffer.isOpen()) {
                            PictureFileUtils.close((Closeable)buffer);
                        }
                    }
                    if (buffer != null && buffer.isOpen()) {
                        PictureFileUtils.close((Closeable)buffer);
                    }
                    return string2;
                }
                if (buffer != null && buffer.isOpen()) {
                    PictureFileUtils.close((Closeable)buffer);
                }
                return "";
            }

            @Override
            public void onSuccess(String result) {
                PictureThreadUtils.cancel(PictureThreadUtils.getCachedPool());
                PictureExternalPreviewActivity.this.onSuccessful(result);
            }
        });
    }

    private Uri createOutImageUri() {
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        contentValues.put("datetaken", ValueOf.toString(System.currentTimeMillis()));
        contentValues.put("mime_type", this.mMimeType);
        contentValues.put("relative_path", "DCIM/Camera");
        return this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String showLoadingImage(String urlPath) {
        BufferedSource inBuffer;
        InputStream inputStream;
        OutputStream outputStream;
        block13: {
            String string2;
            block12: {
                Uri outImageUri = null;
                outputStream = null;
                inputStream = null;
                inBuffer = null;
                try {
                    if (this.isAndroidQ) {
                        outImageUri = this.createOutImageUri();
                    } else {
                        File rootDir;
                        String suffix = PictureMimeType.getLastImgSuffix(this.mMimeType);
                        String state = Environment.getExternalStorageState();
                        File file = rootDir = state.equals("mounted") ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) : this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
                        if (rootDir != null) {
                            File folderDir;
                            if (!rootDir.exists()) {
                                rootDir.mkdirs();
                            }
                            if ((folderDir = new File(!state.equals("mounted") ? rootDir.getAbsolutePath() : rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator)).exists() || folderDir.mkdirs()) {
                                // empty if block
                            }
                            String fileName = DateUtils.getCreateFileName("IMG_") + suffix;
                            File file2 = new File(folderDir, fileName);
                            outImageUri = Uri.fromFile((File)file2);
                        }
                    }
                    if (outImageUri != null) {
                        outputStream = Objects.requireNonNull(this.getContentResolver().openOutputStream(outImageUri));
                        URL u = new URL(urlPath);
                        inputStream = u.openStream();
                        inBuffer = Okio.buffer((Source)Okio.source((InputStream)inputStream));
                        boolean bufferCopy = PictureFileUtils.bufferCopy(inBuffer, outputStream);
                        if (bufferCopy) {
                            string2 = PictureFileUtils.getPath((Context)this, outImageUri);
                            PictureFileUtils.close(inputStream);
                            break block12;
                        }
                    }
                    PictureFileUtils.close(inputStream);
                    break block13;
                }
                catch (Exception e) {
                    if (outImageUri == null) return null;
                    if (!this.isAndroidQ) return null;
                    this.getContentResolver().delete(outImageUri, null, null);
                    return null;
                }
            }
            PictureFileUtils.close(outputStream);
            PictureFileUtils.close((Closeable)inBuffer);
            return string2;
        }
        PictureFileUtils.close(outputStream);
        PictureFileUtils.close(inBuffer);
        return null;
        finally {
            PictureFileUtils.close(inputStream);
            PictureFileUtils.close(outputStream);
            PictureFileUtils.close(inBuffer);
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
        this.exitAnimation();
    }

    private void exitAnimation() {
        this.overridePendingTransition(R.anim.picture_anim_fade_in, this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewExitAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewExitAnimation : R.anim.picture_anim_exit);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.adapter != null) {
            this.adapter.clear();
        }
        if (PictureSelectionConfig.customVideoPlayCallback != null) {
            PictureSelectionConfig.customVideoPlayCallback = null;
        }
        if (PictureSelectionConfig.onPictureSelectorInterfaceListener != null) {
            PictureSelectionConfig.onPictureSelectorInterfaceListener = null;
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] == 0) {
                        this.showDownLoadDialog();
                        continue;
                    }
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_jurisdiction));
                }
                break;
            }
        }
    }

    public class SimpleFragmentAdapter
    extends PagerAdapter {
        private static final int MAX_CACHE_SIZE = 20;
        private SparseArray<View> mCacheView = new SparseArray();

        private void clear() {
            if (null != this.mCacheView) {
                this.mCacheView.clear();
                this.mCacheView = null;
            }
        }

        public void removeCacheView(int position) {
            if (this.mCacheView != null && position < this.mCacheView.size()) {
                this.mCacheView.removeAt(position);
            }
        }

        public int getCount() {
            return PictureExternalPreviewActivity.this.images != null ? PictureExternalPreviewActivity.this.images.size() : 0;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
            if (this.mCacheView.size() > 20) {
                this.mCacheView.remove(position);
            }
        }

        public int getItemPosition(@NonNull Object object) {
            return -2;
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View contentView = (View)this.mCacheView.get(position);
            if (contentView == null) {
                contentView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.picture_image_preview, container, false);
                this.mCacheView.put(position, (Object)contentView);
            }
            PhotoView imageView = (PhotoView)contentView.findViewById(R.id.preview_image);
            SubsamplingScaleImageView longImageView = (SubsamplingScaleImageView)contentView.findViewById(R.id.longImg);
            ImageView ivPlay = (ImageView)contentView.findViewById(R.id.iv_play);
            LocalMedia media = (LocalMedia)PictureExternalPreviewActivity.this.images.get(position);
            if (media != null) {
                String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : (!TextUtils.isEmpty((CharSequence)media.getAndroidQToPath()) ? media.getAndroidQToPath() : media.getPath()));
                boolean isHttp = PictureMimeType.isHttp(path);
                String mimeType = isHttp ? PictureMimeType.getImageMimeType(media.getPath()) : media.getMimeType();
                boolean isHasVideo = PictureMimeType.isHasVideo(mimeType);
                ivPlay.setVisibility(isHasVideo ? 0 : 8);
                boolean isGif = PictureMimeType.isGif(mimeType);
                boolean eqLongImg = MediaUtils.isLongImg(media);
                imageView.setVisibility(eqLongImg && !isGif ? 8 : 0);
                longImageView.setVisibility(eqLongImg && !isGif ? 0 : 8);
                if (isGif && !media.isCompressed()) {
                    if (PictureExternalPreviewActivity.this.config != null && PictureSelectionConfig.imageEngine != null) {
                        PictureSelectionConfig.imageEngine.loadAsGifImage(PictureExternalPreviewActivity.this.getContext(), path, (ImageView)imageView);
                    }
                } else if (PictureExternalPreviewActivity.this.config != null && PictureSelectionConfig.imageEngine != null) {
                    if (isHttp) {
                        PictureSelectionConfig.imageEngine.loadImage(contentView.getContext(), path, (ImageView)imageView, longImageView, new OnImageCompleteCallback(){

                            @Override
                            public void onShowLoading() {
                                PictureExternalPreviewActivity.this.showPleaseDialog();
                            }

                            @Override
                            public void onHideLoading() {
                                PictureExternalPreviewActivity.this.dismissDialog();
                            }
                        });
                    } else if (eqLongImg) {
                        PictureExternalPreviewActivity.this.displayLongPic(PictureExternalPreviewActivity.this.isAndroidQ ? Uri.parse((String)path) : Uri.fromFile((File)new File(path)), longImageView);
                    } else {
                        PictureSelectionConfig.imageEngine.loadImage(contentView.getContext(), path, (ImageView)imageView);
                    }
                }
                imageView.setOnViewTapListener((view, x, y) -> {
                    PictureExternalPreviewActivity.this.finish();
                    PictureExternalPreviewActivity.this.exitAnimation();
                });
                longImageView.setOnClickListener(v -> {
                    PictureExternalPreviewActivity.this.finish();
                    PictureExternalPreviewActivity.this.exitAnimation();
                });
                if (!isHasVideo) {
                    longImageView.setOnLongClickListener(v -> {
                        if (PictureExternalPreviewActivity.this.config.isNotPreviewDownload) {
                            if (PermissionChecker.checkSelfPermission(PictureExternalPreviewActivity.this.getContext(), "android.permission.WRITE_EXTERNAL_STORAGE")) {
                                PictureExternalPreviewActivity.this.downloadPath = path;
                                String currentMimeType = PictureMimeType.isHttp(path) ? PictureMimeType.getImageMimeType(media.getPath()) : media.getMimeType();
                                PictureExternalPreviewActivity.this.mMimeType = PictureMimeType.isJPG(currentMimeType) ? "image/jpeg" : currentMimeType;
                                PictureExternalPreviewActivity.this.showDownLoadDialog();
                            } else {
                                PermissionChecker.requestPermissions((Activity)PictureExternalPreviewActivity.this, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
                            }
                        }
                        return true;
                    });
                }
                if (!isHasVideo) {
                    imageView.setOnLongClickListener(v -> {
                        if (PictureExternalPreviewActivity.this.config.isNotPreviewDownload) {
                            if (PermissionChecker.checkSelfPermission(PictureExternalPreviewActivity.this.getContext(), "android.permission.WRITE_EXTERNAL_STORAGE")) {
                                PictureExternalPreviewActivity.this.downloadPath = path;
                                String currentMimeType = PictureMimeType.isHttp(path) ? PictureMimeType.getImageMimeType(media.getPath()) : media.getMimeType();
                                PictureExternalPreviewActivity.this.mMimeType = PictureMimeType.isJPG(currentMimeType) ? "image/jpeg" : currentMimeType;
                                PictureExternalPreviewActivity.this.showDownLoadDialog();
                            } else {
                                PermissionChecker.requestPermissions((Activity)PictureExternalPreviewActivity.this, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
                            }
                        }
                        return true;
                    });
                }
                ivPlay.setOnClickListener(v -> {
                    if (PictureSelectionConfig.customVideoPlayCallback != null) {
                        PictureSelectionConfig.customVideoPlayCallback.startPlayVideo(media);
                    } else {
                        Intent intent = new Intent();
                        Bundle bundle = new Bundle();
                        bundle.putString("videoPath", path);
                        intent.putExtras(bundle);
                        JumpUtils.startPictureVideoPlayActivity(container.getContext(), bundle, 166);
                    }
                });
            }
            container.addView(contentView, 0);
            return contentView;
        }
    }
}

