/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.SpannableString;
import android.text.style.RelativeSizeSpan;
import android.widget.TextView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.tools.DateUtils;
import java.util.regex.Pattern;

public class StringUtils {
    public static void tempTextFont(TextView tv, int mimeType) {
        String text = tv.getText().toString().trim();
        String str = mimeType == PictureMimeType.ofAudio() ? tv.getContext().getString(R.string.picture_empty_audio_title) : tv.getContext().getString(R.string.picture_empty_title);
        String sumText = str + text;
        SpannableString placeSpan = new SpannableString((CharSequence)sumText);
        placeSpan.setSpan((Object)new RelativeSizeSpan(0.8f), str.length(), sumText.length(), 33);
        tv.setText((CharSequence)placeSpan);
    }

    public static int stringToInt(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]+$");
        return pattern.matcher(str).matches() ? Integer.valueOf(str) : 0;
    }

    @SuppressLint(value={"StringFormatMatches"})
    public static String getMsg(Context context, String mimeType, int maxSelectNum) {
        if (PictureMimeType.eqVideo(mimeType)) {
            return context.getString(R.string.picture_message_video_max_num, new Object[]{maxSelectNum});
        }
        if (PictureMimeType.eqAudio(mimeType)) {
            return context.getString(R.string.picture_message_audio_max_num, new Object[]{maxSelectNum});
        }
        return context.getString(R.string.picture_message_max_num, new Object[]{maxSelectNum});
    }

    public static String rename(String fileName) {
        String temp = fileName.substring(0, fileName.lastIndexOf("."));
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        return new StringBuffer().append(temp).append("_").append(DateUtils.getCreateFileName()).append(suffix).toString();
    }

    public static String renameSuffix(String fileName, String suffix) {
        String temp = fileName.substring(0, fileName.lastIndexOf("."));
        return new StringBuffer().append(temp).append(suffix).toString();
    }
}

