/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

public class PermissionChecker {
    public static boolean checkSelfPermission(Context ctx, String permission2) {
        return ContextCompat.checkSelfPermission((Context)ctx.getApplicationContext(), (String)permission2) == 0;
    }

    public static void requestPermissions(Activity activity, @NonNull String[] permissions, int code) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)code);
    }

    public static void launchAppDetailsSettings(Context context) {
        Context applicationContext = context.getApplicationContext();
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + applicationContext.getPackageName())));
        if (!PermissionChecker.isIntentAvailable(context, intent)) {
            return;
        }
        applicationContext.startActivity(intent.addFlags(0x10000000));
    }

    private static boolean isIntentAvailable(Context context, Intent intent) {
        return context.getApplicationContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }
}

