/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.PicturePreviewActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureWeChatPreviewGalleryAdapter;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.decoration.WrapContentLinearLayoutManager;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.ScreenUtils;

public class PictureSelectorPreviewWeChatStyleActivity
extends PicturePreviewActivity {
    private static final int ALPHA_DURATION = 300;
    private TextView mPictureSendView;
    private RecyclerView mRvGallery;
    private TextView tvSelected;
    private View bottomLine;
    private PictureWeChatPreviewGalleryAdapter mGalleryAdapter;

    @Override
    public int getResourceId() {
        return R.layout.picture_wechat_style_preview;
    }

    private void goneParent() {
        if (this.tv_img_num.getVisibility() == 0) {
            this.tv_img_num.setVisibility(8);
        }
        if (this.mTvPictureOk.getVisibility() == 0) {
            this.mTvPictureOk.setVisibility(8);
        }
        this.check.setText((CharSequence)"");
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.goneParent();
        this.mRvGallery = (RecyclerView)this.findViewById(R.id.rv_gallery);
        this.bottomLine = this.findViewById(R.id.bottomLine);
        this.tvSelected = (TextView)this.findViewById(R.id.tv_selected);
        this.mPictureSendView = (TextView)this.findViewById(R.id.picture_send);
        this.mPictureSendView.setOnClickListener((View.OnClickListener)this);
        this.mPictureSendView.setText((CharSequence)this.getString(R.string.picture_send));
        this.mCbOriginal.setTextSize(16.0f);
        this.mGalleryAdapter = new PictureWeChatPreviewGalleryAdapter(this.config);
        WrapContentLinearLayoutManager layoutManager = new WrapContentLinearLayoutManager(this.getContext());
        layoutManager.setOrientation(0);
        this.mRvGallery.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRvGallery.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(Integer.MAX_VALUE, ScreenUtils.dip2px((Context)this, 8.0f), false));
        this.mRvGallery.setAdapter((RecyclerView.Adapter)this.mGalleryAdapter);
        this.mGalleryAdapter.setItemClickListener((position, media, v) -> {
            if (this.viewPager != null && media != null && this.isEqualsDirectory(media.getParentFolderName(), this.currentDirectory)) {
                int newPosition = this.is_bottom_preview ? position : (this.isShowCamera ? media.position - 1 : media.position);
                this.viewPager.setCurrentItem(newPosition);
            }
        });
        if (this.is_bottom_preview) {
            if (this.selectImages != null && this.selectImages.size() > this.position) {
                ((LocalMedia)this.selectImages.get(this.position)).setChecked(true);
            }
        } else {
            int size = this.selectImages != null ? this.selectImages.size() : 0;
            for (int i = 0; i < size; ++i) {
                LocalMedia media2 = (LocalMedia)this.selectImages.get(i);
                if (!this.isEqualsDirectory(media2.getParentFolderName(), this.currentDirectory)) continue;
                media2.setChecked(this.isShowCamera ? media2.position - 1 == this.position : media2.position == this.position);
            }
        }
    }

    private boolean isEqualsDirectory(String parentFolderName, String currentDirectory) {
        return this.is_bottom_preview || TextUtils.isEmpty((CharSequence)parentFolderName) || TextUtils.isEmpty((CharSequence)currentDirectory) || currentDirectory.equals(this.getString(R.string.picture_camera_roll)) || parentFolderName.equals(currentDirectory);
    }

    @Override
    public void initPictureSelectorStyle() {
        super.initPictureSelectorStyle();
        if (this.config.style != null) {
            if (this.config.style.pictureCompleteBackgroundStyle != 0) {
                this.mPictureSendView.setBackgroundResource(this.config.style.pictureCompleteBackgroundStyle);
            } else {
                this.mPictureSendView.setBackgroundResource(R.drawable.picture_send_button_bg);
            }
            if (this.config.style.pictureRightTextSize != 0) {
                this.mPictureSendView.setTextSize((float)this.config.style.pictureRightTextSize);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureWeChatPreviewSelectedText)) {
                this.tvSelected.setText((CharSequence)this.config.style.pictureWeChatPreviewSelectedText);
            }
            if (this.config.style.pictureWeChatPreviewSelectedTextSize != 0) {
                this.tvSelected.setTextSize((float)this.config.style.pictureWeChatPreviewSelectedTextSize);
            }
            if (this.config.style.picturePreviewBottomBgColor != 0) {
                this.selectBarLayout.setBackgroundColor(this.config.style.picturePreviewBottomBgColor);
            } else {
                this.selectBarLayout.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_half_grey));
            }
            if (this.config.style.pictureCompleteTextColor != 0) {
                this.mPictureSendView.setTextColor(this.config.style.pictureCompleteTextColor);
            } else if (this.config.style.pictureCancelTextColor != 0) {
                this.mPictureSendView.setTextColor(this.config.style.pictureCancelTextColor);
            } else {
                this.mPictureSendView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
            }
            if (this.config.style.pictureOriginalFontColor == 0) {
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_white));
            }
            if (this.config.style.pictureWeChatChooseStyle != 0) {
                this.check.setBackgroundResource(this.config.style.pictureWeChatChooseStyle);
            } else {
                this.check.setBackgroundResource(R.drawable.picture_wechat_select_cb);
            }
            if (this.config.isOriginalControl && this.config.style.pictureOriginalControlStyle == 0) {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_wechat_checkbox));
            }
            if (this.config.style.pictureWeChatLeftBackStyle != 0) {
                this.picture_left_back.setImageResource(this.config.style.pictureWeChatLeftBackStyle);
            } else {
                this.picture_left_back.setImageResource(R.drawable.picture_icon_back);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText)) {
                this.mPictureSendView.setText((CharSequence)this.config.style.pictureUnCompleteText);
            }
        } else {
            this.mPictureSendView.setBackgroundResource(R.drawable.picture_send_button_bg);
            this.mPictureSendView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
            this.selectBarLayout.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_half_grey));
            this.check.setBackgroundResource(R.drawable.picture_wechat_select_cb);
            this.picture_left_back.setImageResource(R.drawable.picture_icon_back);
            this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_white));
            if (this.config.isOriginalControl) {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_wechat_checkbox));
            }
        }
        this.onSelectNumChange(false);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        int id2 = v.getId();
        if (id2 == R.id.picture_send) {
            boolean enable;
            boolean bl = enable = this.selectImages.size() != 0;
            if (enable) {
                this.mTvPictureOk.performClick();
            } else {
                boolean newEnableStatus;
                this.btnCheck.performClick();
                boolean bl2 = newEnableStatus = this.selectImages.size() != 0;
                if (newEnableStatus) {
                    this.mTvPictureOk.performClick();
                }
            }
        }
    }

    @Override
    protected void onSelectedChange(boolean isAddRemove, LocalMedia media) {
        super.onSelectedChange(isAddRemove, media);
        if (isAddRemove) {
            media.setChecked(true);
            if (this.config.selectionMode == 1) {
                this.mGalleryAdapter.addSingleMediaToData(media);
            }
        } else {
            media.setChecked(false);
            this.mGalleryAdapter.removeMediaToData(media);
            if (this.is_bottom_preview) {
                if (this.selectImages != null && this.selectImages.size() > this.position) {
                    ((LocalMedia)this.selectImages.get(this.position)).setChecked(true);
                }
                if (this.mGalleryAdapter.isDataEmpty()) {
                    this.onActivityBackPressed();
                } else {
                    int currentItem = this.viewPager.getCurrentItem();
                    this.images.remove(currentItem);
                    this.adapter.removeCacheView(currentItem);
                    this.position = currentItem;
                    this.tv_title.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.images.size()}));
                    this.check.setSelected(true);
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
    }

    @Override
    protected void onPageSelectedChange(LocalMedia media) {
        super.onPageSelectedChange(media);
        this.goneParent();
        if (this.mGalleryAdapter != null) {
            int itemCount = this.mGalleryAdapter.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                LocalMedia item = this.mGalleryAdapter.getItem(i);
                if (item == null || TextUtils.isEmpty((CharSequence)item.getPath())) continue;
                item.setChecked(item.getPath().equals(media.getPath()) || item.getId() == media.getId());
            }
            this.mGalleryAdapter.notifyDataSetChanged();
        }
    }

    @Override
    protected void onSelectNumChange(boolean isRefresh) {
        boolean enable;
        if (this.mPictureSendView == null) {
            return;
        }
        this.goneParent();
        boolean bl = enable = this.selectImages.size() != 0;
        if (enable) {
            this.initCompleteText(this.selectImages.size());
            if (this.mRvGallery.getVisibility() == 8) {
                this.mRvGallery.animate().alpha(1.0f).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                this.mRvGallery.setVisibility(0);
                this.bottomLine.animate().alpha(1.0f).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                this.bottomLine.setVisibility(0);
                this.mGalleryAdapter.setNewData(this.selectImages);
            }
            if (this.config.style != null) {
                if (this.config.style.pictureCompleteTextColor != 0) {
                    this.mPictureSendView.setTextColor(this.config.style.pictureCompleteTextColor);
                }
                if (this.config.style.pictureCompleteBackgroundStyle != 0) {
                    this.mPictureSendView.setBackgroundResource(this.config.style.pictureCompleteBackgroundStyle);
                }
            } else {
                this.mPictureSendView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                this.mPictureSendView.setBackgroundResource(R.drawable.picture_send_button_bg);
            }
        } else {
            if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText)) {
                this.mPictureSendView.setText((CharSequence)this.config.style.pictureUnCompleteText);
            } else {
                this.mPictureSendView.setText((CharSequence)this.getString(R.string.picture_send));
            }
            this.mRvGallery.animate().alpha(0.0f).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRvGallery.setVisibility(8);
            this.bottomLine.animate().alpha(0.0f).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.bottomLine.setVisibility(8);
        }
    }

    @Override
    protected void initCompleteText(int startCount) {
        boolean isNotEmptyStyle;
        boolean bl = isNotEmptyStyle = this.config.style != null;
        if (this.config.isWithVideoImage) {
            if (this.config.selectionMode == 1) {
                if (startCount <= 0) {
                    this.mPictureSendView.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_send)));
                } else {
                    boolean isCompleteReplaceNum;
                    boolean bl2 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
                    if (isCompleteReplaceNum && isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                        this.mPictureSendView.setText((CharSequence)String.format(this.config.style.pictureCompleteText, this.selectImages.size(), 1));
                    } else {
                        this.mPictureSendView.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText) ? this.config.style.pictureCompleteText : this.getString(R.string.picture_send)));
                    }
                }
            } else {
                boolean isCompleteReplaceNum;
                boolean bl3 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                    this.mPictureSendView.setText((CharSequence)String.format(this.config.style.pictureCompleteText, this.selectImages.size(), this.config.maxVideoSelectNum + this.config.maxSelectNum));
                } else {
                    this.mPictureSendView.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_send_num, new Object[]{this.selectImages.size(), this.config.maxVideoSelectNum + this.config.maxSelectNum})));
                }
            }
        } else {
            int maxSize;
            String mimeType = ((LocalMedia)this.selectImages.get(0)).getMimeType();
            int n = maxSize = PictureMimeType.eqVideo(mimeType) && this.config.maxVideoSelectNum > 0 ? this.config.maxVideoSelectNum : this.config.maxSelectNum;
            if (this.config.selectionMode == 1) {
                if (startCount <= 0) {
                    this.mPictureSendView.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_send)));
                } else {
                    boolean isCompleteReplaceNum;
                    boolean bl4 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
                    if (isCompleteReplaceNum && isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                        this.mPictureSendView.setText((CharSequence)String.format(this.config.style.pictureCompleteText, this.selectImages.size(), 1));
                    } else {
                        this.mPictureSendView.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText) ? this.config.style.pictureCompleteText : this.getString(R.string.picture_send)));
                    }
                }
            } else {
                boolean isCompleteReplaceNum;
                boolean bl5 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                    this.mPictureSendView.setText((CharSequence)String.format(this.config.style.pictureCompleteText, this.selectImages.size(), maxSize));
                } else {
                    this.mPictureSendView.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_send_num, new Object[]{this.selectImages.size(), maxSize})));
                }
            }
        }
    }
}

