/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.view.PreviewView;
import androidx.camera.view.ScaleTypeTransform;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.content.ContextCompat;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;

public class TextureViewImplementation
implements PreviewView.Implementation {
    private static final String TAG = "TextureViewImpl";
    private WeakReference<FrameLayout> mWeakReferenceParent;
    private WeakReference<TextureView> mWeakReferenceTextureView;
    SurfaceTexture mSurfaceTexture;
    private Size mResolution;
    ListenableFuture<SurfaceRequest.Result> mSurfaceReleaseFuture;
    SurfaceRequest mSurfaceRequest;

    @Override
    public void init(@NonNull FrameLayout parent) {
        this.mWeakReferenceParent = new WeakReference<FrameLayout>(parent);
    }

    @Override
    @NonNull
    public Preview.SurfaceProvider getSurfaceProvider() {
        return surfaceRequest -> {
            this.mResolution = surfaceRequest.getResolution();
            this.initInternal();
            if (this.mSurfaceRequest != null) {
                this.mSurfaceRequest.willNotProvideSurface();
            }
            this.mSurfaceRequest = surfaceRequest;
            surfaceRequest.addRequestCancellationListener(ContextCompat.getMainExecutor((Context)this.getTextureView().getContext().getApplicationContext()), () -> {
                if (this.mSurfaceRequest != null && this.mSurfaceRequest == surfaceRequest) {
                    this.mSurfaceRequest = null;
                    this.mSurfaceReleaseFuture = null;
                }
            });
            this.tryToProvidePreviewSurface();
        };
    }

    private TextureView getTextureView() {
        return (TextureView)this.mWeakReferenceTextureView.get();
    }

    @Override
    public void onDisplayChanged() {
        if (this.getParent() == null || this.getTextureView() == null || this.mResolution == null) {
            return;
        }
        this.correctPreviewForCenterCrop((View)this.getParent(), this.getTextureView(), this.mResolution);
    }

    private FrameLayout getParent() {
        return (FrameLayout)this.mWeakReferenceParent.get();
    }

    private void initInternal() {
        final TextureView mTextureView = new TextureView(this.getParent().getContext());
        this.mWeakReferenceTextureView = new WeakReference<TextureView>(mTextureView);
        mTextureView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mResolution.getWidth(), this.mResolution.getHeight()));
        mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
                TextureViewImplementation.this.mSurfaceTexture = surfaceTexture;
                TextureViewImplementation.this.tryToProvidePreviewSurface();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
                Log.d((String)TextureViewImplementation.TAG, (String)("onSurfaceTextureSizeChanged(width:" + width + ", height: " + height + " )"));
            }

            public boolean onSurfaceTextureDestroyed(final SurfaceTexture surfaceTexture) {
                TextureViewImplementation.this.mSurfaceTexture = null;
                if (TextureViewImplementation.this.mSurfaceRequest == null && TextureViewImplementation.this.mSurfaceReleaseFuture != null) {
                    Futures.addCallback(TextureViewImplementation.this.mSurfaceReleaseFuture, (FutureCallback)new FutureCallback<SurfaceRequest.Result>(){

                        public void onSuccess(SurfaceRequest.Result result) {
                            Preconditions.checkState((result.getResultCode() != 3 ? 1 : 0) != 0, (String)"Unexpected result from SurfaceRequest. Surface was provided twice.");
                            surfaceTexture.release();
                        }

                        public void onFailure(Throwable t) {
                            throw new IllegalStateException("SurfaceReleaseFuture did not complete nicely.", t);
                        }
                    }, (Executor)ContextCompat.getMainExecutor((Context)mTextureView.getContext().getApplicationContext()));
                    return false;
                }
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            }
        });
        this.getParent().removeAllViews();
        this.getParent().addView((View)mTextureView);
    }

    void tryToProvidePreviewSurface() {
        ListenableFuture surfaceReleaseFuture;
        if (this.mResolution == null || this.mSurfaceTexture == null || this.mSurfaceRequest == null) {
            return;
        }
        this.mSurfaceTexture.setDefaultBufferSize(this.mResolution.getWidth(), this.mResolution.getHeight());
        Surface surface = new Surface(this.mSurfaceTexture);
        this.mSurfaceReleaseFuture = surfaceReleaseFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mSurfaceRequest.provideSurface(surface, CameraXExecutors.directExecutor(), arg_0 -> ((CallbackToFutureAdapter.Completer)completer).set(arg_0));
            return "provideSurface[request=" + this.mSurfaceRequest + " surface=" + surface + "]";
        });
        this.mSurfaceReleaseFuture.addListener(() -> {
            surface.release();
            if (this.mSurfaceReleaseFuture == surfaceReleaseFuture) {
                this.mSurfaceReleaseFuture = null;
            }
        }, ContextCompat.getMainExecutor((Context)this.getTextureView().getContext().getApplicationContext()));
        this.mSurfaceRequest = null;
        this.correctPreviewForCenterCrop((View)this.getParent(), this.getTextureView(), this.mResolution);
    }

    private void correctPreviewForCenterCrop(@NonNull View container, @NonNull TextureView textureView, @NonNull Size bufferSize) {
        Pair<Float, Float> scale = ScaleTypeTransform.getFillScaleWithBufferAspectRatio(container, (View)textureView, bufferSize);
        textureView.setScaleX(((Float)scale.first).floatValue());
        textureView.setScaleY(((Float)scale.second).floatValue());
        Point newOrigin = ScaleTypeTransform.getOriginOfCenteredView(container, (View)textureView);
        textureView.setX((float)newOrigin.x);
        textureView.setY((float)newOrigin.y);
        int rotation = ScaleTypeTransform.getRotationDegrees((View)textureView);
        textureView.setRotation((float)(-rotation));
    }
}

