/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Preview;
import androidx.camera.view.SurfaceViewImplementation;
import androidx.camera.view.TextureViewImplementation;
import com.luck.picture.lib.R;

public class PreviewView
extends FrameLayout {
    Implementation mImplementation;
    private ImplementationMode mImplementationMode;
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            PreviewView.this.mImplementation.onDisplayChanged();
        }
    };

    public PreviewView(@NonNull Context context) {
        this(context, null);
    }

    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PreviewView, defStyleAttr, defStyleRes);
        if (Build.VERSION.SDK_INT >= 29) {
            this.saveAttributeDataForStyleable(context, R.styleable.PreviewView, attrs, attributes, defStyleAttr, defStyleRes);
        }
        try {
            int implementationModeId = attributes.getInteger(R.styleable.PreviewView_implementationMode, ImplementationMode.TEXTURE_VIEW.getId());
            this.mImplementationMode = ImplementationMode.fromId(implementationModeId);
        }
        finally {
            attributes.recycle();
        }
        this.setUp();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        DisplayManager displayManager = (DisplayManager)this.getContext().getSystemService("display");
        if (displayManager != null) {
            displayManager.registerDisplayListener(this.mDisplayListener, this.getHandler());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        DisplayManager displayManager = (DisplayManager)this.getContext().getSystemService("display");
        if (displayManager != null) {
            displayManager.unregisterDisplayListener(this.mDisplayListener);
        }
    }

    private void setUp() {
        this.removeAllViews();
        switch (this.mImplementationMode) {
            case SURFACE_VIEW: {
                this.mImplementation = new SurfaceViewImplementation();
                break;
            }
            case TEXTURE_VIEW: {
                this.mImplementation = new TextureViewImplementation();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported implementation mode " + (Object)((Object)this.mImplementationMode));
            }
        }
        this.mImplementation.init(this);
    }

    public void setImplementationMode(@NonNull ImplementationMode implementationMode) {
        this.mImplementationMode = implementationMode;
        this.setUp();
    }

    @NonNull
    public ImplementationMode getImplementationMode() {
        return this.mImplementationMode;
    }

    @NonNull
    public Preview.SurfaceProvider getPreviewSurfaceProvider() {
        return this.mImplementation.getSurfaceProvider();
    }

    public static enum ScaleType {
        FILL_START,
        FILL_CENTER,
        FILL_END,
        FIT_START,
        FIT_CENTER,
        FIT_END;

    }

    public static enum ImplementationMode {
        SURFACE_VIEW(0),
        TEXTURE_VIEW(1);

        private final int mId;

        private ImplementationMode(int id) {
            this.mId = id;
        }

        public int getId() {
            return this.mId;
        }

        static ImplementationMode fromId(int id) {
            for (ImplementationMode mode : ImplementationMode.values()) {
                if (mode.mId != id) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unsupported implementation mode " + id);
        }
    }

    static interface Implementation {
        public void init(@NonNull FrameLayout var1);

        @NonNull
        public Preview.SurfaceProvider getSurfaceProvider();

        public void onDisplayChanged();
    }
}

