/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.camera.core.Preview;
import androidx.camera.view.PreviewView;
import androidx.camera.view.TransformableSurfaceView;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;

final class SurfaceViewImplementation
implements PreviewView.Implementation {
    private static final String TAG = "SurfaceViewPreviewView";
    TransformableSurfaceView mSurfaceView;
    final CompleterWithSizeCallback mCompleterWithSizeCallback = new CompleterWithSizeCallback();
    private Preview.PreviewSurfaceProvider mPreviewSurfaceProvider = new Preview.PreviewSurfaceProvider(){

        @NonNull
        public ListenableFuture<Surface> provideSurface(@NonNull Size resolution, @NonNull ListenableFuture<Void> surfaceReleaseFuture) {
            return CallbackToFutureAdapter.getFuture(completer -> {
                SurfaceViewImplementation.this.mSurfaceView.post(() -> SurfaceViewImplementation.this.mCompleterWithSizeCallback.setCompleterAndSize((CallbackToFutureAdapter.Completer<Surface>)completer, resolution));
                return "SurfaceViewSurfaceCreation";
            });
        }
    };

    SurfaceViewImplementation() {
    }

    @Override
    public void init(@NonNull FrameLayout parent) {
        this.mSurfaceView = new TransformableSurfaceView(parent.getContext());
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        parent.addView((View)this.mSurfaceView);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this.mCompleterWithSizeCallback);
    }

    @Override
    @NonNull
    public Preview.PreviewSurfaceProvider getPreviewSurfaceProvider() {
        return this.mPreviewSurfaceProvider;
    }

    class CompleterWithSizeCallback
    implements SurfaceHolder.Callback {
        @Nullable
        private Size mTargetSize;
        @Nullable
        private CallbackToFutureAdapter.Completer<Surface> mCompleter;
        @Nullable
        private Size mCurrentSurfaceSize;

        CompleterWithSizeCallback() {
        }

        @UiThread
        void setCompleterAndSize(CallbackToFutureAdapter.Completer<Surface> completer, Size targetSize) {
            this.cancelCompleter();
            this.mCompleter = completer;
            this.mTargetSize = targetSize;
            if (!this.tryToComplete()) {
                Log.d((String)SurfaceViewImplementation.TAG, (String)"Wait for new Surface creation.");
                SurfaceViewImplementation.this.mSurfaceView.getHolder().setFixedSize(targetSize.getWidth(), targetSize.getHeight());
            }
        }

        @UiThread
        private boolean tryToComplete() {
            Surface surface = SurfaceViewImplementation.this.mSurfaceView.getHolder().getSurface();
            if (this.mCompleter != null && this.mTargetSize != null && this.mTargetSize.equals((Object)this.mCurrentSurfaceSize)) {
                Log.d((String)SurfaceViewImplementation.TAG, (String)"Surface set on Preview.");
                this.mCompleter.set((Object)surface);
                this.mCompleter = null;
                this.mTargetSize = null;
                return true;
            }
            return false;
        }

        @UiThread
        private void cancelCompleter() {
            if (this.mCompleter != null) {
                Log.d((String)SurfaceViewImplementation.TAG, (String)"Completer canceled.");
                this.mCompleter.setCancelled();
                this.mCompleter = null;
            }
            this.mTargetSize = null;
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            Log.d((String)SurfaceViewImplementation.TAG, (String)"Surface created.");
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int format, int width, int height) {
            Log.d((String)SurfaceViewImplementation.TAG, (String)("Surface changed. Size: " + width + "x" + height));
            this.mCurrentSurfaceSize = new Size(width, height);
            this.tryToComplete();
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            Log.d((String)SurfaceViewImplementation.TAG, (String)"Surface destroyed.");
            this.mCurrentSurfaceSize = null;
            this.cancelCompleter();
        }
    }
}

