/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.view.Display;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.view.FixedSizeSurfaceTexture;
import androidx.camera.view.PreviewView;
import androidx.camera.view.ScaleTypeTransform;
import androidx.camera.view.SurfaceTextureReleaseBlockingListener;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;

public class FixedSizeTextureViewImplementation
implements PreviewView.Implementation {
    private TextureView mTextureView;
    private SurfaceTextureReleaseBlockingListener mSurfaceTextureListener;

    @Override
    public void init(@NonNull FrameLayout parent) {
        this.mTextureView = new TextureView(parent.getContext());
        this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mSurfaceTextureListener = new SurfaceTextureReleaseBlockingListener(this.mTextureView);
        parent.addView((View)this.mTextureView);
    }

    @Override
    @NonNull
    public Preview.PreviewSurfaceProvider getPreviewSurfaceProvider() {
        return (resolution, surfaceReleaseFuture) -> {
            FixedSizeSurfaceTexture surfaceTexture = new FixedSizeSurfaceTexture(0, resolution);
            surfaceTexture.detachFromGLContext();
            Surface surface = new Surface((SurfaceTexture)surfaceTexture);
            WindowManager windowManager = (WindowManager)this.mTextureView.getContext().getSystemService("window");
            Preconditions.checkNotNull((Object)windowManager);
            Display display = windowManager.getDefaultDisplay();
            Matrix matrix = ScaleTypeTransform.transformCenterCrop(resolution, (View)this.mTextureView, display.getRotation());
            this.mTextureView.setTransform(matrix);
            ViewGroup parent = (ViewGroup)this.mTextureView.getParent();
            parent.removeView((View)this.mTextureView);
            parent.addView((View)this.mTextureView);
            this.mSurfaceTextureListener.setSurfaceTextureSafely(surfaceTexture, (ListenableFuture<Void>)surfaceReleaseFuture);
            surfaceReleaseFuture.addListener(() -> ((Surface)surface).release(), CameraXExecutors.directExecutor());
            return Futures.immediateFuture((Object)surface);
        };
    }
}

