/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.UiThread;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraOrientationUtil;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.LensFacingConverter;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.VideoCapture;
import androidx.camera.core.VideoCaptureConfig;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.CameraView;
import androidx.camera.view.FixedSizeSurfaceTexture;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

final class CameraXModule {
    public static final String TAG = "CameraXModule";
    private static final float UNITY_ZOOM_SCALE = 1.0f;
    private static final float ZOOM_NOT_SUPPORTED = 1.0f;
    private static final Rational ASPECT_RATIO_16_9 = new Rational(16, 9);
    private static final Rational ASPECT_RATIO_4_3 = new Rational(4, 3);
    private static final Rational ASPECT_RATIO_9_16 = new Rational(9, 16);
    private static final Rational ASPECT_RATIO_3_4 = new Rational(3, 4);
    private final Preview.Builder mPreviewBuilder;
    private final VideoCaptureConfig.Builder mVideoCaptureConfigBuilder;
    private final ImageCapture.Builder mImageCaptureBuilder;
    private WeakReference<CameraView> mCameraViewWeakReference;
    final AtomicBoolean mVideoIsRecording = new AtomicBoolean(false);
    private CameraView.CaptureMode mCaptureMode = CameraView.CaptureMode.IMAGE;
    private long mMaxVideoDuration = -1L;
    private long mMaxVideoSize = -1L;
    private int mFlash = 2;
    @Nullable
    Camera mCamera;
    @Nullable
    CallbackToFutureAdapter.Completer<Size> mResolutionUpdateCompleter;
    @Nullable
    private ImageCapture mImageCapture;
    @Nullable
    private VideoCapture mVideoCapture;
    @Nullable
    Preview mPreview;
    @Nullable
    LifecycleOwner mCurrentLifecycle;
    private final LifecycleObserver mCurrentLifecycleObserver = new LifecycleObserver(){

        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        public void onDestroy(LifecycleOwner owner) {
            if (owner == CameraXModule.this.mCurrentLifecycle) {
                CameraXModule.this.clearCurrentLifecycle();
                CameraXModule.this.mPreview.setPreviewSurfaceProvider(null);
            }
        }
    };
    @Nullable
    private LifecycleOwner mNewLifecycle;
    @Nullable
    Integer mCameraLensFacing = 1;
    @Nullable
    ProcessCameraProvider mCameraProvider;

    CameraXModule(CameraView view) {
        this.mCameraViewWeakReference = new WeakReference<CameraView>(view);
        Futures.addCallback((ListenableFuture)ProcessCameraProvider.getInstance((Context)this.getCameraView().getContext()), (FutureCallback)new FutureCallback<ProcessCameraProvider>(){

            @SuppressLint(value={"MissingPermission"})
            public void onSuccess(@Nullable ProcessCameraProvider provider) {
                Preconditions.checkNotNull((Object)provider);
                CameraXModule.this.mCameraProvider = provider;
                if (CameraXModule.this.mCurrentLifecycle != null) {
                    CameraXModule.this.bindToLifecycle(CameraXModule.this.mCurrentLifecycle);
                }
            }

            public void onFailure(Throwable t) {
                throw new RuntimeException("CameraX failed to initialize.", t);
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        this.mPreviewBuilder = new Preview.Builder().setTargetName("Preview");
        this.mImageCaptureBuilder = new ImageCapture.Builder().setTargetName("ImageCapture");
        this.mVideoCaptureConfigBuilder = new VideoCaptureConfig.Builder().setTargetName("VideoCapture");
    }

    @RequiresPermission(value="android.permission.CAMERA")
    void bindToLifecycle(LifecycleOwner lifecycleOwner) {
        this.mNewLifecycle = lifecycleOwner;
        if (this.getMeasuredWidth() > 0 && this.getMeasuredHeight() > 0) {
            this.bindToLifecycleAfterViewMeasured();
        }
    }

    private CameraView getCameraView() {
        return (CameraView)((Object)this.mCameraViewWeakReference.get());
    }

    @RequiresPermission(value="android.permission.CAMERA")
    void bindToLifecycleAfterViewMeasured() {
        Rational targetAspectRatio;
        boolean isDisplayPortrait;
        if (this.mNewLifecycle == null) {
            return;
        }
        this.clearCurrentLifecycle();
        this.mCurrentLifecycle = this.mNewLifecycle;
        this.mNewLifecycle = null;
        if (this.mCurrentLifecycle.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            this.mCurrentLifecycle = null;
            throw new IllegalArgumentException("Cannot bind to lifecycle in a destroyed state.");
        }
        if (this.mCameraProvider == null) {
            return;
        }
        ListenableFuture resolutionUpdateFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mResolutionUpdateCompleter = completer;
            return "PreviewResolutionUpdate";
        });
        Set<Integer> available = this.getAvailableCameraLensFacing();
        if (available.isEmpty()) {
            Log.w((String)TAG, (String)"Unable to bindToLifeCycle since no cameras available");
            this.mCameraLensFacing = null;
        }
        if (this.mCameraLensFacing != null && !available.contains(this.mCameraLensFacing)) {
            Log.w((String)TAG, (String)("Camera does not exist with direction " + this.mCameraLensFacing));
            this.mCameraLensFacing = available.iterator().next();
            Log.w((String)TAG, (String)("Defaulting to primary camera with direction " + this.mCameraLensFacing));
        }
        if (this.mCameraLensFacing == null) {
            return;
        }
        boolean bl = isDisplayPortrait = this.getDisplayRotationDegrees() == 0 || this.getDisplayRotationDegrees() == 180;
        if (this.getCaptureMode() == CameraView.CaptureMode.IMAGE) {
            this.mImageCaptureBuilder.setTargetAspectRatio(0);
            targetAspectRatio = isDisplayPortrait ? ASPECT_RATIO_3_4 : ASPECT_RATIO_4_3;
        } else {
            this.mImageCaptureBuilder.setTargetAspectRatio(1);
            targetAspectRatio = isDisplayPortrait ? ASPECT_RATIO_9_16 : ASPECT_RATIO_16_9;
        }
        this.mImageCaptureBuilder.setTargetRotation(this.getDisplaySurfaceRotation());
        this.mImageCapture = this.mImageCaptureBuilder.build();
        this.mVideoCaptureConfigBuilder.setTargetRotation(this.getDisplaySurfaceRotation());
        this.mVideoCapture = this.mVideoCaptureConfigBuilder.build();
        int height = (int)((float)this.getMeasuredWidth() / targetAspectRatio.floatValue());
        this.mPreviewBuilder.setTargetResolution(new Size(this.getMeasuredWidth(), height));
        this.mPreview = this.mPreviewBuilder.build();
        this.mPreview.setPreviewSurfaceProvider((resolution, safeToCancelFuture) -> {
            this.mResolutionUpdateCompleter.set((Object)resolution);
            FixedSizeSurfaceTexture surfaceTexture = new FixedSizeSurfaceTexture(0, resolution);
            surfaceTexture.setDefaultBufferSize(resolution.getWidth(), resolution.getHeight());
            surfaceTexture.detachFromGLContext();
            this.setSurfaceTexture(surfaceTexture);
            Surface surface = new Surface((SurfaceTexture)surfaceTexture);
            safeToCancelFuture.addListener(() -> {
                surface.release();
                surfaceTexture.release();
            }, CameraXExecutors.directExecutor());
            return Futures.immediateFuture((Object)surface);
        });
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.mCameraLensFacing.intValue()).build();
        this.mCamera = this.getCaptureMode() == CameraView.CaptureMode.IMAGE ? this.mCameraProvider.bindToLifecycle(this.mCurrentLifecycle, cameraSelector, new UseCase[]{this.mImageCapture, this.mPreview}) : (this.getCaptureMode() == CameraView.CaptureMode.VIDEO ? this.mCameraProvider.bindToLifecycle(this.mCurrentLifecycle, cameraSelector, new UseCase[]{this.mVideoCapture, this.mPreview}) : this.mCameraProvider.bindToLifecycle(this.mCurrentLifecycle, cameraSelector, new UseCase[]{this.mImageCapture, this.mVideoCapture, this.mPreview}));
        Futures.addCallback((ListenableFuture)resolutionUpdateFuture, (FutureCallback)new FutureCallback<Size>(){

            public void onSuccess(@Nullable Size result) {
                if (result == null) {
                    Log.w((String)CameraXModule.TAG, (String)"PreviewSourceDimensUpdate fail");
                    return;
                }
                int cameraOrientation = CameraXModule.this.mCamera != null ? CameraXModule.this.mCamera.getCameraInfo().getSensorRotationDegrees() : 0;
                boolean needReverse = cameraOrientation != 0 && cameraOrientation != 180;
                int textureWidth = needReverse ? result.getHeight() : result.getWidth();
                int textureHeight = needReverse ? result.getWidth() : result.getHeight();
                CameraXModule.this.onPreviewSourceDimensUpdated(textureWidth, textureHeight);
            }

            public void onFailure(Throwable t) {
                Log.d((String)CameraXModule.TAG, (String)"PreviewSourceDimensUpdate fail", (Throwable)t);
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        this.setZoomRatio(1.0f);
        this.mCurrentLifecycle.getLifecycle().addObserver(this.mCurrentLifecycleObserver);
        this.setFlash(this.getFlash());
    }

    public void open() {
        throw new UnsupportedOperationException("Explicit open/close of camera not yet supported. Use bindtoLifecycle() instead.");
    }

    public void close() {
        throw new UnsupportedOperationException("Explicit open/close of camera not yet supported. Use bindtoLifecycle() instead.");
    }

    public void takePicture(Executor executor, ImageCapture.OnImageCapturedCallback callback) {
        if (this.mImageCapture == null) {
            return;
        }
        if (this.getCaptureMode() == CameraView.CaptureMode.VIDEO) {
            throw new IllegalStateException("Can not take picture under VIDEO capture mode.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("OnImageCapturedCallback should not be empty");
        }
        this.mImageCapture.takePicture(executor, callback);
    }

    public void takePicture(File saveLocation, Executor executor, ImageCapture.OnImageSavedCallback callback) {
        if (this.mImageCapture == null) {
            return;
        }
        if (this.getCaptureMode() == CameraView.CaptureMode.VIDEO) {
            throw new IllegalStateException("Can not take picture under VIDEO capture mode.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("OnImageSavedCallback should not be empty");
        }
        ImageCapture.Metadata metadata = new ImageCapture.Metadata();
        metadata.setReversedHorizontal(this.mCameraLensFacing != null && this.mCameraLensFacing == 0);
        this.mImageCapture.takePicture(saveLocation, metadata, executor, callback);
    }

    public void startRecording(File file, Executor executor, final VideoCapture.OnVideoSavedCallback callback) {
        if (this.mVideoCapture == null) {
            return;
        }
        if (this.getCaptureMode() == CameraView.CaptureMode.IMAGE) {
            throw new IllegalStateException("Can not record video under IMAGE capture mode.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("OnVideoSavedCallback should not be empty");
        }
        this.mVideoIsRecording.set(true);
        this.mVideoCapture.startRecording(file, executor, new VideoCapture.OnVideoSavedCallback(){

            public void onVideoSaved(@NonNull File savedFile) {
                CameraXModule.this.mVideoIsRecording.set(false);
                callback.onVideoSaved(savedFile);
            }

            public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                CameraXModule.this.mVideoIsRecording.set(false);
                Log.e((String)CameraXModule.TAG, (String)message, (Throwable)cause);
                callback.onError(videoCaptureError, message, cause);
            }
        });
    }

    public void stopRecording() {
        if (this.mVideoCapture == null) {
            return;
        }
        this.mVideoCapture.stopRecording();
    }

    public boolean isRecording() {
        return this.mVideoIsRecording.get();
    }

    @SuppressLint(value={"MissingPermission"})
    public void setCameraLensFacing(@Nullable Integer lensFacing) {
        if (!Objects.equals(this.mCameraLensFacing, lensFacing)) {
            this.mCameraLensFacing = lensFacing;
            if (this.mCurrentLifecycle != null) {
                this.bindToLifecycle(this.mCurrentLifecycle);
            }
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public boolean hasCameraWithLensFacing(int lensFacing) {
        String cameraId;
        try {
            cameraId = CameraX.getCameraWithLensFacing((int)lensFacing);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to query lens facing.", e);
        }
        return cameraId != null;
    }

    @Nullable
    public Integer getLensFacing() {
        return this.mCameraLensFacing;
    }

    public void toggleCamera() {
        Set<Integer> availableCameraLensFacing = this.getAvailableCameraLensFacing();
        if (availableCameraLensFacing.isEmpty()) {
            return;
        }
        if (this.mCameraLensFacing == null) {
            this.setCameraLensFacing(availableCameraLensFacing.iterator().next());
            return;
        }
        if (this.mCameraLensFacing == 1 && availableCameraLensFacing.contains(0)) {
            this.setCameraLensFacing(0);
            return;
        }
        if (this.mCameraLensFacing == 0 && availableCameraLensFacing.contains(1)) {
            this.setCameraLensFacing(1);
            return;
        }
    }

    public float getZoomRatio() {
        if (this.mCamera != null) {
            return ((Float)this.mCamera.getCameraInfo().getZoomRatio().getValue()).floatValue();
        }
        return 1.0f;
    }

    public void setZoomRatio(float zoomRatio) {
        if (this.mCamera != null) {
            this.mCamera.getCameraControl().setZoomRatio(zoomRatio);
        } else {
            Log.e((String)TAG, (String)"Failed to set zoom ratio");
        }
    }

    public float getMinZoomRatio() {
        if (this.mCamera != null) {
            return ((Float)this.mCamera.getCameraInfo().getMinZoomRatio().getValue()).floatValue();
        }
        return 1.0f;
    }

    public float getMaxZoomRatio() {
        if (this.mCamera != null) {
            return ((Float)this.mCamera.getCameraInfo().getMaxZoomRatio().getValue()).floatValue();
        }
        return 1.0f;
    }

    public boolean isZoomSupported() {
        return this.getMaxZoomRatio() != 1.0f;
    }

    @SuppressLint(value={"MissingPermission"})
    private void rebindToLifecycle() {
        if (this.mCurrentLifecycle != null) {
            this.bindToLifecycle(this.mCurrentLifecycle);
        }
    }

    int getRelativeCameraOrientation(boolean compensateForMirroring) {
        int rotationDegrees = 0;
        if (this.mCamera != null) {
            rotationDegrees = this.mCamera.getCameraInfo().getSensorRotationDegrees(this.getDisplaySurfaceRotation());
            if (compensateForMirroring) {
                rotationDegrees = (360 - rotationDegrees) % 360;
            }
        }
        return rotationDegrees;
    }

    public void invalidateView() {
        this.transformPreview();
        this.updateViewInfo();
    }

    void clearCurrentLifecycle() {
        if (this.mCurrentLifecycle != null && this.mCameraProvider != null) {
            ArrayList<Object> toUnbind = new ArrayList<Object>();
            if (this.mImageCapture != null && this.mCameraProvider.isBound((UseCase)this.mImageCapture)) {
                toUnbind.add(this.mImageCapture);
            }
            if (this.mVideoCapture != null && this.mCameraProvider.isBound((UseCase)this.mVideoCapture)) {
                toUnbind.add(this.mVideoCapture);
            }
            if (this.mPreview != null && this.mCameraProvider.isBound((UseCase)this.mPreview)) {
                toUnbind.add(this.mPreview);
            }
            if (!toUnbind.isEmpty()) {
                this.mCameraProvider.unbind(toUnbind.toArray(new UseCase[0]));
            }
        }
        this.mCamera = null;
        this.mCurrentLifecycle = null;
    }

    @UiThread
    private void transformPreview() {
        int previewWidth = this.getPreviewWidth();
        int previewHeight = this.getPreviewHeight();
        int displayOrientation = this.getDisplayRotationDegrees();
        Matrix matrix = new Matrix();
        int rotation = -displayOrientation;
        int px = (int)Math.round((double)previewWidth / 2.0);
        int py = (int)Math.round((double)previewHeight / 2.0);
        matrix.postRotate((float)rotation, (float)px, (float)py);
        if (displayOrientation == 90 || displayOrientation == 270) {
            float xScale = (float)previewWidth / (float)previewHeight;
            float yScale = (float)previewHeight / (float)previewWidth;
            matrix.postScale(xScale, yScale, (float)px, (float)py);
        }
        this.setTransform(matrix);
    }

    private void updateViewInfo() {
        if (this.mImageCapture != null) {
            this.mImageCapture.setTargetAspectRatioCustom(new Rational(this.getWidth(), this.getHeight()));
            this.mImageCapture.setTargetRotation(this.getDisplaySurfaceRotation());
        }
        if (this.mVideoCapture != null) {
            this.mVideoCapture.setTargetRotation(this.getDisplaySurfaceRotation());
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    private Set<Integer> getAvailableCameraLensFacing() {
        LinkedHashSet<Integer> available = new LinkedHashSet<Integer>(Arrays.asList(LensFacingConverter.values()));
        if (this.mCurrentLifecycle != null) {
            if (!this.hasCameraWithLensFacing(1)) {
                available.remove(1);
            }
            if (!this.hasCameraWithLensFacing(0)) {
                available.remove(0);
            }
        }
        return available;
    }

    public int getFlash() {
        return this.mFlash;
    }

    public void setFlash(int flash) {
        this.mFlash = flash;
        if (this.mImageCapture == null) {
            return;
        }
        this.mImageCapture.setFlashMode(flash);
    }

    public void enableTorch(boolean torch) {
        if (this.mCamera == null) {
            return;
        }
        this.mCamera.getCameraControl().enableTorch(torch);
    }

    public boolean isTorchOn() {
        if (this.mCamera == null) {
            return false;
        }
        return (Integer)this.mCamera.getCameraInfo().getTorchState().getValue() == 1;
    }

    public Context getContext() {
        return this.getCameraView().getContext();
    }

    public int getWidth() {
        return this.getCameraView().getWidth();
    }

    public int getHeight() {
        return this.getCameraView().getHeight();
    }

    public int getDisplayRotationDegrees() {
        return CameraOrientationUtil.surfaceRotationToDegrees((int)this.getDisplaySurfaceRotation());
    }

    protected int getDisplaySurfaceRotation() {
        return this.getCameraView().getDisplaySurfaceRotation();
    }

    public void setSurfaceTexture(SurfaceTexture st) {
        this.getCameraView().setSurfaceTexture(st);
    }

    private int getPreviewWidth() {
        return this.getCameraView().getPreviewWidth();
    }

    private int getPreviewHeight() {
        return this.getCameraView().getPreviewHeight();
    }

    private int getMeasuredWidth() {
        return this.getCameraView().getMeasuredWidth();
    }

    private int getMeasuredHeight() {
        return this.getCameraView().getMeasuredHeight();
    }

    void setTransform(Matrix matrix) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.getCameraView().post(() -> this.setTransform(matrix));
        } else {
            this.getCameraView().setTransform(matrix);
        }
    }

    void onPreviewSourceDimensUpdated(int width, int height) {
        this.getCameraView().onPreviewSourceDimensUpdated(width, height);
    }

    @Nullable
    public Camera getCamera() {
        return this.mCamera;
    }

    @NonNull
    public CameraView.CaptureMode getCaptureMode() {
        return this.mCaptureMode;
    }

    public void setCaptureMode(@NonNull CameraView.CaptureMode captureMode) {
        this.mCaptureMode = captureMode;
        this.rebindToLifecycle();
    }

    public long getMaxVideoDuration() {
        return this.mMaxVideoDuration;
    }

    public void setMaxVideoDuration(long duration) {
        this.mMaxVideoDuration = duration;
    }

    public long getMaxVideoSize() {
        return this.mMaxVideoSize;
    }

    public void setMaxVideoSize(long size) {
        this.mMaxVideoSize = size;
    }

    public boolean isPaused() {
        return false;
    }
}

